/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.List;

public class SoftAssertionError
extends AssertionError {
    private final List<String> errors;

    public SoftAssertionError(List<String> errors) {
        super((Object)SoftAssertionError.createMessage(errors));
        this.errors = errors;
    }

    private static String createMessage(List<String> errors) {
        StringBuilder msg = new StringBuilder("\nThe following ");
        int size = errors.size();
        if (size == 1) {
            msg.append("assertion");
        } else {
            msg.append(size).append(" assertions");
        }
        msg.append(" failed:\n");
        for (int i = 0; i < size; ++i) {
            msg.append(i + 1).append(") ").append(errors.get(i)).append("\n");
        }
        return msg.toString();
    }

    public List<String> getErrors() {
        return this.errors;
    }
}

