/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajbrowser.core;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajde.core.ICompilerConfiguration;
import org.aspectj.ajde.core.IOutputLocationManager;
import org.aspectj.ajde.ui.UserPreferencesAdapter;
import org.aspectj.tools.ajbrowser.BrowserManager;
import org.aspectj.tools.ajbrowser.core.BrowserOutputLocationManager;

public class BrowserCompilerConfiguration
implements ICompilerConfiguration {
    private UserPreferencesAdapter preferencesAdapter;
    private IOutputLocationManager locationManager;

    public BrowserCompilerConfiguration(UserPreferencesAdapter preferencesAdapter) {
        this.preferencesAdapter = preferencesAdapter;
    }

    @Override
    public String getClasspath() {
        StringBuffer classpath = new StringBuffer();
        String userPath = this.preferencesAdapter.getProjectPreference("build.classpath");
        if (userPath != null && userPath.trim().length() != 0) {
            classpath.append(userPath);
        }
        List<File> outputDirs = this.getOutputLocationManager().getAllOutputLocations();
        for (File dir : outputDirs) {
            classpath.append(File.pathSeparator + dir.getAbsolutePath() + File.pathSeparator);
        }
        classpath.append(System.getProperty("java.class.path", "."));
        return classpath.toString();
    }

    @Override
    public Map<String, String> getJavaOptionsMap() {
        return BrowserManager.getDefault().getJavaBuildOptions().getJavaBuildOptionsMap();
    }

    @Override
    public String getNonStandardOptions() {
        return this.preferencesAdapter.getProjectPreference("ajc.nonStandardOptions");
    }

    @Override
    public IOutputLocationManager getOutputLocationManager() {
        if (this.locationManager == null) {
            this.locationManager = new BrowserOutputLocationManager(this.preferencesAdapter);
        }
        return this.locationManager;
    }

    @Override
    public List<String> getProjectSourceFiles() {
        return null;
    }

    public List getProjectSourceFilesChanged() {
        return null;
    }

    public Map getSourcePathResources() {
        return null;
    }

    @Override
    public Set<File> getAspectPath() {
        return null;
    }

    @Override
    public Set<File> getInpath() {
        return null;
    }

    @Override
    public String getOutJar() {
        return null;
    }

    @Override
    public int getConfigurationChanges() {
        return 65535;
    }

    @Override
    public void configurationRead() {
    }

    public List getClasspathElementsWithModifiedContents() {
        return null;
    }

    @Override
    public List<String> getProjectXmlConfigFiles() {
        return Collections.emptyList();
    }

    @Override
    public String getProjectEncoding() {
        return null;
    }

    @Override
    public String getProcessor() {
        return null;
    }

    @Override
    public String getProcessorPath() {
        return null;
    }

    @Override
    public String getModulepath() {
        return null;
    }

    @Override
    public String getModuleSourcepath() {
        return null;
    }
}

