/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import java.lang.reflect.Modifier;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AstUtil;
import org.aspectj.ajdt.internal.compiler.ast.EclipseAttributeAdapter;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.KnownMessageSend;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseTypeMunger;
import org.aspectj.ajdt.internal.compiler.lookup.PrivilegedFieldBinding;
import org.aspectj.ajdt.internal.compiler.lookup.PrivilegedHandler;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Parser;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.NewFieldTypeMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.UnresolvedType;

public class InterTypeFieldDeclaration
extends InterTypeDeclaration {
    public Expression initialization;
    private TypeBinding realFieldType;

    public InterTypeFieldDeclaration(CompilationResult result, TypeReference onType) {
        super(result, onType);
    }

    public TypeBinding getRealFieldType() {
        return this.realFieldType;
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
    }

    protected char[] getPrefix() {
        return "ajc$interType$interField$".toCharArray();
    }

    public void resolveOnType(ClassScope classScope) {
        super.resolveOnType(classScope);
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        if (Modifier.isStatic(this.declaredModifiers) && this.onTypeBinding.isInterface()) {
            this.scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "static inter-type field on interface not supported");
            this.ignoreFurtherInvestigation = true;
        }
        if (Modifier.isStatic(this.declaredModifiers) && this.typeVariableAliases != null && this.typeVariableAliases.size() > 0 && this.onTypeBinding.isGenericType()) {
            this.scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "static intertype field declarations cannot refer to type variables from the target generic type");
        }
    }

    public void resolve(ClassScope upperScope) {
        MethodBinding writeMethod;
        if (this.munger == null) {
            this.ignoreFurtherInvestigation = true;
        }
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(upperScope);
        ResolvedMember sig = this.munger.getSignature();
        UnresolvedType aspectType = world.fromBinding(upperScope.referenceContext.binding);
        if (sig.getReturnType().equals(UnresolvedType.VOID) || sig.getReturnType().isArray() && sig.getReturnType().getComponentType().equals(UnresolvedType.VOID)) {
            upperScope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "field type can not be void");
        }
        if (this.initialization != null && this.initialization instanceof ArrayInitializer) {
            ArrayAllocationExpression aae = new ArrayAllocationExpression();
            aae.initializer = (ArrayInitializer)this.initialization;
            ArrayBinding arrayType = (ArrayBinding)world.makeTypeBinding(sig.getReturnType());
            aae.type = AstUtil.makeTypeReference(arrayType.leafComponentType());
            aae.sourceStart = this.initialization.sourceStart;
            aae.sourceEnd = this.initialization.sourceEnd;
            aae.dimensions = new Expression[arrayType.dimensions];
            this.initialization = aae;
        }
        if (this.initialization == null) {
            this.statements = new Statement[]{new ReturnStatement(null, 0, 0)};
        } else if (!this.onTypeBinding.isInterface()) {
            writeMethod = world.makeMethodBinding(AjcMemberMaker.interFieldSetDispatcher(sig, aspectType), this.munger.getTypeVariableAliases());
            this.statements = Modifier.isStatic(this.declaredModifiers) ? new Statement[]{new KnownMessageSend(writeMethod, AstUtil.makeNameReference(writeMethod.declaringClass), new Expression[]{this.initialization})} : new Statement[]{new KnownMessageSend(writeMethod, AstUtil.makeNameReference(writeMethod.declaringClass), new Expression[]{AstUtil.makeLocalVariableReference(this.arguments[0].binding), this.initialization})};
        } else {
            writeMethod = world.makeMethodBinding(AjcMemberMaker.interFieldInterfaceSetter(sig, sig.getDeclaringType().resolve(world.getWorld()), aspectType), this.munger.getTypeVariableAliases());
            this.statements = Modifier.isStatic(this.declaredModifiers) ? new Statement[]{new KnownMessageSend(writeMethod, AstUtil.makeNameReference(writeMethod.declaringClass), new Expression[]{this.initialization})} : new Statement[]{new KnownMessageSend(writeMethod, AstUtil.makeLocalVariableReference(this.arguments[0].binding), new Expression[]{this.initialization})};
        }
        super.resolve(upperScope);
    }

    public void setInitialization(Expression initialization) {
        this.initialization = initialization;
    }

    public EclipseTypeMunger build(ClassScope classScope) {
        ResolvedType declaringType;
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(classScope);
        this.resolveOnType(classScope);
        if (this.ignoreFurtherInvestigation) {
            return null;
        }
        this.binding = classScope.referenceContext.binding.resolveTypesFor(this.binding);
        if (this.ignoreFurtherInvestigation) {
            return null;
        }
        if (this.isTargetAnnotation(classScope, "field")) {
            return null;
        }
        if (this.isTargetEnum(classScope, "field")) {
            return null;
        }
        if (!Modifier.isStatic(this.declaredModifiers)) {
            this.binding.parameters = new TypeBinding[]{this.onTypeBinding};
            this.arguments = new Argument[]{AstUtil.makeFinalArgument("ajc$this_".toCharArray(), this.onTypeBinding)};
        }
        if ((declaringType = world.fromBinding(this.onTypeBinding).resolve(world.getWorld())).isRawType() || declaringType.isParameterizedType()) {
            declaringType = declaringType.getGenericType();
        }
        if (this.interTypeScope == null) {
            return null;
        }
        ResolvedMemberImpl sigtemp = world.makeResolvedMemberForITD(this.binding, this.onTypeBinding, this.interTypeScope.getRecoveryAliases());
        UnresolvedType returnType = sigtemp.getReturnType();
        ResolvedMemberImpl sig = new ResolvedMemberImpl(Member.FIELD, declaringType, this.declaredModifiers, returnType, new String(this.declaredSelector), UnresolvedType.NONE);
        sig.setTypeVariables(sigtemp.getTypeVariables());
        NewFieldTypeMunger myMunger = new NewFieldTypeMunger(sig, null, this.typeVariableAliases);
        this.setMunger(myMunger);
        ResolvedType aspectType = world.fromEclipse(classScope.referenceContext.binding);
        ResolvedMember me = myMunger.getInitMethod(aspectType);
        this.binding.selector = me.getName().toCharArray();
        this.selector = this.binding.selector;
        this.realFieldType = this.binding.returnType;
        this.binding.returnType = TypeBinding.VOID;
        return new EclipseTypeMunger(world, myMunger, aspectType, this);
    }

    private AjAttribute makeAttribute() {
        return new AjAttribute.TypeMunger(this.munger);
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        classFile.extraAttributes.add(new EclipseAttributeAdapter(this.makeAttribute()));
        super.generateCode(classScope, classFile);
        this.generateDispatchMethods(classScope, classFile);
    }

    private void generateDispatchMethods(ClassScope classScope, ClassFile classFile) {
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(classScope);
        ResolvedMember sig = this.munger.getSignature();
        UnresolvedType aspectType = world.fromBinding(classScope.referenceContext.binding);
        this.generateDispatchMethod(world, sig, aspectType, classScope, classFile, true);
        this.generateDispatchMethod(world, sig, aspectType, classScope, classFile, false);
    }

    private void generateDispatchMethod(EclipseFactory world, ResolvedMember sig, UnresolvedType aspectType, ClassScope classScope, ClassFile classFile, boolean isGetter) {
        MethodBinding binding = isGetter ? world.makeMethodBinding(AjcMemberMaker.interFieldGetDispatcher(sig, aspectType), this.munger.getTypeVariableAliases(), this.munger.getSignature().getDeclaringType()) : world.makeMethodBinding(AjcMemberMaker.interFieldSetDispatcher(sig, aspectType), this.munger.getTypeVariableAliases(), this.munger.getSignature().getDeclaringType());
        classFile.generateMethodInfoHeader(binding);
        int methodAttributeOffset = classFile.contentsOffset;
        int attributeNumber = classFile.generateMethodInfoAttributes(binding, this.makeEffectiveSignatureAttribute(sig, isGetter ? Shadow.FieldGet : Shadow.FieldSet, false));
        int codeAttributeOffset = classFile.contentsOffset;
        classFile.generateCodeAttributeHeader();
        CodeStream codeStream = classFile.codeStream;
        codeStream.reset(this, classFile);
        NewFieldTypeMunger fieldMunger = (NewFieldTypeMunger)this.munger;
        if (world.getItdVersion() == 1) {
            fieldMunger.version = 1;
        } else if (!this.onTypeBinding.isInterface()) {
            FieldBinding[] existingFields = this.onTypeBinding.fields();
            for (int f = 0; f < existingFields.length; ++f) {
                FieldBinding fieldBinding = existingFields[f];
                if (!CharOperation.equals(fieldBinding.name, sig.getName().toCharArray())) continue;
                fieldMunger.version = 1;
            }
        }
        FieldBinding classField = world.makeFieldBinding(AjcMemberMaker.interFieldClassField(sig, aspectType, fieldMunger.version == 2), this.munger.getTypeVariableAliases());
        codeStream.initializeMaxLocals(binding);
        if (isGetter) {
            if (this.onTypeBinding.isInterface()) {
                UnresolvedType declaringTX = sig.getDeclaringType();
                ResolvedType declaringRTX = world.getWorld().resolve(declaringTX, this.munger.getSourceLocation());
                MethodBinding readMethod = world.makeMethodBinding(AjcMemberMaker.interFieldInterfaceGetter(sig, declaringRTX, aspectType), this.munger.getTypeVariableAliases());
                this.generateInterfaceReadBody(binding, readMethod, codeStream);
            } else {
                this.generateClassReadBody(binding, classField, codeStream);
            }
        } else if (this.onTypeBinding.isInterface()) {
            MethodBinding writeMethod = world.makeMethodBinding(AjcMemberMaker.interFieldInterfaceSetter(sig, world.getWorld().resolve(sig.getDeclaringType(), this.munger.getSourceLocation()), aspectType), this.munger.getTypeVariableAliases());
            this.generateInterfaceWriteBody(binding, writeMethod, codeStream);
        } else {
            this.generateClassWriteBody(binding, classField, codeStream);
        }
        AstUtil.generateReturn(binding.returnType, codeStream);
        classFile.completeCodeAttribute(codeAttributeOffset);
        classFile.completeMethodInfo(binding, methodAttributeOffset, ++attributeNumber);
    }

    private void generateInterfaceReadBody(MethodBinding binding, MethodBinding readMethod, CodeStream codeStream) {
        codeStream.aload_0();
        codeStream.invoke((byte)-71, readMethod, null);
    }

    private void generateInterfaceWriteBody(MethodBinding binding, MethodBinding writeMethod, CodeStream codeStream) {
        codeStream.aload_0();
        codeStream.load(writeMethod.parameters[0], 1);
        codeStream.invoke((byte)-71, writeMethod, null);
    }

    private void generateClassReadBody(MethodBinding binding, FieldBinding field, CodeStream codeStream) {
        if (field.isPrivate() || !field.canBeSeenBy(binding.declaringClass.fPackage)) {
            ReferenceBinding typebinding;
            PrivilegedHandler handler = (PrivilegedHandler)Scope.findPrivilegedHandler(binding.declaringClass);
            if (handler == null && (typebinding = binding.declaringClass) instanceof ReferenceBinding) {
                SourceTypeBinding sourceBinding = (SourceTypeBinding)typebinding;
                handler = new PrivilegedHandler((AspectDeclaration)sourceBinding.scope.referenceContext);
                sourceBinding.privilegedHandler = handler;
            }
            PrivilegedFieldBinding fBinding = (PrivilegedFieldBinding)handler.getPrivilegedAccessField(field, null);
            if (field.isStatic()) {
                codeStream.invoke((byte)-72, fBinding.reader, null);
            } else {
                codeStream.aload_0();
                codeStream.invoke((byte)-72, fBinding.reader, null);
            }
            return;
        }
        if (field.isStatic()) {
            codeStream.fieldAccess((byte)-78, field, null);
        } else {
            codeStream.aload_0();
            codeStream.fieldAccess((byte)-76, field, null);
        }
    }

    private void generateClassWriteBody(MethodBinding binding, FieldBinding field, CodeStream codeStream) {
        if (field.isPrivate() || !field.canBeSeenBy(binding.declaringClass.fPackage)) {
            PrivilegedFieldBinding fBinding = (PrivilegedFieldBinding)Scope.findPrivilegedHandler(binding.declaringClass).getPrivilegedAccessField(field, null);
            if (field.isStatic()) {
                codeStream.load(field.type, 0);
                codeStream.invoke((byte)-72, fBinding.writer, null);
            } else {
                codeStream.aload_0();
                codeStream.load(field.type, 1);
                codeStream.invoke((byte)-72, fBinding.writer, null);
            }
            return;
        }
        if (field.isStatic()) {
            codeStream.load(field.type, 0);
            codeStream.fieldAccess((byte)-77, field, null);
        } else {
            codeStream.aload_0();
            codeStream.load(field.type, 1);
            codeStream.fieldAccess((byte)-75, field, null);
        }
    }

    protected Shadow.Kind getShadowKindForBody() {
        return null;
    }
}

