/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELClass;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.MethodNotFoundException;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;

public class StaticFieldELResolver
extends ELResolver {
    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base instanceof ELClass && property instanceof String) {
            String name = (String)property;
            context.setPropertyResolved(base, property);
            Class<?> clazz = ((ELClass)base).getKlass();
            Exception exception = null;
            try {
                Field field = clazz.getField(name);
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers) && Util.canAccess(null, field)) {
                    return field.get(null);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                exception = e;
            }
            String msg = Util.message(context, "staticFieldELResolver.notFound", name, clazz.getName());
            if (exception == null) {
                throw new PropertyNotFoundException(msg);
            }
            throw new PropertyNotFoundException(msg, exception);
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        Objects.requireNonNull(context);
        if (base instanceof ELClass && property instanceof String) {
            String name = (String)property;
            Class<?> clazz = ((ELClass)base).getKlass();
            throw new PropertyNotWritableException(Util.message(context, "staticFieldELResolver.notWritable", name, clazz.getName()));
        }
    }

    @Override
    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        Objects.requireNonNull(context);
        if (base instanceof ELClass && method instanceof String) {
            Object result;
            String methodName = (String)method;
            context.setPropertyResolved(base, method);
            Class<?> clazz = ((ELClass)base).getKlass();
            if ("<init>".equals(methodName)) {
                Object result2;
                Constructor<?> match = Util.findConstructor(context, clazz, paramTypes, params);
                Object[] parameters = Util.buildParameters(context, match.getParameterTypes(), match.isVarArgs(), params);
                try {
                    result2 = match.newInstance(parameters);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    Util.handleThrowable(cause);
                    throw new ELException(cause);
                }
                catch (ReflectiveOperationException e) {
                    throw new ELException(e);
                }
                return result2;
            }
            Method match = Util.findMethod(context, clazz, null, methodName, paramTypes, params);
            if (match == null) {
                throw new MethodNotFoundException(Util.message(context, "staticFieldELResolver.methodNotFound", methodName, clazz.getName()));
            }
            Object[] parameters = Util.buildParameters(context, match.getParameterTypes(), match.isVarArgs(), params);
            try {
                result = match.invoke(null, parameters);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new ELException(e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                Util.handleThrowable(cause);
                throw new ELException(cause);
            }
            return result;
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base instanceof ELClass && property instanceof String) {
            String name = (String)property;
            context.setPropertyResolved(base, property);
            Class<?> clazz = ((ELClass)base).getKlass();
            Exception exception = null;
            try {
                Field field = clazz.getField(name);
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers) && Util.canAccess(null, field)) {
                    return null;
                }
            }
            catch (IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                exception = e;
            }
            String msg = Util.message(context, "staticFieldELResolver.notFound", name, clazz.getName());
            if (exception == null) {
                throw new PropertyNotFoundException(msg);
            }
            throw new PropertyNotFoundException(msg, exception);
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base instanceof ELClass && property instanceof String) {
            context.setPropertyResolved(base, property);
        }
        return true;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return String.class;
    }
}

