/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class AprLifecycleListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(AprLifecycleListener.class);
    private static boolean instanceCreated = false;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");
    protected static final int TCN_REQUIRED_MAJOR = 1;
    protected static final int TCN_REQUIRED_MINOR = 1;
    protected static final int TCN_REQUIRED_PATCH = 17;
    protected static final int TCN_RECOMMENDED_MINOR = 1;
    protected static final int TCN_RECOMMENDED_PV = 20;
    protected static String SSLEngine = "on";
    protected static String SSLRandomSeed = "builtin";
    protected static boolean sslInitialized = false;
    protected static boolean aprInitialized = false;
    protected static boolean sslAvailable = false;
    protected static boolean aprAvailable = false;
    protected static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAprAvailable() {
        if (instanceCreated) {
            Object object = lock;
            synchronized (object) {
                AprLifecycleListener.init();
            }
        }
        return aprAvailable;
    }

    public AprLifecycleListener() {
        instanceCreated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("init".equals(event.getType())) {
            Object object = lock;
            synchronized (object) {
                AprLifecycleListener.init();
                if (aprAvailable) {
                    try {
                        AprLifecycleListener.initializeSSL();
                    }
                    catch (Throwable t) {
                        log.info((Object)sm.getString("aprListener.sslInit"));
                    }
                }
            }
        }
        if ("after_stop".equals(event.getType())) {
            Object object = lock;
            synchronized (object) {
                if (!aprAvailable) {
                    return;
                }
                try {
                    AprLifecycleListener.terminateAPR();
                }
                catch (Throwable t) {
                    log.info((Object)sm.getString("aprListener.aprDestroy"));
                }
            }
        }
    }

    private static void terminateAPR() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String methodName = "terminate";
        Method method = Class.forName("org.apache.tomcat.jni.Library").getMethod(methodName, null);
        method.invoke(null, (Object[])null);
        aprAvailable = false;
        aprInitialized = false;
        sslInitialized = false;
    }

    private static void init() {
        int major = 0;
        int minor = 0;
        int patch = 0;
        if (aprInitialized) {
            return;
        }
        aprInitialized = true;
        try {
            String methodName = "initialize";
            Class[] paramTypes = new Class[]{String.class};
            Object[] paramValues = new Object[]{null};
            Class<?> clazz = Class.forName("org.apache.tomcat.jni.Library");
            Method method = clazz.getMethod(methodName, paramTypes);
            method.invoke(null, paramValues);
            major = clazz.getField("TCN_MAJOR_VERSION").getInt(null);
            minor = clazz.getField("TCN_MINOR_VERSION").getInt(null);
            patch = clazz.getField("TCN_PATCH_VERSION").getInt(null);
        }
        catch (Throwable t) {
            log.info((Object)sm.getString("aprListener.aprInit", new Object[]{System.getProperty("java.library.path")}));
            return;
        }
        if (major != 1 || minor < 1 || minor == 1 && patch < 17) {
            log.error((Object)sm.getString("aprListener.tcnInvalid", new Object[]{major + "." + minor + "." + patch, "1.1.17"}));
            try {
                AprLifecycleListener.terminateAPR();
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
            }
            return;
        }
        if (minor < 1 || minor == 1 && patch < 20) {
            log.info((Object)sm.getString("aprListener.tcnVersion", new Object[]{major + "." + minor + "." + patch, "1.1.20"}));
        }
        log.info((Object)sm.getString("aprListener.tcnValid", new Object[]{major + "." + minor + "." + patch}));
        log.info((Object)sm.getString("aprListener.flags", new Object[]{Library.APR_HAVE_IPV6, Library.APR_HAS_SENDFILE, Library.APR_HAS_SO_ACCEPTFILTER, Library.APR_HAS_RANDOM}));
        aprAvailable = true;
    }

    private static void initializeSSL() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if ("off".equalsIgnoreCase(SSLEngine)) {
            return;
        }
        if (sslInitialized) {
            return;
        }
        sslInitialized = true;
        String methodName = "randSet";
        Class[] paramTypes = new Class[]{String.class};
        Object[] paramValues = new Object[]{SSLRandomSeed};
        Class<?> clazz = Class.forName("org.apache.tomcat.jni.SSL");
        Method method = clazz.getMethod(methodName, paramTypes);
        method.invoke(null, paramValues);
        methodName = "initialize";
        paramValues[0] = "on".equalsIgnoreCase(SSLEngine) ? null : SSLEngine;
        method = clazz.getMethod(methodName, paramTypes);
        method.invoke(null, paramValues);
        sslAvailable = true;
    }

    public String getSSLEngine() {
        return SSLEngine;
    }

    public void setSSLEngine(String SSLEngine) {
        AprLifecycleListener.SSLEngine = SSLEngine;
    }

    public String getSSLRandomSeed() {
        return SSLRandomSeed;
    }

    public void setSSLRandomSeed(String SSLRandomSeed) {
        AprLifecycleListener.SSLRandomSeed = SSLRandomSeed;
    }
}

