/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.template;

import java.io.IOException;
import java.io.Writer;
import java.util.Deque;
import org.apache.tiles.Attribute;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.autotag.core.runtime.ModelBody;
import org.apache.tiles.request.Request;
import org.apache.tiles.template.AttributeResolver;
import org.apache.tiles.template.ComposeStackUtil;
import org.apache.tiles.template.DefaultAttributeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAsStringModel {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private AttributeResolver attributeResolver;

    public GetAsStringModel() {
        this(new DefaultAttributeResolver());
    }

    public GetAsStringModel(AttributeResolver attributeResolver) {
        this.attributeResolver = attributeResolver;
    }

    public void execute(boolean ignore, String preparer, String role, Object defaultValue, String defaultValueRole, String defaultValueType, String name, Attribute value, Request request, ModelBody modelBody) throws IOException {
        TilesContainer container = TilesAccess.getCurrentContainer((Request)request);
        Deque<Object> composeStack = ComposeStackUtil.getComposeStack(request);
        Attribute attribute = this.resolveAttribute(container, ignore, preparer, role, defaultValue, defaultValueRole, defaultValueType, name, value, request);
        if (attribute != null) {
            composeStack.push(attribute);
        }
        modelBody.evaluateWithoutWriting();
        container = TilesAccess.getCurrentContainer((Request)request);
        Writer writer = request.getWriter();
        if (attribute != null) {
            attribute = (Attribute)composeStack.pop();
        }
        this.renderAttribute(attribute, container, writer, ignore, request);
    }

    private Attribute resolveAttribute(TilesContainer container, boolean ignore, String preparer, String role, Object defaultValue, String defaultValueRole, String defaultValueType, String name, Attribute value, Request request) {
        if (preparer != null) {
            container.prepare(preparer, request);
        }
        Attribute attribute = this.attributeResolver.computeAttribute(container, value, name, role, ignore, defaultValue, defaultValueRole, defaultValueType, request);
        container.startContext(request);
        return attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderAttribute(Attribute attribute, TilesContainer container, Writer writer, boolean ignore, Request request) throws IOException {
        try {
            if (attribute == null && ignore) {
                return;
            }
            writer.write(attribute.getValue().toString());
        }
        catch (IOException e) {
            if (!ignore) {
                throw e;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Ignoring exception", (Throwable)e);
            }
        }
        catch (RuntimeException e) {
            if (!ignore) {
                throw e;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Ignoring exception", (Throwable)e);
            }
        }
        finally {
            container.endContext(request);
        }
    }
}

