/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tiles.request.attribute.HasKeys;
import org.apache.tiles.request.collection.CollectionUtil;

public class KeySet
implements Set<String> {
    private HasKeys<?> request;

    public KeySet(HasKeys<?> request) {
        this.request = request;
    }

    @Override
    public boolean add(String e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        return this.request.getValue(CollectionUtil.key(o)) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Collection<?> realCollection = c;
        for (String key : realCollection) {
            if (this.request.getValue(CollectionUtil.key(key)) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return !this.request.getKeys().hasMoreElements();
    }

    @Override
    public Iterator<String> iterator() {
        return new KeySetIterator();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return CollectionUtil.enumerationSize(this.request.getKeys());
    }

    @Override
    public Object[] toArray() {
        return this.toList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toList().toArray(a);
    }

    private List<String> toList() {
        ArrayList<String> entries = new ArrayList<String>();
        Enumeration<String> names = this.request.getKeys();
        while (names.hasMoreElements()) {
            entries.add(names.nextElement());
        }
        return entries;
    }

    private class KeySetIterator
    implements Iterator<String> {
        private Enumeration<String> namesEnumeration;

        private KeySetIterator() {
            this.namesEnumeration = KeySet.this.request.getKeys();
        }

        @Override
        public boolean hasNext() {
            return this.namesEnumeration.hasMoreElements();
        }

        @Override
        public String next() {
            return this.namesEnumeration.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

