/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.jsp.context;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.JspFragment;
import org.apache.tiles.ArrayStack;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.impl.NoSuchContainerException;
import org.apache.tiles.jsp.taglib.TilesJspException;
import org.apache.tiles.servlet.context.ServletUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JspUtil {
    public static final String COMPOSE_STACK_ATTRIBUTE_NAME = "org.apache.tiles.template.COMPOSE_STACK";
    private static final Map<String, Integer> SCOPES = new HashMap<String, Integer>();

    private JspUtil() {
    }

    public static boolean isForceInclude(JspContext context) {
        Boolean retValue = (Boolean)context.getAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.FORCE_INCLUDE", 2);
        return retValue != null && retValue != false;
    }

    public static void setForceInclude(JspContext context, boolean forceInclude) {
        Boolean retValue = forceInclude;
        context.setAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.FORCE_INCLUDE", (Object)retValue, 2);
    }

    public static TilesContainer getContainer(JspContext context) {
        return JspUtil.getContainer(context, "org.apache.tiles.CONTAINER");
    }

    public static TilesContainer getContainer(JspContext context, String key) {
        if (key == null) {
            key = "org.apache.tiles.CONTAINER";
        }
        return (TilesContainer)context.getAttribute(key, 4);
    }

    public static void setContainer(JspContext context, TilesContainer container) {
        JspUtil.setContainer(context, container, "org.apache.tiles.CONTAINER");
    }

    public static void setContainer(JspContext context, TilesContainer container, String key) {
        Logger log = LoggerFactory.getLogger(ServletUtil.class);
        if (key == null) {
            key = "org.apache.tiles.CONTAINER";
        }
        if (container == null) {
            if (log.isInfoEnabled()) {
                log.info("Removing TilesContext for context: " + context.getClass().getName());
            }
            context.removeAttribute(key, 4);
        }
        if (container != null && log.isInfoEnabled()) {
            log.info("Publishing TilesContext for context: " + context.getClass().getName());
        }
        context.setAttribute(key, (Object)container, 4);
    }

    public static void setCurrentContainer(JspContext context, String key) {
        TilesContainer container = JspUtil.getContainer(context, key);
        if (container == null) {
            throw new NoSuchContainerException("The container with the key '" + key + "' cannot be found");
        }
        context.setAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.CURRENT_CONTAINER_KEY", (Object)container, 2);
    }

    public static void setCurrentContainer(JspContext context, TilesContainer container) {
        if (container == null) {
            throw new NoSuchContainerException("The container cannot be null");
        }
        context.setAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.CURRENT_CONTAINER_KEY", (Object)container, 2);
    }

    public static TilesContainer getCurrentContainer(JspContext context) {
        TilesContainer container = (TilesContainer)context.getAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.CURRENT_CONTAINER_KEY", 2);
        if (container == null) {
            container = JspUtil.getContainer(context);
            context.setAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.CURRENT_CONTAINER_KEY", (Object)container, 2);
        }
        return container;
    }

    public static ArrayStack<Object> getComposeStack(JspContext context) {
        ArrayStack composeStack = (ArrayStack)context.getAttribute(COMPOSE_STACK_ATTRIBUTE_NAME, 2);
        if (composeStack == null) {
            composeStack = new ArrayStack();
            context.setAttribute(COMPOSE_STACK_ATTRIBUTE_NAME, (Object)composeStack, 2);
        }
        return composeStack;
    }

    public static int getScope(String scopeName) throws TilesJspException {
        if (scopeName == null) {
            return 1;
        }
        Integer scope = SCOPES.get(scopeName.toLowerCase());
        if (scope == null) {
            throw new TilesJspException("Unable to retrieve the scope " + scopeName);
        }
        return scope;
    }

    public static void evaluateFragment(JspFragment fragment) throws JspException, IOException {
        if (fragment != null) {
            fragment.invoke(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String evaluateFragmentAsString(JspFragment fragment) throws JspException, IOException {
        String body = null;
        if (fragment != null) {
            StringWriter writer = new StringWriter();
            try {
                fragment.invoke((Writer)writer);
            }
            finally {
                writer.close();
            }
            body = writer.toString();
        }
        return body;
    }

    static {
        SCOPES.put("page", 1);
        SCOPES.put("request", 2);
        SCOPES.put("session", 3);
        SCOPES.put("application", 4);
    }
}

