/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.trident;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.storm.kafka.trident.GlobalPartitionInformation;
import org.apache.storm.kafka.trident.IBrokerReader;

public class StaticBrokerReader
implements IBrokerReader {
    private Map<String, GlobalPartitionInformation> brokers = new TreeMap<String, GlobalPartitionInformation>();

    public StaticBrokerReader(String topic, GlobalPartitionInformation partitionInformation) {
        this.brokers.put(topic, partitionInformation);
    }

    @Override
    public GlobalPartitionInformation getBrokerForTopic(String topic) {
        if (this.brokers.containsKey(topic)) {
            return this.brokers.get(topic);
        }
        return null;
    }

    @Override
    public List<GlobalPartitionInformation> getAllBrokers() {
        ArrayList<GlobalPartitionInformation> list = new ArrayList<GlobalPartitionInformation>();
        list.addAll(this.brokers.values());
        return list;
    }

    @Override
    public void close() {
    }
}

