/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.trident;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.storm.kafka.Broker;
import org.apache.storm.kafka.Partition;

public class GlobalPartitionInformation
implements Iterable<Partition>,
Serializable {
    private Map<Integer, Broker> partitionMap;
    public String topic;
    private Boolean bUseTopicNameForPartitionPathId;

    public GlobalPartitionInformation(String topic, Boolean bUseTopicNameForPartitionPathId) {
        this.topic = topic;
        this.partitionMap = new TreeMap<Integer, Broker>();
        this.bUseTopicNameForPartitionPathId = bUseTopicNameForPartitionPathId;
    }

    public GlobalPartitionInformation(String topic) {
        this.topic = topic;
        this.partitionMap = new TreeMap<Integer, Broker>();
        this.bUseTopicNameForPartitionPathId = false;
    }

    public void addPartition(int partitionId, Broker broker) {
        this.partitionMap.put(partitionId, broker);
    }

    public Boolean getbUseTopicNameForPartitionPathId() {
        return this.bUseTopicNameForPartitionPathId;
    }

    public String toString() {
        return "GlobalPartitionInformation{topic=" + this.topic + ", partitionMap=" + this.partitionMap + '}';
    }

    public Broker getBrokerFor(Integer partitionId) {
        return this.partitionMap.get(partitionId);
    }

    public List<Partition> getOrderedPartitions() {
        LinkedList<Partition> partitions = new LinkedList<Partition>();
        for (Map.Entry<Integer, Broker> partition : this.partitionMap.entrySet()) {
            partitions.add(new Partition(partition.getValue(), this.topic, partition.getKey(), this.bUseTopicNameForPartitionPathId));
        }
        return partitions;
    }

    @Override
    public Iterator<Partition> iterator() {
        final Iterator<Map.Entry<Integer, Broker>> iterator = this.partitionMap.entrySet().iterator();
        final String topic = this.topic;
        final Boolean bUseTopicNameForPartitionPathId = this.bUseTopicNameForPartitionPathId;
        return new Iterator<Partition>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Partition next() {
                Map.Entry next = (Map.Entry)iterator.next();
                return new Partition((Broker)next.getValue(), topic, (Integer)next.getKey(), bUseTopicNameForPartitionPathId);
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.partitionMap});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalPartitionInformation other = (GlobalPartitionInformation)obj;
        return Objects.equal(this.partitionMap, other.partitionMap);
    }
}

