/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka;

import com.google.common.base.Objects;
import java.io.Serializable;
import org.apache.storm.kafka.Broker;
import org.apache.storm.trident.spout.ISpoutPartition;

public class Partition
implements ISpoutPartition,
Serializable {
    public Broker host;
    public int partition;
    public String topic;
    private Boolean bUseTopicNameForPartitionPathId;

    private Partition() {
    }

    public Partition(Broker host, String topic, int partition) {
        this.topic = topic;
        this.host = host;
        this.partition = partition;
        this.bUseTopicNameForPartitionPathId = false;
    }

    public Partition(Broker host, String topic, int partition, Boolean bUseTopicNameForPartitionPathId) {
        this.topic = topic;
        this.host = host;
        this.partition = partition;
        this.bUseTopicNameForPartitionPathId = bUseTopicNameForPartitionPathId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.host, this.topic, this.partition});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Partition other = (Partition)obj;
        return Objects.equal((Object)this.host, (Object)other.host) && Objects.equal((Object)this.topic, (Object)other.topic) && Objects.equal((Object)this.partition, (Object)other.partition);
    }

    public String toString() {
        return "Partition{host=" + this.host + ", topic=" + this.topic + ", partition=" + this.partition + '}';
    }

    public String getId() {
        if (this.bUseTopicNameForPartitionPathId.booleanValue()) {
            return this.topic + "/partition_" + this.partition;
        }
        return "partition_" + this.partition;
    }
}

