/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.spark.serializer.KryoInputObjectInputBridge;
import org.apache.spark.serializer.KryoOutputObjectOutputBridge;
import org.apache.spark.streaming.util.EmptyStateMap;
import org.apache.spark.streaming.util.OpenHashMapBasedStateMap$;
import org.apache.spark.streaming.util.OpenHashMapBasedStateMap$StateInfo$;
import org.apache.spark.streaming.util.StateMap;
import org.apache.spark.util.collection.OpenHashMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0011\u001db!B\u0001\u0003\u0001\u0011a!\u0001G(qK:D\u0015m\u001d5NCB\u0014\u0015m]3e'R\fG/Z'ba*\u00111\u0001B\u0001\u0005kRLGN\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sOV\u0019Q\u0002\u0006\u0012\u0014\u0007\u0001qA\u0005\u0005\u0003\u0010!I\tS\"\u0001\u0002\n\u0005E\u0011!\u0001C*uCR,W*\u00199\u0011\u0005M!B\u0002\u0001\u0003\u0006+\u0001\u0011\ra\u0006\u0002\u0002\u0017\u000e\u0001\u0011C\u0001\r\u001f!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!G\u0010\n\u0005\u0001R\"aA!osB\u00111C\t\u0003\u0006G\u0001\u0011\ra\u0006\u0002\u0002'B\u0011Q\u0005L\u0007\u0002M)\u0011q\u0005K\u0001\u0005WJLxN\u0003\u0002*U\u0005\u0001Rm]8uKJL7m]8gi^\f'/\u001a\u0006\u0002W\u0005\u00191m\\7\n\u000552#\u0001E&ss>\u001cVM]5bY&T\u0018M\u00197f\u0011!y\u0003A!a\u0001\n\u0003\u0001\u0014A\u00049be\u0016tGo\u0015;bi\u0016l\u0015\r]\u000b\u0002\u001d!A!\u0007\u0001BA\u0002\u0013\u00051'\u0001\nqCJ,g\u000e^*uCR,W*\u00199`I\u0015\fHC\u0001\u001b8!\tIR'\u0003\u000275\t!QK\\5u\u0011\u001dA\u0014'!AA\u00029\t1\u0001\u001f\u00132\u0011!Q\u0004A!A!B\u0013q\u0011a\u00049be\u0016tGo\u0015;bi\u0016l\u0015\r\u001d\u0011)\u0005eb\u0004CA\r>\u0013\tq$D\u0001\u0005w_2\fG/\u001b7fQ\tI\u0004\t\u0005\u0002\u001a\u0003&\u0011!I\u0007\u0002\niJ\fgn]5f]RD\u0001\u0002\u0012\u0001\u0003\u0002\u0004%I!R\u0001\u0010S:LG/[1m\u0007\u0006\u0004\u0018mY5usV\ta\t\u0005\u0002\u001a\u000f&\u0011\u0001J\u0007\u0002\u0004\u0013:$\b\u0002\u0003&\u0001\u0005\u0003\u0007I\u0011B&\u0002'%t\u0017\u000e^5bY\u000e\u000b\u0007/Y2jif|F%Z9\u0015\u0005Qb\u0005b\u0002\u001dJ\u0003\u0003\u0005\rA\u0012\u0005\t\u001d\u0002\u0011\t\u0011)Q\u0005\r\u0006\u0001\u0012N\\5uS\u0006d7)\u00199bG&$\u0018\u0010\t\u0005\t!\u0002\u0011\t\u0019!C\u0005\u000b\u0006\u0019B-\u001a7uC\u000eC\u0017-\u001b8UQJ,7\u000f[8mI\"A!\u000b\u0001BA\u0002\u0013%1+A\feK2$\u0018m\u00115bS:$\u0006N]3tQ>dGm\u0018\u0013fcR\u0011A\u0007\u0016\u0005\bqE\u000b\t\u00111\u0001G\u0011!1\u0006A!A!B\u00131\u0015\u0001\u00063fYR\f7\t[1j]RC'/Z:i_2$\u0007\u0005\u0003\u0005Y\u0001\t\u0005\r\u0011b\u0003Z\u0003-YW-_\"mCN\u001cH+Y4\u0016\u0003i\u00032a\u00170\u0013\u001b\u0005a&BA/\u001b\u0003\u001d\u0011XM\u001a7fGRL!a\u0018/\u0003\u0011\rc\u0017m]:UC\u001eD\u0001\"\u0019\u0001\u0003\u0002\u0004%IAY\u0001\u0010W\u0016L8\t\\1tgR\u000bwm\u0018\u0013fcR\u0011Ag\u0019\u0005\bq\u0001\f\t\u00111\u0001[\u0011!)\u0007A!A!B\u0013Q\u0016\u0001D6fs\u000ec\u0017m]:UC\u001e\u0004\u0003\u0002C4\u0001\u0005\u0003\u0007I1\u00025\u0002\u001bM$\u0018\r^3DY\u0006\u001c8\u000fV1h+\u0005I\u0007cA._C!A1\u000e\u0001BA\u0002\u0013%A.A\tti\u0006$Xm\u00117bgN$\u0016mZ0%KF$\"\u0001N7\t\u000faR\u0017\u0011!a\u0001S\"Aq\u000e\u0001B\u0001B\u0003&\u0011.\u0001\bti\u0006$Xm\u00117bgN$\u0016m\u001a\u0011\t\u000bE\u0004A\u0011\u0001:\u0002\rqJg.\u001b;?)\u0011\u0019x\u000f_=\u0015\u0007Q,h\u000f\u0005\u0003\u0010\u0001I\t\u0003\"\u0002-q\u0001\bQ\u0006\"B4q\u0001\bI\u0007\"B\u0018q\u0001\u0004q\u0001b\u0002#q!\u0003\u0005\rA\u0012\u0005\b!B\u0004\n\u00111\u0001G\u0011\u0015\t\b\u0001\"\u0001|)\u0011ax0!\u0001\u0015\u0007Qlh\u0010C\u0003Yu\u0002\u000f!\fC\u0003hu\u0002\u000f\u0011\u000eC\u0003Eu\u0002\u0007a\tC\u0003Qu\u0002\u0007a\t\u0003\u0004r\u0001\u0011\u0005\u0011Q\u0001\u000b\u0005\u0003\u000f\ti\u0001F\u0003u\u0003\u0013\tY\u0001\u0003\u0004Y\u0003\u0007\u0001\u001dA\u0017\u0005\u0007O\u0006\r\u00019A5\t\rA\u000b\u0019\u00011\u0001G\u0011\u0019\t\b\u0001\"\u0001\u0002\u0012Q\u0011\u00111\u0003\u000b\u0006i\u0006U\u0011q\u0003\u0005\u00071\u0006=\u00019\u0001.\t\r\u001d\fy\u0001q\u0001j\u0011%\tY\u0002\u0001a\u0001\n\u0013\ti\"\u0001\u0005eK2$\u0018-T1q+\t\ty\u0002E\u0004\u0002\"\u0005%\"#!\f\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\t!bY8mY\u0016\u001cG/[8o\u0015\t\u0019a!\u0003\u0003\u0002,\u0005\r\"aC(qK:D\u0015m\u001d5NCB\u0004R!a\f\u0002f\u0005rA!!\r\u0002L9!\u00111GA%\u001d\u0011\t)$a\u0012\u000f\t\u0005]\u0012Q\t\b\u0005\u0003s\t\u0019E\u0004\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\r\tyDF\u0001\u0007yI|w\u000e\u001e \n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\u0019Aa\u0002\u0005\u0002N\tA\t\u0001BA(\u0003ay\u0005/\u001a8ICNDW*\u00199CCN,Gm\u0015;bi\u0016l\u0015\r\u001d\t\u0004\u001f\u0005EcaB\u0001\u0003\u0011\u0003!\u00111K\n\u0007\u0003#\n)&a\u0017\u0011\u0007e\t9&C\u0002\u0002Zi\u0011a!\u00118z%\u00164\u0007cA\r\u0002^%\u0019\u0011q\f\u000e\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000fE\f\t\u0006\"\u0001\u0002dQ\u0011\u0011q\n\u0004\b\u0003O\n\t\u0006QA5\u0005%\u0019F/\u0019;f\u0013:4w.\u0006\u0003\u0002l\u0005m4\u0003CA3\u0003+\ni'a\u0017\u0011\u0007e\ty'C\u0002\u0002ri\u0011q\u0001\u0015:pIV\u001cG\u000fC\u0006\u0002v\u0005\u0015$\u00113A\u0005\u0002\u0005]\u0014\u0001\u00023bi\u0006,\"!!\u001f\u0011\u0007M\tY\b\u0002\u0004$\u0003K\u0012\ra\u0006\u0005\f\u0003\u007f\n)G!a\u0001\n\u0003\t\t)\u0001\u0005eCR\fw\fJ3r)\r!\u00141\u0011\u0005\nq\u0005u\u0014\u0011!a\u0001\u0003sB1\"a\"\u0002f\tE\t\u0015)\u0003\u0002z\u0005)A-\u0019;bA!Y\u00111RA3\u0005#\u0007I\u0011AAG\u0003))\b\u000fZ1uKRKW.Z\u000b\u0003\u0003\u001f\u00032!GAI\u0013\r\t\u0019J\u0007\u0002\u0005\u0019>tw\rC\u0006\u0002\u0018\u0006\u0015$\u00111A\u0005\u0002\u0005e\u0015AD;qI\u0006$X\rV5nK~#S-\u001d\u000b\u0004i\u0005m\u0005\"\u0003\u001d\u0002\u0016\u0006\u0005\t\u0019AAH\u0011-\ty*!\u001a\u0003\u0012\u0003\u0006K!a$\u0002\u0017U\u0004H-\u0019;f)&lW\r\t\u0005\f\u0003G\u000b)G!e\u0001\n\u0003\t)+A\u0004eK2,G/\u001a3\u0016\u0005\u0005\u001d\u0006cA\r\u0002*&\u0019\u00111\u0016\u000e\u0003\u000f\t{w\u000e\\3b]\"Y\u0011qVA3\u0005\u0003\u0007I\u0011AAY\u0003-!W\r\\3uK\u0012|F%Z9\u0015\u0007Q\n\u0019\fC\u00059\u0003[\u000b\t\u00111\u0001\u0002(\"Y\u0011qWA3\u0005#\u0005\u000b\u0015BAT\u0003!!W\r\\3uK\u0012\u0004\u0003bB9\u0002f\u0011\u0005\u00111\u0018\u000b\t\u0003{\u000b\t-a1\u0002FB1\u0011qXA3\u0003sj!!!\u0015\t\u0015\u0005U\u0014\u0011\u0018I\u0001\u0002\u0004\tI\b\u0003\u0006\u0002\f\u0006e\u0006\u0013!a\u0001\u0003\u001fC!\"a)\u0002:B\u0005\t\u0019AAT\u0011!\tI-!\u001a\u0005\u0002\u0005-\u0017aC7be.$U\r\\3uK\u0012$\u0012\u0001\u000e\u0005\t\u0003\u001f\f)\u0007\"\u0001\u0002R\u00061Q\u000f\u001d3bi\u0016$R\u0001NAj\u0003/D\u0001\"!6\u0002N\u0002\u0007\u0011\u0011P\u0001\b]\u0016<H)\u0019;b\u0011!\tI.!4A\u0002\u0005=\u0015!\u00048foV\u0003H-\u0019;f)&lW\r\u0003\u0006\u0002^\u0006\u0015\u0014\u0011!C\u0001\u0003?\fAaY8qsV!\u0011\u0011]At)!\t\u0019/!;\u0002l\u00065\bCBA`\u0003K\n)\u000fE\u0002\u0014\u0003O$aaIAn\u0005\u00049\u0002BCA;\u00037\u0004\n\u00111\u0001\u0002f\"Q\u00111RAn!\u0003\u0005\r!a$\t\u0015\u0005\r\u00161\u001cI\u0001\u0002\u0004\t9\u000b\u0003\u0006\u0002r\u0006\u0015\u0014\u0013!C\u0001\u0003g\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0003\u0002v\n-QCAA|U\u0011\tI(!?,\u0005\u0005m\b\u0003BA\u007f\u0005\u000fi!!a@\u000b\t\t\u0005!1A\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0002\u001b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0013\tyPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$aaIAx\u0005\u00049\u0002B\u0003B\b\u0003K\n\n\u0011\"\u0001\u0003\u0012\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012T\u0003\u0002B\n\u0005/)\"A!\u0006+\t\u0005=\u0015\u0011 \u0003\u0007G\t5!\u0019A\f\t\u0015\tm\u0011QMI\u0001\n\u0003\u0011i\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\t\t}!1E\u000b\u0003\u0005CQC!a*\u0002z\u001211E!\u0007C\u0002]A!Ba\n\u0002f\u0005\u0005I\u0011\tB\u0015\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!1\u0006\t\u0005\u0005[\u00119$\u0004\u0002\u00030)!!\u0011\u0007B\u001a\u0003\u0011a\u0017M\\4\u000b\u0005\tU\u0012\u0001\u00026bm\u0006LAA!\u000f\u00030\t11\u000b\u001e:j]\u001eD\u0011B!\u0010\u0002f\u0005\u0005I\u0011A#\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0015\t\u0005\u0013QMA\u0001\n\u0003\u0011\u0019%\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007y\u0011)\u0005\u0003\u00059\u0005\u007f\t\t\u00111\u0001G\u0011)\u0011I%!\u001a\u0002\u0002\u0013\u0005#1J\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\n\t\u0006\u0005\u001f\u0012\u0019FH\u0007\u0003\u0005#R1!!\n\u001b\u0013\u0011\u0011)F!\u0015\u0003\u0011%#XM]1u_JD!B!\u0017\u0002f\u0005\u0005I\u0011\u0001B.\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAT\u0005;B\u0001\u0002\u000fB,\u0003\u0003\u0005\rA\b\u0005\u000b\u0005C\n)'!A\u0005B\t\r\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003\u0019C!Ba\u001a\u0002f\u0005\u0005I\u0011\tB5\u0003!!xn\u0015;sS:<GC\u0001B\u0016\u0011)\u0011i'!\u001a\u0002\u0002\u0013\u0005#qN\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u001d&\u0011\u000f\u0005\tq\t-\u0014\u0011!a\u0001=\u001dQ!QOA)\u0003\u0003E\tAa\u001e\u0002\u0013M#\u0018\r^3J]\u001a|\u0007\u0003BA`\u0005s2!\"a\u001a\u0002R\u0005\u0005\t\u0012\u0001B>'\u0019\u0011I(!\u0016\u0002\\!9\u0011O!\u001f\u0005\u0002\t}DC\u0001B<\u0011)\u00119G!\u001f\u0002\u0002\u0013\u0015#\u0011\u000e\u0005\u000b\u0005\u000b\u0013I(!A\u0005\u0002\n\u001d\u0015!B1qa2LX\u0003\u0002BE\u0005\u001f#\u0002Ba#\u0003\u0012\nM%Q\u0013\t\u0007\u0003\u007f\u000b)G!$\u0011\u0007M\u0011y\t\u0002\u0004$\u0005\u0007\u0013\ra\u0006\u0005\u000b\u0003k\u0012\u0019\t%AA\u0002\t5\u0005BCAF\u0005\u0007\u0003\n\u00111\u0001\u0002\u0010\"Q\u00111\u0015BB!\u0003\u0005\r!a*\t\u0015\te%\u0011PA\u0001\n\u0003\u0013Y*A\u0004v]\u0006\u0004\b\u000f\\=\u0016\t\tu%Q\u0016\u000b\u0005\u0005?\u0013y\u000bE\u0003\u001a\u0005C\u0013)+C\u0002\u0003$j\u0011aa\u00149uS>t\u0007#C\r\u0003(\n-\u0016qRAT\u0013\r\u0011IK\u0007\u0002\u0007)V\u0004H.Z\u001a\u0011\u0007M\u0011i\u000b\u0002\u0004$\u0005/\u0013\ra\u0006\u0005\u000b\u0005c\u00139*!AA\u0002\tM\u0016a\u0001=%aA1\u0011qXA3\u0005WC!Ba.\u0003zE\u0005I\u0011\u0001B]\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU!!1\u0018Ba+\t\u0011iL\u000b\u0003\u0003@\u0006e\bcA\n\u0003B\u001211E!.C\u0002]A!B!2\u0003zE\u0005I\u0011\u0001Bd\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU!!1\u0003Be\t\u0019\u0019#1\u0019b\u0001/!Q!Q\u001aB=#\u0003%\tAa4\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0011\u0011yB!5\u0005\r\r\u0012YM1\u0001\u0018\u0011)\u0011)N!\u001f\u0012\u0002\u0013\u0005!q[\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%cU!!\u0011\u001cBp+\t\u0011YN\u000b\u0003\u0003^\u0006e\bcA\n\u0003`\u001211Ea5C\u0002]A!Ba9\u0003zE\u0005I\u0011\u0001Bs\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012T\u0003\u0002B\n\u0005O$aa\tBq\u0005\u00049\u0002B\u0003Bv\u0005s\n\n\u0011\"\u0001\u0003n\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'\u0006\u0003\u0003 \t=HAB\u0012\u0003j\n\u0007q\u0003\u0003\u0006\u0003t\ne\u0014\u0011!C\u0005\u0005k\f1B]3bIJ+7o\u001c7wKR\u0011!q\u001f\t\u0005\u0005[\u0011I0\u0003\u0003\u0003|\n=\"AB(cU\u0016\u001cGOB\u0004\u0003\u0000\u0006E\u0003a!\u0001\u0003\u00171KW.\u001b;NCJ\\WM]\n\u0007\u0005{\f)fa\u0001\u0011\t\r\u001511B\u0007\u0003\u0007\u000fQAa!\u0003\u00034\u0005\u0011\u0011n\\\u0005\u0005\u0003?\u001a9\u0001\u0003\u0006\u0004\u0010\tu(Q1A\u0005\u0002\u0015\u000b1A\\;n\u0011)\u0019\u0019B!@\u0003\u0002\u0003\u0006IAR\u0001\u0005]Vl\u0007\u0005C\u0004r\u0005{$\taa\u0006\u0015\t\re11\u0004\t\u0005\u0003\u007f\u0013i\u0010C\u0004\u0004\u0010\rU\u0001\u0019\u0001$\t\u0013\r}\u0011\u0011\u000bb\u0001\n\u0003)\u0015\u0001\b#F\u0019R\u000bul\u0011%B\u0013:{F*\u0012(H)\"{F\u000b\u0013*F'\"{E\n\u0012\u0005\t\u0007G\t\t\u0006)A\u0005\r\u0006iB)\u0012'U\u0003~\u001b\u0005*Q%O?2+ej\u0012+I?RC%+R*I\u001f2#\u0005\u0005C\u0005\u0004(\u0005E#\u0019!C\u0001\u000b\u0006AB)\u0012$B+2#v,\u0013(J)&\u000bEjX\"B!\u0006\u001b\u0015\nV-\t\u0011\r-\u0012\u0011\u000bQ\u0001\n\u0019\u000b\u0011\u0004R#G\u0003VcEkX%O\u0013RK\u0015\tT0D\u0003B\u000b5)\u0013+ZA!Q!QYA)#\u0003%\taa\f\u0016\r\rE2QGB\u001c+\t\u0019\u0019DK\u0002G\u0003s$a!FB\u0017\u0005\u00049BAB\u0012\u0004.\t\u0007q\u0003\u0003\u0006\u0003N\u0006E\u0013\u0013!C\u0001\u0007w)ba!\r\u0004>\r}BAB\u000b\u0004:\t\u0007q\u0003\u0002\u0004$\u0007s\u0011\ra\u0006\u0005\u000b\u0005g\f\t&!A\u0005\n\tU\b\"CB#\u0001\u0001\u0007I\u0011BB$\u00031!W\r\u001c;b\u001b\u0006\u0004x\fJ3r)\r!4\u0011\n\u0005\nq\r\r\u0013\u0011!a\u0001\u0003?A\u0001b!\u0014\u0001A\u0003&\u0011qD\u0001\nI\u0016dG/Y'ba\u0002B3aa\u0013=Q\r\u0019Y\u0005\u0011\u0005\b\u0007+\u0002A\u0011IB,\u0003\r9W\r\u001e\u000b\u0005\u00073\u001aY\u0006\u0005\u0003\u001a\u0005C\u000b\u0003bBB/\u0007'\u0002\rAE\u0001\u0004W\u0016L\bbBB1\u0001\u0011\u000531M\u0001\nO\u0016$()\u001f+j[\u0016$Ba!\u001a\u0004xA11qMB9\u0007krAa!\u001b\u0004n9!\u00111HB6\u0013\u0005Y\u0012bAB85\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B+\u0007gR1aa\u001c\u001b!\u001dI\"q\u0015\n\"\u0003\u001fC\u0001b!\u001f\u0004`\u0001\u0007\u0011qR\u0001\u0012i\"\u0014Xm\u001d5Va\u0012\fG/\u001a3US6,\u0007bBB?\u0001\u0011\u00053qP\u0001\u0007O\u0016$\u0018\t\u001c7\u0015\u0005\r\u0015\u0004bBBB\u0001\u0011\u00053QQ\u0001\u0004aV$Hc\u0002\u001b\u0004\b\u000e%5Q\u0012\u0005\b\u0007;\u001a\t\t1\u0001\u0013\u0011\u001d\u0019Yi!!A\u0002\u0005\nQa\u001d;bi\u0016D\u0001\"a#\u0004\u0002\u0002\u0007\u0011q\u0012\u0005\b\u0007#\u0003A\u0011IBJ\u0003\u0019\u0011X-\\8wKR\u0019Ag!&\t\u000f\ru3q\u0012a\u0001%!9\u0011Q\u001c\u0001\u0005B\reE#\u0001\b\t\u000f\ru\u0005\u0001\"\u0001\u0002&\u0006i1\u000f[8vY\u0012\u001cu.\u001c9bGRDaa!)\u0001\t\u0003)\u0015\u0001\u00053fYR\f7\t[1j]2+gn\u001a;i\u0011\u0019\u0019)\u000b\u0001C\u0001\u000b\u0006Q\u0011\r\u001d9s_b\u001c\u0016N_3\t\u000f\r%\u0006\u0001\"\u0011\u0004,\u0006iAo\u001c#fEV<7\u000b\u001e:j]\u001e$\"a!,\u0011\t\r=6q\u0017\b\u0005\u0007c\u001b\u0019\fE\u0002\u0002<iI1a!.\u001b\u0003\u0019\u0001&/\u001a3fM&!!\u0011HB]\u0015\r\u0019)L\u0007\u0005\b\u0005O\u0002A\u0011IBV\u0011\u001d\u0019y\f\u0001C\u0005\u0007\u0003\f1c\u001e:ji\u0016|%M[3di&sG/\u001a:oC2$2\u0001NBb\u0011!\u0019)m!0A\u0002\r\u001d\u0017\u0001D8viB,Ho\u0015;sK\u0006l\u0007\u0003BB\u0003\u0007\u0013LAaa3\u0004\b\taqJ\u00196fGR|U\u000f\u001e9vi\"91q\u001a\u0001\u0005\n\rE\u0017A\u0005:fC\u0012|%M[3di&sG/\u001a:oC2$2\u0001NBj\u0011!\u0019)n!4A\u0002\r]\u0017aC5oaV$8\u000b\u001e:fC6\u0004Ba!\u0002\u0004Z&!11\\B\u0004\u0005-y%M[3di&s\u0007/\u001e;\t\u000f\r}\u0007\u0001\"\u0003\u0004b\u0006YqO]5uK>\u0013'.Z2u)\r!41\u001d\u0005\t\u0007\u000b\u001ci\u000e1\u0001\u0004fB!1QABt\u0013\u0011\u0019Ioa\u0002\u0003%=\u0013'.Z2u\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\b\u0007[\u0004A\u0011BBx\u0003)\u0011X-\u00193PE*,7\r\u001e\u000b\u0004i\rE\b\u0002CBk\u0007W\u0004\raa=\u0011\t\r\u00151Q_\u0005\u0005\u0007o\u001c9AA\tPE*,7\r^%oaV$8\u000b\u001e:fC6Dqaa?\u0001\t\u0003\u001ai0A\u0003xe&$X\rF\u00035\u0007\u007f$9\u0001C\u0004(\u0007s\u0004\r\u0001\"\u0001\u0011\u0007\u0015\"\u0019!C\u0002\u0005\u0006\u0019\u0012Aa\u0013:z_\"AA\u0011BB}\u0001\u0004!Y!\u0001\u0004pkR\u0004X\u000f\u001e\t\u0005\t\u001b!\t\"\u0004\u0002\u0005\u0010)\u00191\u0011\u0002\u0014\n\t\u0011MAq\u0002\u0002\u0007\u001fV$\b/\u001e;\t\u000f\u0011]\u0001\u0001\"\u0011\u0005\u001a\u0005!!/Z1e)\u0015!D1\u0004C\u000f\u0011\u001d9CQ\u0003a\u0001\t\u0003A\u0001\u0002b\b\u0005\u0016\u0001\u0007A\u0011E\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\t\u001b!\u0019#\u0003\u0003\u0005&\u0011=!!B%oaV$\b")
public class OpenHashMapBasedStateMap<K, S>
extends StateMap<K, S>
implements KryoSerializable {
    private volatile transient StateMap<K, S> parentStateMap;
    private int initialCapacity;
    private int deltaChainThreshold;
    private ClassTag<K> keyClassTag;
    private ClassTag<S> stateClassTag;
    private volatile transient OpenHashMap<K, StateInfo<S>> deltaMap;

    public static <K, S> int $lessinit$greater$default$3() {
        return OpenHashMapBasedStateMap$.MODULE$.$lessinit$greater$default$3();
    }

    public static <K, S> int $lessinit$greater$default$2() {
        return OpenHashMapBasedStateMap$.MODULE$.$lessinit$greater$default$2();
    }

    public static int DEFAULT_INITIAL_CAPACITY() {
        return OpenHashMapBasedStateMap$.MODULE$.DEFAULT_INITIAL_CAPACITY();
    }

    public static int DELTA_CHAIN_LENGTH_THRESHOLD() {
        return OpenHashMapBasedStateMap$.MODULE$.DELTA_CHAIN_LENGTH_THRESHOLD();
    }

    public StateMap<K, S> parentStateMap() {
        return this.parentStateMap;
    }

    public void parentStateMap_$eq(StateMap<K, S> x$1) {
        this.parentStateMap = x$1;
    }

    private int initialCapacity() {
        return this.initialCapacity;
    }

    private void initialCapacity_$eq(int x$1) {
        this.initialCapacity = x$1;
    }

    private int deltaChainThreshold() {
        return this.deltaChainThreshold;
    }

    private void deltaChainThreshold_$eq(int x$1) {
        this.deltaChainThreshold = x$1;
    }

    private ClassTag<K> keyClassTag() {
        return this.keyClassTag;
    }

    private void keyClassTag_$eq(ClassTag<K> x$1) {
        this.keyClassTag = x$1;
    }

    private ClassTag<S> stateClassTag() {
        return this.stateClassTag;
    }

    private void stateClassTag_$eq(ClassTag<S> x$1) {
        this.stateClassTag = x$1;
    }

    private OpenHashMap<K, StateInfo<S>> deltaMap() {
        return this.deltaMap;
    }

    private void deltaMap_$eq(OpenHashMap<K, StateInfo<S>> x$1) {
        this.deltaMap = x$1;
    }

    @Override
    public Option<S> get(K key) {
        StateInfo stateInfo = (StateInfo)this.deltaMap().apply(key);
        return stateInfo != null ? (!stateInfo.deleted() ? new Some(stateInfo.data()) : None$.MODULE$) : this.parentStateMap().get(key);
    }

    @Override
    public Iterator<Tuple3<K, S, Object>> getByTime(long threshUpdatedTime) {
        Iterator oldStates = this.parentStateMap().getByTime(threshUpdatedTime).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)OpenHashMapBasedStateMap.$anonfun$getByTime$1(this, x0$1)));
        Iterator updatedStates = this.deltaMap().iterator().filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)OpenHashMapBasedStateMap.$anonfun$getByTime$2(threshUpdatedTime, x0$2))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            StateInfo stateInfo = (StateInfo)tuple2._2();
            Tuple3 tuple3 = new Tuple3(key, stateInfo.data(), (Object)BoxesRunTime.boxToLong((long)stateInfo.updateTime()));
            return tuple3;
        });
        return oldStates.$plus$plus((Function0 & Serializable & scala.Serializable)() -> updatedStates);
    }

    @Override
    public Iterator<Tuple3<K, S, Object>> getAll() {
        Iterator oldStates = this.parentStateMap().getAll().filter((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)OpenHashMapBasedStateMap.$anonfun$getAll$1(this, x0$4)));
        Iterator updatedStates = this.deltaMap().iterator().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)OpenHashMapBasedStateMap.$anonfun$getAll$2(x$1))).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            StateInfo stateInfo = (StateInfo)tuple2._2();
            Tuple3 tuple3 = new Tuple3(key, stateInfo.data(), (Object)BoxesRunTime.boxToLong((long)stateInfo.updateTime()));
            return tuple3;
        });
        return oldStates.$plus$plus((Function0 & Serializable & scala.Serializable)() -> updatedStates);
    }

    @Override
    public void put(K key, S state, long updateTime) {
        StateInfo stateInfo = (StateInfo)this.deltaMap().apply(key);
        if (stateInfo != null) {
            stateInfo.update(state, updateTime);
        } else {
            this.deltaMap().update(key, new StateInfo<S>(state, updateTime, OpenHashMapBasedStateMap$StateInfo$.MODULE$.$lessinit$greater$default$3()));
        }
    }

    @Override
    public void remove(K key) {
        StateInfo stateInfo = (StateInfo)this.deltaMap().apply(key);
        if (stateInfo != null) {
            stateInfo.markDeleted();
        } else {
            boolean x$4 = true;
            Object x$5 = OpenHashMapBasedStateMap$StateInfo$.MODULE$.$lessinit$greater$default$1();
            long x$6 = OpenHashMapBasedStateMap$StateInfo$.MODULE$.$lessinit$greater$default$2();
            StateInfo newInfo = new StateInfo(x$5, x$6, x$4);
            this.deltaMap().update(key, newInfo);
        }
    }

    @Override
    public StateMap<K, S> copy() {
        OpenHashMapBasedStateMap x$7 = this;
        int x$8 = this.deltaChainThreshold();
        int x$9 = OpenHashMapBasedStateMap$.MODULE$.$lessinit$greater$default$2();
        return new OpenHashMapBasedStateMap<K, S>(x$7, x$9, x$8, this.keyClassTag(), this.stateClassTag());
    }

    public boolean shouldCompact() {
        return this.deltaChainLength() >= this.deltaChainThreshold();
    }

    public int deltaChainLength() {
        int n;
        StateMap<K, S> stateMap = this.parentStateMap();
        if (stateMap instanceof OpenHashMapBasedStateMap) {
            OpenHashMapBasedStateMap openHashMapBasedStateMap = (OpenHashMapBasedStateMap)stateMap;
            n = openHashMapBasedStateMap.deltaChainLength() + 1;
        } else {
            n = 0;
        }
        return n;
    }

    public int approxSize() {
        int n;
        int n2 = this.deltaMap().size();
        StateMap<K, S> stateMap = this.parentStateMap();
        if (stateMap instanceof OpenHashMapBasedStateMap) {
            OpenHashMapBasedStateMap openHashMapBasedStateMap = (OpenHashMapBasedStateMap)stateMap;
            n = openHashMapBasedStateMap.approxSize();
        } else {
            n = 0;
        }
        return n2 + n;
    }

    @Override
    public String toDebugString() {
        String tabs = this.deltaChainLength() > 0 ? new StringBuilder(5).append(new StringOps(Predef$.MODULE$.augmentString("    ")).$times(this.deltaChainLength() - 1)).append("+--- ").toString() : "";
        return new StringBuilder(1).append(this.parentStateMap().toDebugString()).append("\n").append(this.deltaMap().iterator().mkString(tabs, new StringBuilder(1).append("\n").append(tabs).toString(), "")).toString();
    }

    public String toString() {
        return new StringBuilder(4).append("[").append(System.identityHashCode(this)).append(", ").append(System.identityHashCode(this.parentStateMap())).append("]").toString();
    }

    private void writeObjectInternal(ObjectOutput outputStream) {
        block6: {
            OpenHashMapBasedStateMap<K, S> openHashMapBasedStateMap;
            outputStream.writeInt(this.deltaMap().size());
            Iterator deltaMapIterator = this.deltaMap().iterator();
            int deltaMapCount = 0;
            while (deltaMapIterator.hasNext()) {
                ++deltaMapCount;
                Tuple2 tuple2 = (Tuple2)deltaMapIterator.next();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object key = tuple2._1();
                StateInfo stateInfo = (StateInfo)tuple2._2();
                Tuple2 tuple22 = new Tuple2(key, (Object)stateInfo);
                Tuple2 tuple23 = tuple22;
                Object key2 = tuple23._1();
                StateInfo stateInfo2 = (StateInfo)tuple23._2();
                outputStream.writeObject(key2);
                outputStream.writeObject(stateInfo2);
            }
            Predef$.MODULE$.assert(deltaMapCount == this.deltaMap().size());
            boolean doCompaction = this.shouldCompact();
            if (doCompaction) {
                int initCapacity = this.approxSize() > 0 ? this.approxSize() : 64;
                openHashMapBasedStateMap = new OpenHashMapBasedStateMap<K, S>(initCapacity, this.deltaChainThreshold(), this.keyClassTag(), this.stateClassTag());
            } else {
                openHashMapBasedStateMap = null;
            }
            OpenHashMapBasedStateMap<K, S> newParentSessionStore = openHashMapBasedStateMap;
            Iterator<Tuple3<K, S, Object>> iterOfActiveSessions = this.parentStateMap().getAll();
            int parentSessionCount = 0;
            outputStream.writeInt(this.approxSize());
            while (iterOfActiveSessions.hasNext()) {
                ++parentSessionCount;
                Tuple3 tuple3 = (Tuple3)iterOfActiveSessions.next();
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                Object key = tuple3._1();
                Object state = tuple3._2();
                long updateTime = BoxesRunTime.unboxToLong((Object)tuple3._3());
                Tuple3 tuple32 = new Tuple3(key, state, (Object)BoxesRunTime.boxToLong((long)updateTime));
                Tuple3 tuple33 = tuple32;
                Object key3 = tuple33._1();
                Object state2 = tuple33._2();
                long updateTime2 = BoxesRunTime.unboxToLong((Object)tuple33._3());
                outputStream.writeObject(key3);
                outputStream.writeObject(state2);
                outputStream.writeLong(updateTime2);
                if (!doCompaction) continue;
                super.deltaMap().update(key3, new StateInfo<Object>(state2, updateTime2, false));
            }
            LimitMarker limiterObj = new LimitMarker(parentSessionCount);
            outputStream.writeObject(limiterObj);
            if (!doCompaction) break block6;
            this.parentStateMap_$eq(newParentSessionStore);
        }
    }

    private void readObjectInternal(ObjectInput inputStream) {
        int deltaMapSize = inputStream.readInt();
        this.deltaMap_$eq(deltaMapSize != 0 ? new OpenHashMap(deltaMapSize, this.keyClassTag(), ClassTag$.MODULE$.apply(StateInfo.class)) : new OpenHashMap(this.initialCapacity(), this.keyClassTag(), ClassTag$.MODULE$.apply(StateInfo.class)));
        for (int deltaMapCount = 0; deltaMapCount < deltaMapSize; ++deltaMapCount) {
            Object key = inputStream.readObject();
            StateInfo sessionInfo = (StateInfo)inputStream.readObject();
            this.deltaMap().update(key, (Object)sessionInfo);
        }
        int parentStateMapSizeHint = inputStream.readInt();
        int newStateMapInitialCapacity = package$.MODULE$.max(parentStateMapSizeHint, OpenHashMapBasedStateMap$.MODULE$.DEFAULT_INITIAL_CAPACITY());
        OpenHashMapBasedStateMap<K, S> newParentSessionStore = new OpenHashMapBasedStateMap<K, S>(newStateMapInitialCapacity, this.deltaChainThreshold(), this.keyClassTag(), this.stateClassTag());
        boolean parentSessionLoopDone = false;
        while (!parentSessionLoopDone) {
            Object obj = inputStream.readObject();
            if (obj instanceof LimitMarker) {
                parentSessionLoopDone = true;
                int expectedCount = ((LimitMarker)obj).num();
                Predef$.MODULE$.assert(expectedCount == super.deltaMap().size());
                continue;
            }
            Object key = obj;
            Object state = inputStream.readObject();
            long updateTime = inputStream.readLong();
            super.deltaMap().update(key, new StateInfo<Object>(state, updateTime, false));
        }
        this.parentStateMap_$eq(newParentSessionStore);
    }

    private void writeObject(ObjectOutputStream outputStream) {
        outputStream.defaultWriteObject();
        this.writeObjectInternal(outputStream);
    }

    private void readObject(ObjectInputStream inputStream) {
        inputStream.defaultReadObject();
        this.readObjectInternal(inputStream);
    }

    public void write(Kryo kryo, Output output) {
        output.writeInt(this.initialCapacity());
        output.writeInt(this.deltaChainThreshold());
        kryo.writeClassAndObject(output, this.keyClassTag());
        kryo.writeClassAndObject(output, this.stateClassTag());
        this.writeObjectInternal((ObjectOutput)new KryoOutputObjectOutputBridge(kryo, output));
    }

    public void read(Kryo kryo, Input input) {
        this.initialCapacity_$eq(input.readInt());
        this.deltaChainThreshold_$eq(input.readInt());
        this.keyClassTag_$eq((ClassTag)kryo.readClassAndObject(input));
        this.stateClassTag_$eq((ClassTag)kryo.readClassAndObject(input));
        this.readObjectInternal((ObjectInput)new KryoInputObjectInputBridge(kryo, input));
    }

    public static final /* synthetic */ boolean $anonfun$getByTime$1(OpenHashMapBasedStateMap $this, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Object key = tuple3._1();
        boolean bl = !$this.deltaMap().contains(key);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getByTime$2(long threshUpdatedTime$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StateInfo stateInfo = (StateInfo)tuple2._2();
        boolean bl = !stateInfo.deleted() && stateInfo.updateTime() < threshUpdatedTime$1;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getAll$1(OpenHashMapBasedStateMap $this, Tuple3 x0$4) {
        Tuple3 tuple3 = x0$4;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Object key = tuple3._1();
        boolean bl = !$this.deltaMap().contains(key);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getAll$2(Tuple2 x$1) {
        return !((StateInfo)x$1._2()).deleted();
    }

    public OpenHashMapBasedStateMap(StateMap<K, S> parentStateMap, int initialCapacity, int deltaChainThreshold, ClassTag<K> keyClassTag, ClassTag<S> stateClassTag) {
        this.parentStateMap = parentStateMap;
        this.initialCapacity = initialCapacity;
        this.deltaChainThreshold = deltaChainThreshold;
        this.keyClassTag = keyClassTag;
        this.stateClassTag = stateClassTag;
        Predef$.MODULE$.require(this.initialCapacity() >= 1, (Function0 & Serializable & scala.Serializable)() -> "Invalid initial capacity");
        Predef$.MODULE$.require(this.deltaChainThreshold() >= 1, (Function0 & Serializable & scala.Serializable)() -> "Invalid delta chain threshold");
        this.deltaMap = new OpenHashMap(this.initialCapacity(), this.keyClassTag(), ClassTag$.MODULE$.apply(StateInfo.class));
    }

    public OpenHashMapBasedStateMap(int initialCapacity, int deltaChainThreshold, ClassTag<K> keyClassTag, ClassTag<S> stateClassTag) {
        this(new EmptyStateMap(), initialCapacity, deltaChainThreshold, keyClassTag, stateClassTag);
    }

    public OpenHashMapBasedStateMap(int deltaChainThreshold, ClassTag<K> keyClassTag, ClassTag<S> stateClassTag) {
        this(OpenHashMapBasedStateMap$.MODULE$.DEFAULT_INITIAL_CAPACITY(), deltaChainThreshold, keyClassTag, stateClassTag);
    }

    public OpenHashMapBasedStateMap(ClassTag<K> keyClassTag, ClassTag<S> stateClassTag) {
        this(OpenHashMapBasedStateMap$.MODULE$.DELTA_CHAIN_LENGTH_THRESHOLD(), keyClassTag, stateClassTag);
    }

    public static class LimitMarker
    implements Serializable {
        private final int num;

        public int num() {
            return this.num;
        }

        public LimitMarker(int num) {
            this.num = num;
        }
    }

    public static class StateInfo<S>
    implements Product,
    scala.Serializable {
        private S data;
        private long updateTime;
        private boolean deleted;

        public S data() {
            return this.data;
        }

        public void data_$eq(S x$1) {
            this.data = x$1;
        }

        public long updateTime() {
            return this.updateTime;
        }

        public void updateTime_$eq(long x$1) {
            this.updateTime = x$1;
        }

        public boolean deleted() {
            return this.deleted;
        }

        public void deleted_$eq(boolean x$1) {
            this.deleted = x$1;
        }

        public void markDeleted() {
            this.deleted_$eq(true);
        }

        public void update(S newData, long newUpdateTime) {
            this.data_$eq(newData);
            this.updateTime_$eq(newUpdateTime);
            this.deleted_$eq(false);
        }

        public <S> StateInfo<S> copy(S data, long updateTime, boolean deleted) {
            return new StateInfo<S>(data, updateTime, deleted);
        }

        public <S> S copy$default$1() {
            return this.data();
        }

        public <S> long copy$default$2() {
            return this.updateTime();
        }

        public <S> boolean copy$default$3() {
            return this.deleted();
        }

        public String productPrefix() {
            return "StateInfo";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.data();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.updateTime());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.deleted());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StateInfo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.data()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.updateTime()));
            n = Statics.mix((int)n, (int)(this.deleted() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StateInfo)) return false;
            boolean bl = true;
            if (!bl) return false;
            StateInfo stateInfo = (StateInfo)x$1;
            if (!BoxesRunTime.equals(this.data(), stateInfo.data())) return false;
            if (this.updateTime() != stateInfo.updateTime()) return false;
            if (this.deleted() != stateInfo.deleted()) return false;
            if (!stateInfo.canEqual(this)) return false;
            return true;
        }

        public StateInfo(S data, long updateTime, boolean deleted) {
            this.data = data;
            this.updateTime = updateTime;
            this.deleted = deleted;
            Product.$init$((Product)this);
        }
    }
}

