/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.Closeable;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogSegment;
import org.apache.spark.streaming.util.HdfsUtils$;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001)4Q!\u0001\u0002\u0001\t1\u0011!ER5mK\n\u000b7/\u001a3Xe&$X-\u00115fC\u0012dun\u001a*b]\u0012|WNU3bI\u0016\u0014(BA\u0002\u0005\u0003\u0011)H/\u001b7\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e+A\u0011abE\u0007\u0002\u001f)\u0011\u0001#E\u0001\u0005Y\u0006twMC\u0001\u0013\u0003\u0011Q\u0017M^1\n\u0005Qy!AB(cU\u0016\u001cG\u000f\u0005\u0002\u001735\tqC\u0003\u0002\u0019#\u0005\u0011\u0011n\\\u0005\u00035]\u0011\u0011b\u00117pg\u0016\f'\r\\3\t\u0011q\u0001!\u0011!Q\u0001\ny\tA\u0001]1uQ\u000e\u0001\u0001CA\u0010)\u001d\t\u0001c\u0005\u0005\u0002\"I5\t!E\u0003\u0002$;\u00051AH]8pizR\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\na\u0001\u0015:fI\u00164\u0017BA\u0015+\u0005\u0019\u0019FO]5oO*\u0011q\u0005\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[\u0005!1m\u001c8g!\tq#'D\u00010\u0015\ta\u0003G\u0003\u00022\u0011\u00051\u0001.\u00193p_BL!aM\u0018\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u0015)\u0004\u0001\"\u00017\u0003\u0019a\u0014N\\5u}Q\u0019q'\u000f\u001e\u0011\u0005a\u0002Q\"\u0001\u0002\t\u000bq!\u0004\u0019\u0001\u0010\t\u000b1\"\u0004\u0019A\u0017\t\u000fq\u0002!\u0019!C\u0005{\u0005A\u0011N\\:ue\u0016\fW.F\u0001?!\ty$)D\u0001A\u0015\t\t\u0005'\u0001\u0002gg&\u00111\t\u0011\u0002\u0012\rN#\u0015\r^1J]B,Ho\u0015;sK\u0006l\u0007BB#\u0001A\u0003%a(A\u0005j]N$(/Z1nA!9q\t\u0001a\u0001\n\u0013A\u0015AB2m_N,G-F\u0001J!\tQ5*D\u0001%\u0013\taEEA\u0004C_>dW-\u00198\t\u000f9\u0003\u0001\u0019!C\u0005\u001f\u0006Q1\r\\8tK\u0012|F%Z9\u0015\u0005A\u001b\u0006C\u0001&R\u0013\t\u0011FE\u0001\u0003V]&$\bb\u0002+N\u0003\u0003\u0005\r!S\u0001\u0004q\u0012\n\u0004B\u0002,\u0001A\u0003&\u0011*A\u0004dY>\u001cX\r\u001a\u0011\t\u000ba\u0003A\u0011A-\u0002\tI,\u0017\r\u001a\u000b\u00035\u0002\u0004\"a\u00170\u000e\u0003qS!!X\t\u0002\u00079Lw.\u0003\u0002`9\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000b\u0005<\u0006\u0019\u00012\u0002\u000fM,w-\\3oiB\u0011\u0001hY\u0005\u0003I\n\u0011QDR5mK\n\u000b7/\u001a3Xe&$X-\u00115fC\u0012dunZ*fO6,g\u000e\u001e\u0005\u0006M\u0002!\teZ\u0001\u0006G2|7/\u001a\u000b\u0002!\")\u0011\u000e\u0001C\u0005O\u0006Q\u0011m]:feR|\u0005/\u001a8")
public class FileBasedWriteAheadLogRandomReader
implements Closeable {
    private final FSDataInputStream instream;
    private boolean closed;

    private FSDataInputStream instream() {
        return this.instream;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    public synchronized ByteBuffer read(FileBasedWriteAheadLogSegment segment) {
        this.assertOpen();
        this.instream().seek(segment.offset());
        int nextLength = this.instream().readInt();
        HdfsUtils$.MODULE$.checkState(nextLength == segment.length(), (Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(40).append("Expected message length to be ").append(segment.length()).append(", but was ").append(nextLength).toString());
        byte[] buffer = new byte[nextLength];
        this.instream().readFully(buffer);
        return ByteBuffer.wrap(buffer);
    }

    @Override
    public synchronized void close() {
        this.closed_$eq(true);
        this.instream().close();
    }

    private void assertOpen() {
        HdfsUtils$.MODULE$.checkState(!this.closed(), (Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Stream is closed. Create a new Reader to read from the file.");
    }

    public FileBasedWriteAheadLogRandomReader(String path, Configuration conf) {
        this.instream = HdfsUtils$.MODULE$.getInputStream(path, conf);
        this.closed = this.instream() == null;
    }
}

