/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.ui;

import java.io.Serializable;
import java.util.Date;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.ui.BatchUIData;
import org.apache.spark.streaming.ui.OutputOperationUIData;
import org.apache.spark.streaming.ui.SparkJobIdWithUIData;
import org.apache.spark.streaming.ui.StreamingJobProgressListener;
import org.apache.spark.streaming.ui.StreamingTab;
import org.apache.spark.streaming.ui.UIUtils$;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.WebUIPage;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.MapLike;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.xml.Comment;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001\u0005-h!B\u0001\u0003\u0001\ta!!\u0003\"bi\u000eD\u0007+Y4f\u0015\t\u0019A!\u0001\u0002vS*\u0011QAB\u0001\ngR\u0014X-Y7j]\u001eT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0003\u00015\u0001\"A\u0004\t\u000e\u0003=Q!a\u0001\u0004\n\u0005Ey!!C,fEVK\u0005+Y4f\u0011!\u0019\u0002A!A!\u0002\u0013)\u0012A\u00029be\u0016tGo\u0001\u0001\u0011\u0005Y9R\"\u0001\u0002\n\u0005a\u0011!\u0001D*ue\u0016\fW.\u001b8h)\u0006\u0014\u0007\"\u0002\u000e\u0001\t\u0003Y\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u001d;A\u0011a\u0003\u0001\u0005\u0006'e\u0001\r!\u0006\u0005\b?\u0001\u0011\r\u0011\"\u0003!\u0003E\u0019HO]3b[&tw\rT5ti\u0016tWM]\u000b\u0002CA\u0011aCI\u0005\u0003G\t\u0011Ad\u0015;sK\u0006l\u0017N\\4K_\n\u0004&o\\4sKN\u001cH*[:uK:,'\u000f\u0003\u0004&\u0001\u0001\u0006I!I\u0001\u0013gR\u0014X-Y7j]\u001ed\u0015n\u001d;f]\u0016\u0014\b\u0005C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\u0002\u000bM$xN]3\u0016\u0003%\u0002\"AK\u0017\u000e\u0003-R!\u0001\f\u0004\u0002\rM$\u0018\r^;t\u0013\tq3F\u0001\bBaB\u001cF/\u0019;vgN#xN]3\t\rA\u0002\u0001\u0015!\u0003*\u0003\u0019\u0019Ho\u001c:fA!)!\u0007\u0001C\u0005g\u000591m\u001c7v[:\u001cX#\u0001\u001b\u0011\u0007Uz$I\u0004\u00027y9\u0011qGO\u0007\u0002q)\u0011\u0011\bF\u0001\u0007yI|w\u000e\u001e \n\u0003m\nQa]2bY\u0006L!!\u0010 \u0002\u000fA\f7m[1hK*\t1(\u0003\u0002A\u0003\n\u00191+Z9\u000b\u0005ur\u0004CA\"G\u001b\u0005!%BA#?\u0003\rAX\u000e\\\u0005\u0003\u000f\u0012\u0013AAT8eK\")\u0011\n\u0001C\u0005\u0015\u0006qq-\u001a8fe\u0006$XMS8c%><H\u0003\u0003\u001bL/rs\u0006N\\:\t\u000b1C\u0005\u0019A'\u0002\u000fI,\u0017/^3tiB\u0011a*V\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0005QR$\bO\u0003\u0002S'\u000691/\u001a:wY\u0016$(\"\u0001+\u0002\u000b)\fg/\u0019=\n\u0005Y{%A\u0005%uiB\u001cVM\u001d<mKR\u0014V-];fgRDQ\u0001\u0017%A\u0002e\u000bAb\\;uaV$x\n\u001d#bi\u0006\u0004\"A\u0006.\n\u0005m\u0013!!F(viB,Ho\u00149fe\u0006$\u0018n\u001c8V\u0013\u0012\u000bG/\u0019\u0005\u0006;\"\u0003\r\u0001N\u0001\u0014_V$\b/\u001e;Pa\u0012+7o\u0019:jaRLwN\u001c\u0005\u0006?\"\u0003\r\u0001Y\u0001\u001aM>\u0014X.\u0019;uK\u0012|U\u000f\u001e9vi>\u0003H)\u001e:bi&|g\u000e\u0005\u0002bK:\u0011!m\u0019\t\u0003oyJ!\u0001\u001a \u0002\rA\u0013X\rZ3g\u0013\t1wM\u0001\u0004TiJLgn\u001a\u0006\u0003IzBQ!\u001b%A\u0002)\f\u0011D\\;n'B\f'o\u001b&pEJ{wo]%o\u001fV$\b/\u001e;PaB\u00111\u000e\\\u0007\u0002}%\u0011QN\u0010\u0002\u0004\u0013:$\b\"B8I\u0001\u0004\u0001\u0018AC5t\r&\u00148\u000f\u001e*poB\u00111.]\u0005\u0003ez\u0012qAQ8pY\u0016\fg\u000eC\u0003u\u0011\u0002\u0007Q/A\u0007k_\nLEmV5uQ\u0012\u000bG/\u0019\t\u0003-YL!a\u001e\u0002\u0003)M\u0003\u0018M]6K_\nLEmV5uQVKE)\u0019;b\u0011\u0015I\b\u0001\"\u0003{\u0003\r:WM\\3sCR,w*\u001e;qkR|\u0005OU8x/&$\bn\\;u'B\f'o\u001b&pEN$B\u0001N>}{\")\u0001\f\u001fa\u00013\")Q\f\u001fa\u0001i!)q\f\u001fa\u0001A\"1q\u0010\u0001C\u0005\u0003\u0003\tAcZ3oKJ\fG/\u001a(pe6\fGNS8c%><Hc\u0004\u001b\u0002\u0004\u0005\u0015\u0011qAA\u0005\u0003\u0017\ti!a\u0004\t\u000b1s\b\u0019A'\t\u000bas\b\u0019A-\t\u000bus\b\u0019\u0001\u001b\t\u000b}s\b\u0019\u00011\t\u000b%t\b\u0019\u00016\t\u000b=t\b\u0019\u00019\t\u000f\u0005Ea\u00101\u0001\u0002\u0014\u0005A1\u000f]1sW*{'\r\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\u0005Y\f$bAA\u000fW\u0005\u0019\u0011\r]5\n\t\u0005\u0005\u0012q\u0003\u0002\b\u0015>\u0014G)\u0019;b\u0011\u001d\t)\u0003\u0001C\u0005\u0003O\tQcZ3oKJ\fG/\u001a#s_B\u0004X\r\u001a&pEJ{w\u000fF\u00075\u0003S\tY#!\f\u00020\u0005E\u00121\u0007\u0005\u00071\u0006\r\u0002\u0019A-\t\ru\u000b\u0019\u00031\u00015\u0011\u0019y\u00161\u0005a\u0001A\"1\u0011.a\tA\u0002)Daa\\A\u0012\u0001\u0004\u0001\bbBA\u001b\u0003G\u0001\rA[\u0001\u0006U>\u0014\u0017\n\u001a\u0005\b\u0003s\u0001A\u0011BA\u001e\u0003U9WM\\3sCR,w*\u001e;qkR|\u0005/\u00133S_^$r\u0001NA\u001f\u0003\u007f\t\t\u0005\u0003\u0004M\u0003o\u0001\r!\u0014\u0005\u00071\u0006]\u0002\u0019A-\t\u0011\u0005\r\u0013q\u0007a\u0001\u0003\u000b\n\u0011b\u001d9be.TuNY:\u0011\u0007UzT\u000fC\u0004\u0002J\u0001!I!a\u0013\u00027\u001d,g.\u001a:bi\u0016|U\u000f\u001e9vi>\u0003H)Z:de&\u0004H/[8o)\r!\u0014Q\n\u0005\b\u0003\u001f\n9\u00051\u0001Z\u0003!yW\u000f\u001e9vi>\u0003\bbBA*\u0001\u0011%\u0011QK\u0001\u000bO\u0016$(j\u001c2ECR\fG\u0003BA,\u0003;\u0002Ra[A-\u0003'I1!a\u0017?\u0005\u0019y\u0005\u000f^5p]\"A\u0011qLA)\u0001\u0004\t\t'\u0001\u0006ta\u0006\u00148NS8c\u0013\u0012\u0004B!a\u0019\u0002~9!\u0011QMA=\u001d\u0011\t9'a\u001e\u000f\t\u0005%\u0014Q\u000f\b\u0005\u0003W\n\u0019H\u0004\u0003\u0002n\u0005EdbA\u001c\u0002p%\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\n\u0007\u0005m$!\u0001\u000fTiJ,\u0017-\\5oO*{'\r\u0015:pOJ,7o\u001d'jgR,g.\u001a:\n\t\u0005}\u0014\u0011\u0011\u0002\u000b'B\f'o\u001b&pE&#'bAA>\u0005!9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0015\u0001D4fiN#\u0018mZ3ECR\fG\u0003BAE\u0003#\u0003Ra[A-\u0003\u0017\u0003B!!\u0006\u0002\u000e&!\u0011qRA\f\u0005%\u0019F/Y4f\t\u0006$\u0018\rC\u0004\u0002\u0014\u0006\r\u0005\u0019\u00016\u0002\u000fM$\u0018mZ3JI\"9\u0011q\u0013\u0001\u0005\n\u0005e\u0015AI4f]\u0016\u0014\u0018\r^3PkR\u0004X\u000f^(qKJ\fG/[8o'R\fG/^:G_J,\u0016\nF\u0002a\u00037Cq!!(\u0002\u0016\u0002\u0007\u0001-A\u0004gC&dWO]3\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\u0006\u0001r-\u001a8fe\u0006$XMS8c)\u0006\u0014G.\u001a\u000b\u0006i\u0005\u0015\u0016q\u0015\u0005\u0007\u0019\u0006}\u0005\u0019A'\t\u0011\u0005%\u0016q\u0014a\u0001\u0003W\u000b1BY1uG\",\u0016\nR1uCB\u0019a#!,\n\u0007\u0005=&AA\u0006CCR\u001c\u0007.V%ECR\f\u0007bBAZ\u0001\u0011\u0005\u0011QW\u0001\u0007e\u0016tG-\u001a:\u0015\u0007Q\n9\f\u0003\u0004M\u0003c\u0003\r!\u0014\u0005\b\u0003w\u0003A\u0011AA_\u0003i9WM\\3sCR,\u0017J\u001c9vi6+G/\u00193bi\u0006$\u0016M\u00197f)\r!\u0014q\u0018\u0005\t\u0003\u0003\fI\f1\u0001\u0002D\u0006q\u0011N\u001c9vi6+G/\u00193bi\u0006\u001c\b\u0003B\u001b@\u0003\u000b\u0004Ra[AdU\u0002L1!!3?\u0005\u0019!V\u000f\u001d7fe!9\u0011Q\u001a\u0001\u0005\u0002\u0005=\u0017\u0001G4f]\u0016\u0014\u0018\r^3J]B,H/T3uC\u0012\fG/\u0019*poR\u0019A'!5\t\u0011\u0005M\u00171\u001aa\u0001\u0003\u000b\fQ\"\u001b8qkRlU\r^1eCR\f\u0007bBAl\u0001\u0011%\u0011\u0011\\\u0001\u001a[\u0016$\u0018\rZ1uC\u0012+7o\u0019:jaRLwN\u001c+p\u0011RkE\nF\u00025\u00037Dq!!8\u0002V\u0002\u0007\u0001-A\nnKR\fG-\u0019;b\t\u0016\u001c8M]5qi&|g\u000eC\u0004\u0002b\u0002!I!a9\u0002%=,H\u000f];u\u001fB\u001cF/\u0019;vg\u000e+G\u000e\u001c\u000b\u0006i\u0005\u0015\u0018q\u001d\u0005\b\u0003\u001f\ny\u000e1\u0001Z\u0011\u001d\tI/a8A\u0002)\fqA]8xgB\fg\u000e")
public class BatchPage
extends WebUIPage {
    private final StreamingTab parent;
    private final StreamingJobProgressListener streamingListener;
    private final AppStatusStore store;

    private StreamingJobProgressListener streamingListener() {
        return this.streamingListener;
    }

    private AppStatusStore store() {
        return this.store;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> columns() {
        void var1_1;
        void var3_3;
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Output Op Id"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("Description"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Output Op Duration"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Status"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("Job Id"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Job Duration"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("sorttable_nosort"), (MetaData)$md);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Stages: Succeeded/Total"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("sorttable_nosort"), (MetaData)$md2);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Tasks (for all stages): Succeeded/Total"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("Error"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        return var1_1;
    }

    private Seq<Node> generateJobRow(HttpServletRequest request, OutputOperationUIData outputOpData, Seq<Node> outputOpDescription, String formattedOutputOpDuration, int numSparkJobRowsInOutputOp, boolean isFirstRow, SparkJobIdWithUIData jobIdWithData) {
        return jobIdWithData.jobData().isDefined() ? this.generateNormalJobRow(request, outputOpData, outputOpDescription, formattedOutputOpDuration, numSparkJobRowsInOutputOp, isFirstRow, (JobData)jobIdWithData.jobData().get()) : this.generateDroppedJobRow(outputOpData, outputOpDescription, formattedOutputOpDuration, numSparkJobRowsInOutputOp, isFirstRow, jobIdWithData.sparkJobId());
    }

    private Seq<Node> generateOutputOpRowWithoutSparkJobs(OutputOperationUIData outputOpData, Seq<Node> outputOpDescription, String formattedOutputOpDuration) {
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("output-op-id-cell"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)outputOpData.id())).toString());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus(outputOpDescription);
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)formattedOutputOpDuration);
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus(this.outputOpStatusCell(outputOpData, 1));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Job Id "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Duration "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Stages: Succeeded/Total "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Tasks (for all stages): Succeeded/Total "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Error "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    private Seq<Node> generateNormalJobRow(HttpServletRequest request, OutputOperationUIData outputOpData, Seq<Node> outputOpDescription, String formattedOutputOpDuration, int numSparkJobRowsInOutputOp, boolean isFirstRow, JobData sparkJob) {
        Nil$ nil$;
        Option duration = sparkJob.submissionTime().map((Function1 & Serializable & scala.Serializable)start -> BoxesRunTime.boxToLong((long)BatchPage.$anonfun$generateNormalJobRow$1(sparkJob, start)));
        String lastFailureReason = (String)((TraversableLike)((TraversableLike)((IterableLike)((TraversableLike)((TraversableLike)((SeqLike)sparkJob.stageIds().sorted((Ordering)Ordering.Int$.MODULE$)).reverse()).flatMap((Function1 & Serializable & scala.Serializable)stageId -> Option$.MODULE$.option2Iterable(this.getStageData(BoxesRunTime.unboxToInt((Object)stageId))), Seq$.MODULE$.canBuildFrom())).dropWhile((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BatchPage.$anonfun$generateNormalJobRow$5(x$2)))).take(1)).flatMap((Function1 & Serializable & scala.Serializable)info -> Option$.MODULE$.option2Iterable(info.failureReason()), Seq$.MODULE$.canBuildFrom())).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String formattedDuration = (String)duration.map((Function1 & Serializable & scala.Serializable)d -> org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)d))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "-");
        String detailUrl = new StringBuilder(14).append(org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3())).append("/jobs/job/?id=").append(sparkJob.jobId()).toString();
        if (isFirstRow) {
            NodeBuffer $buf = new NodeBuffer();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("rowspan", ((Object)BoxesRunTime.boxToInteger((int)numSparkJobRowsInOutputOp)).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("class", (Seq)new Text("output-op-id-cell"), (MetaData)$md);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)outputOpData.id())).toString());
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("rowspan", ((Object)BoxesRunTime.boxToInteger((int)numSparkJobRowsInOutputOp)).toString(), (MetaData)$md2);
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf3.$amp$plus(outputOpDescription);
            $buf3.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("rowspan", ((Object)BoxesRunTime.boxToInteger((int)numSparkJobRowsInOutputOp)).toString(), (MetaData)$md3);
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)formattedOutputOpDuration);
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
            nil$ = (AbstractSeq)$buf.$plus$plus(this.outputOpStatusCell(outputOpData, numSparkJobRowsInOutputOp));
        } else {
            nil$ = Nil$.MODULE$;
        }
        Nil$ prefixCells = nil$;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)prefixCells);
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("sorttable_customkey", ((Object)BoxesRunTime.boxToInteger((int)sparkJob.jobId())).toString(), (MetaData)$md);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("href", detailUrl, (MetaData)$md4);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)BoxesRunTime.boxToInteger((int)sparkJob.jobId()));
        $buf6.$amp$plus(sparkJob.jobGroup().map((Function1 & Serializable & scala.Serializable)id -> new StringBuilder(2).append("(").append((String)id).append(")").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "a", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("sorttable_customkey", duration.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Long.MAX_VALUE).toString(), (MetaData)$md5);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n        "));
        $buf7.$amp$plus((Object)formattedDuration);
        $buf7.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("class", (Seq)new Text("stage-progress-cell"), (MetaData)$md6);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf8.$amp$plus((Object)BoxesRunTime.boxToInteger((int)sparkJob.numCompletedStages()));
        $buf8.$amp$plus((Object)new Text("/"));
        $buf8.$amp$plus((Object)BoxesRunTime.boxToInteger((int)(sparkJob.stageIds().size() - sparkJob.numSkippedStages())));
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf8.$amp$plus((Object)(sparkJob.numFailedStages() > 0 ? new StringBuilder(9).append("(").append(sparkJob.numFailedStages()).append(" failed)").toString() : BoxedUnit.UNIT));
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf8.$amp$plus((Object)(sparkJob.numSkippedStages() > 0 ? new StringBuilder(10).append("(").append(sparkJob.numSkippedStages()).append(" skipped)").toString() : BoxedUnit.UNIT));
        $buf8.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("progress-cell"), (MetaData)$md7);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n        "));
        $buf9.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.makeProgressBar(sparkJob.numActiveTasks(), sparkJob.numCompletedTasks(), sparkJob.numFailedTasks(), sparkJob.numSkippedTasks(), sparkJob.killedTasksSummary(), sparkJob.numTasks() - sparkJob.numSkippedTasks()));
        $buf9.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus(UIUtils$.MODULE$.failureReasonCell(lastFailureReason, UIUtils$.MODULE$.failureReasonCell$default$2(), UIUtils$.MODULE$.failureReasonCell$default$3()));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    private Seq<Node> generateDroppedJobRow(OutputOperationUIData outputOpData, Seq<Node> outputOpDescription, String formattedOutputOpDuration, int numSparkJobRowsInOutputOp, boolean isFirstRow, int jobId) {
        Nil$ nil$;
        if (isFirstRow) {
            NodeBuffer $buf = new NodeBuffer();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("rowspan", ((Object)BoxesRunTime.boxToInteger((int)numSparkJobRowsInOutputOp)).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("class", (Seq)new Text("output-op-id-cell"), (MetaData)$md);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)outputOpData.id())).toString());
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("rowspan", ((Object)BoxesRunTime.boxToInteger((int)numSparkJobRowsInOutputOp)).toString(), (MetaData)$md2);
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus(outputOpDescription);
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("rowspan", ((Object)BoxesRunTime.boxToInteger((int)numSparkJobRowsInOutputOp)).toString(), (MetaData)$md3);
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)formattedOutputOpDuration);
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
            nil$ = (AbstractSeq)$buf.$plus$plus(this.outputOpStatusCell(outputOpData, numSparkJobRowsInOutputOp));
        } else {
            nil$ = Nil$.MODULE$;
        }
        Nil$ prefixCells = nil$;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)prefixCells);
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("sorttable_customkey", ((Object)BoxesRunTime.boxToInteger((int)jobId)).toString(), (MetaData)$md);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)(jobId >= 0 ? ((Object)BoxesRunTime.boxToInteger((int)jobId)).toString() : "-"));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Duration "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Stages: Succeeded/Total "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Tasks (for all stages): Succeeded/Total "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Error "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    private Seq<Node> generateOutputOpIdRow(HttpServletRequest request, OutputOperationUIData outputOpData, Seq<SparkJobIdWithUIData> sparkJobs) {
        Seq seq;
        String formattedOutputOpDuration = outputOpData.duration().isEmpty() ? "-" : org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)outputOpData.duration().get()));
        Seq<Node> description = this.generateOutputOpDescription(outputOpData);
        if (sparkJobs.isEmpty()) {
            seq = this.generateOutputOpRowWithoutSparkJobs(outputOpData, description, formattedOutputOpDuration);
        } else {
            Seq<Node> firstRow = this.generateJobRow(request, outputOpData, description, formattedOutputOpDuration, sparkJobs.size(), true, (SparkJobIdWithUIData)sparkJobs.head());
            Seq tailRows = (Seq)((TraversableLike)sparkJobs.tail()).map((Function1 & Serializable & scala.Serializable)sparkJob -> this.generateJobRow(request, outputOpData, description, formattedOutputOpDuration, sparkJobs.size(), false, (SparkJobIdWithUIData)sparkJob), Seq$.MODULE$.canBuildFrom());
            seq = (Seq)((GenericTraversableTemplate)firstRow.$plus$plus((GenTraversableOnce)tailRows, Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        }
        return seq;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> generateOutputOpDescription(OutputOperationUIData outputOp) {
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)outputOp.name());
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("expand-details"), (MetaData)$md);
        $md = new UnprefixedAttribute("onclick", (Seq)new Text("this.parentNode.querySelector('.stage-details').classList.toggle('collapsed')"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n          +details\n      "));
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("stage-details collapsed"), (MetaData)$md2);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)outputOp.description());
        $buf3.$amp$plus((Object)new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
    }

    private Option<JobData> getJobData(int sparkJobId) {
        Some some;
        try {
            some = new Some((Object)this.store().job(sparkJobId));
        }
        catch (NoSuchElementException noSuchElementException) {
            some = None$.MODULE$;
        }
        return some;
    }

    private Option<StageData> getStageData(int stageId) {
        Some some;
        try {
            some = new Some((Object)this.store().lastStageAttempt(stageId));
        }
        catch (NoSuchElementException noSuchElementException) {
            some = None$.MODULE$;
        }
        return some;
    }

    private String generateOutputOperationStatusForUI(String failure) {
        String string;
        if (failure.startsWith("org.apache.spark.SparkException")) {
            string = new StringBuilder(30).append("Failed due to Spark job error\n").append(failure).toString();
        } else {
            int nextLineIndex = failure.indexOf("\n");
            if (nextLineIndex < 0) {
                nextLineIndex = failure.length();
            }
            String firstLine = failure.substring(0, nextLineIndex);
            string = new StringBuilder(22).append("Failed due to error: ").append(firstLine).append("\n").append(failure).toString();
        }
        return string;
    }

    private Seq<Node> generateJobTable(HttpServletRequest request, BatchUIData batchUIData) {
        Map outputOpIdToSparkJobIds = (Map)batchUIData.outputOpIdSparkJobIdPairs().groupBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.outputOpId())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int outputOpId = tuple2._1$mcI$sp();
            Iterable outputOpIdAndSparkJobIds = (Iterable)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)outputOpId), ((TraversableOnce)outputOpIdAndSparkJobIds.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.sparkJobId()), Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.Int$.MODULE$));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        Seq outputOps = (Seq)((MapLike)batchUIData.outputOperations().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int outputOpId = tuple2._1$mcI$sp();
            OutputOperationUIData outputOperation = (OutputOperationUIData)tuple2._2();
            Seq sparkJobIds = (Seq)outputOpIdToSparkJobIds.getOrElse((Object)BoxesRunTime.boxToInteger((int)outputOpId), (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
            Tuple2 tuple22 = new Tuple2((Object)outputOperation, (Object)sparkJobIds);
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom())).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)BatchPage.$anonfun$generateJobTable$6(x$5)), (Ordering)Ordering.Int$.MODULE$);
        Seq outputOpWithJobs = (Seq)outputOps.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            OutputOperationUIData outputOpData = (OutputOperationUIData)tuple2._1();
            Seq sparkJobIds = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)outputOpData, sparkJobIds.map((Function1 & Serializable & scala.Serializable)jobId -> BatchPage.$anonfun$generateJobTable$8(this, BoxesRunTime.unboxToInt((Object)jobId)), Seq$.MODULE$.canBuildFrom()));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("table table-bordered table-striped table-condensed"), (MetaData)$md);
        $md = new UnprefixedAttribute("id", (Seq)new Text("batch-job-table"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(this.columns());
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus(outputOpWithJobs.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            OutputOperationUIData outputOpData = (OutputOperationUIData)tuple2._1();
            Seq sparkJobs = (Seq)tuple2._2();
            Seq<Node> seq = this.generateOutputOpIdRow(request, outputOpData, (Seq<SparkJobIdWithUIData>)sparkJobs);
            return seq;
        }, Seq$.MODULE$.canBuildFrom()));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    public Seq<Node> render(HttpServletRequest request) {
        Seq seq;
        StreamingJobProgressListener streamingJobProgressListener = this.streamingListener();
        synchronized (streamingJobProgressListener) {
            BoxedUnit boxedUnit;
            Time batchTime = (Time)Option$.MODULE$.apply((Object)org.apache.spark.ui.UIUtils$.MODULE$.stripXSS(request.getParameter("id"))).map((Function1 & Serializable & scala.Serializable)id -> new Time(new StringOps(Predef$.MODULE$.augmentString(id)).toLong())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException("Missing id parameter");
            });
            String formattedBatchTime = UIUtils$.MODULE$.formatBatchTime(batchTime.milliseconds(), this.streamingListener().batchDuration(), UIUtils$.MODULE$.formatBatchTime$default$3(), UIUtils$.MODULE$.formatBatchTime$default$4());
            BatchUIData batchUIData = (BatchUIData)this.streamingListener().getBatchUIData(batchTime).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(21).append("Batch ").append(formattedBatchTime).append(" does not exist").toString());
            });
            String formattedSchedulingDelay = (String)batchUIData.schedulingDelay().map((Function1 & Serializable & scala.Serializable)milliseconds -> org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)milliseconds))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "-");
            String formattedProcessingTime = (String)batchUIData.processingDelay().map((Function1 & Serializable & scala.Serializable)milliseconds -> org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)milliseconds))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "-");
            String formattedTotalDelay = (String)batchUIData.totalDelay().map((Function1 & Serializable & scala.Serializable)milliseconds -> org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)milliseconds))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "-");
            Seq inputMetadatas = ((TraversableOnce)batchUIData.streamIdToInputInfo().values().flatMap((Function1 & Serializable & scala.Serializable)inputInfo -> Option$.MODULE$.option2Iterable(inputInfo.metadataDescription().map((Function1 & Serializable & scala.Serializable)desc -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)inputInfo.inputStreamId())), desc))), Iterable$.MODULE$.canBuildFrom())).toSeq();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("unstyled"), (MetaData)$md);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("Batch Duration: "));
            $buf3.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
            $buf3.$amp$plus((Object)new Text("\n            "));
            $buf3.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(this.streamingListener().batchDuration()));
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("Input data size: "));
            $buf5.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
            $buf5.$amp$plus((Object)new Text("\n            "));
            $buf5.$amp$plus((Object)BoxesRunTime.boxToLong((long)batchUIData.numRecords()));
            $buf5.$amp$plus((Object)new Text(" records\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus((Object)new Text("Scheduling delay: "));
            $buf7.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
            $buf7.$amp$plus((Object)new Text("\n            "));
            $buf7.$amp$plus((Object)formattedSchedulingDelay);
            $buf7.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf9 = new NodeBuffer();
            $buf9.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf10 = new NodeBuffer();
            $buf10.$amp$plus((Object)new Text("Processing time: "));
            $buf9.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
            $buf9.$amp$plus((Object)new Text("\n            "));
            $buf9.$amp$plus((Object)formattedProcessingTime);
            $buf9.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf11 = new NodeBuffer();
            $buf11.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf12 = new NodeBuffer();
            $buf12.$amp$plus((Object)new Text("Total delay: "));
            $buf11.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
            $buf11.$amp$plus((Object)new Text("\n            "));
            $buf11.$amp$plus((Object)formattedTotalDelay);
            $buf11.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
            $buf2.$amp$plus((Object)new Text("\n          "));
            if (inputMetadatas.nonEmpty()) {
                NodeBuffer $buf13 = new NodeBuffer();
                $buf13.$amp$plus((Object)new Text("\n                "));
                NodeBuffer $buf14 = new NodeBuffer();
                $buf14.$amp$plus((Object)new Text("Input Metadata:"));
                $buf13.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf14));
                $buf13.$amp$plus(this.generateInputMetadataTable((Seq<Tuple2<Object, String>>)inputMetadatas));
                $buf13.$amp$plus((Object)new Text("\n              "));
                Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf13);
                boxedUnit = elem;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            $buf2.$amp$plus((Object)boxedUnit);
            $buf2.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
            $buf.$amp$plus((Object)new Text("\n      "));
            Elem summary = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            NodeSeq content = (NodeSeq)summary.$plus$plus(this.generateJobTable(request, batchUIData), NodeSeq$.MODULE$.canBuildFrom());
            seq = org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage(request, new StringBuilder(20).append("Details of batch at ").append(formattedBatchTime).toString(), (Function0 & Serializable & scala.Serializable)() -> content, (SparkUITab)this.parent, org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$5(), org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$6(), org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$7(), org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$8());
        }
        return seq;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Node> generateInputMetadataTable(Seq<Tuple2<Object, String>> inputMetadatas) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", org.apache.spark.ui.UIUtils$.MODULE$.TABLE_CLASS_STRIPED_SORTABLE(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Input"));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Metadata"));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus(inputMetadatas.flatMap((Function1 & Serializable & scala.Serializable)inputMetadata -> this.generateInputMetadataRow((Tuple2<Object, String>)inputMetadata), Seq$.MODULE$.canBuildFrom()));
        $buf6.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Node> generateInputMetadataRow(Tuple2<Object, String> inputMetadata) {
        void var3_3;
        int streamId = inputMetadata._1$mcI$sp();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus(this.streamingListener().streamName(streamId).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append("Stream-").append(streamId).toString()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus(this.metadataDescriptionToHTML((String)inputMetadata._2()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    private Seq<Node> metadataDescriptionToHTML(String metadataDescription) {
        return Unparsed$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(StringEscapeUtils.escapeHtml4((String)metadataDescription))).replaceAllLiterally("\t", "&nbsp;&nbsp;&nbsp;&nbsp;"))).replaceAllLiterally("\n", "<br/>"));
    }

    private Seq<Node> outputOpStatusCell(OutputOperationUIData outputOp, int rowspan) {
        Elem elem;
        Option<String> option = outputOp.failureReason();
        if (option instanceof Some) {
            Some some = (Some)option;
            String failureReason = (String)some.value();
            String failureReasonForUI = UIUtils$.MODULE$.createOutputOperationFailureForUI(failureReason);
            elem = UIUtils$.MODULE$.failureReasonCell(failureReasonForUI, rowspan, false);
        } else if (None$.MODULE$.equals(option)) {
            Elem elem2;
            if (outputOp.endTime().isEmpty()) {
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("rowspan", ((Object)BoxesRunTime.boxToInteger((int)rowspan)).toString(), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("-"));
                Elem elem3 = new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                elem2 = elem3;
            } else {
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("rowspan", ((Object)BoxesRunTime.boxToInteger((int)rowspan)).toString(), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("Succeeded"));
                Elem elem4 = new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                elem2 = elem4;
            }
            elem = elem2;
        } else {
            throw new MatchError(option);
        }
        return elem;
    }

    public static final /* synthetic */ long $anonfun$generateNormalJobRow$1(JobData sparkJob$1, Date start) {
        long end = BoxesRunTime.unboxToLong((Object)sparkJob$1.completionTime().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> System.currentTimeMillis()));
        return end - start.getTime();
    }

    public static final /* synthetic */ boolean $anonfun$generateNormalJobRow$5(StageData x$2) {
        Option option = x$2.failureReason();
        None$ none$ = None$.MODULE$;
        return !(option != null ? !option.equals(none$) : none$ != null);
    }

    public static final /* synthetic */ int $anonfun$generateJobTable$6(Tuple2 x$5) {
        return ((OutputOperationUIData)x$5._1()).id();
    }

    public static final /* synthetic */ SparkJobIdWithUIData $anonfun$generateJobTable$8(BatchPage $this, int jobId) {
        return new SparkJobIdWithUIData(jobId, $this.getJobData(jobId));
    }

    public BatchPage(StreamingTab parent) {
        this.parent = parent;
        super("batch");
        this.streamingListener = parent.listener();
        this.store = parent.parent().store();
    }
}

