/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.io.Serializable;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.scheduler.TaskLocation;
import org.apache.spark.scheduler.TaskLocation$;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.scheduler.ReceiverState$;
import org.apache.spark.streaming.scheduler.ReceiverTrackingInfo;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001Y4Q!\u0001\u0002\u0001\t1\u0011\u0001DU3dK&4XM]*dQ\u0016$W\u000f\\5oOB{G.[2z\u0015\t\u0019A!A\u0005tG\",G-\u001e7fe*\u0011QAB\u0001\ngR\u0014X-Y7j]\u001eT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0003\u00015\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007\"\u0002\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAQA\u0007\u0001\u0005\u0002m\t\u0011c]2iK\u0012,H.\u001a*fG\u0016Lg/\u001a:t)\rabg\u0013\t\u0005;\u0001\u0012S%D\u0001\u001f\u0015\tyr\"\u0001\u0006d_2dWm\u0019;j_:L!!\t\u0010\u0003\u00075\u000b\u0007\u000f\u0005\u0002\u000fG%\u0011Ae\u0004\u0002\u0004\u0013:$\bc\u0001\u0014/c9\u0011q\u0005\f\b\u0003Q-j\u0011!\u000b\u0006\u0003UU\ta\u0001\u0010:p_Rt\u0014\"\u0001\t\n\u00055z\u0011a\u00029bG.\fw-Z\u0005\u0003_A\u00121aU3r\u0015\tis\u0002\u0005\u00023i5\t1G\u0003\u0002\u0004\r%\u0011Qg\r\u0002\r)\u0006\u001c8\u000eT8dCRLwN\u001c\u0005\u0006oe\u0001\r\u0001O\u0001\ne\u0016\u001cW-\u001b<feN\u00042A\n\u0018:a\tQ$\tE\u0002<}\u0001k\u0011\u0001\u0010\u0006\u0003{\u0011\t\u0001B]3dK&4XM]\u0005\u0003\u007fq\u0012\u0001BU3dK&4XM\u001d\t\u0003\u0003\nc\u0001\u0001B\u0005Dm\u0005\u0005\t\u0011!B\u0001\t\n\u0019q\fJ\u0019\u0012\u0005\u0015C\u0005C\u0001\bG\u0013\t9uBA\u0004O_RD\u0017N\\4\u0011\u00059I\u0015B\u0001&\u0010\u0005\r\te.\u001f\u0005\u0006\u0019f\u0001\r!T\u0001\nKb,7-\u001e;peN\u00042A\n\u0018O!\t\u0011t*\u0003\u0002Qg\tIR\t_3dkR|'oQ1dQ\u0016$\u0016m]6M_\u000e\fG/[8o\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0003I\u0011Xm]2iK\u0012,H.\u001a*fG\u0016Lg/\u001a:\u0015\u000b\u0015\"fkY5\t\u000bU\u000b\u0006\u0019\u0001\u0012\u0002\u0015I,7-Z5wKJLE\rC\u0003X#\u0002\u0007\u0001,A\tqe\u00164WM\u001d:fI2{7-\u0019;j_:\u00042AD-\\\u0013\tQvB\u0001\u0004PaRLwN\u001c\t\u00039\u0002t!!\u00180\u0011\u0005!z\u0011BA0\u0010\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011M\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}{\u0001\"\u00023R\u0001\u0004)\u0017a\u0006:fG\u0016Lg/\u001a:Ue\u0006\u001c7.\u001b8h\u0013:4w.T1q!\u0011i\u0002E\t4\u0011\u0005a9\u0017B\u00015\u0003\u0005Q\u0011VmY3jm\u0016\u0014HK]1dW&tw-\u00138g_\")A*\u0015a\u0001\u001b\")1\u000e\u0001C\u0005Y\u0006a3m\u001c8wKJ$(+Z2fSZ,'\u000f\u0016:bG.LgnZ%oM>$v.\u0012=fGV$xN],fS\u001eDGo\u001d\u000b\u0003[R\u00042A\n\u0018o!\u0011qqNT9\n\u0005A|!A\u0002+va2,'\u0007\u0005\u0002\u000fe&\u00111o\u0004\u0002\u0007\t>,(\r\\3\t\u000bUT\u0007\u0019\u00014\u0002)I,7-Z5wKJ$&/Y2lS:<\u0017J\u001c4p\u0001")
public class ReceiverSchedulingPolicy {
    public Map<Object, Seq<TaskLocation>> scheduleReceivers(Seq<Receiver<?>> receivers, Seq<ExecutorCacheTaskLocation> executors) {
        if (receivers.isEmpty()) {
            return Map$.MODULE$.empty();
        }
        if (executors.isEmpty()) {
            return ((TraversableOnce)receivers.map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)x$1.streamId())), (Object)Seq$.MODULE$.empty()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        scala.collection.immutable.Map hostToExecutors = executors.groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.host());
        ArrayBuffer[] scheduledLocations = (ArrayBuffer[])Array$.MODULE$.fill(receivers.length(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer(), ClassTag$.MODULE$.apply(ArrayBuffer.class));
        HashMap numReceiversOnExecutor = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        executors.foreach((Function1 & Serializable & scala.Serializable)e -> {
            numReceiversOnExecutor.update((Object)e, (Object)BoxesRunTime.boxToInteger((int)0));
            return BoxedUnit.UNIT;
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), receivers.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> ((Receiver)receivers.apply(i)).preferredLocation().foreach((Function1 & Serializable & scala.Serializable)host -> {
            ArrayBuffer arrayBuffer;
            Option option = hostToExecutors.get(host);
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq executorsOnHost = (Seq)some.value();
                ExecutorCacheTaskLocation leastScheduledExecutor = (ExecutorCacheTaskLocation)executorsOnHost.minBy((Function1 & Serializable & scala.Serializable)executor -> BoxesRunTime.boxToInteger((int)ReceiverSchedulingPolicy.$anonfun$scheduleReceivers$7(numReceiversOnExecutor, executor)), (Ordering)Ordering.Int$.MODULE$);
                scheduledLocations[i].$plus$eq((Object)leastScheduledExecutor);
                numReceiversOnExecutor.update((Object)leastScheduledExecutor, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)numReceiversOnExecutor.apply((Object)leastScheduledExecutor)) + 1)));
                arrayBuffer = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                arrayBuffer = scheduledLocations[i].$plus$eq((Object)TaskLocation$.MODULE$.apply(host));
            } else {
                throw new MatchError((Object)option);
            }
            return arrayBuffer;
        }));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scheduledLocations)).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty())))).foreach((Function1 & Serializable & scala.Serializable)scheduledLocationsForOneReceiver -> {
            ReceiverSchedulingPolicy.$anonfun$scheduleReceivers$9(numReceiversOnExecutor, scheduledLocationsForOneReceiver);
            return BoxedUnit.UNIT;
        });
        scala.collection.mutable.Iterable idleExecutors = (scala.collection.mutable.Iterable)((TraversableLike)numReceiversOnExecutor.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ReceiverSchedulingPolicy.$anonfun$scheduleReceivers$11(x$6)))).map((Function1 & Serializable & scala.Serializable)x$7 -> (ExecutorCacheTaskLocation)x$7._1(), Iterable$.MODULE$.canBuildFrom());
        idleExecutors.foreach((Function1 & Serializable & scala.Serializable)executor -> {
            ArrayBuffer leastScheduledExecutors = (ArrayBuffer)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scheduledLocations)).minBy((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.size()), (Ordering)Ordering.Int$.MODULE$);
            return leastScheduledExecutors.$plus$eq(executor);
        });
        return ((TraversableOnce)((IterableLike)receivers.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.streamId()), Seq$.MODULE$.canBuildFrom())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])scheduledLocations), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<TaskLocation> rescheduleReceiver(int receiverId, Option<String> preferredLocation, Map<Object, ReceiverTrackingInfo> receiverTrackingInfoMap, Seq<ExecutorCacheTaskLocation> executors) {
        Growable growable;
        if (executors.isEmpty()) {
            return (Seq)Seq$.MODULE$.empty();
        }
        Set scheduledLocations = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        scheduledLocations.$plus$plus$eq((TraversableOnce)Option$.MODULE$.option2Iterable(preferredLocation.map((Function1 & Serializable & scala.Serializable)x$10 -> TaskLocation$.MODULE$.apply(x$10))));
        scala.collection.immutable.Map executorWeights = ((TraversableLike)receiverTrackingInfoMap.values().flatMap((Function1 & Serializable & scala.Serializable)receiverTrackingInfo -> this.convertReceiverTrackingInfoToExecutorWeights((ReceiverTrackingInfo)receiverTrackingInfo), scala.collection.Iterable$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$11 -> (ExecutorCacheTaskLocation)x$11._1()).mapValues((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToDouble((double)ReceiverSchedulingPolicy.$anonfun$rescheduleReceiver$4(x$12)));
        scala.collection.immutable.Set idleExecutors = (scala.collection.immutable.Set)executors.toSet().$minus$minus((GenTraversableOnce)executorWeights.keys());
        if (idleExecutors.nonEmpty()) {
            growable = scheduledLocations.$plus$plus$eq((TraversableOnce)idleExecutors);
        } else {
            Seq sortedExecutors = (Seq)executorWeights.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToDouble((double)x$14._2$mcD$sp()), (Ordering)Ordering.Double$.MODULE$);
            if (sortedExecutors.nonEmpty()) {
                double minWeight = ((Tuple2)sortedExecutors.apply(0))._2$mcD$sp();
                growable = scheduledLocations.$plus$plus$eq((TraversableOnce)((TraversableLike)sortedExecutors.takeWhile((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)ReceiverSchedulingPolicy.$anonfun$rescheduleReceiver$7(minWeight, x$15)))).map((Function1 & Serializable & scala.Serializable)x$16 -> (ExecutorCacheTaskLocation)x$16._1(), Seq$.MODULE$.canBuildFrom()));
            } else {
                growable = BoxedUnit.UNIT;
            }
        }
        return scheduledLocations.toSeq();
    }

    private Seq<Tuple2<ExecutorCacheTaskLocation, Object>> convertReceiverTrackingInfoToExecutorWeights(ReceiverTrackingInfo receiverTrackingInfo) {
        Nil$ nil$;
        Enumeration.Value value = receiverTrackingInfo.state();
        Enumeration.Value value2 = ReceiverState$.MODULE$.INACTIVE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            nil$ = Nil$.MODULE$;
        } else {
            Enumeration.Value value4 = ReceiverState$.MODULE$.SCHEDULED();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Seq scheduledLocations = (Seq)receiverTrackingInfo.scheduledLocations().get();
                nil$ = (Seq)((TraversableLike)scheduledLocations.filter((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)ReceiverSchedulingPolicy.$anonfun$convertReceiverTrackingInfoToExecutorWeights$1(x$17)))).map((Function1 & Serializable & scala.Serializable)location -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((ExecutorCacheTaskLocation)location)), (Object)BoxesRunTime.boxToDouble((double)(1.0 / (double)scheduledLocations.size()))), Seq$.MODULE$.canBuildFrom());
            } else {
                Enumeration.Value value6 = ReceiverState$.MODULE$.ACTIVE();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    nil$ = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(receiverTrackingInfo.runningExecutor().get()), (Object)BoxesRunTime.boxToDouble((double)1.0))}));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return nil$;
    }

    public static final /* synthetic */ int $anonfun$scheduleReceivers$7(HashMap numReceiversOnExecutor$1, ExecutorCacheTaskLocation executor) {
        return BoxesRunTime.unboxToInt((Object)numReceiversOnExecutor$1.apply((Object)executor));
    }

    public static final /* synthetic */ void $anonfun$scheduleReceivers$9(HashMap numReceiversOnExecutor$1, ArrayBuffer scheduledLocationsForOneReceiver) {
        Tuple2 tuple2 = (Tuple2)numReceiversOnExecutor$1.minBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ExecutorCacheTaskLocation leastScheduledExecutor = (ExecutorCacheTaskLocation)tuple2._1();
        int numReceivers = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)leastScheduledExecutor, (Object)BoxesRunTime.boxToInteger((int)numReceivers));
        Tuple2 tuple23 = tuple22;
        ExecutorCacheTaskLocation leastScheduledExecutor2 = (ExecutorCacheTaskLocation)tuple23._1();
        int numReceivers2 = tuple23._2$mcI$sp();
        scheduledLocationsForOneReceiver.$plus$eq((Object)leastScheduledExecutor2);
        numReceiversOnExecutor$1.update((Object)leastScheduledExecutor2, (Object)BoxesRunTime.boxToInteger((int)(numReceivers2 + 1)));
    }

    public static final /* synthetic */ boolean $anonfun$scheduleReceivers$11(Tuple2 x$6) {
        return x$6._2$mcI$sp() == 0;
    }

    public static final /* synthetic */ double $anonfun$rescheduleReceiver$4(Iterable x$12) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)x$12.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToDouble((double)x$13._2$mcD$sp()), scala.collection.Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$rescheduleReceiver$7(double minWeight$1, Tuple2 x$15) {
        return x$15._2$mcD$sp() == minWeight$1;
    }

    public static final /* synthetic */ boolean $anonfun$convertReceiverTrackingInfoToExecutorWeights$1(TaskLocation x$17) {
        return x$17 instanceof ExecutorCacheTaskLocation;
    }
}

