/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkConf;
import org.apache.spark.streaming.scheduler.RateController$;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.scheduler.StreamingListener;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchSubmitted;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverError;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStopped;
import org.apache.spark.streaming.scheduler.StreamingListenerStreamingStarted;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005%cAB\u0001\u0003\u0003\u0003!AB\u0001\bSCR,7i\u001c8ue>dG.\u001a:\u000b\u0005\r!\u0011!C:dQ\u0016$W\u000f\\3s\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0005\u0003\u0001\u001bM9\u0002C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u0015+5\t!!\u0003\u0002\u0017\u0005\t\t2\u000b\u001e:fC6Lgn\u001a'jgR,g.\u001a:\u0011\u00059A\u0012BA\r\u0010\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!Y\u0002A!b\u0001\n\u0003i\u0012!C:ue\u0016\fW.V%E\u0007\u0001)\u0012A\b\t\u0003\u001d}I!\u0001I\b\u0003\u0007%sG\u000f\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003\u001f\u0003)\u0019HO]3b[VKE\t\t\u0005\tI\u0001\u0011\t\u0011)A\u0005K\u0005i!/\u0019;f\u000bN$\u0018.\\1u_J\u0004\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\u0002\u0002\tI\fG/Z\u0005\u0003U\u001d\u0012QBU1uK\u0016\u001bH/[7bi>\u0014\b\"\u0002\u0017\u0001\t\u0003i\u0013A\u0002\u001fj]&$h\bF\u0002/_A\u0002\"\u0001\u0006\u0001\t\u000bmY\u0003\u0019\u0001\u0010\t\u000b\u0011Z\u0003\u0019A\u0013\t\u000bI\u0002a\u0011C\u001a\u0002\u000fA,(\r\\5tQR\u0011Ag\u000e\t\u0003\u001dUJ!AN\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006QE\u0002\r\u0001\u000f\t\u0003\u001deJ!AO\b\u0003\t1{gn\u001a\u0005\ny\u0001\u0001\r\u00111A\u0005\fu\n\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0016\u0003y\u0002\"a\u0010\"\u000e\u0003\u0001S!!Q\b\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002D\u0001\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0005\n\u000b\u0002\u0001\r\u00111A\u0005\n\u0019\u000bA#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;`I\u0015\fHC\u0001\u001bH\u0011\u001dAE)!AA\u0002y\n1\u0001\u001f\u00132\u0011%Q\u0005\u00011A\u0001B\u0003&a(A\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0002B#!\u0013'\u0011\u00059i\u0015B\u0001(\u0010\u0005%!(/\u00198tS\u0016tG\u000fC\u0005Q\u0001\u0001\u0007\t\u0019!C\u0005#\u0006I!/\u0019;f\u0019&l\u0017\u000e^\u000b\u0002%B\u00111kW\u0007\u0002)*\u0011QKV\u0001\u0007CR|W.[2\u000b\u0005\u0005;&B\u0001-Z\u0003\u0011)H/\u001b7\u000b\u0003i\u000bAA[1wC&\u0011A\f\u0016\u0002\u000b\u0003R|W.[2M_:<\u0007\"\u00030\u0001\u0001\u0004\u0005\r\u0011\"\u0003`\u00035\u0011\u0018\r^3MS6LGo\u0018\u0013fcR\u0011A\u0007\u0019\u0005\b\u0011v\u000b\t\u00111\u0001S\u0011%\u0011\u0007\u00011A\u0001B\u0003&!+\u0001\u0006sCR,G*[7ji\u0002B#!\u0019'\t\u000b\u0015\u0004A\u0011\u00024\u0002\t%t\u0017\u000e\u001e\u000b\u0002i!)\u0001\u000e\u0001C\u0005S\u0006Q!/Z1e\u001f\nTWm\u0019;\u0015\u0005QR\u0007\"B6h\u0001\u0004a\u0017aA8jgB\u0011Q\u000e]\u0007\u0002]*\u0011q.W\u0001\u0003S>L!!\u001d8\u0003#=\u0013'.Z2u\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0003t\u0001\u0011%A/A\td_6\u0004X\u000f^3B]\u0012\u0004VO\u00197jg\"$R\u0001N;xsnDQA\u001e:A\u0002a\nA\u0001^5nK\")\u0001P\u001da\u0001q\u0005)Q\r\\3ng\")!P\u001da\u0001q\u0005Iqo\u001c:l\t\u0016d\u0017-\u001f\u0005\u0006yJ\u0004\r\u0001O\u0001\no\u0006LG\u000fR3mCfDQA \u0001\u0005\u0002}\fQbZ3u\u0019\u0006$Xm\u001d;SCR,G#\u0001\u001d\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006\u0005\u0001rN\u001c\"bi\u000eD7i\\7qY\u0016$X\r\u001a\u000b\u0004i\u0005\u001d\u0001\u0002CA\u0005\u0003\u0003\u0001\r!a\u0003\u0002\u001d\t\fGo\u00195D_6\u0004H.\u001a;fIB\u0019A#!\u0004\n\u0007\u0005=!AA\u0010TiJ,\u0017-\\5oO2K7\u000f^3oKJ\u0014\u0015\r^2i\u0007>l\u0007\u000f\\3uK\u0012<q!a\u0005\u0003\u0011\u0003\t)\"\u0001\bSCR,7i\u001c8ue>dG.\u001a:\u0011\u0007Q\t9B\u0002\u0004\u0002\u0005!\u0005\u0011\u0011D\n\u0005\u0003/iq\u0003C\u0004-\u0003/!\t!!\b\u0015\u0005\u0005U\u0001\u0002CA\u0011\u0003/!\t!a\t\u0002+%\u001c()Y2l!J,7o];sK\u0016s\u0017M\u00197fIR!\u0011QEA\u0016!\rq\u0011qE\u0005\u0004\u0003Sy!a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003[\ty\u00021\u0001\u00020\u0005!1m\u001c8g!\u0011\t\t$a\r\u000e\u0003\u0019I1!!\u000e\u0007\u0005%\u0019\u0006/\u0019:l\u0007>tg\r\u0003\u0006\u0002:\u0005]\u0011\u0011!C\u0005\u0003w\t1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\b\t\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)\u0019\u00111I-\u0002\t1\fgnZ\u0005\u0005\u0003\u000f\n\tE\u0001\u0004PE*,7\r\u001e")
public abstract class RateController
implements StreamingListener,
scala.Serializable {
    private final int streamUID;
    private final RateEstimator rateEstimator;
    private transient ExecutionContext executionContext;
    private transient AtomicLong rateLimit;

    public static boolean isBackPressureEnabled(SparkConf sparkConf) {
        return RateController$.MODULE$.isBackPressureEnabled(sparkConf);
    }

    @Override
    public void onStreamingStarted(StreamingListenerStreamingStarted streamingStarted) {
        StreamingListener.onStreamingStarted$(this, streamingStarted);
    }

    @Override
    public void onReceiverStarted(StreamingListenerReceiverStarted receiverStarted) {
        StreamingListener.onReceiverStarted$(this, receiverStarted);
    }

    @Override
    public void onReceiverError(StreamingListenerReceiverError receiverError) {
        StreamingListener.onReceiverError$(this, receiverError);
    }

    @Override
    public void onReceiverStopped(StreamingListenerReceiverStopped receiverStopped) {
        StreamingListener.onReceiverStopped$(this, receiverStopped);
    }

    @Override
    public void onBatchSubmitted(StreamingListenerBatchSubmitted batchSubmitted) {
        StreamingListener.onBatchSubmitted$(this, batchSubmitted);
    }

    @Override
    public void onBatchStarted(StreamingListenerBatchStarted batchStarted) {
        StreamingListener.onBatchStarted$(this, batchStarted);
    }

    @Override
    public void onOutputOperationStarted(StreamingListenerOutputOperationStarted outputOperationStarted) {
        StreamingListener.onOutputOperationStarted$(this, outputOperationStarted);
    }

    @Override
    public void onOutputOperationCompleted(StreamingListenerOutputOperationCompleted outputOperationCompleted) {
        StreamingListener.onOutputOperationCompleted$(this, outputOperationCompleted);
    }

    public int streamUID() {
        return this.streamUID;
    }

    public abstract void publish(long var1);

    private ExecutionContext executionContext() {
        return this.executionContext;
    }

    private void executionContext_$eq(ExecutionContext x$1) {
        this.executionContext = x$1;
    }

    private AtomicLong rateLimit() {
        return this.rateLimit;
    }

    private void rateLimit_$eq(AtomicLong x$1) {
        this.rateLimit = x$1;
    }

    private void init() {
        this.executionContext_$eq((ExecutionContext)ExecutionContext$.MODULE$.fromExecutorService(ThreadUtils$.MODULE$.newDaemonSingleThreadExecutor("stream-rate-update")));
        this.rateLimit_$eq(new AtomicLong(-1L));
    }

    private void readObject(ObjectInputStream ois) {
        Utils$.MODULE$.tryOrIOException((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ois.defaultReadObject();
            this.init();
        });
    }

    private void computeAndPublish(long time, long elems, long workDelay, long waitDelay) {
        Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Option<Object> newRate = $this.rateEstimator.compute(time, elems, workDelay, waitDelay);
            newRate.foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)s -> {
                this.rateLimit().set((long)s);
                this.publish(this.getLatestRate());
            });
        }, this.executionContext());
    }

    public long getLatestRate() {
        return this.rateLimit().get();
    }

    @Override
    public void onBatchCompleted(StreamingListenerBatchCompleted batchCompleted) {
        Map<Object, StreamInputInfo> elements = batchCompleted.batchInfo().streamIdToInputInfo();
        batchCompleted.batchInfo().processingEndTime().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)processingEnd -> batchCompleted.batchInfo().processingDelay().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)workDelay -> batchCompleted.batchInfo().schedulingDelay().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)waitDelay -> elements.get((Object)BoxesRunTime.boxToInteger((int)this.streamUID())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.numRecords())).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)elems -> this.computeAndPublish(processingEnd, elems, workDelay, waitDelay)))));
    }

    public RateController(int streamUID, RateEstimator rateEstimator) {
        this.streamUID = streamUID;
        this.rateEstimator = rateEstimator;
        StreamingListener.$init$(this);
        this.init();
    }
}

