/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.receiver.ArrayBufferBlock;
import org.apache.spark.streaming.receiver.ByteBufferBlock;
import org.apache.spark.streaming.receiver.CountingIterator;
import org.apache.spark.streaming.receiver.IteratorBlock;
import org.apache.spark.streaming.receiver.ReceivedBlock;
import org.apache.spark.streaming.receiver.ReceivedBlockHandler;
import org.apache.spark.streaming.receiver.ReceivedBlockStoreResult;
import org.apache.spark.streaming.receiver.WriteAheadLogBasedBlockHandler$;
import org.apache.spark.streaming.receiver.WriteAheadLogBasedStoreResult;
import org.apache.spark.streaming.util.WriteAheadLog;
import org.apache.spark.streaming.util.WriteAheadLogRecordHandle;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%e!B\u0001\u0003\u0001\u0011a!AH,sSR,\u0017\t[3bI2{wMQ1tK\u0012\u0014En\\2l\u0011\u0006tG\r\\3s\u0015\t\u0019A!\u0001\u0005sK\u000e,\u0017N^3s\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0005\u0003\u0001\u001bM9\u0002C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u0015+5\t!!\u0003\u0002\u0017\u0005\t!\"+Z2fSZ,GM\u00117pG.D\u0015M\u001c3mKJ\u0004\"\u0001G\u000e\u000e\u0003eQ!A\u0007\u0004\u0002\u0011%tG/\u001a:oC2L!\u0001H\r\u0003\u000f1{wmZ5oO\"Aa\u0004\u0001B\u0001B\u0003%\u0001%\u0001\u0007cY>\u001c7.T1oC\u001e,'o\u0001\u0001\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r2\u0011aB:u_J\fw-Z\u0005\u0003K\t\u0012AB\u00117pG.l\u0015M\\1hKJD\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0012g\u0016\u0014\u0018.\u00197ju\u0016\u0014X*\u00198bO\u0016\u0014\bCA\u0015-\u001b\u0005Q#BA\u0016\u0007\u0003)\u0019XM]5bY&TXM]\u0005\u0003[)\u0012\u0011cU3sS\u0006d\u0017N_3s\u001b\u0006t\u0017mZ3s\u0011!y\u0003A!A!\u0002\u0013\u0001\u0014\u0001C:ue\u0016\fW.\u00133\u0011\u00059\t\u0014B\u0001\u001a\u0010\u0005\rIe\u000e\u001e\u0005\ti\u0001\u0011\t\u0011)A\u0005k\u0005a1\u000f^8sC\u001e,G*\u001a<fYB\u0011\u0011EN\u0005\u0003o\t\u0012Ab\u0015;pe\u0006<W\rT3wK2D\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IAO\u0001\u0005G>tg\r\u0005\u0002<y5\ta!\u0003\u0002>\r\tI1\u000b]1sW\u000e{gN\u001a\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\u0005\u0005+U\"\u0001\"\u000b\u0005e\u001a%B\u0001#\t\u0003\u0019A\u0017\rZ8pa&\u0011aI\u0011\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u0011!\u0003!\u0011!Q\u0001\n%\u000bQb\u00195fG.\u0004x.\u001b8u\t&\u0014\bC\u0001&R\u001d\tYu\n\u0005\u0002M\u001f5\tQJ\u0003\u0002O?\u00051AH]8pizJ!\u0001U\b\u0002\rA\u0013X\rZ3g\u0013\t\u00116K\u0001\u0004TiJLgn\u001a\u0006\u0003!>A\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IAV\u0001\u0006G2|7m\u001b\t\u0003/jk\u0011\u0001\u0017\u0006\u00033\u001a\tA!\u001e;jY&\u00111\f\u0017\u0002\u0006\u00072|7m\u001b\u0005\u0006;\u0002!\tAX\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013}\u0003\u0017MY2eK\u001a<\u0007C\u0001\u000b\u0001\u0011\u0015qB\f1\u0001!\u0011\u00159C\f1\u0001)\u0011\u0015yC\f1\u00011\u0011\u0015!D\f1\u00016\u0011\u0015ID\f1\u0001;\u0011\u0015yD\f1\u0001A\u0011\u0015AE\f1\u0001J\u0011\u001d)F\f%AA\u0002YCq!\u001b\u0001C\u0002\u0013%!.A\tcY>\u001c7n\u0015;pe\u0016$\u0016.\\3pkR,\u0012a\u001b\t\u0003YFl\u0011!\u001c\u0006\u0003]>\f\u0001\u0002Z;sCRLwN\u001c\u0006\u0003a>\t!bY8oGV\u0014(/\u001a8u\u0013\t\u0011XN\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\t\rQ\u0004\u0001\u0015!\u0003l\u0003I\u0011Gn\\2l'R|'/\u001a+j[\u0016|W\u000f\u001e\u0011\t\u000fY\u0004!\u0019!C\u0005o\u0006)RM\u001a4fGRLg/Z*u_J\fw-\u001a'fm\u0016dW#A\u001b\t\re\u0004\u0001\u0015!\u00036\u0003Y)gMZ3di&4Xm\u0015;pe\u0006<W\rT3wK2\u0004\u0003bB>\u0001\u0005\u0004%I\u0001`\u0001\u000eoJLG/Z!iK\u0006$Gj\\4\u0016\u0003u\u00042A`A\u0001\u001b\u0005y(BA-\u0005\u0013\r\t\u0019a \u0002\u000e/JLG/Z!iK\u0006$Gj\\4\t\u000f\u0005\u001d\u0001\u0001)A\u0005{\u0006qqO]5uK\u0006CW-\u00193M_\u001e\u0004\u0003\"CA\u0006\u0001\t\u0007I1BA\u0007\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/\u0006\u0002\u0002\u0010A!\u0011\u0011CA\n\u001b\u0005y\u0017bAA\u000b_\nyR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\u0011\u0005e\u0001\u0001)A\u0005\u0003\u001f\t\u0011#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;!\u0011\u001d\ti\u0002\u0001C\u0001\u0003?\t!b\u001d;pe\u0016\u0014En\\2l)\u0019\t\t#a\n\u00022A\u0019A#a\t\n\u0007\u0005\u0015\"A\u0001\rSK\u000e,\u0017N^3e\u00052|7m[*u_J,'+Z:vYRD\u0001\"!\u000b\u0002\u001c\u0001\u0007\u00111F\u0001\bE2|7m[%e!\r\t\u0013QF\u0005\u0004\u0003_\u0011#!D*ue\u0016\fWN\u00117pG.LE\r\u0003\u0005\u00024\u0005m\u0001\u0019AA\u001b\u0003\u0015\u0011Gn\\2l!\r!\u0012qG\u0005\u0004\u0003s\u0011!!\u0004*fG\u0016Lg/\u001a3CY>\u001c7\u000eC\u0004\u0002>\u0001!\t!a\u0010\u0002!\rdW-\u00198va>cGM\u00117pG.\u001cH\u0003BA!\u0003\u000f\u00022ADA\"\u0013\r\t)e\u0004\u0002\u0005+:LG\u000f\u0003\u0005\u0002J\u0005m\u0002\u0019AA&\u0003)!\bN]3tQRKW.\u001a\t\u0004\u001d\u00055\u0013bAA(\u001f\t!Aj\u001c8h\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+\nAa\u001d;paR\u0011\u0011\u0011I\u0004\t\u00033\u0012\u0001\u0012\u0001\u0003\u0002\\\u0005qrK]5uK\u0006CW-\u00193M_\u001e\u0014\u0015m]3e\u00052|7m\u001b%b]\u0012dWM\u001d\t\u0004)\u0005ucaB\u0001\u0003\u0011\u0003!\u0011qL\n\u0004\u0003;j\u0001bB/\u0002^\u0011\u0005\u00111\r\u000b\u0003\u00037B\u0001\"a\u001a\u0002^\u0011\u0005\u0011\u0011N\u0001\u0016G\",7m\u001b9pS:$H)\u001b:U_2{w\rR5s)\u0015I\u00151NA7\u0011\u0019A\u0015Q\ra\u0001\u0013\"1q&!\u001aA\u0002AB!\"!\u001d\u0002^E\u0005I\u0011AA:\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%qU\u0011\u0011Q\u000f\u0016\u0004-\u0006]4FAA=!\u0011\tY(!\"\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\ru\"\u0001\u0006b]:|G/\u0019;j_:LA!a\"\u0002~\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class WriteAheadLogBasedBlockHandler
implements ReceivedBlockHandler,
Logging {
    private final BlockManager blockManager;
    private final SerializerManager serializerManager;
    private final StorageLevel storageLevel;
    private final Clock clock;
    private final FiniteDuration blockStoreTimeout;
    private final StorageLevel effectiveStorageLevel;
    private final WriteAheadLog writeAheadLog;
    private final ExecutionContextExecutorService executionContext;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Clock $lessinit$greater$default$8() {
        return WriteAheadLogBasedBlockHandler$.MODULE$.$lessinit$greater$default$8();
    }

    public static String checkpointDirToLogDir(String string, int n) {
        return WriteAheadLogBasedBlockHandler$.MODULE$.checkpointDirToLogDir(string, n);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private FiniteDuration blockStoreTimeout() {
        return this.blockStoreTimeout;
    }

    private StorageLevel effectiveStorageLevel() {
        return this.effectiveStorageLevel;
    }

    private WriteAheadLog writeAheadLog() {
        return this.writeAheadLog;
    }

    private ExecutionContextExecutorService executionContext() {
        return this.executionContext;
    }

    @Override
    public ReceivedBlockStoreResult storeBlock(StreamBlockId blockId, ReceivedBlock block) {
        ChunkedByteBuffer chunkedByteBuffer;
        Option<Object> numRecords = Option$.MODULE$.empty();
        ReceivedBlock receivedBlock = block;
        if (receivedBlock instanceof ArrayBufferBlock) {
            ArrayBufferBlock arrayBufferBlock = (ArrayBufferBlock)receivedBlock;
            ArrayBuffer<?> arrayBuffer = arrayBufferBlock.arrayBuffer();
            numRecords = new Some((Object)BoxesRunTime.boxToLong((long)arrayBuffer.size()));
            chunkedByteBuffer = this.serializerManager.dataSerialize((BlockId)blockId, arrayBuffer.iterator(), ClassTag$.MODULE$.apply(Object.class));
        } else if (receivedBlock instanceof IteratorBlock) {
            IteratorBlock iteratorBlock = (IteratorBlock)receivedBlock;
            Iterator<?> iterator = iteratorBlock.iterator();
            CountingIterator countIterator = new CountingIterator(iterator);
            ChunkedByteBuffer serializedBlock = this.serializerManager.dataSerialize((BlockId)blockId, countIterator, ClassTag$.MODULE$.apply(Object.class));
            numRecords = countIterator.count();
            chunkedByteBuffer = serializedBlock;
        } else if (receivedBlock instanceof ByteBufferBlock) {
            ByteBufferBlock byteBufferBlock = (ByteBufferBlock)receivedBlock;
            ByteBuffer byteBuffer = byteBufferBlock.byteBuffer();
            chunkedByteBuffer = new ChunkedByteBuffer(byteBuffer.duplicate());
        } else {
            throw new Exception(new StringBuilder(55).append("Could not push ").append(blockId).append(" to block manager, unexpected block type").toString());
        }
        ChunkedByteBuffer serializedBlock = chunkedByteBuffer;
        Future storeInBlockManagerFuture = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            boolean putSucceeded = $this.blockManager.putBytes((BlockId)blockId, serializedBlock, this.effectiveStorageLevel(), true, ClassTag$.MODULE$.Nothing());
            if (!putSucceeded) {
                throw new SparkException(new StringBuilder(53).append("Could not store ").append(blockId).append(" to block manager with storage level ").append($this.storageLevel).toString());
            }
        }, (ExecutionContext)this.executionContext());
        Future storeInWriteAheadLogFuture = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.writeAheadLog().write(serializedBlock.toByteBuffer(), $this.clock.getTimeMillis()), (ExecutionContext)this.executionContext());
        Future combinedFuture = storeInBlockManagerFuture.zip(storeInWriteAheadLogFuture).map((Function1 & Serializable & scala.Serializable)x$1 -> (WriteAheadLogRecordHandle)x$1._2(), (ExecutionContext)this.executionContext());
        WriteAheadLogRecordHandle walRecordHandle = (WriteAheadLogRecordHandle)ThreadUtils$.MODULE$.awaitResult((Awaitable)combinedFuture, (Duration)this.blockStoreTimeout());
        return new WriteAheadLogBasedStoreResult(blockId, numRecords, walRecordHandle);
    }

    @Override
    public void cleanupOldBlocks(long threshTime) {
        this.writeAheadLog().clean(threshTime, false);
    }

    public void stop() {
        this.writeAheadLog().close();
        this.executionContext().shutdown();
    }

    public WriteAheadLogBasedBlockHandler(BlockManager blockManager, SerializerManager serializerManager, int streamId, StorageLevel storageLevel, SparkConf conf, Configuration hadoopConf, String checkpointDir, Clock clock) {
        this.blockManager = blockManager;
        this.serializerManager = serializerManager;
        this.storageLevel = storageLevel;
        this.clock = clock;
        Logging.$init$((Logging)this);
        this.blockStoreTimeout = new package.DurationInt(package$.MODULE$.DurationInt(conf.getInt("spark.streaming.receiver.blockStoreTimeout", 30))).seconds();
        if (storageLevel.deserialized()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(108).append("Storage level serialization ").append($this.storageLevel.deserialized()).append(" is not supported when").append(" write ahead log is enabled, change to serialization false").toString());
        }
        if (storageLevel.replication() > 1) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(98).append("Storage level replication ").append($this.storageLevel.replication()).append(" is unnecessary when ").append("write ahead log is enabled, change to replication 1").toString());
        }
        this.effectiveStorageLevel = StorageLevel$.MODULE$.apply(storageLevel.useDisk(), storageLevel.useMemory(), storageLevel.useOffHeap(), false, 1);
        StorageLevel storageLevel2 = storageLevel;
        StorageLevel storageLevel3 = this.effectiveStorageLevel();
        if (storageLevel2 == null ? storageLevel3 != null : !storageLevel2.equals(storageLevel3)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("User defined storage level ").append($this.storageLevel).append(" is changed to effective storage level ").append(new StringBuilder(32).append(this.effectiveStorageLevel()).append(" when write ahead log is enabled").toString()).toString());
        }
        this.writeAheadLog = WriteAheadLogUtils$.MODULE$.createLogForReceiver(conf, WriteAheadLogBasedBlockHandler$.MODULE$.checkpointDirToLogDir(checkpointDir, streamId), hadoopConf);
        this.executionContext = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)ThreadUtils$.MODULE$.newDaemonFixedThreadPool(2, this.getClass().getSimpleName()));
    }
}

