/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.nio.ByteBuffer;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.receiver.ReceiverSupervisor;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005]g!B\u0001\u0003\u0003\u0003i!\u0001\u0003*fG\u0016Lg/\u001a:\u000b\u0005\r!\u0011\u0001\u0003:fG\u0016Lg/\u001a:\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\u000b\u0003\u001d)\u001a2\u0001A\b\u0016!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fMB\u0011\u0001CF\u0005\u0003/E\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"\u0007\u0001\u0003\u0006\u0004%\tAG\u0001\rgR|'/Y4f\u0019\u00164X\r\\\u000b\u00027A\u0011AdH\u0007\u0002;)\u0011aDB\u0001\bgR|'/Y4f\u0013\t\u0001SD\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G\u000e\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003\u001c\u00035\u0019Ho\u001c:bO\u0016dUM^3mA!)A\u0005\u0001C\u0001K\u00051A(\u001b8jiz\"\"AJ\u001a\u0011\u0007\u001d\u0002\u0001&D\u0001\u0003!\tI#\u0006\u0004\u0001\u0005\u000b-\u0002!\u0019\u0001\u0017\u0003\u0003Q\u000b\"!\f\u0019\u0011\u0005Aq\u0013BA\u0018\u0012\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001E\u0019\n\u0005I\n\"aA!os\")\u0011d\ta\u00017!)Q\u0007\u0001D\u0001m\u00059qN\\*uCJ$H#A\u001c\u0011\u0005AA\u0014BA\u001d\u0012\u0005\u0011)f.\u001b;\t\u000bm\u0002a\u0011\u0001\u001c\u0002\r=t7\u000b^8q\u0011\u0015i\u0004\u0001\"\u0001?\u0003E\u0001(/\u001a4feJ,G\rT8dCRLwN\\\u000b\u0002\u007fA\u0019\u0001\u0003\u0011\"\n\u0005\u0005\u000b\"AB(qi&|g\u000e\u0005\u0002D\u0015:\u0011A\t\u0013\t\u0003\u000bFi\u0011A\u0012\u0006\u0003\u000f2\ta\u0001\u0010:p_Rt\u0014BA%\u0012\u0003\u0019\u0001&/\u001a3fM&\u00111\n\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%\u000b\u0002\"\u0002(\u0001\t\u0003y\u0015!B:u_J,GCA\u001cQ\u0011\u0015\tV\n1\u0001)\u0003!!\u0017\r^1Ji\u0016l\u0007\"\u0002(\u0001\t\u0003\u0019FCA\u001cU\u0011\u0015)&\u000b1\u0001W\u0003)!\u0017\r^1Ck\u001a4WM\u001d\t\u0004/rCS\"\u0001-\u000b\u0005eS\u0016aB7vi\u0006\u0014G.\u001a\u0006\u00037F\t!bY8mY\u0016\u001cG/[8o\u0013\ti\u0006LA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\b\"\u0002(\u0001\t\u0003yFcA\u001caC\")QK\u0018a\u0001-\")!M\u0018a\u0001a\u0005AQ.\u001a;bI\u0006$\u0018\rC\u0003O\u0001\u0011\u0005A\r\u0006\u00028K\")am\u0019a\u0001O\u0006aA-\u0019;b\u0013R,'/\u0019;peB\u0019\u0001.\u001c\u0015\u000f\u0005%\\gBA#k\u0013\u0005\u0011\u0012B\u00017\u0012\u0003\u001d\u0001\u0018mY6bO\u0016L!A\\8\u0003\u0011%#XM]1u_JT!\u0001\\\t\t\u000b9\u0003A\u0011A9\u0015\u0007]\u0012(\u0010C\u0003ga\u0002\u00071\u000fE\u0002us\"j\u0011!\u001e\u0006\u0003m^\fA!\u001e;jY*\t\u00010\u0001\u0003kCZ\f\u0017B\u00018v\u0011\u0015\u0011\u0007\u000f1\u00011\u0011\u0015q\u0005\u0001\"\u0001})\t9T\u0010C\u0003gw\u0002\u00071\u000fC\u0003O\u0001\u0011\u0005q\u0010F\u00038\u0003\u0003\t\u0019\u0001C\u0003g}\u0002\u0007q\rC\u0003c}\u0002\u0007\u0001\u0007\u0003\u0004O\u0001\u0011\u0005\u0011q\u0001\u000b\u0004o\u0005%\u0001\u0002CA\u0006\u0003\u000b\u0001\r!!\u0004\u0002\u000b\tLH/Z:\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005x\u0003\rq\u0017n\\\u0005\u0005\u0003/\t\tB\u0001\u0006CsR,')\u001e4gKJDaA\u0014\u0001\u0005\u0002\u0005mA#B\u001c\u0002\u001e\u0005}\u0001\u0002CA\u0006\u00033\u0001\r!!\u0004\t\r\t\fI\u00021\u00011\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003K\t1B]3q_J$XI\u001d:peR)q'a\n\u0002,!9\u0011\u0011FA\u0011\u0001\u0004\u0011\u0015aB7fgN\fw-\u001a\u0005\t\u0003[\t\t\u00031\u0001\u00020\u0005IA\u000f\u001b:po\u0006\u0014G.\u001a\t\u0004Q\u0006E\u0012bAA\u001a_\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0005\b\u0003o\u0001A\u0011AA\u001d\u0003\u001d\u0011Xm\u001d;beR$2aNA\u001e\u0011\u001d\tI#!\u000eA\u0002\tCq!a\u000e\u0001\t\u0003\ty\u0004F\u00038\u0003\u0003\n\u0019\u0005C\u0004\u0002*\u0005u\u0002\u0019\u0001\"\t\u0011\u0005\u0015\u0013Q\ba\u0001\u0003_\tQ!\u001a:s_JDq!a\u000e\u0001\t\u0003\tI\u0005F\u00048\u0003\u0017\ni%a\u0014\t\u000f\u0005%\u0012q\ta\u0001\u0005\"A\u0011QIA$\u0001\u0004\ty\u0003\u0003\u0005\u0002R\u0005\u001d\u0003\u0019AA*\u0003-i\u0017\u000e\u001c7jg\u0016\u001cwN\u001c3\u0011\u0007A\t)&C\u0002\u0002XE\u00111!\u00138u\u0011\u001d\tY\u0006\u0001C\u0001\u0003;\nAa\u001d;paR\u0019q'a\u0018\t\u000f\u0005%\u0012\u0011\fa\u0001\u0005\"9\u00111\f\u0001\u0005\u0002\u0005\rD#B\u001c\u0002f\u0005\u001d\u0004bBA\u0015\u0003C\u0002\rA\u0011\u0005\t\u0003\u000b\n\t\u00071\u0001\u00020!9\u00111\u000e\u0001\u0005\u0002\u00055\u0014!C5t'R\f'\u000f^3e)\t\ty\u0007E\u0002\u0011\u0003cJ1!a\u001d\u0012\u0005\u001d\u0011un\u001c7fC:Dq!a\u001e\u0001\t\u0003\ti'A\u0005jgN#x\u000e\u001d9fI\"9\u00111\u0010\u0001\u0005\u0002\u0005u\u0014\u0001C:ue\u0016\fW.\u00133\u0016\u0005\u0005M\u0003\"CAA\u0001\u0001\u0007I\u0011BA?\u0003\tIG\rC\u0005\u0002\u0006\u0002\u0001\r\u0011\"\u0003\u0002\b\u00061\u0011\u000eZ0%KF$2aNAE\u0011)\tY)a!\u0002\u0002\u0003\u0007\u00111K\u0001\u0004q\u0012\n\u0004\u0002CAH\u0001\u0001\u0006K!a\u0015\u0002\u0007%$\u0007\u0005C\u0005\u0002\u0014\u0002\u0001\r\u0011\"\u0003\u0002\u0016\u0006Yql];qKJ4\u0018n]8s+\t\t9\nE\u0002(\u00033K1!a'\u0003\u0005I\u0011VmY3jm\u0016\u00148+\u001e9feZL7o\u001c:\t\u0013\u0005}\u0005\u00011A\u0005\n\u0005\u0005\u0016aD0tkB,'O^5t_J|F%Z9\u0015\u0007]\n\u0019\u000b\u0003\u0006\u0002\f\u0006u\u0015\u0011!a\u0001\u0003/C\u0001\"a*\u0001A\u0003&\u0011qS\u0001\r?N,\b/\u001a:wSN|'\u000f\t\u0015\u0005\u0003K\u000bY\u000bE\u0002\u0011\u0003[K1!a,\u0012\u0005%!(/\u00198tS\u0016tG\u000f\u0003\u0005\u00024\u0002!\t\u0001BA[\u00035\u0019X\r\u001e*fG\u0016Lg/\u001a:JIR\u0019q'a.\t\u0011\u0005e\u0016\u0011\u0017a\u0001\u0003'\n1aX5e\u0011!\ti\f\u0001C\u0001\t\u0005}\u0016\u0001E1ui\u0006\u001c\u0007nU;qKJ4\u0018n]8s)\r9\u0014\u0011\u0019\u0005\t\u0003\u0007\fY\f1\u0001\u0002\u0018\u0006!Q\r_3d\u0011!\t9\r\u0001C\u0001\t\u0005U\u0015AC:va\u0016\u0014h/[:pe\"\u001a\u0001!a3\u0011\t\u00055\u00171[\u0007\u0003\u0003\u001fT1!!5\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003+\fyM\u0001\u0007EKZ,Gn\u001c9fe\u0006\u0003\u0018\u000e")
public abstract class Receiver<T>
implements Serializable {
    private final StorageLevel storageLevel;
    private int id;
    private transient ReceiverSupervisor _supervisor;

    public StorageLevel storageLevel() {
        return this.storageLevel;
    }

    public abstract void onStart();

    public abstract void onStop();

    public Option<String> preferredLocation() {
        return None$.MODULE$;
    }

    public void store(T dataItem) {
        this.supervisor().pushSingle(dataItem);
    }

    public void store(ArrayBuffer<T> dataBuffer) {
        this.supervisor().pushArrayBuffer(dataBuffer, (Option<Object>)None$.MODULE$, (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(ArrayBuffer<T> dataBuffer, Object metadata) {
        this.supervisor().pushArrayBuffer(dataBuffer, (Option<Object>)new Some(metadata), (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(Iterator<T> dataIterator) {
        this.supervisor().pushIterator(dataIterator, (Option<Object>)None$.MODULE$, (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(java.util.Iterator<T> dataIterator, Object metadata) {
        this.supervisor().pushIterator((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(dataIterator).asScala(), (Option<Object>)new Some(metadata), (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(java.util.Iterator<T> dataIterator) {
        this.supervisor().pushIterator((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(dataIterator).asScala(), (Option<Object>)None$.MODULE$, (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(Iterator<T> dataIterator, Object metadata) {
        this.supervisor().pushIterator(dataIterator, (Option<Object>)new Some(metadata), (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(ByteBuffer bytes) {
        this.supervisor().pushBytes(bytes, (Option<Object>)None$.MODULE$, (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(ByteBuffer bytes, Object metadata) {
        this.supervisor().pushBytes(bytes, (Option<Object>)new Some(metadata), (Option<StreamBlockId>)None$.MODULE$);
    }

    public void reportError(String message, Throwable throwable) {
        this.supervisor().reportError(message, throwable);
    }

    public void restart(String message) {
        ReceiverSupervisor qual$1 = this.supervisor();
        String x$1 = message;
        Option<Throwable> x$2 = qual$1.restartReceiver$default$2();
        qual$1.restartReceiver(x$1, x$2);
    }

    public void restart(String message, Throwable error) {
        this.supervisor().restartReceiver(message, (Option<Throwable>)new Some((Object)error));
    }

    public void restart(String message, Throwable error, int millisecond) {
        this.supervisor().restartReceiver(message, (Option<Throwable>)new Some((Object)error), millisecond);
    }

    public void stop(String message) {
        this.supervisor().stop(message, (Option<Throwable>)None$.MODULE$);
    }

    public void stop(String message, Throwable error) {
        this.supervisor().stop(message, (Option<Throwable>)new Some((Object)error));
    }

    public boolean isStarted() {
        return this.supervisor().isReceiverStarted();
    }

    public boolean isStopped() {
        return this.supervisor().isReceiverStopped();
    }

    public int streamId() {
        return this.id();
    }

    private int id() {
        return this.id;
    }

    private void id_$eq(int x$1) {
        this.id = x$1;
    }

    private ReceiverSupervisor _supervisor() {
        return this._supervisor;
    }

    private void _supervisor_$eq(ReceiverSupervisor x$1) {
        this._supervisor = x$1;
    }

    public void setReceiverId(int _id) {
        this.id_$eq(_id);
    }

    public void attachSupervisor(ReceiverSupervisor exec) {
        Predef$.MODULE$.assert(this._supervisor() == null);
        this._supervisor_$eq(exec);
    }

    public ReceiverSupervisor supervisor() {
        Predef$.MODULE$.assert(this._supervisor() != null, (Function0 & java.io.Serializable & Serializable)() -> "A ReceiverSupervisor has not been attached to the receiver yet. Maybe you are starting some computation in the receiver before the Receiver.onStart() has been called.");
        return this._supervisor();
    }

    public Receiver(StorageLevel storageLevel) {
        this.storageLevel = storageLevel;
        this.id = -1;
        this._supervisor = null;
    }
}

