/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.nio.ByteBuffer;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.receiver.ArrayBufferBlock;
import org.apache.spark.streaming.receiver.BlockManagerBasedStoreResult;
import org.apache.spark.streaming.receiver.ByteBufferBlock;
import org.apache.spark.streaming.receiver.CountingIterator;
import org.apache.spark.streaming.receiver.IteratorBlock;
import org.apache.spark.streaming.receiver.ReceivedBlock;
import org.apache.spark.streaming.receiver.ReceivedBlockHandler;
import org.apache.spark.streaming.receiver.ReceivedBlockStoreResult;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000113Q!\u0001\u0002\u0001\t1\u0011QD\u00117pG.l\u0015M\\1hKJ\u0014\u0015m]3e\u00052|7m\u001b%b]\u0012dWM\u001d\u0006\u0003\u0007\u0011\t\u0001B]3dK&4XM\u001d\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001cB\u0001A\u0007\u0014/A\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\u0004\"\u0001F\u000b\u000e\u0003\tI!A\u0006\u0002\u0003)I+7-Z5wK\u0012\u0014En\\2l\u0011\u0006tG\r\\3s!\tA2$D\u0001\u001a\u0015\tQb!\u0001\u0005j]R,'O\\1m\u0013\ta\u0012DA\u0004M_\u001e<\u0017N\\4\t\u0011y\u0001!\u0011!Q\u0001\n\u0001\nAB\u00197pG.l\u0015M\\1hKJ\u001c\u0001\u0001\u0005\u0002\"I5\t!E\u0003\u0002$\r\u000591\u000f^8sC\u001e,\u0017BA\u0013#\u00051\u0011En\\2l\u001b\u0006t\u0017mZ3s\u0011!9\u0003A!A!\u0002\u0013A\u0013\u0001D:u_J\fw-\u001a'fm\u0016d\u0007CA\u0011*\u0013\tQ#E\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G\u000eC\u0003-\u0001\u0011\u0005Q&\u0001\u0004=S:LGO\u0010\u000b\u0004]=\u0002\u0004C\u0001\u000b\u0001\u0011\u0015q2\u00061\u0001!\u0011\u001593\u00061\u0001)\u0011\u0015\u0011\u0004\u0001\"\u00014\u0003)\u0019Ho\u001c:f\u00052|7m\u001b\u000b\u0004i]b\u0004C\u0001\u000b6\u0013\t1$A\u0001\rSK\u000e,\u0017N^3e\u00052|7m[*u_J,'+Z:vYRDQ\u0001O\u0019A\u0002e\nqA\u00197pG.LE\r\u0005\u0002\"u%\u00111H\t\u0002\u000e'R\u0014X-Y7CY>\u001c7.\u00133\t\u000bu\n\u0004\u0019\u0001 \u0002\u000b\tdwnY6\u0011\u0005Qy\u0014B\u0001!\u0003\u00055\u0011VmY3jm\u0016$'\t\\8dW\")!\t\u0001C\u0001\u0007\u0006\u00012\r\\3b]V\u0004x\n\u001c3CY>\u001c7n\u001d\u000b\u0003\t\u001e\u0003\"AD#\n\u0005\u0019{!\u0001B+oSRDQ\u0001S!A\u0002%\u000b!\u0002\u001e5sKNDG+[7f!\tq!*\u0003\u0002L\u001f\t!Aj\u001c8h\u0001")
public class BlockManagerBasedBlockHandler
implements ReceivedBlockHandler,
Logging {
    private final BlockManager blockManager;
    private final StorageLevel storageLevel;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public ReceivedBlockStoreResult storeBlock(StreamBlockId blockId, ReceivedBlock block) {
        boolean bl;
        Option<Object> numRecords = None$.MODULE$;
        ReceivedBlock receivedBlock = block;
        if (receivedBlock instanceof ArrayBufferBlock) {
            ArrayBufferBlock arrayBufferBlock = (ArrayBufferBlock)receivedBlock;
            ArrayBuffer<?> arrayBuffer = arrayBufferBlock.arrayBuffer();
            numRecords = new Some((Object)BoxesRunTime.boxToLong((long)arrayBuffer.size()));
            bl = this.blockManager.putIterator((BlockId)blockId, arrayBuffer.iterator(), this.storageLevel, true, ClassTag$.MODULE$.apply(Object.class));
        } else if (receivedBlock instanceof IteratorBlock) {
            IteratorBlock iteratorBlock = (IteratorBlock)receivedBlock;
            Iterator<?> iterator = iteratorBlock.iterator();
            CountingIterator countIterator = new CountingIterator(iterator);
            boolean putResult = this.blockManager.putIterator((BlockId)blockId, countIterator, this.storageLevel, true, ClassTag$.MODULE$.apply(Object.class));
            numRecords = countIterator.count();
            bl = putResult;
        } else if (receivedBlock instanceof ByteBufferBlock) {
            ByteBufferBlock byteBufferBlock = (ByteBufferBlock)receivedBlock;
            ByteBuffer byteBuffer = byteBufferBlock.byteBuffer();
            bl = this.blockManager.putBytes((BlockId)blockId, new ChunkedByteBuffer(byteBuffer.duplicate()), this.storageLevel, true, ClassTag$.MODULE$.Nothing());
        } else {
            throw new SparkException(new StringBuilder(57).append("Could not store ").append(blockId).append(" to block manager, unexpected block type ").append(receivedBlock.getClass().getName()).toString());
        }
        boolean putSucceeded = bl;
        if (!putSucceeded) {
            throw new SparkException(new StringBuilder(53).append("Could not store ").append(blockId).append(" to block manager with storage level ").append(this.storageLevel).toString());
        }
        return new BlockManagerBasedStoreResult(blockId, numRecords);
    }

    @Override
    public void cleanupOldBlocks(long threshTime) {
    }

    public BlockManagerBasedBlockHandler(BlockManager blockManager, StorageLevel storageLevel) {
        this.blockManager = blockManager;
        this.storageLevel = storageLevel;
        Logging.$init$((Logging)this);
    }
}

