/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.dstream;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.UnionRDD;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStreamCheckpointData;
import org.apache.spark.streaming.dstream.FileInputDStream$;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.scheduler.StreamInputInfo$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.TimeStampedHashMap;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\red!B\u0001\u0003\u0001\u0011a!\u0001\u0005$jY\u0016Le\u000e];u\tN#(/Z1n\u0015\t\u0019A!A\u0004egR\u0014X-Y7\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<W\u0003B\u0007\u001bK\u0015\u001c\"\u0001\u0001\b\u0011\u0007=\u0001\"#D\u0001\u0003\u0013\t\t\"A\u0001\u0007J]B,H\u000fR*ue\u0016\fW\u000e\u0005\u0003\u0014-a!S\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\rQ+\b\u000f\\33!\tI\"\u0004\u0004\u0001\u0005\u000bm\u0001!\u0019A\u000f\u0003\u0003-\u001b\u0001!\u0005\u0002\u001fCA\u00111cH\u0005\u0003AQ\u0011qAT8uQ&tw\r\u0005\u0002\u0014E%\u00111\u0005\u0006\u0002\u0004\u0003:L\bCA\r&\t\u00151\u0003A1\u0001\u001e\u0005\u00051\u0006\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002\t}\u001b8o\u0019\t\u0003U-j\u0011\u0001B\u0005\u0003Y\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u00119\u0002!\u0011!Q\u0001\n=\n\u0011\u0002Z5sK\u000e$xN]=\u0011\u0005A:dBA\u00196!\t\u0011D#D\u00014\u0015\t!D$\u0001\u0004=e>|GOP\u0005\u0003mQ\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011a\u0007\u0006\u0005\tw\u0001\u0011\t\u0011)A\u0005y\u00051a-\u001b7uKJ\u0004BaE\u001f@\u000f&\u0011a\b\u0006\u0002\n\rVt7\r^5p]F\u0002\"\u0001Q#\u000e\u0003\u0005S!AQ\"\u0002\u0005\u0019\u001c(B\u0001#\t\u0003\u0019A\u0017\rZ8pa&\u0011a)\u0011\u0002\u0005!\u0006$\b\u000e\u0005\u0002\u0014\u0011&\u0011\u0011\n\u0006\u0002\b\u0005>|G.Z1o\u0011!Y\u0005A!A!\u0002\u00139\u0015\u0001\u00048fo\u001aKG.Z:P]2L\b\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\u0002\t\r|gN\u001a\t\u0004'=\u000b\u0016B\u0001)\u0015\u0005\u0019y\u0005\u000f^5p]B\u0011!\u000bV\u0007\u0002'*\u0011QjQ\u0005\u0003+N\u0013QbQ8oM&<WO]1uS>t\u0007\u0002C,\u0001\u0005\u0003\u0005\u000b1\u0002-\u0002\u0005-l\u0007cA-]15\t!L\u0003\u0002\\)\u00059!/\u001a4mK\u000e$\u0018BA/[\u0005!\u0019E.Y:t)\u0006<\u0007\u0002C0\u0001\u0005\u0003\u0005\u000b1\u00021\u0002\u0005Yl\u0007cA-]I!A!\r\u0001B\u0001B\u0003-1-\u0001\u0002g[B\u0019\u0011\f\u00183\u0011\u0005e)G!\u00024\u0001\u0005\u00049'!\u0001$\u0012\u0005yA\u0007\u0003B5m1\u0011j\u0011A\u001b\u0006\u0003W\u000e\u000b\u0011\"\\1qe\u0016$WoY3\n\u00055T'aC%oaV$hi\u001c:nCRDQa\u001c\u0001\u0005\u0002A\fa\u0001P5oSRtDCB9wobL(\u0010\u0006\u0003sgR,\b#B\b\u00011\u0011\"\u0007\"B,o\u0001\bA\u0006\"B0o\u0001\b\u0001\u0007\"\u00022o\u0001\b\u0019\u0007\"\u0002\u0015o\u0001\u0004I\u0003\"\u0002\u0018o\u0001\u0004y\u0003bB\u001eo!\u0003\u0005\r\u0001\u0010\u0005\b\u0017:\u0004\n\u00111\u0001H\u0011\u001die\u000e%AA\u00029Cq\u0001 \u0001C\u0002\u0013%Q0A\ntKJL\u0017\r\\5{C\ndWmQ8oM>\u0003H/F\u0001\u007f!\r\u0019rj \t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u0004\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0013\t\u0019AA\rTKJL\u0017\r\\5{C\ndWmQ8oM&<WO]1uS>t\u0007bBA\u0007\u0001\u0001\u0006IA`\u0001\u0015g\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\"p]\u001a|\u0005\u000f\u001e\u0011\t\u0013\u0005E\u0001A1A\u0005\n\u0005M\u0011\u0001F7j]J+W.Z7cKJ$UO]1uS>t7+\u0006\u0002\u0002\u0016A\u0019!&a\u0006\n\u0007\u0005eAA\u0001\u0005EkJ\fG/[8o\u0011!\ti\u0002\u0001Q\u0001\n\u0005U\u0011!F7j]J+W.Z7cKJ$UO]1uS>t7\u000b\t\u0005\b\u0003C\u0001A\u0011BA\u0012\u0003\u0015\u0019Gn\\2l+\t\t)\u0003\u0005\u0003\u0002\u0002\u0005\u001d\u0012\u0002BA\u0015\u0003\u0007\u0011Qa\u00117pG.D!\"!\f\u0001\u0005\u0004%\t\u0006BA\u0018\u00039\u0019\u0007.Z2la>Lg\u000e\u001e#bi\u0006,\"!!\r\u0011\t\u0005M\u0012QG\u0007\u0002\u0001\u00199\u0011q\u0007\u0001\u0001\t\u0005e\"A\b$jY\u0016Le\u000e];u\tN#(/Z1n\u0007\",7m\u001b9pS:$H)\u0019;b'\u0011\t)$a\u000f\u0011\t=\tiDE\u0005\u0004\u0003\u007f\u0011!!\u0006#TiJ,\u0017-\\\"iK\u000e\\\u0007o\\5oi\u0012\u000bG/\u0019\u0005\b_\u0006UB\u0011AA\")\t\t\t\u0004\u0003\u0005\u0002H\u0005UB\u0011BA%\u0003-A\u0017\rZ8pa\u001aKG.Z:\u0016\u0005\u0005-\u0003\u0003CA'\u0003/\nY&!\u0019\u000e\u0005\u0005=#\u0002BA)\u0003'\nq!\\;uC\ndWMC\u0002\u0002VQ\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI&a\u0014\u0003\u000f!\u000b7\u000f['baB\u0019!&!\u0018\n\u0007\u0005}CA\u0001\u0003US6,\u0007\u0003B\n\u0002d=J1!!\u001a\u0015\u0005\u0015\t%O]1z\u0011!\tI'!\u000e\u0005B\u0005-\u0014AB;qI\u0006$X\r\u0006\u0003\u0002n\u0005M\u0004cA\n\u0002p%\u0019\u0011\u0011\u000f\u000b\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003k\n9\u00071\u0001\u0002\\\u0005!A/[7f\u0011!\tI(!\u000e\u0005B\u0005m\u0014aB2mK\u0006tW\u000f\u001d\u000b\u0005\u0003[\ni\b\u0003\u0005\u0002v\u0005]\u0004\u0019AA.\u0011!\t\t)!\u000e\u0005B\u0005\r\u0015a\u0002:fgR|'/\u001a\u000b\u0003\u0003[B\u0001\"a\"\u00026\u0011\u0005\u0013\u0011R\u0001\ti>\u001cFO]5oOR\tq\u0006\u0003\u0005\u0002\u000e\u0002\u0001\u000b\u0011BA\u0019\u0003=\u0019\u0007.Z2la>Lg\u000e\u001e#bi\u0006\u0004\u0003\"CAI\u0001\t\u0007I\u0011BAJ\u0003uIg.\u001b;jC2lu\u000e\u001a+j[\u0016LuM\\8sKRC'/Z:i_2$WCAAK!\r\u0019\u0012qS\u0005\u0004\u00033#\"\u0001\u0002'p]\u001eD\u0001\"!(\u0001A\u0003%\u0011QS\u0001\u001fS:LG/[1m\u001b>$G+[7f\u0013\u001etwN]3UQJ,7\u000f[8mI\u0002B\u0011\"!)\u0001\u0005\u0004%I!a)\u0002)9,XNQ1uG\",7\u000fV8SK6,WNY3s+\t\t)\u000bE\u0002\u0014\u0003OK1!!+\u0015\u0005\rIe\u000e\u001e\u0005\t\u0003[\u0003\u0001\u0015!\u0003\u0002&\u0006)b.^7CCR\u001c\u0007.Z:U_J+W.Z7cKJ\u0004\u0003\"CAY\u0001\t\u0007I\u0011BA\n\u0003I!WO]1uS>tGk\u001c*f[\u0016l'-\u001a:\t\u0011\u0005U\u0006\u0001)A\u0005\u0003+\t1\u0003Z;sCRLwN\u001c+p%\u0016lW-\u001c2fe\u0002B!\"!/\u0001\u0001\u0004%\t\u0001BA%\u0003a\u0011\u0017\r^2i)&lW\rV8TK2,7\r^3e\r&dWm\u001d\u0005\u000b\u0003{\u0003\u0001\u0019!C\u0001\t\u0005}\u0016\u0001\b2bi\u000eDG+[7f)>\u001cV\r\\3di\u0016$g)\u001b7fg~#S-\u001d\u000b\u0005\u0003[\n\t\r\u0003\u0006\u0002D\u0006m\u0016\u0011!a\u0001\u0003\u0017\n1\u0001\u001f\u00132\u0011!\t9\r\u0001Q!\n\u0005-\u0013!\u00072bi\u000eDG+[7f)>\u001cV\r\\3di\u0016$g)\u001b7fg\u0002BC!!2\u0002LB\u00191#!4\n\u0007\u0005=GCA\u0005ue\u0006t7/[3oi\"I\u00111\u001b\u0001A\u0002\u0013%\u0011Q[\u0001\u0016e\u0016\u001cWM\u001c;msN+G.Z2uK\u00124\u0015\u000e\\3t+\t\t9\u000eE\u0003\u0002N\u0005ew&\u0003\u0003\u0002\\\u0006=#a\u0002%bg\"\u001cV\r\u001e\u0005\n\u0003?\u0004\u0001\u0019!C\u0005\u0003C\f\u0011D]3dK:$H._*fY\u0016\u001cG/\u001a3GS2,7o\u0018\u0013fcR!\u0011QNAr\u0011)\t\u0019-!8\u0002\u0002\u0003\u0007\u0011q\u001b\u0005\t\u0003O\u0004\u0001\u0015)\u0003\u0002X\u00061\"/Z2f]Rd\u0017pU3mK\u000e$X\r\u001a$jY\u0016\u001c\b\u0005\u000b\u0003\u0002f\u0006-\u0007\"CAw\u0001\u0001\u0007I\u0011BAx\u000351\u0017\u000e\\3U_6{G\rV5nKV\u0011\u0011\u0011\u001f\t\b\u0003\u0003\t\u0019pLAK\u0013\u0011\t)0a\u0001\u0003%QKW.Z*uC6\u0004X\r\u001a%bg\"l\u0015\r\u001d\u0005\n\u0003s\u0004\u0001\u0019!C\u0005\u0003w\f\u0011CZ5mKR{Wj\u001c3US6,w\fJ3r)\u0011\ti'!@\t\u0015\u0005\r\u0017q_A\u0001\u0002\u0004\t\t\u0010\u0003\u0005\u0003\u0002\u0001\u0001\u000b\u0015BAy\u000391\u0017\u000e\\3U_6{G\rV5nK\u0002BC!a@\u0002L\"I!q\u0001\u0001A\u0002\u0013%\u00111S\u0001\u0017Y\u0006\u001cHOT3x\r&dWMR5oI&tw\rV5nK\"I!1\u0002\u0001A\u0002\u0013%!QB\u0001\u001bY\u0006\u001cHOT3x\r&dWMR5oI&tw\rV5nK~#S-\u001d\u000b\u0005\u0003[\u0012y\u0001\u0003\u0006\u0002D\n%\u0011\u0011!a\u0001\u0003+C\u0001Ba\u0005\u0001A\u0003&\u0011QS\u0001\u0018Y\u0006\u001cHOT3x\r&dWMR5oI&tw\rV5nK\u0002BCA!\u0005\u0002L\"I!\u0011\u0004\u0001A\u0002\u0013%!1D\u0001\u0006?B\fG\u000f[\u000b\u0002\u007f!I!q\u0004\u0001A\u0002\u0013%!\u0011E\u0001\n?B\fG\u000f[0%KF$B!!\u001c\u0003$!I\u00111\u0019B\u000f\u0003\u0003\u0005\ra\u0010\u0005\b\u0005O\u0001\u0001\u0015)\u0003@\u0003\u0019y\u0006/\u0019;iA!\"!QEAf\u0011%\u0011i\u0003\u0001a\u0001\n\u0013\u0011y#A\u0002`MN,\"A!\r\u0011\u0007\u0001\u0013\u0019$C\u0002\u00036\u0005\u0013!BR5mKNK8\u000f^3n\u0011%\u0011I\u0004\u0001a\u0001\n\u0013\u0011Y$A\u0004`MN|F%Z9\u0015\t\u00055$Q\b\u0005\u000b\u0003\u0007\u00149$!AA\u0002\tE\u0002\u0002\u0003B!\u0001\u0001\u0006KA!\r\u0002\t}37\u000f\t\u0015\u0005\u0005\u007f\tY\rC\u0004\u0003H\u0001!\t%a!\u0002\u000bM$\u0018M\u001d;\t\u000f\t-\u0003\u0001\"\u0011\u0002\u0004\u0006!1\u000f^8q\u0011\u001d\u0011y\u0005\u0001C!\u0005#\nqaY8naV$X\r\u0006\u0003\u0003T\t\u0005\u0004\u0003B\nP\u0005+\u0002RAa\u0016\u0003^Ii!A!\u0017\u000b\u0007\tmc!A\u0002sI\u0012LAAa\u0018\u0003Z\t\u0019!\u000b\u0012#\t\u0011\t\r$Q\na\u0001\u00037\n\u0011B^1mS\u0012$\u0016.\\3\t\u0011\t\u001d\u0004\u0001\"\u0015\u0005\u0005S\nQb\u00197fCJlU\r^1eCR\fG\u0003BA7\u0005WB\u0001\"!\u001e\u0003f\u0001\u0007\u00111\f\u0005\b\u0005_\u0002A\u0011\u0002B9\u000311\u0017N\u001c3OK^4\u0015\u000e\\3t)\u0011\t\tGa\u001d\t\u0011\tU$Q\u000ea\u0001\u0003+\u000b1bY;se\u0016tG\u000fV5nK\"9!\u0011\u0010\u0001\u0005\n\tm\u0014!C5t\u001d\u0016<h)\u001b7f)\u001d9%Q\u0010BA\u0005\u0007CqAa \u0003x\u0001\u0007q(\u0001\u0003qCRD\u0007\u0002\u0003B;\u0005o\u0002\r!!&\t\u0011\t\u0015%q\u000fa\u0001\u0003+\u000ba#\\8e)&lW-S4o_J,G\u000b\u001b:fg\"|G\u000e\u001a\u0005\b\u0005\u0013\u0003A\u0011\u0002BF\u0003)1\u0017\u000e\\3t)>\u0014F\t\u0012\u000b\u0005\u0005+\u0012i\t\u0003\u0005\u0003\u0010\n\u001d\u0005\u0019\u0001BI\u0003\u00151\u0017\u000e\\3t!\u0015\u0011\u0019J!(0\u001d\u0011\u0011)J!'\u000f\u0007I\u00129*C\u0001\u0016\u0013\r\u0011Y\nF\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011yJ!)\u0003\u0007M+\u0017OC\u0002\u0003\u001cRAqA!*\u0001\t\u0013\u00119+\u0001\bhKR4\u0015\u000e\\3N_\u0012$\u0016.\\3\u0015\t\u0005U%\u0011\u0016\u0005\b\u0005\u007f\u0012\u0019\u000b1\u0001@\u0011\u001d\u0011i\u000b\u0001C\u0005\u00057\tQ\u0002Z5sK\u000e$xN]=QCRD\u0007B\u0002\"\u0001\t\u0013\u0011y\u0003C\u0004\u00034\u0002!I!a!\u0002\u000bI,7/\u001a;\t\u000f\t]\u0006\u0001\"\u0003\u0003:\u0006Q!/Z1e\u001f\nTWm\u0019;\u0015\t\u00055$1\u0018\u0005\t\u0005{\u0013)\f1\u0001\u0003@\u0006\u0019q.[:\u0011\t\t\u0005'1Z\u0007\u0003\u0005\u0007TAA!2\u0003H\u0006\u0011\u0011n\u001c\u0006\u0003\u0005\u0013\fAA[1wC&!!Q\u001aBb\u0005Ey%M[3di&s\u0007/\u001e;TiJ,\u0017-\u001c\u0015\u0007\u0005k\u0013\tN!8\u0011\u000bM\u0011\u0019Na6\n\u0007\tUGC\u0001\u0004uQJ|wo\u001d\t\u0005\u0005\u0003\u0014I.\u0003\u0003\u0003\\\n\r'aC%P\u000bb\u001cW\r\u001d;j_:\u001c#Aa6\b\u0011\t\u0005(\u0001#\u0001\u0005\u0005G\f\u0001CR5mK&s\u0007/\u001e;E'R\u0014X-Y7\u0011\u0007=\u0011)OB\u0004\u0002\u0005!\u0005AAa:\u0014\r\t\u0015(\u0011\u001eBx!\r\u0019\"1^\u0005\u0004\u0005[$\"AB!osJ+g\rE\u0002\u0014\u0005cL1Aa=\u0015\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001dy'Q\u001dC\u0001\u0005o$\"Aa9\t\u0011\tm(Q\u001dC\u0001\u0005{\fQ\u0002Z3gCVdGOR5mi\u0016\u0014HcA$\u0003\u0000\"9!q\u0010B}\u0001\u0004y\u0004\u0002CB\u0002\u0005K$\ta!\u0002\u0002;\r\fGnY;mCR,g*^7CCR\u001c\u0007.Z:U_J+W.Z7cKJ$b!!*\u0004\b\r-\u0001\u0002CB\u0005\u0007\u0003\u0001\r!!\u0006\u0002\u001b\t\fGo\u00195EkJ\fG/[8o\u0011!\t\tb!\u0001A\u0002\u0005U\u0001BCB\b\u0005K\f\n\u0011\"\u0001\u0004\u0012\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\u0002ba\u0005\u0004*\r-2QF\u000b\u0003\u0007+Q3\u0001PB\fW\t\u0019I\u0002\u0005\u0003\u0004\u001c\r\u0015RBAB\u000f\u0015\u0011\u0019yb!\t\u0002\u0013Ut7\r[3dW\u0016$'bAB\u0012)\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r\u001d2Q\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GAB\u000e\u0004\u000e\t\u0007Q\u0004\u0002\u0004'\u0007\u001b\u0011\r!\b\u0003\bM\u000e5!\u0019AB\u0018#\rq2\u0011\u0007\t\u0007S2\u001c\u0019d!\u000e\u0011\u0007e\u0019I\u0003E\u0002\u001a\u0007WA!b!\u000f\u0003fF\u0005I\u0011AB\u001e\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iUA1QHB!\u0007\u0007\u001a)%\u0006\u0002\u0004@)\u001aqia\u0006\u0005\rm\u00199D1\u0001\u001e\t\u001913q\u0007b\u0001;\u00119ama\u000eC\u0002\r\u001d\u0013c\u0001\u0010\u0004JA1\u0011\u000e\\B&\u0007\u001b\u00022!GB!!\rI21\t\u0005\u000b\u0007#\u0012)/%A\u0005\u0002\rM\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0005\u0004V\re31LB/+\t\u00199FK\u0002O\u0007/!aaGB(\u0005\u0004iBA\u0002\u0014\u0004P\t\u0007Q\u0004B\u0004g\u0007\u001f\u0012\raa\u0018\u0012\u0007y\u0019\t\u0007\u0005\u0004jY\u000e\r4Q\r\t\u00043\re\u0003cA\r\u0004\\!Q1\u0011\u000eBs\u0003\u0003%Iaa\u001b\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007[\u0002Baa\u001c\u0004v5\u00111\u0011\u000f\u0006\u0005\u0007g\u00129-\u0001\u0003mC:<\u0017\u0002BB<\u0007c\u0012aa\u00142kK\u000e$\b")
public class FileInputDStream<K, V, F extends InputFormat<K, V>>
extends InputDStream<Tuple2<K, V>> {
    private final String directory;
    private final Function1<Path, Object> filter;
    private final ClassTag<K> km;
    private final ClassTag<V> vm;
    private final ClassTag<F> fm;
    private final Option<SerializableConfiguration> serializableConfOpt;
    private final Duration minRememberDurationS;
    private final FileInputDStreamCheckpointData checkpointData;
    private final long initialModTimeIgnoreThreshold;
    private final int numBatchesToRemember;
    private final Duration durationToRemember;
    private transient HashMap<Time, String[]> batchTimeToSelectedFiles;
    private transient HashSet<String> org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles;
    private transient TimeStampedHashMap<String, Object> fileToModTime;
    private transient long lastNewFileFindingTime;
    private transient Path _path;
    private transient FileSystem _fs;

    public static <K, V, F extends InputFormat<K, V>> Option<Configuration> $lessinit$greater$default$5() {
        return FileInputDStream$.MODULE$.$lessinit$greater$default$5();
    }

    public static <K, V, F extends InputFormat<K, V>> boolean $lessinit$greater$default$4() {
        return FileInputDStream$.MODULE$.$lessinit$greater$default$4();
    }

    public static <K, V, F extends InputFormat<K, V>> Function1<Path, Object> $lessinit$greater$default$3() {
        return FileInputDStream$.MODULE$.$lessinit$greater$default$3();
    }

    public static int calculateNumBatchesToRemember(Duration duration, Duration duration2) {
        return FileInputDStream$.MODULE$.calculateNumBatchesToRemember(duration, duration2);
    }

    public static boolean defaultFilter(Path path) {
        return FileInputDStream$.MODULE$.defaultFilter(path);
    }

    private Option<SerializableConfiguration> serializableConfOpt() {
        return this.serializableConfOpt;
    }

    private Duration minRememberDurationS() {
        return this.minRememberDurationS;
    }

    private Clock clock() {
        return this.ssc().scheduler().clock();
    }

    public FileInputDStreamCheckpointData checkpointData() {
        return this.checkpointData;
    }

    private long initialModTimeIgnoreThreshold() {
        return this.initialModTimeIgnoreThreshold;
    }

    private int numBatchesToRemember() {
        return this.numBatchesToRemember;
    }

    private Duration durationToRemember() {
        return this.durationToRemember;
    }

    public HashMap<Time, String[]> batchTimeToSelectedFiles() {
        return this.batchTimeToSelectedFiles;
    }

    public void batchTimeToSelectedFiles_$eq(HashMap<Time, String[]> x$1) {
        this.batchTimeToSelectedFiles = x$1;
    }

    public HashSet<String> org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles() {
        return this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles;
    }

    private void org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles_$eq(HashSet<String> x$1) {
        this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles = x$1;
    }

    private TimeStampedHashMap<String, Object> fileToModTime() {
        return this.fileToModTime;
    }

    private void fileToModTime_$eq(TimeStampedHashMap<String, Object> x$1) {
        this.fileToModTime = x$1;
    }

    private long lastNewFileFindingTime() {
        return this.lastNewFileFindingTime;
    }

    private void lastNewFileFindingTime_$eq(long x$1) {
        this.lastNewFileFindingTime = x$1;
    }

    private Path _path() {
        return this._path;
    }

    private void _path_$eq(Path x$1) {
        this._path = x$1;
    }

    private FileSystem _fs() {
        return this._fs;
    }

    private void _fs_$eq(FileSystem x$1) {
        this._fs = x$1;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Option<RDD<Tuple2<K, V>>> compute(Time validTime) {
        String[] newFiles = this.findNewFiles(validTime.milliseconds());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("New files at time ").append(validTime).append(":\n").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newFiles)).mkString("\n")).toString());
        HashMap<Time, String[]> hashMap = this.batchTimeToSelectedFiles();
        synchronized (hashMap) {
            this.batchTimeToSelectedFiles().$plus$eq(new Tuple2((Object)validTime, (Object)newFiles));
        }
        this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles().$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newFiles)));
        Some rdds = new Some(this.org$apache$spark$streaming$dstream$FileInputDStream$$filesToRDD((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])newFiles)));
        Map metadata = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"files"), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newFiles)).toList()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StreamInputInfo$.MODULE$.METADATA_KEY_DESCRIPTION()), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newFiles)).mkString("\n"))}));
        StreamInputInfo inputInfo = new StreamInputInfo(this.id(), 0L, (Map<String, Object>)metadata);
        this.ssc().scheduler().inputInfoTracker().reportInfo(validTime, inputInfo);
        return rdds;
    }

    @Override
    public void clearMetadata(Time time) {
        super.clearMetadata(time);
        HashMap<Time, String[]> hashMap = this.batchTimeToSelectedFiles();
        synchronized (hashMap) {
            HashMap oldFiles = (HashMap)this.batchTimeToSelectedFiles().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FileInputDStream.$anonfun$clearMetadata$1(this, time, x$2)));
            this.batchTimeToSelectedFiles().$minus$minus$eq((TraversableOnce)oldFiles.keys());
            this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles().$minus$minus$eq((TraversableOnce)oldFiles.values().flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Cleared ").append(oldFiles.size()).append(" old files that were older than ").append(time.$minus(this.rememberDuration())).append(": ").append(oldFiles.keys().mkString(", ")).toString());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Cleared files are:\n").append(((TraversableOnce)oldFiles.map((Function1 & Serializable & scala.Serializable)p -> new Tuple2(p._1(), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p._2())).mkString(", ")), HashMap$.MODULE$.canBuildFrom())).mkString("\n")).toString());
        }
        this.fileToModTime().clearOldValues(this.lastNewFileFindingTime() - 1L);
    }

    private String[] findNewFiles(long currentTime) {
        String[] stringArray;
        try {
            this.lastNewFileFindingTime_$eq(this.clock().getTimeMillis());
            long modTimeIgnoreThreshold = package$.MODULE$.max(this.initialModTimeIgnoreThreshold(), currentTime - this.durationToRemember().milliseconds());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Getting new files for time ").append(currentTime).append(", ").append(new StringBuilder(26).append("ignoring files older than ").append(modTimeIgnoreThreshold).toString()).toString());
            PathFilter newFileFilter = new PathFilter(this, currentTime, modTimeIgnoreThreshold){
                private final /* synthetic */ FileInputDStream $outer;
                private final long currentTime$1;
                private final long modTimeIgnoreThreshold$1;

                public boolean accept(Path path) {
                    return this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$isNewFile(path, this.currentTime$1, this.modTimeIgnoreThreshold$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.currentTime$1 = currentTime$1;
                    this.modTimeIgnoreThreshold$1 = modTimeIgnoreThreshold$1;
                }
            };
            PathFilter directoryFilter = new PathFilter(this){
                private final /* synthetic */ FileInputDStream $outer;

                public boolean accept(Path path) {
                    return this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$fs().getFileStatus(path).isDirectory();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            Path[] directories = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$dstream$FileInputDStream$$fs().globStatus(this.directoryPath(), directoryFilter))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)));
            String[] newFiles = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])directories)).flatMap((Function1 & Serializable & scala.Serializable)dir -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$dstream$FileInputDStream$$fs().listStatus(dir, newFileFilter))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            long timeTaken = this.clock().getTimeMillis() - this.lastNewFileFindingTime();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Finding new files took ").append(timeTaken).append(" ms").toString());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("# cached file times = ").append(this.fileToModTime().size()).toString());
            if (timeTaken > this.slideDuration().milliseconds()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Time taken to find new files exceeds the batch size. Consider increasing the batch size or reducing the number of files in the monitored directory.");
            }
            stringArray = newFiles;
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error finding new files", e);
            this.reset();
            stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        return stringArray;
    }

    public boolean org$apache$spark$streaming$dstream$FileInputDStream$$isNewFile(Path path, long currentTime, long modTimeIgnoreThreshold) {
        String pathStr = path.toString();
        if (!BoxesRunTime.unboxToBoolean((Object)this.filter.apply((Object)path))) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append(pathStr).append(" rejected by filter").toString());
            return false;
        }
        long modTime = this.getFileModTime(path);
        if (modTime <= modTimeIgnoreThreshold) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append(pathStr).append(" ignored as mod time ").append(modTime).append(" <= ignore time ").append(modTimeIgnoreThreshold).toString());
            return false;
        }
        if (modTime > currentTime) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append(pathStr).append(" not selected as mod time ").append(modTime).append(" > current time ").append(currentTime).toString());
            return false;
        }
        if (this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles().contains((Object)pathStr)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append(pathStr).append(" already considered").toString());
            return false;
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append(pathStr).append(" accepted with mod time ").append(modTime).toString());
        return true;
    }

    public RDD<Tuple2<K, V>> org$apache$spark$streaming$dstream$FileInputDStream$$filesToRDD(Seq<String> files) {
        Seq fileRDDs = (Seq)files.map((Function1 & Serializable & scala.Serializable)file -> {
            void var3_6;
            block4: {
                RDD rDD;
                Option option = this.serializableConfOpt().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.value());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Configuration config = (Configuration)some.value();
                    rDD = this.context().sparkContext().newAPIHadoopFile(file, $this.fm.runtimeClass(), $this.km.runtimeClass(), $this.vm.runtimeClass(), config);
                } else if (None$.MODULE$.equals(option)) {
                    rDD = this.context().sparkContext().newAPIHadoopFile(file, $this.km, $this.vm, $this.fm);
                } else {
                    throw new MatchError((Object)option);
                }
                RDD rdd = rDD;
                if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.partitions())).isEmpty()) break block4;
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(190).append("File ").append((String)file).append(" has no data in it. Spark Streaming can only ingest ").append("files that have been \"moved\" to the directory assigned to the file stream. ").append("Refer to the streaming programming guide for more details.").toString());
            }
            return var3_6;
        }, Seq$.MODULE$.canBuildFrom());
        return new UnionRDD(this.context().sparkContext(), fileRDDs, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private long getFileModTime(Path path) {
        return BoxesRunTime.unboxToLong((Object)this.fileToModTime().getOrElseUpdate((Object)path.toString(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.org$apache$spark$streaming$dstream$FileInputDStream$$fs().getFileStatus(path).getModificationTime()));
    }

    private Path directoryPath() {
        block0: {
            if (this._path() != null) break block0;
            this._path_$eq(new Path(this.directory));
        }
        return this._path();
    }

    public FileSystem org$apache$spark$streaming$dstream$FileInputDStream$$fs() {
        block0: {
            if (this._fs() != null) break block0;
            this._fs_$eq(this.directoryPath().getFileSystem(this.ssc().sparkContext().hadoopConfiguration()));
        }
        return this._fs();
    }

    private void reset() {
        this._fs_$eq(null);
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append(this.getClass().getSimpleName()).append(".readObject used").toString());
            ois.defaultReadObject();
            this.generatedRDDs_$eq(new HashMap());
            this.batchTimeToSelectedFiles_$eq((HashMap<Time, String[]>)new HashMap());
            this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles_$eq((HashSet<String>)new HashSet());
            this.fileToModTime_$eq((TimeStampedHashMap<String, Object>)new TimeStampedHashMap(true));
        });
    }

    public static final /* synthetic */ boolean $anonfun$clearMetadata$1(FileInputDStream $this, Time time$1, Tuple2 x$2) {
        return ((Time)x$2._1()).$less(time$1.$minus($this.rememberDuration()));
    }

    public FileInputDStream(StreamingContext _ssc, String directory, Function1<Path, Object> filter, boolean newFilesOnly, Option<Configuration> conf, ClassTag<K> km, ClassTag<V> vm, ClassTag<F> fm) {
        this.directory = directory;
        this.filter = filter;
        this.km = km;
        this.vm = vm;
        this.fm = fm;
        super(_ssc, ClassTag$.MODULE$.apply(Tuple2.class));
        this.serializableConfOpt = conf.map((Function1 & Serializable & scala.Serializable)x$1 -> new SerializableConfiguration(x$1));
        this.minRememberDurationS = Seconds$.MODULE$.apply(this.ssc().conf().getTimeAsSeconds("spark.streaming.fileStream.minRememberDuration", this.ssc().conf().get("spark.streaming.minRememberDuration", "60s")));
        this.checkpointData = new FileInputDStreamCheckpointData();
        this.initialModTimeIgnoreThreshold = newFilesOnly ? this.clock().getTimeMillis() : 0L;
        this.numBatchesToRemember = FileInputDStream$.MODULE$.calculateNumBatchesToRemember(this.slideDuration(), this.minRememberDurationS());
        this.durationToRemember = this.slideDuration().$times(this.numBatchesToRemember());
        this.remember(this.durationToRemember());
        this.batchTimeToSelectedFiles = new HashMap();
        this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles = new HashSet();
        this.fileToModTime = new TimeStampedHashMap(true);
        this.lastNewFileFindingTime = 0L;
        this._path = null;
        this._fs = null;
    }

    public class FileInputDStreamCheckpointData
    extends DStreamCheckpointData<Tuple2<K, V>> {
        private HashMap<Time, String[]> hadoopFiles() {
            return this.data();
        }

        @Override
        public void update(Time time) {
            this.hadoopFiles().clear();
            HashMap<Time, String[]> hashMap = this.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().batchTimeToSelectedFiles();
            synchronized (hashMap) {
                HashMap cfr_ignored_0 = (HashMap)this.hadoopFiles().$plus$plus$eq(this.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().batchTimeToSelectedFiles());
            }
        }

        @Override
        public void cleanup(Time time) {
        }

        @Override
        public void restore() {
            ((IterableLike)this.hadoopFiles().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$6 -> (Time)x$6._1(), Time$.MODULE$.ordering())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String[] f;
                Time t;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    t = (Time)tuple2._1();
                    f = (String[])tuple2._2();
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Restoring files for time ").append(t).append(" - ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f)).mkString("[", ", ", "]")).toString());
                    HashMap<Time, String[]> hashMap = this.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().batchTimeToSelectedFiles();
                    synchronized (hashMap) {
                        this.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().batchTimeToSelectedFiles().$plus$eq(new Tuple2((Object)t, (Object)f));
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                this.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles().$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f)));
                HashMap hashMap = this.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().generatedRDDs().$plus$eq(new Tuple2((Object)t, this.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().org$apache$spark$streaming$dstream$FileInputDStream$$filesToRDD((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])f))));
                return hashMap;
            });
        }

        @Override
        public String toString() {
            return new StringBuilder(15).append("[\n").append(this.hadoopFiles().size()).append(" file sets\n").append(((TraversableOnce)this.hadoopFiles().map((Function1 & Serializable & scala.Serializable)p -> new Tuple2(p._1(), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p._2())).mkString(", ")), HashMap$.MODULE$.canBuildFrom())).mkString("\n")).append("\n]").toString();
        }

        public /* synthetic */ FileInputDStream org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer() {
            return FileInputDStream.this;
        }

        public FileInputDStreamCheckpointData() {
            if (FileInputDStream.this == null) {
                throw null;
            }
            super(FileInputDStream.this, ClassTag$.MODULE$.apply(Tuple2.class));
        }
    }
}

