/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.continuous;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousTrigger;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;

public final class ContinuousTrigger$
implements Serializable {
    public static final ContinuousTrigger$ MODULE$;

    static {
        new ContinuousTrigger$();
    }

    public ContinuousTrigger apply(String interval) {
        CalendarInterval cal;
        if (StringUtils.isBlank((CharSequence)interval)) {
            throw new IllegalArgumentException("interval cannot be null or blank.");
        }
        CalendarInterval calendarInterval = cal = interval.startsWith("interval") ? CalendarInterval.fromString((String)interval) : CalendarInterval.fromString((String)new StringBuilder().append((Object)"interval ").append((Object)interval).toString());
        if (cal == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid interval: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{interval})));
        }
        if (cal.months > 0) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Doesn't support month or year interval: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{interval})));
        }
        return new ContinuousTrigger(cal.microseconds / 1000L);
    }

    public ContinuousTrigger apply(Duration interval) {
        return new ContinuousTrigger(interval.toMillis());
    }

    public ContinuousTrigger create(String interval) {
        return this.apply(interval);
    }

    public ContinuousTrigger create(long interval, TimeUnit unit) {
        return new ContinuousTrigger(unit.toMillis(interval));
    }

    public ContinuousTrigger apply(long intervalMs) {
        return new ContinuousTrigger(intervalMs);
    }

    public Option<Object> unapply(ContinuousTrigger x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)x$0.intervalMs()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ContinuousTrigger$() {
        MODULE$ = this;
    }
}

