/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.FileContextBasedCheckpointFileManager;
import org.apache.spark.sql.execution.streaming.FileSystemBasedCheckpointFileManager;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class CheckpointFileManager$
implements Logging {
    public static final CheckpointFileManager$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CheckpointFileManager$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CheckpointFileManager create(Path path, Configuration hadoopConf) {
        Logging logging;
        String fileManagerClass = hadoopConf.get(SQLConf$.MODULE$.STREAMING_CHECKPOINT_FILE_MANAGER_CLASS().parent().key());
        if (fileManagerClass != null) return (CheckpointFileManager)Utils$.MODULE$.classForName(fileManagerClass).getConstructor(Path.class, Configuration.class).newInstance(path, hadoopConf);
        try {
            logging = new FileContextBasedCheckpointFileManager(path, hadoopConf);
            return logging;
        }
        catch (UnsupportedFileSystemException unsupportedFileSystemException) {
            this.logWarning((Function0<String>)new Serializable(path){
                public static final long serialVersionUID = 0L;
                private final Path path$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Could not use FileContext API for managing Structured Streaming checkpoint files at ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Using FileSystem API instead for managing log files. If the implementation "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"of FileSystem.rename() is not atomic, then the correctness and fault-tolerance of"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"your Structured Streaming is not guaranteed."})).s((Seq)Nil$.MODULE$)).toString();
                }
                {
                    this.path$1 = path$1;
                }
            });
            logging = new FileSystemBasedCheckpointFileManager(path, hadoopConf);
        }
        return logging;
    }

    public Path org$apache$spark$sql$execution$streaming$CheckpointFileManager$$generateTempPath(Path path) {
        TaskContext tc = TaskContext$.MODULE$.get();
        String tid = tc == null ? "" : new StringBuilder().append((Object)".TID").append((Object)BoxesRunTime.boxToLong((long)tc.taskAttemptId())).toString();
        return new Path(path.getParent(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", ".", "", ".tmp"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path.getName(), UUID.randomUUID(), tid})));
    }

    private CheckpointFileManager$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

