/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.Locale;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.ToNumber$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ToNumberParser;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n     _FUNC_(expr, fmt) - Convert string 'expr' to a number based on the string format 'fmt'.\n       Throws an exception if the conversion fails. The format can consist of the following\n       characters, case insensitive:\n         '0' or '9': Specifies an expected digit between 0 and 9. A sequence of 0 or 9 in the format\n           string matches a sequence of digits in the input string. If the 0/9 sequence starts with\n           0 and is before the decimal point, it can only match a digit sequence of the same size.\n           Otherwise, if the sequence starts with 9 or is after the decimal poin, it can match a\n           digit sequence that has the same or smaller size.\n         '.' or 'D': Specifies the position of the decimal point (optional, only allowed once).\n         ',' or 'G': Specifies the position of the grouping (thousands) separator (,). There must be\n           one or more 0 or 9 to the left of the rightmost grouping separator. 'expr' must match the\n           grouping separator relevant for the size of the number.\n         '$': Specifies the location of the $ currency sign. This character may only be specified\n           once.\n         'S' or 'MI': Specifies the position of a '-' or '+' sign (optional, only allowed once at\n           the beginning or end of the format string). Note that 'S' allows '-' but 'MI' does not.\n         'PR': Only allowed at the end of the format string; specifies that 'expr' indicates a\n           negative number with wrapping angled brackets.\n           ('<1>').\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('454', '999');\n       454\n      > SELECT _FUNC_('454.00', '000.00');\n       454.00\n      > SELECT _FUNC_('12,454', '99,999');\n       12454\n      > SELECT _FUNC_('$78.12', '$99.99');\n       78.12\n      > SELECT _FUNC_('12,454.8-', '99,999.9S');\n       -12454.8\n  ", since="3.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001B\u0010!\u00016B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\"A1\n\u0001BK\u0002\u0013\u0005a\t\u0003\u0005M\u0001\tE\t\u0015!\u0003H\u0011\u0015i\u0005\u0001\"\u0001O\u0011!\u0011\u0006\u0001#b\u0001\n\u0013\u0019\u0006\u0002\u0003/\u0001\u0011\u000b\u0007I\u0011B/\t\u000b\u0011\u0004A\u0011I3\t\u000b1\u0004A\u0011I7\t\u000be\u0004A\u0011\t>\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!9\u0011Q\u0003\u0001\u0005B\u0005]\u0001bBA\u0014\u0001\u0011\u0005\u0013\u0011\u0006\u0005\b\u0003\u000b\u0002A\u0011KA$\u0011%\t\t\u0006AA\u0001\n\u0003\t\u0019\u0006C\u0005\u0002Z\u0001\t\n\u0011\"\u0001\u0002\\!I\u0011\u0011\u000f\u0001\u0012\u0002\u0013\u0005\u00111\f\u0005\t\u0003g\u0002\u0011\u0011!C!'\"I\u0011Q\u000f\u0001\u0002\u0002\u0013\u0005\u0011q\u000f\u0005\n\u0003\u007f\u0002\u0011\u0011!C\u0001\u0003\u0003C\u0011\"a\"\u0001\u0003\u0003%\t%!#\t\u0013\u0005]\u0005!!A\u0005\u0002\u0005e\u0005\"CAR\u0001\u0005\u0005I\u0011IAS\u000f%\tI\rIA\u0001\u0012\u0003\tYM\u0002\u0005 A\u0005\u0005\t\u0012AAg\u0011\u0019i\u0015\u0004\"\u0001\u0002\\\"I\u0011Q\\\r\u0002\u0002\u0013\u0015\u0013q\u001c\u0005\n\u0003CL\u0012\u0011!CA\u0003GD\u0011\"!;\u001a\u0003\u0003%\t)a;\t\u0013\u0005u\u0018$!A\u0005\n\u0005}(\u0001\u0003+p\u001dVl'-\u001a:\u000b\u0005\u0005\u0012\u0013aC3yaJ,7o]5p]NT!a\t\u0013\u0002\u0011\r\fG/\u00197zgRT!!\n\u0014\u0002\u0007M\fHN\u0003\u0002(Q\u0005)1\u000f]1sW*\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\u00183kq\u0012\u0005CA\u00181\u001b\u0005\u0001\u0013BA\u0019!\u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00020g%\u0011A\u0007\t\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011a'\u000f\b\u0003_]J!\u0001\u000f\u0011\u0002\u000fA\f7m[1hK&\u0011!h\u000f\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\tA\u0004\u0005\u0005\u0002>\u00016\taHC\u0001@\u0003\u0015\u00198-\u00197b\u0013\t\teHA\u0004Qe>$Wo\u0019;\u0011\u0005u\u001a\u0015B\u0001#?\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003\u001d\u0003\"a\f%\n\u0005%\u0003#AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na\u0001P5oSRtDcA(Q#B\u0011q\u0006\u0001\u0005\u0006\u000b\u0016\u0001\ra\u0012\u0005\u0006\u0017\u0016\u0001\raR\u0001\r]Vl'-\u001a:G_Jl\u0017\r^\u000b\u0002)B\u0011QKW\u0007\u0002-*\u0011q\u000bW\u0001\u0005Y\u0006twMC\u0001Z\u0003\u0011Q\u0017M^1\n\u0005m3&AB*ue&tw-A\bok6\u0014WM\u001d$pe6\fG\u000f^3s+\u0005q\u0006CA0c\u001b\u0005\u0001'BA1#\u0003\u0011)H/\u001b7\n\u0005\r\u0004'A\u0004+p\u001dVl'-\u001a:QCJ\u001cXM]\u0001\tI\u0006$\u0018\rV=qKV\ta\r\u0005\u0002hU6\t\u0001N\u0003\u0002jI\u0005)A/\u001f9fg&\u00111\u000e\u001b\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u00039\u00042a\u001c<g\u001d\t\u0001XO\u0004\u0002ri6\t!O\u0003\u0002tY\u00051AH]8pizJ\u0011aP\u0005\u0003qyJ!a\u001e=\u0003\u0007M+\u0017O\u0003\u00029}\u0005\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\t1\u0010\u0005\u0002}\u007f6\tQP\u0003\u0002\u007fE\u0005A\u0011M\\1msNL7/C\u0002\u0002\u0002u\u0014q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\u000baJ,G\u000f^=OC6,WCAA\u0004!\u0011\tI!!\u0005\u000f\t\u0005-\u0011Q\u0002\t\u0003czJ1!a\u0004?\u0003\u0019\u0001&/\u001a3fM&\u00191,a\u0005\u000b\u0007\u0005=a(\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0004\u0002\u001a\u0005}\u00111\u0005\t\u0004{\u0005m\u0011bAA\u000f}\t\u0019\u0011I\\=\t\u000f\u0005\u0005B\u00021\u0001\u0002\u001a\u000511\u000f\u001e:j]\u001eDq!!\n\r\u0001\u0004\tI\"\u0001\u0004g_Jl\u0017\r^\u0001\nI><UM\\\"pI\u0016$b!a\u000b\u00028\u0005\u0005\u0003\u0003BA\u0017\u0003gi!!a\f\u000b\u0007\u0005E\u0002%A\u0004d_\u0012,w-\u001a8\n\t\u0005U\u0012q\u0006\u0002\t\u000bb\u0004(oQ8eK\"9\u0011\u0011H\u0007A\u0002\u0005m\u0012aA2uqB!\u0011QFA\u001f\u0013\u0011\ty$a\f\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u00111I\u0007A\u0002\u0005-\u0012AA3w\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003P\u0003\u0013\ni\u0005\u0003\u0004\u0002L9\u0001\raR\u0001\b]\u0016<H*\u001a4u\u0011\u0019\tyE\u0004a\u0001\u000f\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLH#B(\u0002V\u0005]\u0003bB#\u0010!\u0003\u0005\ra\u0012\u0005\b\u0017>\u0001\n\u00111\u0001H\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0018+\u0007\u001d\u000byf\u000b\u0002\u0002bA!\u00111MA7\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014!C;oG\",7m[3e\u0015\r\tYGP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA8\u0003K\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\u0018\u0001\u00049s_\u0012,8\r^!sSRLXCAA=!\ri\u00141P\u0005\u0004\u0003{r$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\r\u0003\u0007C\u0011\"!\"\u0015\u0003\u0003\u0005\r!!\u001f\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\t\u0005\u0004\u0002\u000e\u0006M\u0015\u0011D\u0007\u0003\u0003\u001fS1!!%?\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003+\u000byI\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAN\u0003C\u00032!PAO\u0013\r\tyJ\u0010\u0002\b\u0005>|G.Z1o\u0011%\t)IFA\u0001\u0002\u0004\tI\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u00037\u000b9\u000bC\u0005\u0002\u0006^\t\t\u00111\u0001\u0002\u001a!\u001a\u0002!a+\u00022\u0006M\u0016qWA]\u0003{\u000by,a1\u0002FB\u0019q&!,\n\u0007\u0005=\u0006EA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005U\u0016ac?\u000bA\u0001\u0002\u0003\u0005I0G+:\u001bu\fK3yaJd\u0003EZ7uS\u0001j\u0003eQ8om\u0016\u0014H\u000fI:ue&tw\rI\u0014fqB\u0014x\u0005\t;pA\u0005\u0004c.^7cKJ\u0004#-Y:fI\u0002zg\u000e\t;iK\u0002\u001aHO]5oO\u00022wN]7bi\u0002:c-\u001c;(])\u0001\u0003\u0005\t\u0011!A\u0001\"\u0006N]8xg\u0002\ng\u000eI3yG\u0016\u0004H/[8oA%4\u0007\u0005\u001e5fA\r|gN^3sg&|g\u000e\t4bS2\u001ch\u0006\t+iK\u00022wN]7bi\u0002\u001a\u0017M\u001c\u0011d_:\u001c\u0018n\u001d;!_\u001a\u0004C\u000f[3!M>dGn\\<j]\u001eT\u0001\u0005\t\u0011!A\u0001\u00023\r[1sC\u000e$XM]:-A\r\f7/\u001a\u0011j]N,gn]5uSZ,'H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!OA:\u0003e\u001c:!Oe:#\bI*qK\u000eLg-[3tA\u0005t\u0007%\u001a=qK\u000e$X\r\u001a\u0011eS\u001eLG\u000f\t2fi^,WM\u001c\u00111A\u0005tG\rI\u001d/A\u0005\u00033/Z9vK:\u001cW\rI8gAA\u0002sN\u001d\u0011:A%t\u0007\u0005\u001e5fA\u0019|'/\\1u\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I:ue&tw\rI7bi\u000eDWm\u001d\u0011bAM,\u0017/^3oG\u0016\u0004sN\u001a\u0011eS\u001eLGo\u001d\u0011j]\u0002\"\b.\u001a\u0011j]B,H\u000fI:ue&twM\f\u0011JM\u0002\"\b.\u001a\u00111_e\u00023/Z9vK:\u001cW\rI:uCJ$8\u000fI<ji\"T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!a\u0001\ng\u000e\u001a\u0011jg\u0002\u0012WMZ8sK\u0002\"\b.\u001a\u0011eK\u000eLW.\u00197!a>Lg\u000e\u001e\u0017!SR\u00043-\u00198!_:d\u0017\u0010I7bi\u000eD\u0007%\u0019\u0011eS\u001eLG\u000fI:fcV,gnY3!_\u001a\u0004C\u000f[3!g\u0006lW\rI:ju\u0016t#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A=#\b.\u001a:xSN,G\u0006I5gAQDW\rI:fcV,gnY3!gR\f'\u000f^:!o&$\b\u000eI\u001d!_J\u0004\u0013n\u001d\u0011bMR,'\u000f\t;iK\u0002\"WmY5nC2\u0004\u0003o\\5oY\u0001JG\u000fI2b]\u0002j\u0017\r^2iA\u0005T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!I&<\u0017\u000e\u001e\u0011tKF,XM\\2fAQD\u0017\r\u001e\u0011iCN\u0004C\u000f[3!g\u0006lW\rI8sAMl\u0017\r\u001c7fe\u0002\u001a\u0018N_3/\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002sEL\u0014!_J\u0004s\u0005R\u0014;AM\u0003XmY5gS\u0016\u001c\b\u0005\u001e5fAA|7/\u001b;j_:\u0004sN\u001a\u0011uQ\u0016\u0004C-Z2j[\u0006d\u0007\u0005]8j]R\u0004\u0003f\u001c9uS>t\u0017\r\u001c\u0017!_:d\u0017\u0010I1mY><X\r\u001a\u0011p]\u000e,\u0017F\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u001dbs\u0005I8sA\u001d:uE\u000f\u0011Ta\u0016\u001c\u0017NZ5fg\u0002\"\b.\u001a\u0011q_NLG/[8oA=4\u0007\u0005\u001e5fA\u001d\u0014x.\u001e9j]\u001e\u0004\u0003\u0006\u001e5pkN\fg\u000eZ:*AM,\u0007/\u0019:bi>\u0014\b\u0005\u000b\u0017*]\u0001\"\u0006.\u001a:fA5,8\u000f\u001e\u0011cK*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011p]\u0016\u0004sN\u001d\u0011n_J,\u0007\u0005\r\u0011pe\u0002J\u0004\u0005^8!i\",\u0007\u0005\\3gi\u0002zg\r\t;iK\u0002\u0012\u0018n\u001a5u[>\u001cH\u000fI4s_V\u0004\u0018N\\4!g\u0016\u0004\u0018M]1u_Jt\u0003eJ3yaJ<\u0003%\\;ti\u0002j\u0017\r^2iAQDWM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001:'o\\;qS:<\u0007e]3qCJ\fGo\u001c:!e\u0016dWM^1oi\u00022wN\u001d\u0011uQ\u0016\u00043/\u001b>fA=4\u0007\u0005\u001e5fA9,XNY3s])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003e\n\u0013(u\u0001\u001a\u0006/Z2jM&,7\u000f\t;iK\u0002bwnY1uS>t\u0007e\u001c4!i\",\u0007\u0005\n\u0011dkJ\u0014XM\\2zAMLwM\u001c\u0018!)\"L7\u000fI2iCJ\f7\r^3sA5\f\u0017\u0010I8oYf\u0004#-\u001a\u0011ta\u0016\u001c\u0017NZ5fI*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011p]\u000e,gF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!OM;\u0003e\u001c:!O5KuE\u000f\u0011Ta\u0016\u001c\u0017NZ5fg\u0002\"\b.\u001a\u0011q_NLG/[8oA=4\u0007%\u0019\u0011([\u001d\u0002sN\u001d\u0011(W\u001d\u00023/[4oA!z\u0007\u000f^5p]\u0006dG\u0006I8oYf\u0004\u0013\r\u001c7po\u0016$\u0007e\u001c8dK\u0002\nGO\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"\b.\u001a\u0011cK\u001eLgN\\5oO\u0002z'\u000fI3oI\u0002zg\r\t;iK\u00022wN]7bi\u0002\u001aHO]5oO&r\u0003ET8uK\u0002\"\b.\u0019;!OM;\u0003%\u00197m_^\u001c\beJ\u0017(A\t,H\u000fI\u0014N\u0013\u001e\u0002Cm\\3tA9|GO\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u001d\u0002&k\n\u001e!\u001f:d\u0017\u0010I1mY><X\r\u001a\u0011bi\u0002\"\b.\u001a\u0011f]\u0012\u0004sN\u001a\u0011uQ\u0016\u0004cm\u001c:nCR\u00043\u000f\u001e:j]\u001e\\\u0004e\u001d9fG&4\u0017.Z:!i\"\fG\u000fI\u0014fqB\u0014x\u0005I5oI&\u001c\u0017\r^3tA\u0005T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!]\u0016<\u0017\r^5wK\u0002rW/\u001c2fe\u0002:\u0018\u000e\u001e5!oJ\f\u0007\u000f]5oO\u0002\ngn\u001a7fI\u0002\u0012'/Y2lKR\u001chF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001Bs\u0005P\u0019?O%r#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a/\u0002\u0005/R\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001b6i\u001db\u0003eJ\u001d:s\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001b6i)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005N\u001b5]A\u0002t\u0005\f\u0011(aA\u0002d\u0006\r\u0019(SmR\u0001\u0005\t\u0011!A\u0001\u0002C'\u000e\u001b/aAR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ\u00193YQ*Dg\n\u0017!OeJD&O\u001d:O%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u001a5kQR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u00138q9\n$g\n\u0017!O\u0011J\u0014HL\u001d:O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u000e\u001d/cIR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ\u00193YQ*DG\f\u001d.O1\u0002s%O\u001d-seJd&O*(SmR\u0001\u0005\t\u0011!A\u0001\u0002S&\r\u001a5kQr\u0003H\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t\t-A\u00034]Mr\u0003'A\u0003he>,\b/\t\u0002\u0002H\u0006a1\u000f\u001e:j]\u001e|f-\u001e8dg\u0006AAk\u001c(v[\n,'\u000f\u0005\u000203M!\u0011$a4C!\u001d\t\t.a6H\u000f>k!!a5\u000b\u0007\u0005Ug(A\u0004sk:$\u0018.\\3\n\t\u0005e\u00171\u001b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAAf\u0003!!xn\u0015;sS:<G#\u0001+\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b=\u000b)/a:\t\u000b\u0015c\u0002\u0019A$\t\u000b-c\u0002\u0019A$\u0002\u000fUt\u0017\r\u001d9msR!\u0011Q^A}!\u0015i\u0014q^Az\u0013\r\t\tP\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bu\n)pR$\n\u0007\u0005]hH\u0001\u0004UkBdWM\r\u0005\t\u0003wl\u0012\u0011!a\u0001\u001f\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u0003\u00012!\u0016B\u0002\u0013\r\u0011)A\u0016\u0002\u0007\u001f\nTWm\u0019;")
public class ToNumber
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private String numberFormat;
    private ToNumberParser numberFormatter;
    private final Expression left;
    private final Expression right;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ToNumber toNumber) {
        return ToNumber$.MODULE$.unapply(toNumber);
    }

    public static Function1<Tuple2<Expression, Expression>, ToNumber> tupled() {
        return ToNumber$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ToNumber>> curried() {
        return ToNumber$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private String numberFormat$lzycompute() {
        ToNumber toNumber = this;
        synchronized (toNumber) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.numberFormat = this.right().eval(this.right().eval$default$1()).toString().toUpperCase(Locale.ROOT);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.numberFormat;
    }

    private String numberFormat() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.numberFormat$lzycompute() : this.numberFormat;
    }

    private ToNumberParser numberFormatter$lzycompute() {
        ToNumber toNumber = this;
        synchronized (toNumber) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.numberFormatter = new ToNumberParser(this.numberFormat(), true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.numberFormatter;
    }

    private ToNumberParser numberFormatter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.numberFormatter$lzycompute() : this.numberFormatter;
    }

    @Override
    public DataType dataType() {
        return this.numberFormatter().parsedDecimalType();
    }

    public Seq<DataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        void var1_1;
        TypeCheckResult inputTypeCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return inputTypeCheck.isSuccess() ? (this.right().foldable() ? this.numberFormatter().check() : new TypeCheckResult.TypeCheckFailure(new StringBuilder(44).append("Format expression must be foldable, but got ").append(this.right()).toString())) : var1_1;
    }

    @Override
    public String prettyName() {
        return "to_number";
    }

    @Override
    public Object nullSafeEval(Object string, Object format) {
        UTF8String input = (UTF8String)string;
        return this.numberFormatter().parse(input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String builder = ctx.addReferenceObj("builder", this.numberFormatter(), ToNumberParser.class.getName());
        ExprCode eval = this.left().genCode(ctx);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |", "\n        |boolean ", " = ", ";\n        |", " ", " = ", ";\n        |if (!", ") {\n        |  ", " = ", ".parse(", ");\n        |}\n      "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), ev.isNull(), eval.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), builder, eval.value()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public ToNumber withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ToNumber copy(Expression left, Expression right) {
        return new ToNumber(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ToNumber";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToNumber;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToNumber)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToNumber toNumber = (ToNumber)x$1;
        Expression expression = this.left();
        Expression expression2 = toNumber.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = toNumber.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!toNumber.canEqual(this)) return false;
        return true;
    }

    public ToNumber(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

