/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Encode;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.ToBinary$;
import org.apache.spark.sql.catalyst.expressions.UnBase64;
import org.apache.spark.sql.catalyst.expressions.Unhex;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str[, fmt]) - Converts the input `str` to a binary value based on the supplied `fmt`.\n      `fmt` can be a case-insensitive string literal of \"hex\", \"utf-8\", or \"base64\".\n      By default, the binary format for conversion is \"hex\" if `fmt` is omitted.\n      The function returns NULL if at least one of the input parameters is NULL.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('abc', 'utf-8');\n       abc\n  ", since="3.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001\u0002\u0012$\u0001BB\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\r\u0002\u0011\t\u0012)A\u0005c!Aq\t\u0001BK\u0002\u0013\u0005\u0001\n\u0003\u0005M\u0001\tE\t\u0015!\u0003J\u0011!i\u0005A!f\u0001\n\u0003q\u0005\u0002\u0003*\u0001\u0005#\u0005\u000b\u0011B(\t\u000bM\u0003A\u0011\u0001+\t\u0011e\u0003\u0001R1A\u0005B\u0015CQa\u0015\u0001\u0005\u0002iCQa\u0015\u0001\u0005\u0002qCQa\u0018\u0001\u0005B\u0001DQ\u0001\u001c\u0001\u0005B5DQa\u001e\u0001\u0005BaDq!!\u0001\u0001\t#\n\u0019\u0001C\u0005\u0002\u0010\u0001\t\t\u0011\"\u0001\u0002\u0012!I\u0011\u0011\u0004\u0001\u0012\u0002\u0013\u0005\u00111\u0004\u0005\n\u0003c\u0001\u0011\u0013!C\u0001\u0003gA\u0011\"a\u000e\u0001#\u0003%\t!!\u000f\t\u0013\u0005u\u0002!!A\u0005B\u0005}\u0002\"CA(\u0001\u0005\u0005I\u0011AA)\u0011%\tI\u0006AA\u0001\n\u0003\tY\u0006C\u0005\u0002h\u0001\t\t\u0011\"\u0011\u0002j!I\u0011q\u000f\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0010\u0005\n\u0003{\u0002\u0011\u0011!C!\u0003\u007f:\u0011\"a)$\u0003\u0003E\t!!*\u0007\u0011\t\u001a\u0013\u0011!E\u0001\u0003OCaa\u0015\u000e\u0005\u0002\u0005U\u0006\"CA\\5\u0005\u0005IQIA]\u0011%\tYLGA\u0001\n\u0003\u000bi\fC\u0005\u0002Fj\t\n\u0011\"\u0001\u0002:!I\u0011q\u0019\u000e\u0002\u0002\u0013\u0005\u0015\u0011\u001a\u0005\n\u0003/T\u0012\u0013!C\u0001\u0003sA\u0011\"!7\u001b\u0003\u0003%I!a7\u0003\u0011Q{')\u001b8befT!\u0001J\u0013\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003M\u001d\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003Q%\n1a]9m\u0015\tQ3&A\u0003ta\u0006\u00148N\u0003\u0002-[\u00051\u0011\r]1dQ\u0016T\u0011AL\u0001\u0004_J<7\u0001A\n\u0007\u0001E*\u0004hO!\u0011\u0005I\u001aT\"A\u0012\n\u0005Q\u001a#AC#yaJ,7o]5p]B\u0011!GN\u0005\u0003o\r\u0012!CU;oi&lWMU3qY\u0006\u001cW-\u00192mKB\u0011!'O\u0005\u0003u\r\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\b!J|G-^2u!\ta$)\u0003\u0002D{\ta1+\u001a:jC2L'0\u00192mK\u0006!Q\r\u001f9s+\u0005\t\u0014!B3yaJ\u0004\u0013A\u00024pe6\fG/F\u0001J!\ra$*M\u0005\u0003\u0017v\u0012aa\u00149uS>t\u0017a\u00024pe6\fG\u000fI\u0001\u0014]VdGn\u00148J]Z\fG.\u001b3G_Jl\u0017\r^\u000b\u0002\u001fB\u0011A\bU\u0005\u0003#v\u0012qAQ8pY\u0016\fg.\u0001\u000bok2dwJ\\%om\u0006d\u0017\u000e\u001a$pe6\fG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tU3v\u000b\u0017\t\u0003e\u0001AQ\u0001R\u0004A\u0002EBQaR\u0004A\u0002%Cq!T\u0004\u0011\u0002\u0003\u0007q*A\u0006sKBd\u0017mY3nK:$HCA+\\\u0011\u0015!\u0015\u00021\u00012)\r)VL\u0018\u0005\u0006\t*\u0001\r!\r\u0005\u0006\u000f*\u0001\r!M\u0001\u000baJ,G\u000f^=OC6,W#A1\u0011\u0005\tLgBA2h!\t!W(D\u0001f\u0015\t1w&\u0001\u0004=e>|GOP\u0005\u0003Qv\na\u0001\u0015:fI\u00164\u0017B\u00016l\u0005\u0019\u0019FO]5oO*\u0011\u0001.P\u0001\tG\"LG\u000e\u001a:f]V\ta\u000eE\u0002piFr!\u0001\u001d:\u000f\u0005\u0011\f\u0018\"\u0001 \n\u0005Ml\u0014a\u00029bG.\fw-Z\u0005\u0003kZ\u00141aU3r\u0015\t\u0019X(\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u001f\t\u0004_RT\bCA>\u007f\u001b\u0005a(BA?(\u0003\u0015!\u0018\u0010]3t\u0013\tyHP\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004c\u0005\u0015\u0001bBA\u0004\u001d\u0001\u0007\u0011\u0011B\u0001\f]\u0016<8\t[5mIJ,g\u000e\u0005\u0003p\u0003\u0017\t\u0014bAA\u0007m\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002\t\r|\u0007/\u001f\u000b\b+\u0006M\u0011QCA\f\u0011\u001d!u\u0002%AA\u0002EBqaR\b\u0011\u0002\u0003\u0007\u0011\nC\u0004N\u001fA\u0005\t\u0019A(\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0004\u0016\u0004c\u0005}1FAA\u0011!\u0011\t\u0019#!\f\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-R(\u0001\u0006b]:|G/\u0019;j_:LA!a\f\u0002&\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0007\u0016\u0004\u0013\u0006}\u0011AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003wQ3aTA\u0010\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\t\t\u0005\u0003\u0007\ni%\u0004\u0002\u0002F)!\u0011qIA%\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0013\u0001\u00026bm\u0006L1A[A#\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\u0019\u0006E\u0002=\u0003+J1!a\u0016>\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ti&a\u0019\u0011\u0007q\ny&C\u0002\u0002bu\u00121!\u00118z\u0011%\t)'FA\u0001\u0002\u0004\t\u0019&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003W\u0002b!!\u001c\u0002t\u0005uSBAA8\u0015\r\t\t(P\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA;\u0003_\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019q*a\u001f\t\u0013\u0005\u0015t#!AA\u0002\u0005u\u0013AB3rk\u0006d7\u000fF\u0002P\u0003\u0003C\u0011\"!\u001a\u0019\u0003\u0003\u0005\r!!\u0018)'\u0001\t))a#\u0002\u000e\u0006E\u00151SAL\u00033\u000bi*a(\u0011\u0007I\n9)C\u0002\u0002\n\u000e\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0010\u0006\u00119L\u0003\u0011!A\u0001zf)\u0016(D?\"\u001aHO].-A\u0019lG/X\u0015![\u0001\u001auN\u001c<feR\u001c\b\u0005\u001e5fA%t\u0007/\u001e;!AN$(\u000f\u0019\u0011u_\u0002\n\u0007EY5oCJL\bE^1mk\u0016\u0004#-Y:fI\u0002zg\u000e\t;iK\u0002\u001aX\u000f\u001d9mS\u0016$\u0007\u0005\u00194ni\u0002t#\u0002\t\u0011!A\u0001\u0002\u0003MZ7uA\u0002\u001a\u0017M\u001c\u0011cK\u0002\n\u0007eY1tK6Jgn]3og&$\u0018N^3!gR\u0014\u0018N\\4!Y&$XM]1mA=4\u0007E\t5fq\nb\u0003EI;uM6B$\u0005\f\u0011pe\u0002\u0012#-Y:fmQ\u0012cF\u0003\u0011!A\u0001\u0002\u0003EQ=!I\u00164\u0017-\u001e7uY\u0001\"\b.\u001a\u0011cS:\f'/\u001f\u0011g_Jl\u0017\r\u001e\u0011g_J\u00043m\u001c8wKJ\u001c\u0018n\u001c8!SN\u0004#\u0005[3yE\u0001Jg\r\t1g[R\u0004\u0007%[:!_6LG\u000f^3e])\u0001\u0003\u0005\t\u0011!AQCW\r\t4v]\u000e$\u0018n\u001c8!e\u0016$XO\u001d8tA9+F\n\u0014\u0011jM\u0002\nG\u000f\t7fCN$\be\u001c8fA=4\u0007\u0005\u001e5fA%t\u0007/\u001e;!a\u0006\u0014\u0018-\\3uKJ\u001c\b%[:!\u001dVcEJ\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002\u0016\u0006\u0019%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014bE\u000e<C\u0006I\u0014vi\u001al\u0003hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u00147M\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\tY*A\u00034]Mr\u0003'A\u0003he>,\b/\t\u0002\u0002\"\u0006a1\u000f\u001e:j]\u001e|f-\u001e8dg\u0006AAk\u001c\"j]\u0006\u0014\u0018\u0010\u0005\u000235M!!$!+B!!\tY+!-2\u0013>+VBAAW\u0015\r\ty+P\u0001\beVtG/[7f\u0013\u0011\t\u0019,!,\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0002&\u0006AAo\\*ue&tw\r\u0006\u0002\u0002B\u0005)\u0011\r\u001d9msR9Q+a0\u0002B\u0006\r\u0007\"\u0002#\u001e\u0001\u0004\t\u0004\"B$\u001e\u0001\u0004I\u0005bB'\u001e!\u0003\u0005\raT\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u00059QO\\1qa2LH\u0003BAf\u0003'\u0004B\u0001\u0010&\u0002NB1A(a42\u0013>K1!!5>\u0005\u0019!V\u000f\u001d7fg!A\u0011Q[\u0010\u0002\u0002\u0003\u0007Q+A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!8\u0011\t\u0005\r\u0013q\\\u0005\u0005\u0003C\f)E\u0001\u0004PE*,7\r\u001e")
public class ToBinary
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
scala.Serializable {
    private Expression replacement;
    private final Expression expr;
    private final Option<Expression> format;
    private final boolean nullOnInvalidFormat;
    private final Seq<Enumeration.Value> nodePatterns;
    private Expression preCanonicalized;
    private volatile byte bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return ToBinary$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Option<Expression>, Object>> unapply(ToBinary toBinary) {
        return ToBinary$.MODULE$.unapply(toBinary);
    }

    public static boolean apply$default$3() {
        return ToBinary$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Object>, ToBinary> tupled() {
        return ToBinary$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Object, ToBinary>>> curried() {
        return ToBinary$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression preCanonicalized$lzycompute() {
        ToBinary toBinary = this;
        synchronized (toBinary) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.preCanonicalized = RuntimeReplaceable.preCanonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.preCanonicalized;
    }

    @Override
    public Expression preCanonicalized() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.preCanonicalized$lzycompute() : this.preCanonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression expr() {
        return this.expr;
    }

    public Option<Expression> format() {
        return this.format;
    }

    public boolean nullOnInvalidFormat() {
        return this.nullOnInvalidFormat;
    }

    private Expression replacement$lzycompute() {
        ToBinary toBinary = this;
        synchronized (toBinary) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = (Expression)this.format().map(arg_0 -> ToBinary.$anonfun$replacement$1(this, arg_0)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Unhex(this.expr()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.replacement$lzycompute() : this.replacement;
    }

    @Override
    public String prettyName() {
        return "to_binary";
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.expr();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$46 -> StringType$.MODULE$, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.format().isDefined() ? this.copy((Expression)newChildren.head(), (Option<Expression>)new Some(newChildren.last()), this.copy$default$3()) : this.copy((Expression)newChildren.head(), this.copy$default$2(), this.copy$default$3());
    }

    public ToBinary copy(Expression expr, Option<Expression> format, boolean nullOnInvalidFormat) {
        return new ToBinary(expr, format, nullOnInvalidFormat);
    }

    public Expression copy$default$1() {
        return this.expr();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public boolean copy$default$3() {
        return this.nullOnInvalidFormat();
    }

    @Override
    public String productPrefix() {
        return "ToBinary";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.expr();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.nullOnInvalidFormat());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToBinary;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToBinary)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToBinary toBinary = (ToBinary)x$1;
        Expression expression = this.expr();
        Expression expression2 = toBinary.expr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = toBinary.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.nullOnInvalidFormat() != toBinary.nullOnInvalidFormat()) return false;
        if (!toBinary.canEqual(this)) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ Expression $anonfun$replacement$1(ToBinary $this, Expression f) {
        if (!f.foldable()) ** GOTO lbl-1000
        v0 = f.dataType();
        var3_2 = StringType$.MODULE$;
        if (!(v0 == null ? var3_2 != null : v0.equals(var3_2) == false)) ** GOTO lbl-1000
        v1 = f.dataType();
        var4_3 = NullType$.MODULE$;
        if (!(v1 != null ? v1.equals(var4_3) == false : var4_3 != null)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        Predef$.MODULE$.assert(v2);
        value = f.eval(f.eval$default$1());
        if (value == null) {
            v3 /* !! */  = new Literal(null, BinaryType$.MODULE$);
        } else {
            var6_5 = ((UTF8String)value).toString().toLowerCase(Locale.ROOT);
            if ("hex".equals(var6_5)) {
                var2_6 /* !! */  = new Unhex($this.expr());
            } else if ("utf-8".equals(var6_5)) {
                var2_6 /* !! */  = new Encode($this.expr(), Literal$.MODULE$.apply("UTF-8"));
            } else if ("base64".equals(var6_5)) {
                var2_6 /* !! */  = new UnBase64($this.expr());
            } else if ($this.nullOnInvalidFormat()) {
                var2_6 /* !! */  = new Literal(null, BinaryType$.MODULE$);
            } else {
                throw QueryCompilationErrors$.MODULE$.invalidStringLiteralParameter("to_binary", "format", var6_5, (Option<String>)new Some((Object)"The value has to be a case-insensitive string literal of 'hex', 'utf-8', or 'base64'."));
            }
            v3 /* !! */  = var2_6 /* !! */ ;
        }
        return v3 /* !! */ ;
    }

    public ToBinary(Expression expr, Option<Expression> format, boolean nullOnInvalidFormat) {
        this.expr = expr;
        this.format = format;
        this.nullOnInvalidFormat = nullOnInvalidFormat;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public ToBinary(Expression expr) {
        this(expr, (Option<Expression>)None$.MODULE$, false);
    }

    public ToBinary(Expression expr, Expression format) {
        block3: {
            block2: {
                NullType$ nullType$;
                DataType dataType;
                block4: {
                    if (!format.foldable()) break block2;
                    DataType dataType2 = format.dataType();
                    StringType$ stringType$ = StringType$.MODULE$;
                    if (!(dataType2 == null ? stringType$ != null : !dataType2.equals(stringType$))) break block3;
                    dataType = format.dataType();
                    nullType$ = NullType$.MODULE$;
                    if (dataType != null) break block4;
                    if (nullType$ == null) break block3;
                    break block2;
                }
                if (dataType.equals(nullType$)) break block3;
            }
            throw QueryCompilationErrors$.MODULE$.requireLiteralParameter("to_binary", "format", "string");
        }
        this(expr, (Option<Expression>)new Some((Object)format), false);
    }
}

