/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.MapZipWith$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.LinkedHashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n      _FUNC_(map1, map2, function) - Merges two given maps into a single map by applying\n      function to the pair of values with the same key. For keys only presented in one map,\n      NULL will be passed as the value for the missing key. If an input map contains duplicated\n      keys, only the first entry of the duplicated key is passed into the lambda function.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'), map(1, 'x', 2, 'y'), (k, v1, v2) -> concat(v1, v2));\n       {1:\"ax\",2:\"by\"}\n  ", since="3.0.0", group="lambda_funcs")
@ScalaSignature(bytes="\u0006\u0001\rea\u0001B\u001e=\u0001&C\u0001B\u001a\u0001\u0003\u0016\u0004%\ta\u001a\u0005\tQ\u0002\u0011\t\u0012)A\u0005\u0015\"A\u0011\u000e\u0001BK\u0002\u0013\u0005q\r\u0003\u0005k\u0001\tE\t\u0015!\u0003K\u0011!Y\u0007A!f\u0001\n\u00039\u0007\u0002\u00037\u0001\u0005#\u0005\u000b\u0011\u0002&\t\u000b5\u0004A\u0011\u00018\t\u000bM\u0004A\u0011A4\t\u0015Q\u0004\u0001\u0013!EDB\u0013%Q\u000f\u0003\u0006\u0002\u0006\u0001A)\u0019!C\u0001\u0003\u000fA!\"!\u0005\u0001\u0011\u000b\u0007I\u0011AA\u0004\u0011)\t)\u0002\u0001EC\u0002\u0013\u0005\u0011q\u0003\u0005\f\u00037\u0001\u0001\u0013!EDB\u0013%Q\u000f\u0003\u0006\u0002\u001e\u0001A)\u0019!C\u0001\u0003\u000fA!\"!\t\u0001\u0011\u000b\u0007I\u0011AA\u0004\u0011)\t)\u0003\u0001EC\u0002\u0013\u0005\u0011q\u0003\u0005\u000b\u0003S\u0001\u0001R1A\u0005\u0002\u0005\u001d\u0001BCA\u0017\u0001!\u0015\r\u0011\"\u0001\u00020!9\u0011\u0011\u000b\u0001\u0005B\u0005M\u0003bBA.\u0001\u0011\u0005\u0013Q\f\u0005\b\u0003O\u0002A\u0011IA*\u0011\u001d\tI\u0007\u0001C!\u0003;Bq!a\u001b\u0001\t\u0003\n9\u0001C\u0004\u0002n\u0001!\t%a\u001c\t\u000f\u0005%\u0005\u0001\"\u0011\u0002\f\"9\u0011\u0011\u0014\u0001\u0005B\u0005-\u0005bBAN\u0001\u0011\u0005\u0013Q\u0014\u0005\r\u0003W\u0003\u0001\u0013!EDB\u0013%\u0011Q\u0016\u0005\u000b\u0003o\u0003\u0001R1A\u0005\u0002\u0005e\u0006BCA_\u0001!\u0015\r\u0011\"\u0001\u0002:\"Q\u0011\u0011\u0019\u0001\t\u0006\u0004%\t!!/\t\u0015\u0005\u0015\u0007\u0001#b\u0001\n\u0013\t9\rC\u0004\u0002~\u0002!I!a@\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e!9!Q\u0004\u0001\u0005\n\t}\u0001b\u0002B\u0016\u0001\u0011%!Q\u0006\u0005\b\u0005w\u0001A\u0011\tB\u001f\u0011\u0019\u0011y\u0005\u0001C!O\"1!\u0011\u000b\u0001\u0005B\u001dDaAa\u0015\u0001\t\u0003:\u0007b\u0002B+\u0001\u0011E#q\u000b\u0005\n\u0005K\u0002\u0011\u0011!C\u0001\u0005OB\u0011Ba\u001c\u0001#\u0003%\tA!\u001d\t\u0013\t\u001d\u0005!%A\u0005\u0002\tE\u0004\"\u0003BE\u0001E\u0005I\u0011\u0001B9\u0011%\u0011Y\tAA\u0001\n\u0003\u0012i\tC\u0005\u0003\u001e\u0002\t\t\u0011\"\u0001\u0003 \"I!\u0011\u0015\u0001\u0002\u0002\u0013\u0005!1\u0015\u0005\n\u0005S\u0003\u0011\u0011!C!\u0005WC\u0011B!.\u0001\u0003\u0003%\tAa.\t\u0013\tm\u0006!!A\u0005B\tuv!\u0003Bqy\u0005\u0005\t\u0012\u0001Br\r!YD(!A\t\u0002\t\u0015\bBB76\t\u0003\u0011\u0019\u0010C\u0005\u0003vV\n\t\u0011\"\u0012\u0003x\"I!\u0011`\u001b\u0002\u0002\u0013\u0005%1 \u0005\n\u0007\u0007)\u0014\u0011!CA\u0007\u000bA\u0011ba\u00046\u0003\u0003%Ia!\u0005\u0003\u00155\u000b\u0007OW5q/&$\bN\u0003\u0002>}\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\ty\u0004)\u0001\u0005dCR\fG._:u\u0015\t\t%)A\u0002tc2T!a\u0011#\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u00153\u0015AB1qC\u000eDWMC\u0001H\u0003\ry'oZ\u0002\u0001'\u001d\u0001!JT)X;\u000e\u0004\"a\u0013'\u000e\u0003qJ!!\u0014\u001f\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002L\u001f&\u0011\u0001\u000b\u0010\u0002\u0014\u0011&<\u0007.\u001a:Pe\u0012,'OR;oGRLwN\u001c\t\u0003%Vk\u0011a\u0015\u0006\u0003)r\nqaY8eK\u001e,g.\u0003\u0002W'\ny1i\u001c3fO\u0016tg)\u00197mE\u0006\u001c7\u000eE\u0002Y7*k\u0011!\u0017\u0006\u00035z\nQ\u0001\u001e:fKNL!\u0001X-\u0003\u0017Q+'O\\1ss2K7.\u001a\t\u0003=\u0006l\u0011a\u0018\u0006\u0002A\u0006)1oY1mC&\u0011!m\u0018\u0002\b!J|G-^2u!\tqF-\u0003\u0002f?\na1+\u001a:jC2L'0\u00192mK\u0006!A.\u001a4u+\u0005Q\u0015!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0005gk:\u001cG/[8o\u0003%1WO\\2uS>t\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005_B\f(\u000f\u0005\u0002L\u0001!)am\u0002a\u0001\u0015\")\u0011n\u0002a\u0001\u0015\")1n\u0002a\u0001\u0015\u0006ya-\u001e8di&|gNR8s\u000bZ\fG.\u0001\u0003yIUJT#\u0001<\u0011\u000by;\u00180_@\n\u0005a|&A\u0002+va2,7\u0007\u0005\u0002{{6\t1P\u0003\u0002}\u0001\u0006)A/\u001f9fg&\u0011ap\u001f\u0002\t\t\u0006$\u0018\rV=qKB\u0019a,!\u0001\n\u0007\u0005\rqLA\u0004C_>dW-\u00198\u0002\u00171,g\r^&fsRK\b/Z\u000b\u0002s\"\u001a!\"a\u0003\u0011\u0007y\u000bi!C\u0002\u0002\u0010}\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u001b1,g\r\u001e,bYV,G+\u001f9fQ\rY\u00111B\u0001\u0016Y\u00164GOV1mk\u0016\u001cuN\u001c;bS:\u001ch*\u001e7m+\u0005y\bf\u0001\u0007\u0002\f\u0005!\u0001\u0010\n\u001c1\u00031\u0011\u0018n\u001a5u\u0017\u0016LH+\u001f9fQ\rq\u00111B\u0001\u000fe&<\u0007\u000e\u001e,bYV,G+\u001f9fQ\ry\u00111B\u0001\u0017e&<\u0007\u000e\u001e,bYV,7i\u001c8uC&t7OT;mY\"\u001a\u0001#a\u0003\u0002\u000f-,\u0017\u0010V=qK\"\u001a\u0011#a\u0003\u0002\u0011=\u0014H-\u001a:j]\u001e,\"!!\r\u0011\r\u0005M\u00121IA%\u001d\u0011\t)$a\u0010\u000f\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000fI\u0003\u0019a$o\\8u}%\t\u0001-C\u0002\u0002B}\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002F\u0005\u001d#\u0001C(sI\u0016\u0014\u0018N\\4\u000b\u0007\u0005\u0005s\fE\u0002_\u0003\u0017J1!!\u0014`\u0005\r\te.\u001f\u0015\u0004%\u0005-\u0011!C1sOVlWM\u001c;t+\t\t)\u0006E\u0003\u00024\u0005]#*\u0003\u0003\u0002Z\u0005\u001d#aA*fc\u0006i\u0011M]4v[\u0016tG\u000fV=qKN,\"!a\u0018\u0011\r\u0005M\u0012qKA1!\rQ\u00181M\u0005\u0004\u0003KZ(\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003%1WO\\2uS>t7/A\u0007gk:\u001cG/[8o)f\u0004Xm]\u0001\tI\u0006$\u0018\rV=qK\u0006!!-\u001b8e)\ry\u0017\u0011\u000f\u0005\b\u0003gB\u0002\u0019AA;\u0003\u00051\u0007\u0003\u00030\u0002x)\u000bY(a!\n\u0007\u0005etLA\u0005Gk:\u001cG/[8oeA1\u00111GA,\u0003{\u0002RAXA@s~L1!!!`\u0005\u0019!V\u000f\u001d7feA\u00191*!\"\n\u0007\u0005\u001dEH\u0001\bMC6\u0014G-\u0019$v]\u000e$\u0018n\u001c8\u0002-\rDWmY6Be\u001e,X.\u001a8u\t\u0006$\u0018\rV=qKN$\"!!$\u0011\t\u0005=\u0015QS\u0007\u0003\u0003#S1!a%?\u0003!\tg.\u00197zg&\u001c\u0018\u0002BAL\u0003#\u0013q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm]\u0001\u0005KZ\fG\u000e\u0006\u0003\u0002J\u0005}\u0005\"CAQ7A\u0005\t\u0019AAR\u0003\u0015Ig\u000e];u!\u0011\t)+a*\u000e\u0003yJ1!!+?\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\ta$cgN\u000b\u0003\u0003_\u0003\u0002BX<\u00022\u0006E\u0016\u0011\u0017\t\u0004\u0017\u0006M\u0016bAA[y\t\u0019b*Y7fI2\u000bWN\u00193b-\u0006\u0014\u0018.\u00192mK\u000611.Z=WCJ,\"!!-)\u0007u\tY!A\u0005wC2,X-\r,be\"\u001aa$a\u0003\u0002\u0013Y\fG.^33-\u0006\u0014\bfA\u0010\u0002\f\u00059r-\u001a;LKf\u001cx+\u001b;i-\u0006dW/Z%oI\u0016DXm]\u000b\u0003\u0003\u0013\u0004\u0012BXA<\u0003\u0017\fY-a6\u0011\t\u00055\u00171[\u0007\u0003\u0003\u001fT1!!5?\u0003\u0011)H/\u001b7\n\t\u0005U\u0017q\u001a\u0002\n\u0003J\u0014\u0018-\u001f#bi\u0006\u0004b!!7\u0002d\u0006\u001dXBAAn\u0015\u0011\ti.a8\u0002\u000f5,H/\u00192mK*\u0019\u0011\u0011]0\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002f\u0006m'\u0001C%uKJ\f'\r\\3\u0011\u000fy\u000by(!\u0013\u0002jB)a,a;\u0002p&\u0019\u0011Q^0\u0003\u000b\u0005\u0013(/Y=\u0011\u000by\u000b\t0!>\n\u0007\u0005MxL\u0001\u0004PaRLwN\u001c\t\u0004=\u0006]\u0018bAA}?\n\u0019\u0011J\u001c;)\u0007\u0001\nY!A\fbgN,'\u000f^*ju\u0016|e-\u0011:sCf\u0014UO\u001a4feR!!\u0011\u0001B\u0004!\rq&1A\u0005\u0004\u0005\u000by&\u0001B+oSRDqA!\u0003\"\u0001\u0004\t)0\u0001\u0003tSj,\u0017AF4fi.+\u0017p],ji\"Le\u000eZ3yKN4\u0015m\u001d;\u0015\r\t=!Q\u0003B\r!!\tIN!\u0005\u0002J\u0005%\u0018\u0002\u0002B\n\u00037\u0014Q\u0002T5oW\u0016$\u0007*Y:i\u001b\u0006\u0004\bb\u0002B\fE\u0001\u0007\u00111Z\u0001\u0006W\u0016L8/\r\u0005\b\u00057\u0011\u0003\u0019AAf\u0003\u0015YW-_:3\u0003q9W\r^&fsN<\u0016\u000e\u001e5J]\u0012,\u00070Z:CeV$XMR8sG\u0016$bA!\t\u0003(\t%\u0002CBAm\u0005G\t9/\u0003\u0003\u0003&\u0005m'aC!se\u0006L()\u001e4gKJDqAa\u0006$\u0001\u0004\tY\rC\u0004\u0003\u001c\r\u0002\r!a3\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0011\u0005%#q\u0006B\u001a\u0005oAqA!\r%\u0001\u0004\t\u0019+\u0001\u0005j]B,HOU8x\u0011\u001d\u0011)\u0004\na\u0001\u0003\u0013\naA^1mk\u0016\f\u0004b\u0002B\u001dI\u0001\u0007\u0011\u0011J\u0001\u0007m\u0006dW/\u001a\u001a\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0003@A!!\u0011\tB%\u001d\u0011\u0011\u0019E!\u0012\u0011\u0007\u0005]r,C\u0002\u0003H}\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002B&\u0005\u001b\u0012aa\u0015;sS:<'b\u0001B$?\u0006)a-\u001b:ti\u000611/Z2p]\u0012\fQ\u0001\u001e5je\u0012\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000f=\u0014IF!\u0018\u0003b!1!1L\u0015A\u0002)\u000b\u0001B\\3x\r&\u00148\u000f\u001e\u0005\u0007\u0005?J\u0003\u0019\u0001&\u0002\u00139,woU3d_:$\u0007B\u0002B2S\u0001\u0007!*\u0001\u0005oK^$\u0006.\u001b:e\u0003\u0011\u0019w\u000e]=\u0015\u000f=\u0014IGa\u001b\u0003n!9aM\u000bI\u0001\u0002\u0004Q\u0005bB5+!\u0003\u0005\rA\u0013\u0005\bW*\u0002\n\u00111\u0001K\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u001d+\u0007)\u0013)h\u000b\u0002\u0003xA!!\u0011\u0010BB\u001b\t\u0011YH\u0003\u0003\u0003~\t}\u0014!C;oG\",7m[3e\u0015\r\u0011\tiX\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BC\u0005w\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u001f\u0003BA!%\u0003\u001c6\u0011!1\u0013\u0006\u0005\u0005+\u00139*\u0001\u0003mC:<'B\u0001BM\u0003\u0011Q\u0017M^1\n\t\t-#1S\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003k\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002J\t\u0015\u0006\"\u0003BTa\u0005\u0005\t\u0019AA{\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\u0016\t\u0007\u0005_\u0013\t,!\u0013\u000e\u0005\u0005}\u0017\u0002\u0002BZ\u0003?\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019qP!/\t\u0013\t\u001d&'!AA\u0002\u0005%\u0013AB3rk\u0006d7\u000fF\u0002\u0000\u0005\u007fC\u0011Ba*4\u0003\u0003\u0005\r!!\u0013)'\u0001\u0011\u0019M!3\u0003L\n='\u0011\u001bBk\u0005/\u0014YN!8\u0011\u0007-\u0013)-C\u0002\u0003Hr\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003N\u0006\u0011YO\u0003\u0011!A\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006&\\1qc1\u0002S.\u001993Y\u00012WO\\2uS>t\u0017\u0006I\u0017!\u001b\u0016\u0014x-Z:!i^|\u0007eZ5wK:\u0004S.\u00199tA%tGo\u001c\u0011bAMLgn\u001a7fA5\f\u0007\u000f\t2zA\u0005\u0004\b\u000f\\=j]\u001eT\u0001\u0005\t\u0011!A\u00012WO\\2uS>t\u0007\u0005^8!i\",\u0007\u0005]1je\u0002zg\r\t<bYV,7\u000fI<ji\"\u0004C\u000f[3!g\u0006lW\rI6fs:\u0002ci\u001c:!W\u0016L8\u000fI8oYf\u0004\u0003O]3tK:$X\r\u001a\u0011j]\u0002zg.\u001a\u0011nCBd#\u0002\t\u0011!A\u0001\u0002c*\u0016'MA]LG\u000e\u001c\u0011cK\u0002\u0002\u0018m]:fI\u0002\n7\u000f\t;iK\u00022\u0018\r\\;fA\u0019|'\u000f\t;iK\u0002j\u0017n]:j]\u001e\u00043.Z=/A%3\u0007%\u00198!S:\u0004X\u000f\u001e\u0011nCB\u00043m\u001c8uC&t7\u000f\t3va2L7-\u0019;fI*\u0001\u0003\u0005\t\u0011!A-,\u0017p\u001d\u0017!_:d\u0017\u0010\t;iK\u00022\u0017N]:uA\u0015tGO]=!_\u001a\u0004C\u000f[3!IV\u0004H.[2bi\u0016$\u0007e[3zA%\u001c\b\u0005]1tg\u0016$\u0007%\u001b8u_\u0002\"\b.\u001a\u0011mC6\u0014G-\u0019\u0011gk:\u001cG/[8o])\u0001\u0003\u0005\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#Aa5\u0002\u0003#Q\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\\1qQEb\u0003eJ1(Y\u0001\u0012D\u0006I\u0014cO%b\u0003%\\1qQEb\u0003e\n=(Y\u0001\u0012D\u0006I\u0014zO%b\u0003\u0005K6-AY\fD\u0006\t<3S\u0001jc\bI2p]\u000e\fG\u000f\u000b<2Y\u00012('K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\f$HI1yE1\u0012$H\t2zEuT\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u00053\fQa\r\u00181]A\nQa\u001a:pkB\f#Aa8\u0002\u00191\fWN\u00193b?\u001a,hnY:\u0002\u00155\u000b\u0007OW5q/&$\b\u000e\u0005\u0002LkM!QGa:d!!\u0011IOa<K\u0015*{WB\u0001Bv\u0015\r\u0011ioX\u0001\beVtG/[7f\u0013\u0011\u0011\tPa;\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0003d\u0006AAo\\*ue&tw\r\u0006\u0002\u0003\u0010\u0006)\u0011\r\u001d9msR9qN!@\u0003\u0000\u000e\u0005\u0001\"\u000249\u0001\u0004Q\u0005\"B59\u0001\u0004Q\u0005\"B69\u0001\u0004Q\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0007\u000f\u0019Y\u0001E\u0003_\u0003c\u001cI\u0001E\u0003_o*S%\n\u0003\u0005\u0004\u000ee\n\t\u00111\u0001p\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0004\u0014A!!\u0011SB\u000b\u0013\u0011\u00199Ba%\u0003\r=\u0013'.Z2u\u0001")
public class MapZipWith
extends Expression
implements HigherOrderFunction,
CodegenFallback,
TernaryLike<Expression>,
scala.Serializable {
    private Tuple3<DataType, DataType, Object> x$59;
    private transient DataType leftKeyType;
    private transient DataType leftValueType;
    private transient boolean leftValueContainsNull;
    private Tuple3<DataType, DataType, Object> x$60;
    private transient DataType rightKeyType;
    private transient DataType rightValueType;
    private transient boolean rightValueContainsNull;
    private transient DataType keyType;
    private transient Ordering<Object> ordering;
    private Tuple3<NamedLambdaVariable, NamedLambdaVariable, NamedLambdaVariable> x$67;
    private transient NamedLambdaVariable keyVar;
    private transient NamedLambdaVariable value1Var;
    private transient NamedLambdaVariable value2Var;
    private transient Function2<ArrayData, ArrayData, Iterable<Tuple2<Object, Option<Object>[]>>> getKeysWithValueIndexes;
    private final Expression left;
    private final Expression right;
    private final Expression function;
    private transient Seq<Expression> children;
    private final Seq<Enumeration.Value> nodePatterns;
    private boolean argumentsResolved;
    private boolean resolved;
    private transient Seq<Expression> functionsForEval;
    private Expression preCanonicalized;
    private volatile byte bitmap$0;
    private volatile transient int bitmap$trans$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(MapZipWith mapZipWith) {
        return MapZipWith$.MODULE$.unapply(mapZipWith);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, MapZipWith> tupled() {
        return MapZipWith$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, MapZipWith>>> curried() {
        return MapZipWith$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public boolean nullable() {
        return HigherOrderFunction.nullable$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return HigherOrderFunction.inputTypes$(this);
    }

    private Seq<Expression> children$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x1000) == 0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 |= 0x1000;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return (this.bitmap$trans$0 & 0x1000) == 0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean argumentsResolved$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.argumentsResolved = HigherOrderFunction.argumentsResolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.argumentsResolved;
    }

    @Override
    public boolean argumentsResolved() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.argumentsResolved$lzycompute() : this.argumentsResolved;
    }

    private boolean resolved$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.resolved = HigherOrderFunction.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private Seq<Expression> functionsForEval$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x2000) == 0) {
                this.functionsForEval = HigherOrderFunction.functionsForEval$(this);
                this.bitmap$trans$0 |= 0x2000;
            }
        }
        return this.functionsForEval;
    }

    @Override
    public Seq<Expression> functionsForEval() {
        return (this.bitmap$trans$0 & 0x2000) == 0 ? this.functionsForEval$lzycompute() : this.functionsForEval;
    }

    private Expression preCanonicalized$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.preCanonicalized = HigherOrderFunction.preCanonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.preCanonicalized;
    }

    @Override
    public Expression preCanonicalized() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.preCanonicalized$lzycompute() : this.preCanonicalized;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$HigherOrderFunction$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    public Expression function() {
        return this.function;
    }

    public Expression functionForEval() {
        return (Expression)this.functionsForEval().head();
    }

    private Tuple3<DataType, DataType, Object> x$59$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                DataType dataType = this.left().dataType();
                if (!(dataType instanceof MapType)) {
                    throw new MatchError((Object)dataType);
                }
                MapType mapType = (MapType)dataType;
                DataType leftKeyType = mapType.keyType();
                DataType leftValueType = mapType.valueType();
                boolean leftValueContainsNull = mapType.valueContainsNull();
                Tuple3 tuple3 = new Tuple3((Object)leftKeyType, (Object)leftValueType, (Object)BoxesRunTime.boxToBoolean((boolean)leftValueContainsNull));
                this.x$59 = tuple3;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$59;
    }

    private /* synthetic */ Tuple3 x$59() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$59$lzycompute() : this.x$59;
    }

    private DataType leftKeyType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 1) == 0) {
                this.leftKeyType = (DataType)this.x$59()._1();
                this.bitmap$trans$0 |= 1;
            }
        }
        return this.leftKeyType;
    }

    public DataType leftKeyType() {
        return (this.bitmap$trans$0 & 1) == 0 ? this.leftKeyType$lzycompute() : this.leftKeyType;
    }

    private DataType leftValueType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 2) == 0) {
                this.leftValueType = (DataType)this.x$59()._2();
                this.bitmap$trans$0 |= 2;
            }
        }
        return this.leftValueType;
    }

    public DataType leftValueType() {
        return (this.bitmap$trans$0 & 2) == 0 ? this.leftValueType$lzycompute() : this.leftValueType;
    }

    private boolean leftValueContainsNull$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 4) == 0) {
                this.leftValueContainsNull = BoxesRunTime.unboxToBoolean((Object)this.x$59()._3());
                this.bitmap$trans$0 |= 4;
            }
        }
        return this.leftValueContainsNull;
    }

    public boolean leftValueContainsNull() {
        return (this.bitmap$trans$0 & 4) == 0 ? this.leftValueContainsNull$lzycompute() : this.leftValueContainsNull;
    }

    private Tuple3<DataType, DataType, Object> x$60$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                DataType dataType = this.right().dataType();
                if (!(dataType instanceof MapType)) {
                    throw new MatchError((Object)dataType);
                }
                MapType mapType = (MapType)dataType;
                DataType rightKeyType = mapType.keyType();
                DataType rightValueType = mapType.valueType();
                boolean rightValueContainsNull = mapType.valueContainsNull();
                Tuple3 tuple3 = new Tuple3((Object)rightKeyType, (Object)rightValueType, (Object)BoxesRunTime.boxToBoolean((boolean)rightValueContainsNull));
                this.x$60 = tuple3;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.x$60;
    }

    private /* synthetic */ Tuple3 x$60() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.x$60$lzycompute() : this.x$60;
    }

    private DataType rightKeyType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 8) == 0) {
                this.rightKeyType = (DataType)this.x$60()._1();
                this.bitmap$trans$0 |= 8;
            }
        }
        return this.rightKeyType;
    }

    public DataType rightKeyType() {
        return (this.bitmap$trans$0 & 8) == 0 ? this.rightKeyType$lzycompute() : this.rightKeyType;
    }

    private DataType rightValueType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x10) == 0) {
                this.rightValueType = (DataType)this.x$60()._2();
                this.bitmap$trans$0 |= 0x10;
            }
        }
        return this.rightValueType;
    }

    public DataType rightValueType() {
        return (this.bitmap$trans$0 & 0x10) == 0 ? this.rightValueType$lzycompute() : this.rightValueType;
    }

    private boolean rightValueContainsNull$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x20) == 0) {
                this.rightValueContainsNull = BoxesRunTime.unboxToBoolean((Object)this.x$60()._3());
                this.bitmap$trans$0 |= 0x20;
            }
        }
        return this.rightValueContainsNull;
    }

    public boolean rightValueContainsNull() {
        return (this.bitmap$trans$0 & 0x20) == 0 ? this.rightValueContainsNull$lzycompute() : this.rightValueContainsNull;
    }

    private DataType keyType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x40) == 0) {
                this.keyType = (DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags(this.leftKeyType(), this.rightKeyType()).get();
                this.bitmap$trans$0 |= 0x40;
            }
        }
        return this.keyType;
    }

    public DataType keyType() {
        return (this.bitmap$trans$0 & 0x40) == 0 ? this.keyType$lzycompute() : this.keyType;
    }

    private Ordering<Object> ordering$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x80) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.keyType());
                this.bitmap$trans$0 |= 0x80;
            }
        }
        return this.ordering;
    }

    public Ordering<Object> ordering() {
        return (this.bitmap$trans$0 & 0x80) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    @Override
    public Seq<Expression> arguments() {
        Expression expression = this.left();
        Expression expression2 = this.right();
        return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> argumentTypes() {
        MapType$ mapType$ = MapType$.MODULE$;
        MapType$ mapType$2 = MapType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)mapType$2).$colon$colon((Object)mapType$);
    }

    @Override
    public Seq<Expression> functions() {
        Expression expression = this.function();
        return Nil$.MODULE$.$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> functionTypes() {
        AnyDataType$ anyDataType$ = AnyDataType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)anyDataType$);
    }

    @Override
    public DataType dataType() {
        return new MapType(this.keyType(), this.function().dataType(), this.function().nullable());
    }

    @Override
    public MapZipWith bind(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        Seq arguments = (Seq)new .colon.colon((Object)new Tuple2((Object)this.keyType(), (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)this.leftValueType(), (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)this.rightValueType(), (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$)));
        LambdaFunction x$1 = (LambdaFunction)f.apply((Object)this.function(), (Object)arguments);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public TypeCheckResult checkArgumentDataTypes() {
        TypeCheckResult typeCheckResult = HigherOrderFunction.checkArgumentDataTypes$(this);
        TypeCheckResult typeCheckResult2 = TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult) ? (this.leftKeyType().sameType(this.rightKeyType()) ? TypeUtils$.MODULE$.checkForOrderingExpr(this.leftKeyType(), new StringBuilder(9).append("function ").append(this.prettyName()).toString()) : new TypeCheckResult.TypeCheckFailure(new StringBuilder(100).append("The input to function ").append(this.prettyName()).append(" should have ").append("been two ").append(MapType$.MODULE$.simpleString()).append("s with compatible key types, but the key types are ").append("[").append(this.leftKeyType().catalogString()).append(", ").append(this.rightKeyType().catalogString()).append("].").toString())) : typeCheckResult;
        return typeCheckResult2;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.checkArgumentDataTypes();
    }

    @Override
    public Object eval(InternalRow input) {
        Object value2;
        Object value1 = this.left().eval(input);
        return value1 == null ? null : ((value2 = this.right().eval(input)) == null ? null : this.nullSafeEval(input, value1, value2));
    }

    private Tuple3<NamedLambdaVariable, NamedLambdaVariable, NamedLambdaVariable> x$67$lzycompute() {
        block5: {
            MapZipWith mapZipWith = this;
            synchronized (mapZipWith) {
                NamedLambdaVariable namedLambdaVariable;
                NamedLambdaVariable namedLambdaVariable2;
                NamedExpression value2Var;
                block7: {
                    Expression expression;
                    block6: {
                        LambdaFunction lambdaFunction;
                        Seq<NamedExpression> seq;
                        Some some;
                        if ((byte)(this.bitmap$0 & 4) != 0) break block5;
                        expression = this.function();
                        if (!(expression instanceof LambdaFunction) || (some = Seq$.MODULE$.unapplySeq(seq = (lambdaFunction = (LambdaFunction)expression).arguments())).isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block6;
                        NamedExpression keyVar = (NamedExpression)((SeqLike)some.get()).apply(0);
                        NamedExpression value1Var = (NamedExpression)((SeqLike)some.get()).apply(1);
                        value2Var = (NamedExpression)((SeqLike)some.get()).apply(2);
                        if (!(keyVar instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable2 = (NamedLambdaVariable)keyVar;
                        if (!(value1Var instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable = (NamedLambdaVariable)value1Var;
                        if (value2Var instanceof NamedLambdaVariable) break block7;
                    }
                    throw new MatchError((Object)expression);
                }
                NamedLambdaVariable namedLambdaVariable3 = (NamedLambdaVariable)value2Var;
                Tuple3 tuple3 = new Tuple3((Object)namedLambdaVariable2, (Object)namedLambdaVariable, (Object)namedLambdaVariable3);
                this.x$67 = tuple3;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.x$67;
    }

    private /* synthetic */ Tuple3 x$67() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.x$67$lzycompute() : this.x$67;
    }

    private NamedLambdaVariable keyVar$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x100) == 0) {
                this.keyVar = (NamedLambdaVariable)this.x$67()._1();
                this.bitmap$trans$0 |= 0x100;
            }
        }
        return this.keyVar;
    }

    public NamedLambdaVariable keyVar() {
        return (this.bitmap$trans$0 & 0x100) == 0 ? this.keyVar$lzycompute() : this.keyVar;
    }

    private NamedLambdaVariable value1Var$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x200) == 0) {
                this.value1Var = (NamedLambdaVariable)this.x$67()._2();
                this.bitmap$trans$0 |= 0x200;
            }
        }
        return this.value1Var;
    }

    public NamedLambdaVariable value1Var() {
        return (this.bitmap$trans$0 & 0x200) == 0 ? this.value1Var$lzycompute() : this.value1Var;
    }

    private NamedLambdaVariable value2Var$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x400) == 0) {
                this.value2Var = (NamedLambdaVariable)this.x$67()._3();
                this.bitmap$trans$0 |= 0x400;
            }
        }
        return this.value2Var;
    }

    public NamedLambdaVariable value2Var() {
        return (this.bitmap$trans$0 & 0x400) == 0 ? this.value2Var$lzycompute() : this.value2Var;
    }

    private Function2<ArrayData, ArrayData, Iterable<Tuple2<Object, Option<Object>[]>>> getKeysWithValueIndexes$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x800) == 0) {
                this.getKeysWithValueIndexes = TypeUtils$.MODULE$.typeWithProperEquals(this.keyType()) ? (Function2 & Serializable & scala.Serializable)(keys1, keys2) -> this.getKeysWithIndexesFast((ArrayData)keys1, (ArrayData)keys2) : (Function2 & Serializable & scala.Serializable)(keys1, keys2) -> this.getKeysWithIndexesBruteForce((ArrayData)keys1, (ArrayData)keys2);
                this.bitmap$trans$0 |= 0x800;
            }
        }
        return this.getKeysWithValueIndexes;
    }

    private Function2<ArrayData, ArrayData, Iterable<Tuple2<Object, Option<Object>[]>>> getKeysWithValueIndexes() {
        return (this.bitmap$trans$0 & 0x800) == 0 ? this.getKeysWithValueIndexes$lzycompute() : this.getKeysWithValueIndexes;
    }

    private void assertSizeOfArrayBuffer(int size) {
        if (size > 0x7FFFFFF0) {
            throw QueryExecutionErrors$.MODULE$.mapSizeExceedArraySizeWhenZipMapError(size);
        }
    }

    /*
     * WARNING - void declaration
     */
    private LinkedHashMap<Object, Option<Object>[]> getKeysWithIndexesFast(ArrayData keys1, ArrayData keys2) {
        void var3_3;
        LinkedHashMap hashMap = new LinkedHashMap();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)keys1), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)keys2)})).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MapZipWith.$anonfun$getKeysWithIndexesFast$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$68 -> {
            MapZipWith.$anonfun$getKeysWithIndexesFast$2(this, hashMap, x$68);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private ArrayBuffer<Tuple2<Object, Option<Object>[]>> getKeysWithIndexesBruteForce(ArrayData keys1, ArrayData keys2) {
        void var3_3;
        ArrayBuffer arrayBuffer = new ArrayBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)keys1), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)keys2)})).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)MapZipWith.$anonfun$getKeysWithIndexesBruteForce$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$70 -> {
            MapZipWith.$anonfun$getKeysWithIndexesBruteForce$2(this, arrayBuffer, x$70);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    private Object nullSafeEval(InternalRow inputRow, Object value1, Object value2) {
        MapData mapData1 = (MapData)value1;
        MapData mapData2 = (MapData)value2;
        Iterable keysWithIndexes = (Iterable)this.getKeysWithValueIndexes().apply((Object)mapData1.keyArray(), (Object)mapData2.keyArray());
        int size = keysWithIndexes.size();
        GenericArrayData keys = new GenericArrayData(new Object[size]);
        GenericArrayData values = new GenericArrayData(new Object[size]);
        ArrayData valueData1 = mapData1.valueArray();
        ArrayData valueData2 = mapData2.valueArray();
        IntRef i = IntRef.create((int)0);
        keysWithIndexes.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)MapZipWith.$anonfun$nullSafeEval$2(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$73 -> {
            MapZipWith.$anonfun$nullSafeEval$3(this, valueData1, valueData2, keys, i, inputRow, values, x$73);
            return BoxedUnit.UNIT;
        });
        return new ArrayBasedMapData(keys, values);
    }

    @Override
    public String prettyName() {
        return "map_zip_with";
    }

    @Override
    public Expression first() {
        return this.left();
    }

    @Override
    public Expression second() {
        return this.right();
    }

    @Override
    public Expression third() {
        return this.function();
    }

    @Override
    public MapZipWith withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public MapZipWith copy(Expression left, Expression right, Expression function) {
        return new MapZipWith(left, right, function);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Expression copy$default$3() {
        return this.function();
    }

    @Override
    public String productPrefix() {
        return "MapZipWith";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 2: {
                expression = this.function();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MapZipWith;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MapZipWith)) return false;
        boolean bl = true;
        if (!bl) return false;
        MapZipWith mapZipWith = (MapZipWith)x$1;
        Expression expression = this.left();
        Expression expression2 = mapZipWith.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = mapZipWith.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.function();
        Expression expression6 = mapZipWith.function();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!mapZipWith.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getKeysWithIndexesFast$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$getKeysWithIndexesFast$2(MapZipWith $this, LinkedHashMap hashMap$1, Tuple2 x$68) {
        Tuple2 tuple2 = x$68;
        if (tuple2 != null) {
            int z = tuple2._1$mcI$sp();
            ArrayData array = (ArrayData)tuple2._2();
            for (int i = 0; i < array.numElements(); ++i) {
                BoxedUnit boxedUnit;
                Object key = array.get(i, $this.keyType());
                Option option = hashMap$1.get(key);
                if (option instanceof Some) {
                    BoxedUnit boxedUnit2;
                    Some some = (Some)option;
                    Option[] indexes = (Option[])some.value();
                    if (indexes[z].isEmpty()) {
                        indexes[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit2;
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    Option[] indexes = (Option[])((Object[])new Option[]{None$.MODULE$, None$.MODULE$});
                    indexes[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                    boxedUnit = hashMap$1.put(key, (Object)indexes);
                    continue;
                }
                throw new MatchError((Object)option);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getKeysWithIndexesBruteForce$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$getKeysWithIndexesBruteForce$2(MapZipWith $this, ArrayBuffer arrayBuffer$1, Tuple2 x$70) {
        Tuple2 tuple2 = x$70;
        if (tuple2 != null) {
            int z = tuple2._1$mcI$sp();
            ArrayData array = (ArrayData)tuple2._2();
            for (int i = 0; i < array.numElements(); ++i) {
                BoxedUnit boxedUnit;
                Object key = array.get(i, $this.keyType());
                boolean found = false;
                for (int j = 0; !found && j < arrayBuffer$1.size(); ++j) {
                    Tuple2 tuple22 = (Tuple2)arrayBuffer$1.apply(j);
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    Object bufferKey = tuple22._1();
                    Option[] indexes = (Option[])tuple22._2();
                    Tuple2 tuple23 = new Tuple2(bufferKey, (Object)indexes);
                    Tuple2 tuple24 = tuple23;
                    Object bufferKey2 = tuple24._1();
                    Option[] indexes2 = (Option[])tuple24._2();
                    if (!$this.ordering().equiv(bufferKey2, key)) continue;
                    found = true;
                    if (!indexes2[z].isEmpty()) continue;
                    indexes2[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                }
                if (!found) {
                    $this.assertSizeOfArrayBuffer(arrayBuffer$1.size());
                    Option[] indexes = (Option[])((Object[])new Option[]{None$.MODULE$, None$.MODULE$});
                    indexes[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                    boxedUnit = arrayBuffer$1.$plus$eq((Object)new Tuple2(key, (Object)indexes));
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$nullSafeEval$2(Tuple2 check$ifrefutable$3) {
        Option[] optionArray;
        Option option;
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null && !(option = Array$.MODULE$.unapplySeq((Object)(optionArray = (Option[])tuple2._2()))).isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$nullSafeEval$3(MapZipWith $this, ArrayData valueData1$1, ArrayData valueData2$1, GenericArrayData keys$1, IntRef i$1, InternalRow inputRow$3, GenericArrayData values$1, Tuple2 x$73) {
        Tuple2 tuple2 = x$73;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Object key = tuple2._1();
        Option[] optionArray = (Option[])tuple2._2();
        Option option = Array$.MODULE$.unapplySeq((Object)optionArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) throw new MatchError((Object)tuple2);
        Option index1 = (Option)((SeqLike)option.get()).apply(0);
        Option index2 = (Option)((SeqLike)option.get()).apply(1);
        Object v1 = index1.map((Function1 & Serializable & scala.Serializable)x$71 -> valueData1$1.get(BoxesRunTime.unboxToInt((Object)x$71), $this.leftValueType())).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
        Object v2 = index2.map((Function1 & Serializable & scala.Serializable)x$72 -> valueData2$1.get(BoxesRunTime.unboxToInt((Object)x$72), $this.rightValueType())).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
        $this.keyVar().value().set(key);
        $this.value1Var().value().set(v1);
        $this.value2Var().value().set(v2);
        keys$1.update(i$1.elem, key);
        Object v = InternalRow$.MODULE$.copyValue($this.functionForEval().eval(inputRow$3));
        values$1.update(i$1.elem, v);
        ++i$1.elem;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public MapZipWith(Expression left, Expression right, Expression function) {
        this.left = left;
        this.right = right;
        this.function = function;
        ExpectsInputTypes.$init$(this);
        HigherOrderFunction.$init$(this);
        CodegenFallback.$init$(this);
        TernaryLike.$init$(this);
    }
}

