/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical.statsEstimation;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Equality$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.ColumnStatsMap;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.EstimationUtils$;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.FilterEstimation$;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.NumericValueInterval;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.ValueInterval;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.ValueInterval$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Ordering;
import scala.math.ScalaNumericAnyConversions;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\teb\u0001B\u0001\u0003\u0001N\u0011\u0001CR5mi\u0016\u0014Xi\u001d;j[\u0006$\u0018n\u001c8\u000b\u0005\r!\u0011aD:uCR\u001cXi\u001d;j[\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003\u000f!\tQ\u0001\u001d7b]NT!!\u0003\u0006\u0002\u0011\r\fG/\u00197zgRT!a\u0003\u0007\u0002\u0007M\fHN\u0003\u0002\u000e\u001d\u0005)1\u000f]1sW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u000b\u001bA\r\u0002\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0007CA\u000e\u001f\u001b\u0005a\"BA\u000f\r\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0010\u001d\u0005\u001daunZ4j]\u001e\u0004\"!F\u0011\n\u0005\t2\"a\u0002)s_\u0012,8\r\u001e\t\u0003+\u0011J!!\n\f\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011\u001d\u0002!Q3A\u0005\u0002!\nA\u0001\u001d7b]V\t\u0011\u0006\u0005\u0002+W5\tA!\u0003\u0002-\t\t1a)\u001b7uKJD\u0001B\f\u0001\u0003\u0012\u0003\u0006I!K\u0001\u0006a2\fg\u000e\t\u0005\u0006a\u0001!\t!M\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005I\"\u0004CA\u001a\u0001\u001b\u0005\u0011\u0001\"B\u00140\u0001\u0004I\u0003b\u0002\u001c\u0001\u0005\u0004%IaN\u0001\u000bG\"LG\u000eZ*uCR\u001cX#\u0001\u001d\u0011\u0005)J\u0014B\u0001\u001e\u0005\u0005)\u0019F/\u0019;jgRL7m\u001d\u0005\u0007y\u0001\u0001\u000b\u0011\u0002\u001d\u0002\u0017\rD\u0017\u000e\u001c3Ti\u0006$8\u000f\t\u0005\b}\u0001\u0011\r\u0011\"\u0003@\u0003-\u0019w\u000e\\*uCR\u001cX*\u00199\u0016\u0003\u0001\u0003\"aM!\n\u0005\t\u0013!AD\"pYVlgn\u0015;biNl\u0015\r\u001d\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002!\u0002\u0019\r|Gn\u0015;biNl\u0015\r\u001d\u0011\t\u000b\u0019\u0003A\u0011A$\u0002\u0011\u0015\u001cH/[7bi\u0016,\u0012\u0001\u0013\t\u0004+%C\u0014B\u0001&\u0017\u0005\u0019y\u0005\u000f^5p]\")A\n\u0001C\u0001\u001b\u0006Q2-\u00197dk2\fG/\u001a$jYR,'oU3mK\u000e$\u0018N^5usR\u0019aJ\u0015.\u0011\u0007UIu\n\u0005\u0002\u0016!&\u0011\u0011K\u0006\u0002\u0007\t>,(\r\\3\t\u000bM[\u0005\u0019\u0001+\u0002\u0013\r|g\u000eZ5uS>t\u0007CA+Y\u001b\u00051&BA,\t\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005e3&AC#yaJ,7o]5p]\"91l\u0013I\u0001\u0002\u0004a\u0016AB;qI\u0006$X\r\u0005\u0002\u0016;&\u0011aL\u0006\u0002\b\u0005>|G.Z1o\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0003a\u0019\u0017\r\\2vY\u0006$XmU5oO2,7i\u001c8eSRLwN\u001c\u000b\u0004\u001d\n\u001c\u0007\"B*`\u0001\u0004!\u0006\"B.`\u0001\u0004a\u0006\"B3\u0001\t\u00031\u0017!E3wC2,\u0018\r^3Ok2d7\t[3dWR!aj\u001a7o\u0011\u0015AG\r1\u0001j\u0003\u0011\tG\u000f\u001e:\u0011\u0005US\u0017BA6W\u0005%\tE\u000f\u001e:jEV$X\rC\u0003nI\u0002\u0007A,\u0001\u0004jg:+H\u000e\u001c\u0005\u00067\u0012\u0004\r\u0001\u0018\u0005\u0006a\u0002!\t!]\u0001\u000fKZ\fG.^1uK\nKg.\u0019:z)\u0015q%o\u001e=~\u0011\u0015\u0019x\u000e1\u0001u\u0003\ty\u0007\u000f\u0005\u0002Vk&\u0011aO\u0016\u0002\u0011\u0005&t\u0017M]=D_6\u0004\u0018M]5t_:DQ\u0001[8A\u0002%DQ!_8A\u0002i\fq\u0001\\5uKJ\fG\u000e\u0005\u0002Vw&\u0011AP\u0016\u0002\b\u0019&$XM]1m\u0011\u0015Yv\u000e1\u0001]\u0011\u0019y\b\u0001\"\u0001\u0002\u0002\u0005\u0001RM^1mk\u0006$X-R9vC2LG/\u001f\u000b\b\u001d\u0006\r\u0011QAA\u0004\u0011\u0015Ag\u00101\u0001j\u0011\u0015Ih\u00101\u0001{\u0011\u0015Yf\u00101\u0001]\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001b\tq\"\u001a<bYV\fG/\u001a'ji\u0016\u0014\u0018\r\u001c\u000b\u0004\u001d\u0006=\u0001BB=\u0002\n\u0001\u0007!\u0010C\u0004\u0002\u0014\u0001!\t!!\u0006\u0002\u001b\u00154\u0018\r\\;bi\u0016LenU3u)\u001dq\u0015qCA\r\u0003sAa\u0001[A\t\u0001\u0004I\u0007\u0002CA\u000e\u0003#\u0001\r!!\b\u0002\t!\u001cV\r\u001e\t\u0007\u0003?\ti#a\r\u000f\t\u0005\u0005\u0012\u0011\u0006\t\u0004\u0003G1RBAA\u0013\u0015\r\t9CE\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-b#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003_\t\tDA\u0002TKRT1!a\u000b\u0017!\r)\u0012QG\u0005\u0004\u0003o1\"aA!os\"11,!\u0005A\u0002qCq!!\u0010\u0001\t\u0003\ty$\u0001\rfm\u0006dW/\u0019;f\u0005&t\u0017M]=G_JtU/\\3sS\u000e$\u0012BTA!\u0003\u0007\n)%a\u0012\t\rM\fY\u00041\u0001u\u0011\u0019A\u00171\ba\u0001S\"1\u00110a\u000fA\u0002iDaaWA\u001e\u0001\u0004a\u0006bBA&\u0001\u0011%\u0011QJ\u0001&G>l\u0007/\u001e;f\u000bF,\u0018\r\\5usB{7o]5cS2LG/\u001f\"z\u0011&\u001cHo\\4sC6$RaTA(\u0003#Ba!_A%\u0001\u0004Q\b\u0002CA*\u0003\u0013\u0002\r!!\u0016\u0002\u000f\r|Gn\u0015;biB\u0019!&a\u0016\n\u0007\u0005eCA\u0001\u0006D_2,XN\\*uCRDq!!\u0018\u0001\t\u0013\ty&A\u0014d_6\u0004X\u000f^3D_6\u0004\u0018M]5t_:\u0004vn]:jE&d\u0017\u000e^=Cs\"K7\u000f^8he\u0006lGcB(\u0002b\u0005\r\u0014Q\r\u0005\u0007g\u0006m\u0003\u0019\u0001;\t\re\fY\u00061\u0001{\u0011!\t\u0019&a\u0017A\u0002\u0005U\u0003bBA5\u0001\u0011\u0005\u00111N\u0001\u001cKZ\fG.^1uK\nKg.\u0019:z\r>\u0014Hk^8D_2,XN\\:\u0015\u00139\u000bi'a\u001c\u0002t\u0005]\u0004BB:\u0002h\u0001\u0007A\u000fC\u0004\u0002r\u0005\u001d\u0004\u0019A5\u0002\u0011\u0005$HO\u001d'fMRDq!!\u001e\u0002h\u0001\u0007\u0011.A\u0005biR\u0014(+[4ii\"11,a\u001aA\u0002qC\u0011\"a\u001f\u0001\u0003\u0003%\t!! \u0002\t\r|\u0007/\u001f\u000b\u0004e\u0005}\u0004\u0002C\u0014\u0002zA\u0005\t\u0019A\u0015\t\u0013\u0005\r\u0005!%A\u0005\u0002\u0005\u0015\u0015\u0001J2bY\u000e,H.\u0019;f\r&dG/\u001a:TK2,7\r^5wSRLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u001d%f\u0001/\u0002\n.\u0012\u00111\u0012\t\u0005\u0003\u001b\u000b9*\u0004\u0002\u0002\u0010*!\u0011\u0011SAJ\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0016Z\t!\"\u00198o_R\fG/[8o\u0013\u0011\tI*a$\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002\u001e\u0002\t\n\u0011\"\u0001\u0002 \u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAQU\rI\u0013\u0011\u0012\u0005\n\u0003K\u0003\u0011\u0011!C!\u0003O\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAU!\u0011\tY+!.\u000e\u0005\u00055&\u0002BAX\u0003c\u000bA\u0001\\1oO*\u0011\u00111W\u0001\u0005U\u00064\u0018-\u0003\u0003\u00028\u00065&AB*ue&tw\rC\u0005\u0002<\u0002\t\t\u0011\"\u0001\u0002>\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0018\t\u0004+\u0005\u0005\u0017bAAb-\t\u0019\u0011J\u001c;\t\u0013\u0005\u001d\u0007!!A\u0005\u0002\u0005%\u0017A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003g\tY\r\u0003\u0006\u0002N\u0006\u0015\u0017\u0011!a\u0001\u0003\u007f\u000b1\u0001\u001f\u00132\u0011%\t\t\u000eAA\u0001\n\u0003\n\u0019.A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u000e\u0005\u0004\u0002X\u0006u\u00171G\u0007\u0003\u00033T1!a7\u0017\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003?\fIN\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t\u0019\u000fAA\u0001\n\u0003\t)/\u0001\u0005dC:,\u0015/^1m)\ra\u0016q\u001d\u0005\u000b\u0003\u001b\f\t/!AA\u0002\u0005M\u0002\"CAv\u0001\u0005\u0005I\u0011IAw\u0003!A\u0017m\u001d5D_\u0012,GCAA`\u0011%\t\t\u0010AA\u0001\n\u0003\n\u00190\u0001\u0005u_N#(/\u001b8h)\t\tI\u000bC\u0005\u0002x\u0002\t\t\u0011\"\u0011\u0002z\u00061Q-];bYN$2\u0001XA~\u0011)\ti-!>\u0002\u0002\u0003\u0007\u00111G\u0004\n\u0003\u007f\u0014\u0011\u0011!E\u0001\u0005\u0003\t\u0001CR5mi\u0016\u0014Xi\u001d;j[\u0006$\u0018n\u001c8\u0011\u0007M\u0012\u0019A\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001B\u0003'\u0015\u0011\u0019Aa\u0002$!\u0019\u0011IAa\u0004*e5\u0011!1\u0002\u0006\u0004\u0005\u001b1\u0012a\u0002:v]RLW.Z\u0005\u0005\u0005#\u0011YAA\tBEN$(/Y2u\rVt7\r^5p]FBq\u0001\rB\u0002\t\u0003\u0011)\u0002\u0006\u0002\u0003\u0002!Q\u0011\u0011\u001fB\u0002\u0003\u0003%)%a=\t\u0015\tm!1AA\u0001\n\u0003\u0013i\"A\u0003baBd\u0017\u0010F\u00023\u0005?Aaa\nB\r\u0001\u0004I\u0003B\u0003B\u0012\u0005\u0007\t\t\u0011\"!\u0003&\u00059QO\\1qa2LH\u0003\u0002B\u0014\u0005S\u00012!F%*\u0011%\u0011YC!\t\u0002\u0002\u0003\u0007!'A\u0002yIAB!Ba\f\u0003\u0004\u0005\u0005I\u0011\u0002B\u0019\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tM\u0002\u0003BAV\u0005kIAAa\u000e\u0002.\n1qJ\u00196fGR\u0004")
public class FilterEstimation
implements Logging,
Product,
scala.Serializable {
    private final Filter plan;
    private final Statistics childStats;
    private final ColumnStatsMap colStatsMap;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static /* bridge */ Object apply(Object object) {
        return FilterEstimation$.MODULE$.apply(object);
    }

    public static Option<Filter> unapply(FilterEstimation filterEstimation) {
        return FilterEstimation$.MODULE$.unapply(filterEstimation);
    }

    public static FilterEstimation apply(Filter filter) {
        return FilterEstimation$.MODULE$.apply(filter);
    }

    public static <A> Function1<Filter, A> andThen(Function1<FilterEstimation, A> function1) {
        return FilterEstimation$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, FilterEstimation> compose(Function1<A, Filter> function1) {
        return FilterEstimation$.MODULE$.compose(function1);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Filter plan() {
        return this.plan;
    }

    private Statistics childStats() {
        return this.childStats;
    }

    private ColumnStatsMap colStatsMap() {
        return this.colStatsMap;
    }

    public Option<Statistics> estimate() {
        if (this.childStats().rowCount().isEmpty()) {
            return None$.MODULE$;
        }
        double filterSelectivity = BoxesRunTime.unboxToDouble((Object)this.calculateFilterSelectivity(this.plan().condition(), this.calculateFilterSelectivity$default$2()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0));
        BigInt filteredRowCount = EstimationUtils$.MODULE$.ceil(package$.MODULE$.BigDecimal().apply((BigInt)this.childStats().rowCount().get()).$times(BigDecimal$.MODULE$.double2bigDecimal(filterSelectivity)));
        AttributeMap<ColumnStat> newColStats = BoxesRunTime.equalsNumObject((Number)filteredRowCount, (Object)BoxesRunTime.boxToInteger((int)0)) ? AttributeMap$.MODULE$.apply(Nil$.MODULE$) : this.colStatsMap().outputColumnStats((BigInt)this.childStats().rowCount().get(), filteredRowCount);
        BigInt filteredSizeInBytes = EstimationUtils$.MODULE$.getOutputSize(this.plan().output(), filteredRowCount, newColStats);
        return new Some((Object)this.childStats().copy(filteredSizeInBytes, (Option<BigInt>)new Some((Object)filteredRowCount), newColStats, this.childStats().copy$default$4()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Object> calculateFilterSelectivity(Expression condition, boolean update) {
        Some some;
        Literal literal;
        Object object;
        Expression l;
        Expression expression;
        Expression expression2;
        boolean bl = false;
        Not not = null;
        Expression expression3 = condition;
        if (expression3 instanceof And) {
            And and = (And)expression3;
            Expression cond1 = and.left();
            Expression cond2 = and.right();
            double percent1 = BoxesRunTime.unboxToDouble((Object)this.calculateFilterSelectivity(cond1, update).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0));
            double percent2 = BoxesRunTime.unboxToDouble((Object)this.calculateFilterSelectivity(cond2, update).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0));
            return new Some((Object)BoxesRunTime.boxToDouble((double)(percent1 * percent2)));
        }
        if (expression3 instanceof Or) {
            Or or = (Or)expression3;
            Expression cond1 = or.left();
            Expression cond2 = or.right();
            double percent1 = BoxesRunTime.unboxToDouble((Object)this.calculateFilterSelectivity(cond1, false).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0));
            double percent2 = BoxesRunTime.unboxToDouble((Object)this.calculateFilterSelectivity(cond2, false).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0));
            return new Some((Object)BoxesRunTime.boxToDouble((double)(percent1 + percent2 - percent1 * percent2)));
        }
        if (expression3 instanceof Not) {
            bl = true;
            not = (Not)expression3;
            Expression expression4 = not.child();
            if (expression4 instanceof And) {
                And and = (And)expression4;
                Expression cond1 = and.left();
                Expression cond2 = and.right();
                return this.calculateFilterSelectivity(new Or(new Not(cond1), new Not(cond2)), false);
            }
        }
        if (bl && (expression2 = not.child()) instanceof Or) {
            Or or = (Or)expression2;
            Expression cond1 = or.left();
            Expression cond2 = or.right();
            return this.calculateFilterSelectivity(new And(new Not(cond1), new Not(cond2)), false);
        }
        if (bl && (expression = not.child()) instanceof Not) {
            Not not2 = (Not)expression;
            Expression cond = not2.child();
            return this.calculateFilterSelectivity(cond, false);
        }
        if (bl && (l = not.child()) instanceof Literal && (object = (literal = (Literal)l).value()) == null) {
            return this.calculateSingleCondition(literal, false);
        }
        if (!bl) return this.calculateSingleCondition(condition, update);
        Expression cond = not.child();
        Option<Object> option = this.calculateFilterSelectivity(cond, false);
        if (option instanceof Some) {
            Some some2 = (Some)option;
            double percent = BoxesRunTime.unboxToDouble((Object)some2.value());
            some = new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - percent)));
            return some;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            some = None$.MODULE$;
        }
        return some;
    }

    public boolean calculateFilterSelectivity$default$2() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Object> calculateSingleCondition(Expression condition, boolean update) {
        Option<Tuple2<Expression, Expression>> option;
        IsNotNull isNotNull;
        Expression ar;
        IsNull isNull;
        Expression ar2;
        Option<Tuple2<Expression, Expression>> option2;
        boolean bl = false;
        BinaryComparison binaryComparison = null;
        boolean bl2 = false;
        LessThan lessThan = null;
        boolean bl3 = false;
        LessThanOrEqual lessThanOrEqual = null;
        boolean bl4 = false;
        GreaterThan greaterThan = null;
        boolean bl5 = false;
        GreaterThanOrEqual greaterThanOrEqual = null;
        Expression expression = condition;
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            return this.evaluateLiteral(literal);
        }
        if (expression instanceof BinaryComparison) {
            bl = true;
            binaryComparison = (BinaryComparison)expression;
            Option<Tuple2<Expression, Expression>> option3 = Equality$.MODULE$.unapply(binaryComparison);
            if (!option3.isEmpty()) {
                Expression ar3 = (Expression)((Tuple2)option3.get())._1();
                Expression l = (Expression)((Tuple2)option3.get())._2();
                if (ar3 instanceof Attribute) {
                    Attribute attribute = (Attribute)ar3;
                    if (l instanceof Literal) {
                        Literal literal = (Literal)l;
                        return this.evaluateEquality(attribute, literal, update);
                    }
                }
            }
        }
        if (bl && !(option2 = Equality$.MODULE$.unapply(binaryComparison)).isEmpty()) {
            Expression l = (Expression)((Tuple2)option2.get())._1();
            Expression ar4 = (Expression)((Tuple2)option2.get())._2();
            if (l instanceof Literal) {
                Literal literal = (Literal)l;
                if (ar4 instanceof Attribute) {
                    Attribute attribute = (Attribute)ar4;
                    return this.evaluateEquality(attribute, literal, update);
                }
            }
        }
        if (expression instanceof LessThan) {
            bl2 = true;
            lessThan = (LessThan)expression;
            Expression ar5 = lessThan.left();
            Expression l = lessThan.right();
            if (ar5 instanceof Attribute) {
                Attribute attribute = (Attribute)ar5;
                if (l instanceof Literal) {
                    Literal literal = (Literal)l;
                    return this.evaluateBinary(lessThan, attribute, literal, update);
                }
            }
        }
        if (bl2) {
            Expression l = lessThan.left();
            Expression ar6 = lessThan.right();
            if (l instanceof Literal) {
                Literal literal = (Literal)l;
                if (ar6 instanceof Attribute) {
                    Attribute attribute = (Attribute)ar6;
                    return this.evaluateBinary(new GreaterThan(attribute, literal), attribute, literal, update);
                }
            }
        }
        if (expression instanceof LessThanOrEqual) {
            bl3 = true;
            lessThanOrEqual = (LessThanOrEqual)expression;
            Expression ar7 = lessThanOrEqual.left();
            Expression l = lessThanOrEqual.right();
            if (ar7 instanceof Attribute) {
                Attribute attribute = (Attribute)ar7;
                if (l instanceof Literal) {
                    Literal literal = (Literal)l;
                    return this.evaluateBinary(lessThanOrEqual, attribute, literal, update);
                }
            }
        }
        if (bl3) {
            Expression l = lessThanOrEqual.left();
            Expression ar8 = lessThanOrEqual.right();
            if (l instanceof Literal) {
                Literal literal = (Literal)l;
                if (ar8 instanceof Attribute) {
                    Attribute attribute = (Attribute)ar8;
                    return this.evaluateBinary(new GreaterThanOrEqual(attribute, literal), attribute, literal, update);
                }
            }
        }
        if (expression instanceof GreaterThan) {
            bl4 = true;
            greaterThan = (GreaterThan)expression;
            Expression ar9 = greaterThan.left();
            Expression l = greaterThan.right();
            if (ar9 instanceof Attribute) {
                Attribute attribute = (Attribute)ar9;
                if (l instanceof Literal) {
                    Literal literal = (Literal)l;
                    return this.evaluateBinary(greaterThan, attribute, literal, update);
                }
            }
        }
        if (bl4) {
            Expression l = greaterThan.left();
            Expression ar10 = greaterThan.right();
            if (l instanceof Literal) {
                Literal literal = (Literal)l;
                if (ar10 instanceof Attribute) {
                    Attribute attribute = (Attribute)ar10;
                    return this.evaluateBinary(new LessThan(attribute, literal), attribute, literal, update);
                }
            }
        }
        if (expression instanceof GreaterThanOrEqual) {
            bl5 = true;
            greaterThanOrEqual = (GreaterThanOrEqual)expression;
            Expression ar11 = greaterThanOrEqual.left();
            Expression l = greaterThanOrEqual.right();
            if (ar11 instanceof Attribute) {
                Attribute attribute = (Attribute)ar11;
                if (l instanceof Literal) {
                    Literal literal = (Literal)l;
                    return this.evaluateBinary(greaterThanOrEqual, attribute, literal, update);
                }
            }
        }
        if (bl5) {
            Expression l = greaterThanOrEqual.left();
            Expression ar12 = greaterThanOrEqual.right();
            if (l instanceof Literal) {
                Literal literal = (Literal)l;
                if (ar12 instanceof Attribute) {
                    Attribute attribute = (Attribute)ar12;
                    return this.evaluateBinary(new LessThanOrEqual(attribute, literal), attribute, literal, update);
                }
            }
        }
        if (expression instanceof In) {
            In in = (In)expression;
            Expression ar13 = in.value();
            Seq<Expression> expList = in.list();
            if (ar13 instanceof Attribute) {
                Attribute attribute = (Attribute)ar13;
                if (expList.forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)FilterEstimation.$anonfun$calculateSingleCondition$1(e)))) {
                    Seq hSet = (Seq)expList.map((Function1 & Serializable & scala.Serializable)e -> e.eval(e.eval$default$1()), Seq$.MODULE$.canBuildFrom());
                    return this.evaluateInSet(attribute, (Set<Object>)((Set)((SetLike)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)hSet)), update);
                }
            }
        }
        if (expression instanceof InSet) {
            InSet inSet = (InSet)expression;
            Expression ar14 = inSet.child();
            Set<Object> set = inSet.hset();
            if (ar14 instanceof Attribute) {
                Attribute attribute = (Attribute)ar14;
                return this.evaluateInSet(attribute, set, update);
            }
        }
        if (expression instanceof IsNull && (ar2 = (isNull = (IsNull)expression).child()) instanceof Attribute) {
            Attribute attribute = (Attribute)ar2;
            if (this.plan().child() instanceof LeafNode) {
                return this.evaluateNullCheck(attribute, true, update);
            }
        }
        if (expression instanceof IsNotNull && (ar = (isNotNull = (IsNotNull)expression).child()) instanceof Attribute) {
            Attribute attribute = (Attribute)ar;
            if (this.plan().child() instanceof LeafNode) {
                return this.evaluateNullCheck(attribute, false, update);
            }
        }
        if (bl && !(option = Equality$.MODULE$.unapply(binaryComparison)).isEmpty()) {
            Expression attrLeft = (Expression)((Tuple2)option.get())._1();
            Expression attrRight = (Expression)((Tuple2)option.get())._2();
            if (attrLeft instanceof Attribute) {
                Attribute attribute = (Attribute)attrLeft;
                if (attrRight instanceof Attribute) {
                    Attribute attribute2 = (Attribute)attrRight;
                    return this.evaluateBinaryForTwoColumns(binaryComparison, attribute, attribute2, update);
                }
            }
        }
        if (bl2) {
            Expression attrLeft = lessThan.left();
            Expression attrRight = lessThan.right();
            if (attrLeft instanceof Attribute) {
                Attribute attribute = (Attribute)attrLeft;
                if (attrRight instanceof Attribute) {
                    Attribute attribute3 = (Attribute)attrRight;
                    return this.evaluateBinaryForTwoColumns(lessThan, attribute, attribute3, update);
                }
            }
        }
        if (bl3) {
            Expression attrLeft = lessThanOrEqual.left();
            Expression attrRight = lessThanOrEqual.right();
            if (attrLeft instanceof Attribute) {
                Attribute attribute = (Attribute)attrLeft;
                if (attrRight instanceof Attribute) {
                    Attribute attribute4 = (Attribute)attrRight;
                    return this.evaluateBinaryForTwoColumns(lessThanOrEqual, attribute, attribute4, update);
                }
            }
        }
        if (bl4) {
            Expression attrLeft = greaterThan.left();
            Expression attrRight = greaterThan.right();
            if (attrLeft instanceof Attribute) {
                Attribute attribute = (Attribute)attrLeft;
                if (attrRight instanceof Attribute) {
                    Attribute attribute5 = (Attribute)attrRight;
                    return this.evaluateBinaryForTwoColumns(greaterThan, attribute, attribute5, update);
                }
            }
        }
        if (bl5) {
            Expression attrLeft = greaterThanOrEqual.left();
            Expression attrRight = greaterThanOrEqual.right();
            if (attrLeft instanceof Attribute) {
                Attribute attribute = (Attribute)attrLeft;
                if (attrRight instanceof Attribute) {
                    Attribute attribute6 = (Attribute)attrRight;
                    return this.evaluateBinaryForTwoColumns(greaterThanOrEqual, attribute, attribute6, update);
                }
            }
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("[CBO] Unsupported filter condition: ").append(condition).toString());
        return None$.MODULE$;
    }

    public Option<Object> evaluateNullCheck(Attribute attr, boolean isNull, boolean update) {
        double nullPercent;
        if (!this.colStatsMap().contains(attr) || !this.colStatsMap().apply(attr).hasCountStats()) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("[CBO] No statistics for ").append(attr).toString());
            return None$.MODULE$;
        }
        ColumnStat colStat = this.colStatsMap().apply(attr);
        BigInt rowCountValue = (BigInt)this.childStats().rowCount().get();
        double d = nullPercent = BoxesRunTime.equalsNumObject((Number)rowCountValue, (Object)BoxesRunTime.boxToInteger((int)0)) ? 0.0 : package$.MODULE$.BigDecimal().apply((BigInt)colStat.nullCount().get()).$div(package$.MODULE$.BigDecimal().apply(rowCountValue)).toDouble();
        if (update) {
            ColumnStat columnStat;
            if (isNull) {
                columnStat = colStat.copy((Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, colStat.copy$default$4(), colStat.copy$default$5(), colStat.copy$default$6(), colStat.copy$default$7());
            } else {
                Some x$10 = new Some((Object)BigInt$.MODULE$.int2bigInt(0));
                Option<BigInt> x$11 = colStat.copy$default$1();
                Option<Object> x$12 = colStat.copy$default$2();
                Option<Object> x$13 = colStat.copy$default$3();
                Option<Object> x$14 = colStat.copy$default$5();
                Option<Object> x$15 = colStat.copy$default$6();
                Option<Histogram> x$16 = colStat.copy$default$7();
                columnStat = colStat.copy(x$11, x$12, x$13, (Option<BigInt>)x$10, x$14, x$15, x$16);
            }
            ColumnStat newStats = columnStat;
            this.colStatsMap().update(attr, newStats);
        }
        double percent = isNull ? nullPercent : 1.0 - nullPercent;
        return new Some((Object)BoxesRunTime.boxToDouble((double)percent));
    }

    public Option<Object> evaluateBinary(BinaryComparison op, Attribute attr, Literal literal, boolean update) {
        None$ none$;
        if (!this.colStatsMap().contains(attr)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("[CBO] No statistics for ").append(attr).toString());
            return None$.MODULE$;
        }
        DataType dataType = attr.dataType();
        boolean bl = dataType instanceof NumericType ? true : (DateType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : BooleanType$.MODULE$.equals(dataType)));
        if (bl) {
            none$ = this.evaluateBinaryForNumeric(op, attr, literal, update);
        } else {
            boolean bl2 = StringType$.MODULE$.equals(dataType) ? true : BinaryType$.MODULE$.equals(dataType);
            if (bl2) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("[CBO] No range comparison statistics for String/Binary type ").append(attr).toString());
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)dataType);
            }
        }
        return none$;
    }

    public Option<Object> evaluateEquality(Attribute attr, Literal literal, boolean update) {
        Object object;
        if (!this.colStatsMap().contains(attr)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("[CBO] No statistics for ").append(attr).toString());
            return None$.MODULE$;
        }
        ColumnStat colStat = this.colStatsMap().apply(attr);
        ValueInterval statsInterval = ValueInterval$.MODULE$.apply(colStat.min(), colStat.max(), attr.dataType());
        if (statsInterval.contains(literal)) {
            if (update) {
                ColumnStat columnStat;
                DataType dataType = attr.dataType();
                boolean bl = StringType$.MODULE$.equals(dataType) ? true : BinaryType$.MODULE$.equals(dataType);
                if (bl) {
                    Some x$17 = new Some((Object)BigInt$.MODULE$.int2bigInt(1));
                    Some x$18 = new Some((Object)BigInt$.MODULE$.int2bigInt(0));
                    Option<Object> x$19 = colStat.copy$default$2();
                    Option<Object> x$20 = colStat.copy$default$3();
                    Option<Object> x$21 = colStat.copy$default$5();
                    Option<Object> x$22 = colStat.copy$default$6();
                    Option<Histogram> x$23 = colStat.copy$default$7();
                    columnStat = colStat.copy((Option<BigInt>)x$17, x$19, x$20, (Option<BigInt>)x$18, x$21, x$22, x$23);
                } else {
                    columnStat = colStat.copy((Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option<Object>)new Some(literal.value()), (Option<Object>)new Some(literal.value()), (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), colStat.copy$default$5(), colStat.copy$default$6(), colStat.copy$default$7());
                }
                ColumnStat newStats = columnStat;
                this.colStatsMap().update(attr, newStats);
            }
            object = colStat.histogram().isEmpty() ? (!colStat.distinctCount().isEmpty() ? new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 / ((ScalaNumericAnyConversions)colStat.distinctCount().get()).toDouble()))) : None$.MODULE$) : new Some((Object)BoxesRunTime.boxToDouble((double)this.computeEqualityPossibilityByHistogram(literal, colStat)));
        } else {
            object = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
        }
        return object;
    }

    public Option<Object> evaluateLiteral(Literal literal) {
        Object object;
        Object object2;
        Literal literal2 = literal;
        if (literal2 != null && (object2 = literal2.value()) == null) {
            object = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
        } else {
            Literal literal3 = Literal$.MODULE$.FalseLiteral();
            Literal literal4 = literal2;
            if (!(literal3 != null ? !((Object)literal3).equals(literal4) : literal4 != null)) {
                object = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
            } else {
                Literal literal5 = Literal$.MODULE$.TrueLiteral();
                Literal literal6 = literal2;
                object = !(literal5 != null ? !((Object)literal5).equals(literal6) : literal6 != null) ? new Some((Object)BoxesRunTime.boxToDouble((double)1.0)) : None$.MODULE$;
            }
        }
        return object;
    }

    public Option<Object> evaluateInSet(Attribute attr, Set<Object> hSet, boolean update) {
        if (!this.colStatsMap().hasDistinctCount(attr)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("[CBO] No statistics for ").append(attr).toString());
            return None$.MODULE$;
        }
        ColumnStat colStat = this.colStatsMap().apply(attr);
        BigInt ndv = (BigInt)colStat.distinctCount().get();
        DataType dataType = attr.dataType();
        BigInt newNdv = ndv;
        DataType dataType2 = dataType;
        boolean bl = dataType2 instanceof NumericType ? true : (BooleanType$.MODULE$.equals(dataType2) ? true : (DateType$.MODULE$.equals(dataType2) ? true : TimestampType$.MODULE$.equals(dataType2)));
        if (bl) {
            BoxedUnit boxedUnit;
            if (ndv.toDouble() == 0.0 || colStat.min().isEmpty() || colStat.max().isEmpty()) {
                return new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
            }
            NumericValueInterval statsInterval = (NumericValueInterval)ValueInterval$.MODULE$.apply(colStat.min(), colStat.max(), dataType);
            Set validQuerySet = (Set)hSet.filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)FilterEstimation.$anonfun$evaluateInSet$2(dataType, statsInterval, v)));
            if (validQuerySet.isEmpty()) {
                return new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
            }
            Object newMax = validQuerySet.maxBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)EstimationUtils$.MODULE$.toDouble(x$1, dataType)), (Ordering)Ordering.Double$.MODULE$);
            Object newMin = validQuerySet.minBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)EstimationUtils$.MODULE$.toDouble(x$2, dataType)), (Ordering)Ordering.Double$.MODULE$);
            newNdv = ndv.min(package$.MODULE$.BigInt().apply(validQuerySet.size()));
            if (update) {
                ColumnStat newStats = colStat.copy((Option<BigInt>)new Some((Object)newNdv), (Option<Object>)new Some(newMin), (Option<Object>)new Some(newMax), (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), colStat.copy$default$5(), colStat.copy$default$6(), colStat.copy$default$7());
                this.colStatsMap().update(attr, newStats);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            boolean bl2 = StringType$.MODULE$.equals(dataType2) ? true : BinaryType$.MODULE$.equals(dataType2);
            if (bl2) {
                BoxedUnit boxedUnit;
                if (ndv.toDouble() == 0.0) {
                    return new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
                }
                newNdv = ndv.min(package$.MODULE$.BigInt().apply(hSet.size()));
                if (update) {
                    Some x$24 = new Some((Object)newNdv);
                    Some x$25 = new Some((Object)BigInt$.MODULE$.int2bigInt(0));
                    Option<Object> x$26 = colStat.copy$default$2();
                    Option<Object> x$27 = colStat.copy$default$3();
                    Option<Object> x$28 = colStat.copy$default$5();
                    Option<Object> x$29 = colStat.copy$default$6();
                    Option<Histogram> x$30 = colStat.copy$default$7();
                    ColumnStat newStats = colStat.copy((Option<BigInt>)x$24, x$26, x$27, (Option<BigInt>)x$25, x$28, x$29, x$30);
                    this.colStatsMap().update(attr, newStats);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            } else {
                throw new MatchError((Object)dataType2);
            }
        }
        return new Some((Object)BoxesRunTime.boxToDouble((double)scala.math.package$.MODULE$.min(newNdv.toDouble() / ndv.toDouble(), 1.0)));
    }

    public Option<Object> evaluateBinaryForNumeric(BinaryComparison op, Attribute attr, Literal literal, boolean update) {
        Tuple2.mcZZ.sp sp2;
        if (!this.colStatsMap().hasMinMaxStats(attr) || !this.colStatsMap().hasDistinctCount(attr)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("[CBO] No statistics for ").append(attr).toString());
            return None$.MODULE$;
        }
        ColumnStat colStat = this.colStatsMap().apply(attr);
        NumericValueInterval statsInterval = (NumericValueInterval)ValueInterval$.MODULE$.apply(colStat.min(), colStat.max(), attr.dataType());
        double max = statsInterval.max();
        double min = statsInterval.min();
        double ndv = ((ScalaNumericAnyConversions)colStat.distinctCount().get()).toDouble();
        double numericLiteral = EstimationUtils$.MODULE$.toDouble(literal.value(), literal.dataType());
        BinaryComparison binaryComparison = op;
        if (binaryComparison instanceof LessThan) {
            sp2 = new Tuple2.mcZZ.sp(numericLiteral <= min, numericLiteral > max);
        } else if (binaryComparison instanceof LessThanOrEqual) {
            sp2 = new Tuple2.mcZZ.sp(numericLiteral < min, numericLiteral >= max);
        } else if (binaryComparison instanceof GreaterThan) {
            sp2 = new Tuple2.mcZZ.sp(numericLiteral >= max, numericLiteral < min);
        } else if (binaryComparison instanceof GreaterThanOrEqual) {
            sp2 = new Tuple2.mcZZ.sp(numericLiteral > max, numericLiteral <= min);
        } else {
            throw new MatchError((Object)binaryComparison);
        }
        Tuple2.mcZZ.sp sp3 = sp2;
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        boolean noOverlap = sp3._1$mcZ$sp();
        boolean completeOverlap = sp3._2$mcZ$sp();
        boolean bl = noOverlap;
        boolean bl2 = completeOverlap;
        Tuple2.mcZZ.sp sp4 = new Tuple2.mcZZ.sp(bl, bl2);
        Tuple2.mcZZ.sp sp5 = sp4;
        boolean noOverlap2 = sp5._1$mcZ$sp();
        boolean completeOverlap2 = sp5._2$mcZ$sp();
        double percent = 1.0;
        if (noOverlap2) {
            percent = 0.0;
        } else if (completeOverlap2) {
            percent = 1.0;
        } else {
            if (colStat.histogram().isEmpty()) {
                double d;
                Predef$.MODULE$.assert(max > min);
                BinaryComparison binaryComparison2 = op;
                if (binaryComparison2 instanceof LessThan) {
                    d = numericLiteral == max ? 1.0 - 1.0 / ndv : (numericLiteral - min) / (max - min);
                } else if (binaryComparison2 instanceof LessThanOrEqual) {
                    d = numericLiteral == min ? 1.0 / ndv : (numericLiteral - min) / (max - min);
                } else if (binaryComparison2 instanceof GreaterThan) {
                    d = numericLiteral == min ? 1.0 - 1.0 / ndv : (max - numericLiteral) / (max - min);
                } else if (binaryComparison2 instanceof GreaterThanOrEqual) {
                    d = numericLiteral == max ? 1.0 / ndv : (max - numericLiteral) / (max - min);
                } else {
                    throw new MatchError((Object)binaryComparison2);
                }
                percent = d;
            } else {
                percent = this.computeComparisonPossibilityByHistogram(op, literal, colStat);
            }
            if (update) {
                Some newValue = new Some(literal.value());
                Some newMax = colStat.max();
                Some newMin = colStat.min();
                BinaryComparison binaryComparison3 = op;
                boolean bl3 = binaryComparison3 instanceof GreaterThan ? true : binaryComparison3 instanceof GreaterThanOrEqual;
                if (bl3) {
                    newMin = newValue;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    boolean bl4 = binaryComparison3 instanceof LessThan ? true : binaryComparison3 instanceof LessThanOrEqual;
                    if (bl4) {
                        newMax = newValue;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)binaryComparison3);
                    }
                }
                ColumnStat newStats = colStat.copy((Option<BigInt>)new Some((Object)EstimationUtils$.MODULE$.ceil(BigDecimal$.MODULE$.double2bigDecimal(ndv * percent))), (Option<Object>)newMin, (Option<Object>)newMax, (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), colStat.copy$default$5(), colStat.copy$default$6(), colStat.copy$default$7());
                this.colStatsMap().update(attr, newStats);
            }
        }
        return new Some((Object)BoxesRunTime.boxToDouble((double)percent));
    }

    private double computeEqualityPossibilityByHistogram(Literal literal, ColumnStat colStat) {
        double datum = EstimationUtils$.MODULE$.toDouble(literal.value(), literal.dataType());
        Histogram histogram = (Histogram)colStat.histogram().get();
        double min = EstimationUtils$.MODULE$.toDouble(colStat.min().get(), literal.dataType());
        double max = EstimationUtils$.MODULE$.toDouble(colStat.max().get(), literal.dataType());
        double numBinsHoldingEntireRange = EstimationUtils$.MODULE$.numBinsHoldingRange(max, true, min, true, histogram.bins());
        double numBinsHoldingDatum = EstimationUtils$.MODULE$.numBinsHoldingRange(datum, true, datum, true, histogram.bins());
        return numBinsHoldingDatum / numBinsHoldingEntireRange;
    }

    private double computeComparisonPossibilityByHistogram(BinaryComparison op, Literal literal, ColumnStat colStat) {
        double d;
        double datum = EstimationUtils$.MODULE$.toDouble(literal.value(), literal.dataType());
        Histogram histogram = (Histogram)colStat.histogram().get();
        double min = EstimationUtils$.MODULE$.toDouble(colStat.min().get(), literal.dataType());
        double max = EstimationUtils$.MODULE$.toDouble(colStat.max().get(), literal.dataType());
        double numBinsHoldingEntireRange = EstimationUtils$.MODULE$.numBinsHoldingRange(max, true, min, true, histogram.bins());
        BinaryComparison binaryComparison = op;
        if (binaryComparison instanceof LessThan) {
            d = EstimationUtils$.MODULE$.numBinsHoldingRange(datum, false, min, true, histogram.bins());
        } else if (binaryComparison instanceof LessThanOrEqual) {
            d = EstimationUtils$.MODULE$.numBinsHoldingRange(datum, true, min, true, histogram.bins());
        } else if (binaryComparison instanceof GreaterThan) {
            d = EstimationUtils$.MODULE$.numBinsHoldingRange(max, true, datum, false, histogram.bins());
        } else if (binaryComparison instanceof GreaterThanOrEqual) {
            d = EstimationUtils$.MODULE$.numBinsHoldingRange(max, true, datum, true, histogram.bins());
        } else {
            throw new MatchError((Object)binaryComparison);
        }
        double numBinsHoldingRange = d;
        return numBinsHoldingRange / numBinsHoldingEntireRange;
    }

    public Option<Object> evaluateBinaryForTwoColumns(BinaryComparison op, Attribute attrLeft, Attribute attrRight, boolean update) {
        Tuple2.mcZZ.sp sp2;
        if (!this.colStatsMap().hasCountStats(attrLeft)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("[CBO] No statistics for ").append(attrLeft).toString());
            return None$.MODULE$;
        }
        if (!this.colStatsMap().hasCountStats(attrRight)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("[CBO] No statistics for ").append(attrRight).toString());
            return None$.MODULE$;
        }
        DataType dataType = attrLeft.dataType();
        boolean bl = StringType$.MODULE$.equals(dataType) ? true : BinaryType$.MODULE$.equals(dataType);
        if (bl) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("[CBO] No range comparison statistics for String/Binary type ").append(attrLeft).toString());
            return None$.MODULE$;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        ColumnStat colStatLeft = this.colStatsMap().apply(attrLeft);
        NumericValueInterval statsIntervalLeft = (NumericValueInterval)ValueInterval$.MODULE$.apply(colStatLeft.min(), colStatLeft.max(), attrLeft.dataType());
        double maxLeft = statsIntervalLeft.max();
        double minLeft = statsIntervalLeft.min();
        ColumnStat colStatRight = this.colStatsMap().apply(attrRight);
        NumericValueInterval statsIntervalRight = (NumericValueInterval)ValueInterval$.MODULE$.apply(colStatRight.min(), colStatRight.max(), attrRight.dataType());
        double maxRight = statsIntervalRight.max();
        double minRight = statsIntervalRight.min();
        boolean allNotNull = BoxesRunTime.equals((Object)colStatLeft.nullCount().get(), (Object)BoxesRunTime.boxToInteger((int)0)) && BoxesRunTime.equals((Object)colStatRight.nullCount().get(), (Object)BoxesRunTime.boxToInteger((int)0));
        BinaryComparison binaryComparison = op;
        if (binaryComparison instanceof LessThan) {
            sp2 = new Tuple2.mcZZ.sp(minLeft >= maxRight, maxLeft < minRight && allNotNull);
        } else if (binaryComparison instanceof LessThanOrEqual) {
            sp2 = new Tuple2.mcZZ.sp(minLeft > maxRight, maxLeft <= minRight && allNotNull);
        } else if (binaryComparison instanceof GreaterThan) {
            sp2 = new Tuple2.mcZZ.sp(maxLeft <= minRight, minLeft > maxRight && allNotNull);
        } else if (binaryComparison instanceof GreaterThanOrEqual) {
            sp2 = new Tuple2.mcZZ.sp(maxLeft < minRight, minLeft >= maxRight && allNotNull);
        } else if (binaryComparison instanceof EqualTo) {
            sp2 = new Tuple2.mcZZ.sp(maxLeft < minRight || maxRight < minLeft, minLeft == minRight && maxLeft == maxRight && allNotNull && BoxesRunTime.equals((Object)colStatLeft.distinctCount().get(), (Object)colStatRight.distinctCount().get()));
        } else if (binaryComparison instanceof EqualNullSafe) {
            sp2 = new Tuple2.mcZZ.sp((maxLeft < minRight || maxRight < minLeft) && allNotNull, minLeft == minRight && maxLeft == maxRight && allNotNull && BoxesRunTime.equals((Object)colStatLeft.distinctCount().get(), (Object)colStatRight.distinctCount().get()));
        } else {
            throw new MatchError((Object)binaryComparison);
        }
        Tuple2.mcZZ.sp sp3 = sp2;
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        boolean noOverlap = sp3._1$mcZ$sp();
        boolean completeOverlap = sp3._2$mcZ$sp();
        boolean bl2 = noOverlap;
        boolean bl3 = completeOverlap;
        Tuple2.mcZZ.sp sp4 = new Tuple2.mcZZ.sp(bl2, bl3);
        Tuple2.mcZZ.sp sp5 = sp4;
        boolean noOverlap2 = sp5._1$mcZ$sp();
        boolean completeOverlap2 = sp5._2$mcZ$sp();
        double percent = 1.0;
        if (noOverlap2) {
            percent = 0.0;
        } else if (completeOverlap2) {
            percent = 1.0;
        } else {
            percent = 0.3333333333333333;
            if (update) {
                BigDecimal ndvLeft = package$.MODULE$.BigDecimal().apply((BigInt)colStatLeft.distinctCount().get());
                BigInt newNdvLeft = EstimationUtils$.MODULE$.ceil(ndvLeft.$times(BigDecimal$.MODULE$.double2bigDecimal(percent)));
                BigDecimal ndvRight = package$.MODULE$.BigDecimal().apply((BigInt)colStatRight.distinctCount().get());
                BigInt newNdvRight = EstimationUtils$.MODULE$.ceil(ndvRight.$times(BigDecimal$.MODULE$.double2bigDecimal(percent)));
                Option<Object> newMaxLeft = colStatLeft.max();
                Option<Object> newMinLeft = colStatLeft.min();
                Option<Object> newMaxRight = colStatRight.max();
                Option<Object> newMinRight = colStatRight.min();
                BinaryComparison binaryComparison2 = op;
                boolean bl4 = binaryComparison2 instanceof LessThan ? true : binaryComparison2 instanceof LessThanOrEqual;
                if (bl4) {
                    BoxedUnit boxedUnit2;
                    if (minLeft > minRight) {
                        newMinRight = colStatLeft.min();
                    }
                    if (maxLeft > maxRight) {
                        newMaxLeft = colStatRight.max();
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit2;
                } else {
                    boolean bl5 = binaryComparison2 instanceof GreaterThan ? true : binaryComparison2 instanceof GreaterThanOrEqual;
                    if (bl5) {
                        BoxedUnit boxedUnit4;
                        if (minLeft < minRight) {
                            newMinLeft = colStatRight.min();
                        }
                        if (maxLeft < maxRight) {
                            newMaxRight = colStatLeft.max();
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit5 = boxedUnit4;
                    } else {
                        boolean bl6 = binaryComparison2 instanceof EqualTo ? true : binaryComparison2 instanceof EqualNullSafe;
                        if (bl6) {
                            BoxedUnit boxedUnit6;
                            if (minLeft < minRight) {
                                newMinLeft = colStatRight.min();
                            } else {
                                newMinRight = colStatLeft.min();
                            }
                            if (maxLeft < maxRight) {
                                newMaxRight = colStatLeft.max();
                                boxedUnit6 = BoxedUnit.UNIT;
                            } else {
                                newMaxLeft = colStatRight.max();
                                boxedUnit6 = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit7 = boxedUnit6;
                        } else {
                            throw new MatchError((Object)binaryComparison2);
                        }
                    }
                }
                ColumnStat newStatsLeft = colStatLeft.copy((Option<BigInt>)new Some((Object)newNdvLeft), newMinLeft, newMaxLeft, colStatLeft.copy$default$4(), colStatLeft.copy$default$5(), colStatLeft.copy$default$6(), colStatLeft.copy$default$7());
                this.colStatsMap().update(attrLeft, newStatsLeft);
                ColumnStat newStatsRight = colStatRight.copy((Option<BigInt>)new Some((Object)newNdvRight), newMinRight, newMaxRight, colStatRight.copy$default$4(), colStatRight.copy$default$5(), colStatRight.copy$default$6(), colStatRight.copy$default$7());
                this.colStatsMap().update(attrRight, newStatsRight);
            }
        }
        return new Some((Object)BoxesRunTime.boxToDouble((double)percent));
    }

    public FilterEstimation copy(Filter plan2) {
        return new FilterEstimation(plan2);
    }

    public Filter copy$default$1() {
        return this.plan();
    }

    public String productPrefix() {
        return "FilterEstimation";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.plan();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FilterEstimation;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FilterEstimation)) return false;
        boolean bl = true;
        if (!bl) return false;
        FilterEstimation filterEstimation = (FilterEstimation)x$1;
        Filter filter = this.plan();
        Filter filter2 = filterEstimation.plan();
        if (filter == null) {
            if (filter2 != null) {
                return false;
            }
        } else if (!((Object)filter).equals(filter2)) return false;
        if (!filterEstimation.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$calculateSingleCondition$1(Expression e) {
        return e instanceof Literal;
    }

    public static final /* synthetic */ boolean $anonfun$evaluateInSet$2(DataType dataType$1, NumericValueInterval statsInterval$1, Object v) {
        return v != null && statsInterval$1.contains(new Literal(v, dataType$1));
    }

    public FilterEstimation(Filter plan2) {
        this.plan = plan2;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.childStats = plan2.child().stats();
        this.colStatsMap = new ColumnStatsMap(this.childStats().attributeStats());
    }
}

