/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskKilledException;
import org.apache.spark.executor.InputMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.metrics.source.CodegenMetrics$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeAndComment;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeFormatter$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.GeneratedClass;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.ParentClassLoader;
import org.apache.spark.util.Utils$;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ByteArrayClassLoader;
import org.codehaus.janino.ClassBodyEvaluator;
import org.codehaus.janino.InternalCompilerException;
import org.codehaus.janino.SimpleCompiler;
import org.codehaus.janino.util.ClassFile;
import org.slf4j.Logger;
import org.spark_project.guava.cache.CacheBuilder;
import org.spark_project.guava.cache.CacheLoader;
import org.spark_project.guava.cache.LoadingCache;
import org.spark_project.guava.util.concurrent.ExecutionError;
import org.spark_project.guava.util.concurrent.UncheckedExecutionException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.control.NonFatal$;

public final class CodeGenerator$
implements Logging {
    public static CodeGenerator$ MODULE$;
    private final LoadingCache<CodeAndComment, Tuple2<GeneratedClass, Object>> cache;
    private final Seq<String> primitiveTypes;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CodeGenerator$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public final int DEFAULT_JVM_HUGE_METHOD_LIMIT() {
        return 8000;
    }

    public final int MAX_JVM_METHOD_PARAMS_LENGTH() {
        return 255;
    }

    public final int MERGE_SPLIT_METHODS_THRESHOLD() {
        return 3;
    }

    public final int GENERATED_CLASS_SIZE_THRESHOLD() {
        return 1000000;
    }

    public final int OUTER_CLASS_VARIABLES_THRESHOLD() {
        return 10000;
    }

    public final int MUTABLESTATEARRAY_SIZE_LIMIT() {
        return 32768;
    }

    public Tuple2<GeneratedClass, Object> compile(CodeAndComment code) {
        Tuple2 tuple2;
        try {
            tuple2 = (Tuple2)this.cache().get((Object)code);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof UncheckedExecutionException ? true : throwable2 instanceof ExecutionError;
            if (bl) {
                throw throwable2.getCause();
            }
            throw throwable;
        }
        return tuple2;
    }

    public Tuple2<GeneratedClass, Object> org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$doCompile(CodeAndComment code) {
        int n;
        ClassBodyEvaluator evaluator = new ClassBodyEvaluator();
        ParentClassLoader parentClassLoader = new ParentClassLoader(Utils$.MODULE$.getContextOrSparkClassLoader());
        evaluator.setParentClassLoader((ClassLoader)parentClassLoader);
        evaluator.setClassName("org.apache.spark.sql.catalyst.expressions.GeneratedClass");
        evaluator.setDefaultImports(new String[]{Platform.class.getName(), InternalRow.class.getName(), UnsafeRow.class.getName(), UTF8String.class.getName(), Decimal.class.getName(), CalendarInterval.class.getName(), ArrayData.class.getName(), UnsafeArrayData.class.getName(), MapData.class.getName(), UnsafeMapData.class.getName(), Expression.class.getName(), TaskContext.class.getName(), TaskKilledException.class.getName(), InputMetrics.class.getName()});
        evaluator.setExtendedClass(GeneratedClass.class);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            evaluator.setDebuggingInformation(true, true, false);
            return new StringBuilder(1).append("\n").append(CodeFormatter$.MODULE$.format(code, CodeFormatter$.MODULE$.format$default$2())).toString();
        });
        try {
            evaluator.cook("generated.java", code.body());
            n = this.updateAndGetCompilationStats(evaluator);
        }
        catch (InternalCompilerException e) {
            String msg = new StringBuilder(19).append("failed to compile: ").append((Object)e).toString();
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
            int maxLines = SQLConf$.MODULE$.get().loggingMaxLinesForCodegen();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append("\n").append(CodeFormatter$.MODULE$.format(code, maxLines)).toString());
            throw new InternalCompilerException(msg, (Throwable)e);
        }
        catch (CompileException e) {
            String msg = new StringBuilder(19).append("failed to compile: ").append((Object)e).toString();
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
            int maxLines = SQLConf$.MODULE$.get().loggingMaxLinesForCodegen();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append("\n").append(CodeFormatter$.MODULE$.format(code, maxLines)).toString());
            throw new CompileException(msg, e.getLocation());
        }
        int maxCodeSize = n;
        return new Tuple2((Object)((GeneratedClass)evaluator.getClazz().newInstance()), (Object)BoxesRunTime.boxToInteger((int)maxCodeSize));
    }

    private int updateAndGetCompilationStats(ClassBodyEvaluator evaluator) {
        Field resultField = SimpleCompiler.class.getDeclaredField("result");
        resultField.setAccessible(true);
        ByteArrayClassLoader loader = (ByteArrayClassLoader)resultField.get(evaluator);
        Field classesField = loader.getClass().getDeclaredField("classes");
        classesField.setAccessible(true);
        scala.collection.mutable.Map classes = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)classesField.get(loader)).asScala();
        Class codeAttr = Utils$.MODULE$.classForName("org.codehaus.janino.util.ClassFile$CodeAttribute");
        Field codeAttrField = codeAttr.getDeclaredField("code");
        codeAttrField.setAccessible(true);
        scala.collection.mutable.Iterable codeSizes = (scala.collection.mutable.Iterable)((GenericTraversableTemplate)classes.flatMap((Function1 & Serializable & scala.Serializable)x0$11 -> {
            Iterable iterable;
            Tuple2 tuple2 = x0$11;
            if (tuple2 != null) {
                byte[] classBytes = (byte[])tuple2._2();
                CodegenMetrics$.MODULE$.METRIC_GENERATED_CLASS_BYTECODE_SIZE().update(classBytes.length);
                try {
                    ClassFile cf = new ClassFile((InputStream)new ByteArrayInputStream(classBytes));
                    Buffer stats = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(cf.methodInfos).asScala()).flatMap((Function1 & Serializable & scala.Serializable)method -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])method.getAttributes())).filter((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)CodeGenerator$.$anonfun$updateAndGetCompilationStats$3(codeAttr$1, x$21))))).map((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToInteger((int)CodeGenerator$.$anonfun$updateAndGetCompilationStats$4(codeAttrField$1, cf$1, method, a)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))), Buffer$.MODULE$.canBuildFrom());
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)stats));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error calculating stats of compiled class.", e);
                    Iterable iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    iterable = iterable2;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Iterable iterable3 = iterable;
            return iterable3;
        }, Iterable$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        return BoxesRunTime.unboxToInt((Object)codeSizes.max((Ordering)Ordering.Int$.MODULE$));
    }

    private LoadingCache<CodeAndComment, Tuple2<GeneratedClass, Object>> cache() {
        return this.cache;
    }

    public final String JAVA_BOOLEAN() {
        return "boolean";
    }

    public final String JAVA_BYTE() {
        return "byte";
    }

    public final String JAVA_SHORT() {
        return "short";
    }

    public final String JAVA_INT() {
        return "int";
    }

    public final String JAVA_LONG() {
        return "long";
    }

    public final String JAVA_FLOAT() {
        return "float";
    }

    public final String JAVA_DOUBLE() {
        return "double";
    }

    public Seq<String> primitiveTypes() {
        return this.primitiveTypes;
    }

    public boolean isPrimitiveType(String jt) {
        return this.primitiveTypes().contains((Object)jt);
    }

    public boolean isPrimitiveType(DataType dt) {
        return this.isPrimitiveType(this.javaType(dt));
    }

    public String getValue(String input, DataType dataType, String ordinal) {
        String string;
        block10: {
            String jt;
            while (true) {
                jt = this.javaType(dataType);
                DataType dataType2 = dataType;
                if (this.isPrimitiveType(jt)) {
                    string = new StringBuilder(6).append(input).append(".get").append(this.primitiveTypeName(jt)).append("(").append(ordinal).append(")").toString();
                    break block10;
                }
                if (dataType2 instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)dataType2;
                    string = new StringBuilder(17).append(input).append(".getDecimal(").append(ordinal).append(", ").append(decimalType.precision()).append(", ").append(decimalType.scale()).append(")").toString();
                    break block10;
                }
                if (StringType$.MODULE$.equals(dataType2)) {
                    string = new StringBuilder(16).append(input).append(".getUTF8String(").append(ordinal).append(")").toString();
                    break block10;
                }
                if (BinaryType$.MODULE$.equals(dataType2)) {
                    string = new StringBuilder(12).append(input).append(".getBinary(").append(ordinal).append(")").toString();
                    break block10;
                }
                if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
                    string = new StringBuilder(14).append(input).append(".getInterval(").append(ordinal).append(")").toString();
                    break block10;
                }
                if (dataType2 instanceof StructType) {
                    StructType structType = (StructType)dataType2;
                    string = new StringBuilder(14).append(input).append(".getStruct(").append(ordinal).append(", ").append(structType.size()).append(")").toString();
                    break block10;
                }
                if (dataType2 instanceof ArrayType) {
                    string = new StringBuilder(11).append(input).append(".getArray(").append(ordinal).append(")").toString();
                    break block10;
                }
                if (dataType2 instanceof MapType) {
                    string = new StringBuilder(9).append(input).append(".getMap(").append(ordinal).append(")").toString();
                    break block10;
                }
                if (NullType$.MODULE$.equals(dataType2)) {
                    string = "null";
                    break block10;
                }
                if (!(dataType2 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                dataType = userDefinedType.sqlType();
            }
            string = new StringBuilder(14).append("(").append(jt).append(")").append(input).append(".get(").append(ordinal).append(", null)").toString();
        }
        return string;
    }

    public String createArrayData(String arrayName, DataType elementType, String numElements, String additionalErrorMessage) {
        int elementSize = this.isPrimitiveType(elementType) ? elementType.defaultSize() : -1;
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(75).append("\n       |ArrayData ").append(arrayName).append(" = ArrayData.allocateArrayData(\n       |  ").append(elementSize).append(", ").append(numElements).append(", \"").append(additionalErrorMessage).append("\");\n     ").toString())).stripMargin();
    }

    public String createArrayAssignment(String dstArray, DataType elementType, String srcArray, String dstArrayIndex, String srcArrayIndex, boolean needNullCheck) {
        return this.setArrayElement(dstArray, elementType, dstArrayIndex, this.getValue(srcArray, elementType, srcArrayIndex), (Option<String>)(needNullCheck ? new Some((Object)new StringBuilder(11).append(srcArray).append(".isNullAt(").append(srcArrayIndex).append(")").toString()) : None$.MODULE$));
    }

    public String setColumn(String row, DataType dataType, int ordinal, String value) {
        String string;
        block3: {
            DataType dataType2;
            while (true) {
                String jt = this.javaType(dataType);
                dataType2 = dataType;
                if (this.isPrimitiveType(jt)) {
                    string = new StringBuilder(8).append(row).append(".set").append(this.primitiveTypeName(jt)).append("(").append(ordinal).append(", ").append(value).append(")").toString();
                    break block3;
                }
                if (dataType2 instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)dataType2;
                    string = new StringBuilder(17).append(row).append(".setDecimal(").append(ordinal).append(", ").append(value).append(", ").append(decimalType.precision()).append(")").toString();
                    break block3;
                }
                if (!(dataType2 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                dataType = userDefinedType.sqlType();
            }
            boolean bl = StringType$.MODULE$.equals(dataType2) ? true : (dataType2 instanceof StructType ? true : (dataType2 instanceof ArrayType ? true : dataType2 instanceof MapType));
            string = bl ? new StringBuilder(18).append(row).append(".update(").append(ordinal).append(", ").append(value).append(".copy())").toString() : new StringBuilder(11).append(row).append(".update(").append(ordinal).append(", ").append(value).append(")").toString();
        }
        return string;
    }

    public String updateColumn(String row, DataType dataType, int ordinal, ExprCode ev, boolean nullable, boolean isVectorized) {
        return nullable ? (!isVectorized && dataType instanceof DecimalType ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(98).append("\n           |if (!").append(ev.isNull()).append(") {\n           |  ").append(this.setColumn(row, dataType, ordinal, ExprValue$.MODULE$.exprValueToString(ev.value()))).append(";\n           |} else {\n           |  ").append(this.setColumn(row, dataType, ordinal, "null")).append(";\n           |}\n         ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(110).append("\n           |if (!").append(ev.isNull()).append(") {\n           |  ").append(this.setColumn(row, dataType, ordinal, ExprValue$.MODULE$.exprValueToString(ev.value()))).append(";\n           |} else {\n           |  ").append(row).append(".setNullAt(").append(ordinal).append(");\n           |}\n         ").toString())).stripMargin()) : new StringBuilder(1).append(this.setColumn(row, dataType, ordinal, ExprValue$.MODULE$.exprValueToString(ev.value()))).append(";").toString();
    }

    public String setValue(String vector, String rowId, DataType dataType, String value) {
        String string;
        String jt = this.javaType(dataType);
        DataType dataType2 = dataType;
        if (this.isPrimitiveType(jt)) {
            string = new StringBuilder(9).append(vector).append(".put").append(this.primitiveTypeName(jt)).append("(").append(rowId).append(", ").append(value).append(");").toString();
        } else if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            string = new StringBuilder(18).append(vector).append(".putDecimal(").append(rowId).append(", ").append(value).append(", ").append(decimalType.precision()).append(");").toString();
        } else if (dataType2 instanceof StringType) {
            string = new StringBuilder(29).append(vector).append(".putByteArray(").append(rowId).append(", ").append(value).append(".getBytes());").toString();
        } else {
            throw new IllegalArgumentException(new StringBuilder(43).append("cannot generate code for unsupported type: ").append(dataType).toString());
        }
        return string;
    }

    public String setArrayElement(String array, DataType elementType, String i, String value, Option<String> isNull) {
        boolean isPrimitiveType = this.isPrimitiveType(elementType);
        String setFunc = isPrimitiveType ? new StringBuilder(3).append("set").append(this.primitiveTypeName(elementType)).toString() : "update";
        return isNull.isDefined() && isPrimitiveType ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("\n         |if (").append(isNull.get()).append(") {\n         |  ").append(array).append(".setNullAt(").append(i).append(");\n         |} else {\n         |  ").append(array).append(".").append(setFunc).append("(").append(i).append(", ").append(value).append(");\n         |}\n       ").toString())).stripMargin() : new StringBuilder(6).append(array).append(".").append(setFunc).append("(").append(i).append(", ").append(value).append(");").toString();
    }

    public Option<String> setArrayElement$default$5() {
        return None$.MODULE$;
    }

    public String updateColumn(String vector, String rowId, DataType dataType, ExprCode ev, boolean nullable) {
        return nullable ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(95).append("\n         |if (!").append(ev.isNull()).append(") {\n         |  ").append(this.setValue(vector, rowId, dataType, ExprValue$.MODULE$.exprValueToString(ev.value()))).append("\n         |} else {\n         |  ").append(vector).append(".putNull(").append(rowId).append(");\n         |}\n       ").toString())).stripMargin() : new StringBuilder(1).append(this.setValue(vector, rowId, dataType, ExprValue$.MODULE$.exprValueToString(ev.value()))).append(";").toString();
    }

    public boolean updateColumn$default$6() {
        return false;
    }

    public String getValueFromVector(String vector, DataType dataType, String rowId) {
        return dataType instanceof StructType ? new StringBuilder(12).append(vector).append(".getStruct(").append(rowId).append(")").toString() : this.getValue(vector, dataType, rowId);
    }

    public String primitiveTypeName(String jt) {
        String string = jt;
        String string2 = "int".equals(string) ? "Int" : this.boxedType(jt);
        return string2;
    }

    public String primitiveTypeName(DataType dt) {
        return this.primitiveTypeName(this.javaType(dt));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String javaType(DataType dt) {
        DataType dataType;
        ObjectType objectType;
        boolean bl;
        while (true) {
            bl = false;
            objectType = null;
            dataType = dt;
            if (BooleanType$.MODULE$.equals(dataType)) {
                return "boolean";
            }
            if (ByteType$.MODULE$.equals(dataType)) {
                return "byte";
            }
            if (ShortType$.MODULE$.equals(dataType)) {
                return "short";
            }
            if (IntegerType$.MODULE$.equals(dataType)) {
                return "int";
            }
            if (DateType$.MODULE$.equals(dataType)) {
                return "int";
            }
            boolean bl2 = false;
            if (bl2) {
                return "int";
            }
            if (LongType$.MODULE$.equals(dataType)) {
                return "long";
            }
            if (TimestampType$.MODULE$.equals(dataType)) {
                return "long";
            }
            boolean bl3 = false;
            if (bl3) {
                return "long";
            }
            if (FloatType$.MODULE$.equals(dataType)) {
                return "float";
            }
            if (DoubleType$.MODULE$.equals(dataType)) {
                return "double";
            }
            if (dataType instanceof DecimalType) {
                return "Decimal";
            }
            if (BinaryType$.MODULE$.equals(dataType)) {
                return "byte[]";
            }
            if (StringType$.MODULE$.equals(dataType)) {
                return "UTF8String";
            }
            if (CalendarIntervalType$.MODULE$.equals(dataType)) {
                return "CalendarInterval";
            }
            if (dataType instanceof StructType) {
                return "InternalRow";
            }
            if (dataType instanceof ArrayType) {
                return "ArrayData";
            }
            if (dataType instanceof MapType) {
                return "MapData";
            }
            if (!(dataType instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            dt = userDefinedType.sqlType();
        }
        if (dataType instanceof ObjectType) {
            bl = true;
            objectType = (ObjectType)dataType;
            Class<?> cls = objectType.cls();
            if (cls.isArray()) {
                return new StringBuilder(2).append(this.javaType(new ObjectType(cls.getComponentType()))).append("[]").toString();
            }
        }
        if (!bl) return "Object";
        Class<?> cls = objectType.cls();
        return cls.getName();
    }

    public Class<?> javaClass(DataType dt) {
        Class<Object> clazz;
        block17: {
            DataType dataType;
            while (true) {
                if (BooleanType$.MODULE$.equals(dataType = dt)) {
                    clazz = Boolean.TYPE;
                    break block17;
                }
                if (ByteType$.MODULE$.equals(dataType)) {
                    clazz = Byte.TYPE;
                    break block17;
                }
                if (ShortType$.MODULE$.equals(dataType)) {
                    clazz = Short.TYPE;
                    break block17;
                }
                boolean bl = IntegerType$.MODULE$.equals(dataType) ? true : DateType$.MODULE$.equals(dataType);
                if (bl) {
                    clazz = Integer.TYPE;
                    break block17;
                }
                boolean bl2 = LongType$.MODULE$.equals(dataType) ? true : TimestampType$.MODULE$.equals(dataType);
                if (bl2) {
                    clazz = Long.TYPE;
                    break block17;
                }
                if (FloatType$.MODULE$.equals(dataType)) {
                    clazz = Float.TYPE;
                    break block17;
                }
                if (DoubleType$.MODULE$.equals(dataType)) {
                    clazz = Double.TYPE;
                    break block17;
                }
                if (dataType instanceof DecimalType) {
                    clazz = Decimal.class;
                    break block17;
                }
                if (BinaryType$.MODULE$.equals(dataType)) {
                    clazz = byte[].class;
                    break block17;
                }
                if (StringType$.MODULE$.equals(dataType)) {
                    clazz = UTF8String.class;
                    break block17;
                }
                if (CalendarIntervalType$.MODULE$.equals(dataType)) {
                    clazz = CalendarInterval.class;
                    break block17;
                }
                if (dataType instanceof StructType) {
                    clazz = InternalRow.class;
                    break block17;
                }
                if (dataType instanceof ArrayType) {
                    clazz = ArrayData.class;
                    break block17;
                }
                if (dataType instanceof MapType) {
                    clazz = MapData.class;
                    break block17;
                }
                if (!(dataType instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType;
                dt = userDefinedType.sqlType();
            }
            if (dataType instanceof ObjectType) {
                ObjectType objectType = (ObjectType)dataType;
                Class<?> cls = objectType.cls();
                clazz = cls;
            } else {
                clazz = Object.class;
            }
        }
        return clazz;
    }

    public String boxedType(String jt) {
        String string = jt;
        String string2 = "boolean".equals(string) ? "Boolean" : ("byte".equals(string) ? "Byte" : ("short".equals(string) ? "Short" : ("int".equals(string) ? "Integer" : ("long".equals(string) ? "Long" : ("float".equals(string) ? "Float" : ("double".equals(string) ? "Double" : string))))));
        return string2;
    }

    public String boxedType(DataType dt) {
        return this.boxedType(this.javaType(dt));
    }

    public String defaultValue(String jt, boolean typedNull) {
        String string = jt;
        String string2 = "boolean".equals(string) ? "false" : ("byte".equals(string) ? "(byte)-1" : ("short".equals(string) ? "(short)-1" : ("int".equals(string) ? "-1" : ("long".equals(string) ? "-1L" : ("float".equals(string) ? "-1.0f" : ("double".equals(string) ? "-1.0" : (typedNull ? new StringBuilder(8).append("((").append(jt).append(")null)").toString() : "null")))))));
        return string2;
    }

    public String defaultValue(DataType dt, boolean typedNull) {
        return this.defaultValue(this.javaType(dt), typedNull);
    }

    public boolean defaultValue$default$2() {
        return false;
    }

    public int calculateParamLength(Seq<Expression> params) {
        return 1 + BoxesRunTime.unboxToInt((Object)((TraversableOnce)params.map((Function1 & Serializable & scala.Serializable)input -> BoxesRunTime.boxToInteger((int)this.paramLengthForExpr$1(input)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public boolean isValidParamLength(int paramLength) {
        return paramLength <= 255;
    }

    public static final /* synthetic */ boolean $anonfun$updateAndGetCompilationStats$3(Class codeAttr$1, ClassFile.AttributeInfo x$21) {
        return x$21.getClass() == codeAttr$1;
    }

    public static final /* synthetic */ int $anonfun$updateAndGetCompilationStats$4(Field codeAttrField$1, ClassFile cf$1, ClassFile.MethodInfo method$1, ClassFile.AttributeInfo a) {
        int byteCodeSize;
        block0: {
            byteCodeSize = ((byte[])codeAttrField$1.get(a)).length;
            CodegenMetrics$.MODULE$.METRIC_GENERATED_METHOD_BYTECODE_SIZE().update(byteCodeSize);
            if (byteCodeSize <= 8000) break block0;
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Generated method too long to be JIT compiled: ").append(new StringBuilder(11).append(cf$1.getThisClassName()).append(".").append(method$1.getName()).append(" is ").append(byteCodeSize).append(" bytes").toString()).toString());
        }
        return byteCodeSize;
    }

    private final int paramLengthForExpr$1(Expression input) {
        String string = this.javaType(input.dataType());
        boolean bl = "long".equals(string) ? true : "double".equals(string);
        int n = bl ? 2 : 1;
        int javaParamLength = n;
        return (input.nullable() ? 1 : 0) + javaParamLength;
    }

    private CodeGenerator$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.cache = CacheBuilder.newBuilder().maximumSize((long)SQLConf$.MODULE$.get().codegenCacheMaxEntries()).build((CacheLoader)new CacheLoader<CodeAndComment, Tuple2<GeneratedClass, Object>>(){

            public Tuple2<GeneratedClass, Object> load(CodeAndComment code) {
                long startTime = System.nanoTime();
                Tuple2<GeneratedClass, Object> result = CodeGenerator$.MODULE$.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$doCompile(code);
                long endTime = System.nanoTime();
                CodegenMetrics$.MODULE$.METRIC_SOURCE_CODE_SIZE().update(code.body().length());
                CodegenMetrics$.MODULE$.METRIC_COMPILATION_TIME().update((long)anon.1.timeMs$1(startTime, endTime));
                CodeGenerator$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Code generated in ").append(anon.1.timeMs$1(startTime, endTime)).append(" ms").toString());
                return result;
            }

            private static final double timeMs$1(long startTime$1, long endTime$1) {
                return (double)(endTime$1 - startTime$1) / (double)1000000;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$load$1(long long )}, serializedLambda);
            }
        });
        this.primitiveTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"boolean", "byte", "short", "int", "long", "float", "double"}));
    }
}

