/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.SparkException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.aggregate.Percentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.util.collection.OpenHashMap;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n      _FUNC_(col, percentage [, frequency]) - Returns the exact percentile value of numeric column\n       `col` at the given percentage. The value of percentage must be between 0.0 and 1.0. The\n       value of frequency should be positive integral\n\n      _FUNC_(col, array(percentage1 [, percentage2]...) [, frequency]) - Returns the exact\n      percentile value array of numeric column `col` at the given percentage(s). Each value\n      of the percentage array must be between 0.0 and 1.0. The value of frequency should be\n      positive integral\n\n      ")
@ScalaSignature(bytes="\u0006\u0001\t]h\u0001B\u0001\u0003\u0001F\u0011!\u0002U3sG\u0016tG/\u001b7f\u0015\t\u0019A!A\u0005bO\u001e\u0014XmZ1uK*\u0011QAB\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\b\u0011\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001%\u001dZc\u0006E\u0002\u0014)Yi\u0011AA\u0005\u0003+\t\u0011\u0001\u0004V=qK\u0012LU\u000e]3sCRLg/Z!hOJ,w-\u0019;f!\u00119BD\b\u0013\u000e\u0003aQ!!\u0007\u000e\u0002\u0015\r|G\u000e\\3di&|gN\u0003\u0002\u001c\u0015\u0005!Q\u000f^5m\u0013\ti\u0002DA\u0006Pa\u0016t\u0007*Y:i\u001b\u0006\u0004\bCA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g\r\u0005\u0002 K%\u0011a\u0005\t\u0002\u0005\u0019>tw\r\u0005\u0002)S5\tA!\u0003\u0002+\t\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002 Y%\u0011Q\u0006\t\u0002\b!J|G-^2u!\tyr&\u0003\u00021A\ta1+\u001a:jC2L'0\u00192mK\"A!\u0007\u0001BK\u0002\u0013\u00051'A\u0003dQ&dG-F\u00015!\tAS'\u0003\u00027\t\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011a\u0002!\u0011#Q\u0001\nQ\naa\u00195jY\u0012\u0004\u0003\u0002\u0003\u001e\u0001\u0005+\u0007I\u0011A\u001a\u0002)A,'oY3oi\u0006<W-\u0012=qe\u0016\u001c8/[8o\u0011!a\u0004A!E!\u0002\u0013!\u0014!\u00069fe\u000e,g\u000e^1hK\u0016C\bO]3tg&|g\u000e\t\u0005\t}\u0001\u0011)\u001a!C\u0001g\u0005\u0019bM]3rk\u0016t7-_#yaJ,7o]5p]\"A\u0001\t\u0001B\tB\u0003%A'\u0001\u000bge\u0016\fX/\u001a8ds\u0016C\bO]3tg&|g\u000e\t\u0005\t\u0005\u0002\u0011)\u001a!C\u0001\u0007\u00061R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G/F\u0001E!\tyR)\u0003\u0002GA\t\u0019\u0011J\u001c;\t\u0011!\u0003!\u0011#Q\u0001\n\u0011\u000bq#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\t\u0011)\u0003!Q3A\u0005\u0002\r\u000bA#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b\u0002\u0003'\u0001\u0005#\u0005\u000b\u0011\u0002#\u0002+%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3uA!)a\n\u0001C\u0001\u001f\u00061A(\u001b8jiz\"b\u0001U)S'R+\u0006CA\n\u0001\u0011\u0015\u0011T\n1\u00015\u0011\u0015QT\n1\u00015\u0011\u0015qT\n1\u00015\u0011\u001d\u0011U\n%AA\u0002\u0011CqAS'\u0011\u0002\u0003\u0007A\tC\u0003O\u0001\u0011\u0005q\u000bF\u0002Q1fCQA\r,A\u0002QBQA\u000f,A\u0002QBQA\u0014\u0001\u0005\u0002m#B\u0001\u0015/^=\")!G\u0017a\u0001i!)!H\u0017a\u0001i!)qL\u0017a\u0001i\u0005IaM]3rk\u0016t7-\u001f\u0005\u0006C\u0002!\tEY\u0001\u000baJ,G\u000f^=OC6,W#A2\u0011\u0005\u0011\\gBA3j!\t1\u0007%D\u0001h\u0015\tA\u0007#\u0001\u0004=e>|GOP\u0005\u0003U\u0002\na\u0001\u0015:fI\u00164\u0017B\u00017n\u0005\u0019\u0019FO]5oO*\u0011!\u000e\t\u0005\u0006_\u0002!\t\u0005]\u0001\u001eo&$\bNT3x\u001bV$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fiR\u0011\u0001+\u001d\u0005\u0006e:\u0004\r\u0001R\u0001\u001a]\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000fC\u0003u\u0001\u0011\u0005S/A\u000exSRDg*Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u000b\u0003!ZDQa^:A\u0002\u0011\u000bqC\\3x\u0013:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\t\u0011e\u0004\u0001R1A\u0005\ni\fQC]3ukJt\u0007+\u001a:dK:$\u0018\u000e\\3BeJ\f\u00170F\u0001|!\tyB0\u0003\u0002~A\t9!i\\8mK\u0006t\u0007F\u0001=\u0000!\ry\u0012\u0011A\u0005\u0004\u0003\u0007\u0001#!\u0003;sC:\u001c\u0018.\u001a8u\u0011)\t9\u0001\u0001EC\u0002\u0013%\u0011\u0011B\u0001\fa\u0016\u00148-\u001a8uC\u001e,7/\u0006\u0002\u0002\fA1\u0011QBA\t\u0003+i!!a\u0004\u000b\u0005e\u0001\u0013\u0002BA\n\u0003\u001f\u00111aU3r!\ry\u0012qC\u0005\u0004\u00033\u0001#A\u0002#pk\ndW\rK\u0002\u0002\u0006}Dq!a\b\u0001\t\u0003\n\t#\u0001\u0005dQ&dGM]3o+\t\t\u0019\u0003E\u0003\u0002&\u0005=BG\u0004\u0003\u0002(\u0005-bb\u00014\u0002*%\t\u0011%C\u0002\u0002.\u0001\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0014\u0005E\"bAA\u0017A!1\u0011Q\u0007\u0001\u0005Bi\f\u0001B\\;mY\u0006\u0014G.\u001a\u0005\u000b\u0003s\u0001\u0001R1A\u0005B\u0005m\u0012\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005u\u0002\u0003BA \u0003\u000bj!!!\u0011\u000b\u0007\u0005\r\u0003\"A\u0003usB,7/\u0003\u0003\u0002H\u0005\u0005#\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N\u0005Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005=\u0003CBA\u0013\u0003_\t\t\u0006\u0005\u0003\u0002@\u0005M\u0013\u0002BA+\u0003\u0003\u0012\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\t\u000f\u0005e\u0003\u0001\"\u0011\u0002\\\u0005\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\u0011\u0011Q\f\t\u0005\u0003?\n)'\u0004\u0002\u0002b)\u0019\u00111\r\u0004\u0002\u0011\u0005t\u0017\r\\=tSNLA!a\u001a\u0002b\tyA+\u001f9f\u0007\",7m\u001b*fgVdG\u000fC\u0004\u0002l\u0001!I!!\u001c\u0002\u001bQ|Gi\\;cY\u00164\u0016\r\\;f)\u0011\t)\"a\u001c\t\u0011\u0005E\u0014\u0011\u000ea\u0001\u0003g\n\u0011\u0001\u001a\t\u0004?\u0005U\u0014bAA<A\t\u0019\u0011I\\=\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~\u000592M]3bi\u0016\fum\u001a:fO\u0006$\u0018n\u001c8Ck\u001a4WM\u001d\u000b\u0002-!9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0015AB;qI\u0006$X\rF\u0003\u0017\u0003\u000b\u000bI\tC\u0004\u0002\b\u0006}\u0004\u0019\u0001\f\u0002\r\t,hMZ3s\u0011!\tY)a A\u0002\u00055\u0015!B5oaV$\b\u0003BAH\u0003#k\u0011AB\u0005\u0004\u0003'3!aC%oi\u0016\u0014h.\u00197S_^Dq!a&\u0001\t\u0003\nI*A\u0003nKJ<W\rF\u0003\u0017\u00037\u000bi\nC\u0004\u0002\b\u0006U\u0005\u0019\u0001\f\t\u000f\u0005}\u0015Q\u0013a\u0001-\u0005)q\u000e\u001e5fe\"9\u00111\u0015\u0001\u0005B\u0005\u0015\u0016\u0001B3wC2$B!a\u001d\u0002(\"9\u0011qQAQ\u0001\u00041\u0002bBAV\u0001\u0011%\u0011QV\u0001\u000fO\u0016$\b+\u001a:dK:$\u0018\u000e\\3t)\u0011\ty+!-\u0011\r\u0005\u0015\u0012qFA\u000b\u0011\u001d\t9)!+A\u0002YAq!!.\u0001\t\u0013\t9,\u0001\bhK:,'/\u0019;f\u001fV$\b/\u001e;\u0015\t\u0005M\u0014\u0011\u0018\u0005\t\u0003w\u000b\u0019\f1\u0001\u00020\u00069!/Z:vYR\u001c\bbBA`\u0001\u0011%\u0011\u0011Y\u0001\u000eO\u0016$\b+\u001a:dK:$\u0018\u000e\\3\u0015\r\u0005U\u00111YAh\u0011!\t)-!0A\u0002\u0005\u001d\u0017aC1hOJ,7i\\;oiN\u0004b!!\n\u00020\u0005%\u0007#B\u0010\u0002Lz!\u0013bAAgA\t1A+\u001e9mKJB\u0001\"!5\u0002>\u0002\u0007\u0011QC\u0001\ta>\u001c\u0018\u000e^5p]\"9\u0011Q\u001b\u0001\u0005\n\u0005]\u0017!\u00052j]\u0006\u0014\u0018pU3be\u000eD7i\\;oiRIA)!7\u0002d\u0006\u001d\u00181\u001e\u0005\t\u00037\f\u0019\u000e1\u0001\u0002^\u0006Y1m\\;oiN\f%O]1z!\u0011y\u0012q\u001c\u0013\n\u0007\u0005\u0005\bEA\u0003BeJ\f\u0017\u0010C\u0004\u0002f\u0006M\u0007\u0019\u0001#\u0002\u000bM$\u0018M\u001d;\t\u000f\u0005%\u00181\u001ba\u0001\t\u0006\u0019QM\u001c3\t\u000f\u00055\u00181\u001ba\u0001I\u0005)a/\u00197vK\"9\u0011\u0011\u001f\u0001\u0005B\u0005M\u0018!C:fe&\fG.\u001b>f)\u0011\t)0!@\u0011\u000b}\ty.a>\u0011\u0007}\tI0C\u0002\u0002|\u0002\u0012AAQ=uK\"9\u0011q`Ax\u0001\u00041\u0012aA8cU\"9!1\u0001\u0001\u0005B\t\u0015\u0011a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$2A\u0006B\u0004\u0011!\u0011IA!\u0001A\u0002\u0005U\u0018!\u00022zi\u0016\u001c\b\"\u0003B\u0007\u0001\u0005\u0005I\u0011\u0001B\b\u0003\u0011\u0019w\u000e]=\u0015\u0017A\u0013\tBa\u0005\u0003\u0016\t]!\u0011\u0004\u0005\te\t-\u0001\u0013!a\u0001i!A!Ha\u0003\u0011\u0002\u0003\u0007A\u0007\u0003\u0005?\u0005\u0017\u0001\n\u00111\u00015\u0011!\u0011%1\u0002I\u0001\u0002\u0004!\u0005\u0002\u0003&\u0003\fA\u0005\t\u0019\u0001#\t\u0013\tu\u0001!%A\u0005\u0002\t}\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005CQ3\u0001\u000eB\u0012W\t\u0011)\u0003\u0005\u0003\u0003(\tERB\u0001B\u0015\u0015\u0011\u0011YC!\f\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0018A\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tM\"\u0011\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003B\u001c\u0001E\u0005I\u0011\u0001B\u0010\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB\u0011Ba\u000f\u0001#\u0003%\tAa\b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g!I!q\b\u0001\u0012\u0002\u0013\u0005!\u0011I\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011\u0019EK\u0002E\u0005GA\u0011Ba\u0012\u0001#\u0003%\tA!\u0011\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%k!I!1\n\u0001\u0002\u0002\u0013\u0005#QJ\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t=\u0003\u0003\u0002B)\u00057j!Aa\u0015\u000b\t\tU#qK\u0001\u0005Y\u0006twM\u0003\u0002\u0003Z\u0005!!.\u0019<b\u0013\ra'1\u000b\u0005\t\u0005?\u0002\u0011\u0011!C\u0001\u0007\u0006a\u0001O]8ek\u000e$\u0018I]5us\"I!1\r\u0001\u0002\u0002\u0013\u0005!QM\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019Ha\u001a\t\u0013\t%$\u0011MA\u0001\u0002\u0004!\u0015a\u0001=%c!I!Q\u000e\u0001\u0002\u0002\u0013\u0005#qN\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\u000f\t\u0007\u0003\u001b\u0011\u0019(a\u001d\n\t\tU\u0014q\u0002\u0002\t\u0013R,'/\u0019;pe\"I!\u0011\u0010\u0001\u0002\u0002\u0013\u0005!1P\u0001\tG\u0006tW)];bYR\u00191P! \t\u0015\t%$qOA\u0001\u0002\u0004\t\u0019\bC\u0005\u0003\u0002\u0002\t\t\u0011\"\u0011\u0003\u0004\u00061Q-];bYN$2a\u001fBC\u0011)\u0011IGa \u0002\u0002\u0003\u0007\u00111\u000f\u0015\b\u0001\t%%q\u0012BI!\rA#1R\u0005\u0004\u0005\u001b#!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005'\u000bA\u0011\f\u0006!A\u0001\u0002\u0003\u0005I0G+:\u001bu\fK2pY2\u0002\u0003/\u001a:dK:$\u0018mZ3!72\u0002cM]3rk\u0016t7-_/*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA\u0015D\u0018m\u0019;!a\u0016\u00148-\u001a8uS2,\u0007E^1mk\u0016\u0004sN\u001a\u0011ok6,'/[2!G>dW/\u001c8\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u000e|G\u000e\u0019\u0011bi\u0002\"\b.\u001a\u0011hSZ,g\u000e\t9fe\u000e,g\u000e^1hK:\u0002C\u000b[3!m\u0006dW/\u001a\u0011pM\u0002\u0002XM]2f]R\fw-\u001a\u0011nkN$\bEY3!E\u0016$x/Z3oAAr\u0003\u0007I1oI\u0002\nd\u0006\r\u0018!)\",'\u0002\t\u0011!A\u0001\u0002\u0003E^1mk\u0016\u0004sN\u001a\u0011ge\u0016\fX/\u001a8ds\u0002\u001a\bn\\;mI\u0002\u0012W\r\t9pg&$\u0018N^3!S:$Xm\u001a:bY*Q\u0001\u0005\t\u0011!A\u0001zf)\u0016(D?\"\u001aw\u000e\u001c\u0017!CJ\u0014\u0018-\u001f\u0015qKJ\u001cWM\u001c;bO\u0016\f\u0004e\u0017\u0017!a\u0016\u00148-\u001a8uC\u001e,''\u0018\u0018/]%\u00023\f\f\u0011ge\u0016\fX/\u001a8dsvK\u0003%\f\u0011SKR,(O\\:!i\",\u0007%\u001a=bGRT\u0001\u0005\t\u0011!A\u0001\u0002XM]2f]RLG.\u001a\u0011wC2,X\rI1se\u0006L\be\u001c4!]VlWM]5dA\r|G.^7oA\u0001\u001cw\u000e\u001c1!CR\u0004C\u000f[3!O&4XM\u001c\u0011qKJ\u001cWM\u001c;bO\u0016D3/\u000b\u0018!\u000b\u0006\u001c\u0007\u000e\t<bYV,'\u0002\t\u0011!A\u0001\u0002sN\u001a\u0011uQ\u0016\u0004\u0003/\u001a:dK:$\u0018mZ3!CJ\u0014\u0018-\u001f\u0011nkN$\bEY3!E\u0016$x/Z3oAAr\u0003\u0007I1oI\u0002\nd\u0006\r\u0018!)\",\u0007E^1mk\u0016\u0004sN\u001a\u0011ge\u0016\fX/\u001a8ds\u0002\u001a\bn\\;mI\u0002\u0012WM\u0003\u0011!A\u0001\u0002\u0003\u0005]8tSRLg/\u001a\u0011j]R,wM]1m\u0015)\u0001\u0003\u0005\t\u0011!A\u001dI!q\u0013\u0002\u0002\u0002#\u0005!\u0011T\u0001\u000b!\u0016\u00148-\u001a8uS2,\u0007cA\n\u0003\u001c\u001aA\u0011AAA\u0001\u0012\u0003\u0011ijE\u0003\u0003\u001c\n}e\u0006\u0005\u0006\u0003\"\n\u001dF\u0007\u000e\u001bE\tBk!Aa)\u000b\u0007\t\u0015\u0006%A\u0004sk:$\u0018.\\3\n\t\t%&1\u0015\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:,\u0004b\u0002(\u0003\u001c\u0012\u0005!Q\u0016\u000b\u0003\u00053C!B!-\u0003\u001c\u0006\u0005IQ\tBZ\u0003!!xn\u0015;sS:<GC\u0001B(\u0011)\u00119La'\u0002\u0002\u0013\u0005%\u0011X\u0001\u0006CB\u0004H.\u001f\u000b\f!\nm&Q\u0018B`\u0005\u0003\u0014\u0019\r\u0003\u00043\u0005k\u0003\r\u0001\u000e\u0005\u0007u\tU\u0006\u0019\u0001\u001b\t\ry\u0012)\f1\u00015\u0011!\u0011%Q\u0017I\u0001\u0002\u0004!\u0005\u0002\u0003&\u00036B\u0005\t\u0019\u0001#\t\u0015\t\u001d'1TA\u0001\n\u0003\u0013I-A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t-'q\u001b\t\u0006?\t5'\u0011[\u0005\u0004\u0005\u001f\u0004#AB(qi&|g\u000e\u0005\u0005 \u0005'$D\u0007\u000e#E\u0013\r\u0011)\u000e\t\u0002\u0007)V\u0004H.Z\u001b\t\u0013\te'QYA\u0001\u0002\u0004\u0001\u0016a\u0001=%a!Q!Q\u001cBN#\u0003%\tA!\u0011\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0011)\u0011\tOa'\u0012\u0002\u0013\u0005!\u0011I\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\t\u0015\t\u0015(1TI\u0001\n\u0003\u0011\t%A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0011)\u0011IOa'\u0012\u0002\u0013\u0005!\u0011I\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%k!Q!Q\u001eBN\u0003\u0003%IAa<\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005c\u0004BA!\u0015\u0003t&!!Q\u001fB*\u0005\u0019y%M[3di\u0002")
public class Percentile
extends TypedImperativeAggregate<OpenHashMap<Object, Object>>
implements ImplicitCastInputTypes,
scala.Serializable {
    private transient boolean returnPercentileArray;
    private transient Seq<Object> percentages;
    private DataType dataType;
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression frequencyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static int apply$default$5() {
        return Percentile$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return Percentile$.MODULE$.apply$default$4();
    }

    public static int $lessinit$greater$default$5() {
        return Percentile$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return Percentile$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(Percentile percentile) {
        return Percentile$.MODULE$.unapply(percentile);
    }

    public static Function1<Tuple5<Expression, Expression, Expression, Object, Object>, Percentile> tupled() {
        return Percentile$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, Percentile>>>>> curried() {
        return Percentile$.MODULE$.curried();
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    public Expression frequencyExpression() {
        return this.frequencyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public String prettyName() {
        return "percentile";
    }

    @Override
    public Percentile withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$8 = newMutableAggBufferOffset;
        Expression x$9 = this.copy$default$1();
        Expression x$10 = this.copy$default$2();
        Expression x$11 = this.copy$default$3();
        int x$12 = this.copy$default$5();
        return this.copy(x$9, x$10, x$11, x$8, x$12);
    }

    @Override
    public Percentile withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$13 = newInputAggBufferOffset;
        Expression x$14 = this.copy$default$1();
        Expression x$15 = this.copy$default$2();
        Expression x$16 = this.copy$default$3();
        int x$17 = this.copy$default$4();
        return this.copy(x$14, x$15, x$16, x$17, x$13);
    }

    private boolean returnPercentileArray$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.returnPercentileArray = this.percentageExpression().dataType() instanceof ArrayType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.returnPercentileArray;
    }

    private boolean returnPercentileArray() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.returnPercentileArray$lzycompute() : this.returnPercentileArray;
    }

    private Seq<Object> percentages$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Seq seq;
                Object object = this.percentageExpression().eval(this.percentageExpression().eval$default$1());
                if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{d}));
                } else if (object instanceof ArrayData) {
                    ArrayData arrayData = (ArrayData)object;
                    seq = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(arrayData.toDoubleArray())).toSeq();
                } else {
                    throw new MatchError(object);
                }
                this.percentages = seq;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.percentages;
    }

    private Seq<Object> percentages() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.percentages$lzycompute() : this.percentages;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.child();
        Expression expression2 = this.percentageExpression();
        Expression expression3 = this.frequencyExpression();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private DataType dataType$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if (!this.bitmap$0) {
                DataType dataType = this.percentageExpression().dataType();
                DataType dataType2 = dataType instanceof ArrayType ? new ArrayType(DoubleType$.MODULE$, false) : DoubleType$.MODULE$;
                this.dataType = dataType2;
                this.bitmap$0 = true;
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return !this.bitmap$0 ? this.dataType$lzycompute() : this.dataType;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        DataType dataType = this.percentageExpression().dataType();
        DataType dataType2 = dataType instanceof ArrayType ? ArrayType$.MODULE$.apply(DoubleType$.MODULE$) : DoubleType$.MODULE$;
        DataType percentageExpType = dataType2;
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, percentageExpType, IntegralType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.percentageExpression().foldable() ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(46).append("The percentage(s) must be a constant literal, ").append(new StringBuilder(8).append("but got ").append(this.percentageExpression()).toString()).toString()) : (this.percentages().exists((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)percentage -> percentage < 0.0 || percentage > 1.0) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(43).append("Percentage(s) must be between 0.0 and 1.0, ").append(new StringBuilder(8).append("but got ").append(this.percentageExpression()).toString()).toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$));
    }

    private double toDoubleValue(Object d) {
        double d2;
        Object object = d;
        if (object instanceof Decimal) {
            Decimal decimal = (Decimal)object;
            d2 = decimal.toDouble();
        } else if (object instanceof Number) {
            Number number = (Number)object;
            d2 = number.doubleValue();
        } else {
            throw new MatchError(object);
        }
        return d2;
    }

    @Override
    public OpenHashMap<Object, Object> createAggregationBuffer() {
        return new OpenHashMap.mcJ.sp(ClassTag$.MODULE$.AnyRef(), ClassTag$.MODULE$.Long());
    }

    @Override
    public OpenHashMap<Object, Object> update(OpenHashMap<Object, Object> buffer, InternalRow input) {
        Object object;
        Object key = this.child().eval(input);
        Object frqValue = this.frequencyExpression().eval(input);
        if (key != null && frqValue != null) {
            long frqLong = ((Number)frqValue).longValue();
            if (frqLong > 0L) {
                object = BoxesRunTime.boxToLong((long)buffer.changeValue$mcJ$sp(key, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> frqLong, (Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$4 -> x$4 + frqLong));
            } else {
                if (frqLong < 0L) {
                    throw new SparkException(new StringBuilder(25).append("Negative values found in ").append(this.frequencyExpression().sql()).toString());
                }
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        return buffer;
    }

    @Override
    public OpenHashMap<Object, Object> merge(OpenHashMap<Object, Object> buffer, OpenHashMap<Object, Object> other) {
        other.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong((long)Percentile.$anonfun$merge$1(buffer, x0$1)));
        return buffer;
    }

    @Override
    public Object eval(OpenHashMap<Object, Object> buffer) {
        return this.generateOutput(this.getPercentiles(buffer));
    }

    private Seq<Object> getPercentiles(OpenHashMap<Object, Object> buffer) {
        if (buffer.isEmpty()) {
            return (Seq)Seq$.MODULE$.empty();
        }
        Seq sortedCounts = (Seq)buffer.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6._1(), ((NumericType)this.child().dataType()).ordering());
        Seq accumlatedCounts = (Seq)((TraversableLike)sortedCounts.scanLeft((Object)new Tuple2(((Tuple2)sortedCounts.head())._1(), (Object)BoxesRunTime.boxToLong((long)0L)), (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> {
            long count1;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$2, x1$1);
                    if (tuple22 == null) break block2;
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple23 == null) break block2;
                    count1 = tuple23._2$mcJ$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Object key2 = tuple2._1();
            long count2 = tuple2._2$mcJ$sp();
            Tuple2 tuple24 = new Tuple2(key2, (Object)BoxesRunTime.boxToLong((long)(count1 + count2)));
            return tuple24;
        }, Seq$.MODULE$.canBuildFrom())).tail();
        long maxPosition = ((Tuple2)accumlatedCounts.last())._2$mcJ$sp() - 1L;
        return (Seq)this.percentages().map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)percentile -> this.getPercentile((Seq<Tuple2<Object, Object>>)accumlatedCounts, (double)maxPosition * percentile), Seq$.MODULE$.canBuildFrom());
    }

    private Object generateOutput(Seq<Object> results) {
        return results.isEmpty() ? null : (this.returnPercentileArray() ? new GenericArrayData(results) : results.head());
    }

    private double getPercentile(Seq<Tuple2<Object, Object>> aggreCounts, double position) {
        long lower = (long)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(position));
        long higher = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(position));
        long[] countsArray = (long[])((TraversableOnce)aggreCounts.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7._2$mcJ$sp()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long());
        int lowerIndex = this.binarySearchCount(countsArray, 0, aggreCounts.size(), lower + 1L);
        int higherIndex = this.binarySearchCount(countsArray, 0, aggreCounts.size(), higher + 1L);
        Object lowerKey = ((Tuple2)aggreCounts.apply(lowerIndex))._1();
        if (higher == lower) {
            return this.toDoubleValue(lowerKey);
        }
        Object higherKey = ((Tuple2)aggreCounts.apply(higherIndex))._1();
        if (BoxesRunTime.equals((Object)higherKey, (Object)lowerKey)) {
            return this.toDoubleValue(lowerKey);
        }
        return ((double)higher - position) * this.toDoubleValue(lowerKey) + (position - (double)lower) * this.toDoubleValue(higherKey);
    }

    private int binarySearchCount(long[] countsArray, int start, int end, long value) {
        int n = Arrays.binarySearch(countsArray, 0, end, value);
        switch (n) {
            default: 
        }
        return n < 0 ? -(n + 1) : n;
    }

    @Override
    public byte[] serialize(OpenHashMap<Object, Object> obj) {
        byte[] byArray;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        try {
            UnsafeProjection projection = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{this.child().dataType(), LongType$.MODULE$}));
            obj.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Percentile.$anonfun$serialize$1(buffer, out, projection, x0$3);
                return BoxedUnit.UNIT;
            });
            out.writeInt(-1);
            out.flush();
            byArray = bos.toByteArray();
        }
        finally {
            out.close();
            bos.close();
        }
        return byArray;
    }

    @Override
    public OpenHashMap<Object, Object> deserialize(byte[] bytes) {
        OpenHashMap.mcJ.sp sp2;
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream ins = new DataInputStream(bis);
        try {
            OpenHashMap.mcJ.sp counts = new OpenHashMap.mcJ.sp(ClassTag$.MODULE$.AnyRef(), ClassTag$.MODULE$.Long());
            int sizeOfNextRow = ins.readInt();
            while (sizeOfNextRow >= 0) {
                byte[] bs = new byte[sizeOfNextRow];
                ins.readFully(bs);
                UnsafeRow row = new UnsafeRow(2);
                row.pointTo(bs, sizeOfNextRow);
                Object key = row.get(0, this.child().dataType());
                long count = BoxesRunTime.unboxToLong((Object)row.get(1, LongType$.MODULE$));
                counts.update$mcJ$sp(key, count);
                sizeOfNextRow = ins.readInt();
            }
            sp2 = counts;
        }
        finally {
            ins.close();
            bis.close();
        }
        return sp2;
    }

    public Percentile copy(Expression child, Expression percentageExpression, Expression frequencyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new Percentile(child, percentageExpression, frequencyExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.frequencyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "Percentile";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.percentageExpression();
                break;
            }
            case 2: {
                object = this.frequencyExpression();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Percentile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Percentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        Percentile percentile = (Percentile)x$1;
        Expression expression = this.child();
        Expression expression2 = percentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = percentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.frequencyExpression();
        Expression expression6 = percentile.frequencyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.mutableAggBufferOffset() != percentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != percentile.inputAggBufferOffset()) return false;
        if (!percentile.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$merge$1(OpenHashMap buffer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object key = tuple2._1();
        long count = tuple2._2$mcJ$sp();
        long l = buffer$1.changeValue$mcJ$sp(key, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> count, (Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$5 -> x$5 + count);
        return l;
    }

    public static final /* synthetic */ void $anonfun$serialize$1(byte[] buffer$2, DataOutputStream out$1, UnsafeProjection projection$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object key = tuple2._1();
        long count = tuple2._2$mcJ$sp();
        InternalRow row = InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, BoxesRunTime.boxToLong((long)count)}));
        UnsafeRow unsafeRow = projection$1.apply(row);
        out$1.writeInt(unsafeRow.getSizeInBytes());
        unsafeRow.writeToStream(out$1, buffer$2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Percentile(Expression child, Expression percentageExpression, Expression frequencyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.frequencyExpression = frequencyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
    }

    public Percentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)1L)), 0, 0);
    }

    public Percentile(Expression child, Expression percentageExpression, Expression frequency) {
        this(child, percentageExpression, frequency, 0, 0);
    }
}

