/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.CountMinSketchAgg$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.sketch.CountMinSketch;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(col, eps, confidence, seed) - Returns a count-min sketch of a column with the given esp,\n      confidence and seed. The result is an array of bytes, which can be deserialized to a\n      `CountMinSketch` before usage. Count-min sketch is a probabilistic data structure used for\n      cardinality estimation using sub-linear space.\n  ")
@ScalaSignature(bytes="\u0006\u0001\t5e\u0001B\u0001\u0003\u0001F\u0011\u0011cQ8v]Rl\u0015N\\*lKR\u001c\u0007.Q4h\u0015\t\u0019A!A\u0005bO\u001e\u0014XmZ1uK*\u0011QAB\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\b\u0011\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001%y\u0011\u0003\u0006E\u0002\u0014)Yi\u0011AA\u0005\u0003+\t\u0011\u0001\u0004V=qK\u0012LU\u000e]3sCRLg/Z!hOJ,w-\u0019;f!\t9B$D\u0001\u0019\u0015\tI\"$\u0001\u0004tW\u0016$8\r\u001b\u0006\u00037)\tA!\u001e;jY&\u0011Q\u0004\u0007\u0002\u000f\u0007>,h\u000e^'j]N[W\r^2i!\ty\u0002%D\u0001\u0005\u0013\t\tCAA\tFqB,7\r^:J]B,H\u000fV=qKN\u0004\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002$S%\u0011!\u0006\n\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tY\u0001\u0011)\u001a!C\u0001[\u0005)1\r[5mIV\ta\u0006\u0005\u0002 _%\u0011\u0001\u0007\u0002\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002\u0003\u001a\u0001\u0005#\u0005\u000b\u0011\u0002\u0018\u0002\r\rD\u0017\u000e\u001c3!\u0011!!\u0004A!f\u0001\n\u0003i\u0013!D3qg\u0016C\bO]3tg&|g\u000e\u0003\u00057\u0001\tE\t\u0015!\u0003/\u00039)\u0007o]#yaJ,7o]5p]\u0002B\u0001\u0002\u000f\u0001\u0003\u0016\u0004%\t!L\u0001\u0015G>tg-\u001b3f]\u000e,W\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011i\u0002!\u0011#Q\u0001\n9\nQcY8oM&$WM\\2f\u000bb\u0004(/Z:tS>t\u0007\u0005\u0003\u0005=\u0001\tU\r\u0011\"\u0001.\u00039\u0019X-\u001a3FqB\u0014Xm]:j_:D\u0001B\u0010\u0001\u0003\u0012\u0003\u0006IAL\u0001\u0010g\u0016,G-\u0012=qe\u0016\u001c8/[8oA!A\u0001\t\u0001BK\u0002\u0013\u0005\u0013)\u0001\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u+\u0005\u0011\u0005CA\u0012D\u0013\t!EEA\u0002J]RD\u0001B\u0012\u0001\u0003\u0012\u0003\u0006IAQ\u0001\u0018[V$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0002B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t%Q\u0001\u0015S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\t\u0011)\u0003!\u0011#Q\u0001\n\t\u000bQ#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b\u0005C\u0003M\u0001\u0011\u0005Q*\u0001\u0004=S:LGO\u0010\u000b\b\u001d>\u0003\u0016KU*U!\t\u0019\u0002\u0001C\u0003-\u0017\u0002\u0007a\u0006C\u00035\u0017\u0002\u0007a\u0006C\u00039\u0017\u0002\u0007a\u0006C\u0003=\u0017\u0002\u0007a\u0006C\u0003A\u0017\u0002\u0007!\tC\u0003I\u0017\u0002\u0007!\tC\u0003M\u0001\u0011\u0005a\u000bF\u0003O/bK&\fC\u0003-+\u0002\u0007a\u0006C\u00035+\u0002\u0007a\u0006C\u00039+\u0002\u0007a\u0006C\u0003=+\u0002\u0007a\u0006\u0003\u0005]\u0001!\u0015\r\u0011\"\u0003^\u0003\r)\u0007o]\u000b\u0002=B\u00111eX\u0005\u0003A\u0012\u0012a\u0001R8vE2,\u0007\u0002\u00032\u0001\u0011\u000b\u0007I\u0011B/\u0002\u0015\r|gNZ5eK:\u001cW\r\u0003\u0005e\u0001!\u0015\r\u0011\"\u0003B\u0003\u0011\u0019X-\u001a3\t\u000b\u0019\u0004A\u0011I4\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0003!\u0004\"!\u001b7\u000e\u0003)T!a\u001b\u0004\u0002\u0011\u0005t\u0017\r\\=tSNL!!\u001c6\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYRDQa\u001c\u0001\u0005BA\fqc\u0019:fCR,\u0017iZ4sK\u001e\fG/[8o\u0005V4g-\u001a:\u0015\u0003YAQA\u001d\u0001\u0005BM\fa!\u001e9eCR,Gc\u0001\fum\")Q/\u001da\u0001-\u00051!-\u001e4gKJDQa^9A\u0002a\fQ!\u001b8qkR\u0004\"!\u001f>\u000e\u0003\u0019I!a\u001f\u0004\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0006{\u0002!\tE`\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0005-}\f\t\u0001C\u0003vy\u0002\u0007a\u0003C\u0003xy\u0002\u0007a\u0003C\u0004\u0002\u0006\u0001!\t%a\u0002\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003\u0013\ty\u0001E\u0002$\u0003\u0017I1!!\u0004%\u0005\r\te.\u001f\u0005\u0007k\u0006\r\u0001\u0019\u0001\f\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016\u0005I1/\u001a:jC2L'0\u001a\u000b\u0005\u0003/\t\u0019\u0003E\u0003$\u00033\ti\"C\u0002\u0002\u001c\u0011\u0012Q!\u0011:sCf\u00042aIA\u0010\u0013\r\t\t\u0003\n\u0002\u0005\u0005f$X\r\u0003\u0004v\u0003#\u0001\rA\u0006\u0005\b\u0003O\u0001A\u0011IA\u0015\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0007Y\tY\u0003\u0003\u0005\u0002.\u0005\u0015\u0002\u0019AA\f\u00035\u0019Ho\u001c:bO\u00164uN]7bi\"9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0012!H<ji\"tUm^'vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\u00079\u000b)\u0004C\u0004\u00028\u0005=\u0002\u0019\u0001\"\u000239,w/T;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0005\b\u0003w\u0001A\u0011IA\u001f\u0003m9\u0018\u000e\u001e5OK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fiR\u0019a*a\u0010\t\u000f\u0005\u0005\u0013\u0011\ba\u0001\u0005\u00069b.Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0005\b\u0003\u000b\u0002A\u0011IA$\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003\u0013\u0002b!a\u0013\u0002\\\u0005\u0005d\u0002BA'\u0003/rA!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'\u0002\u0012A\u0002\u001fs_>$h(C\u0001&\u0013\r\tI\u0006J\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti&a\u0018\u0003\u0007M+\u0017OC\u0002\u0002Z\u0011\u0002B!a\u0019\u0002j5\u0011\u0011Q\r\u0006\u0004\u0003OB\u0011!\u0002;za\u0016\u001c\u0018\u0002BA6\u0003K\u0012\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\t\u000f\u0005=\u0004\u0001\"\u0011\u0002r\u0005Aa.\u001e7mC\ndW-\u0006\u0002\u0002tA\u00191%!\u001e\n\u0007\u0005]DEA\u0004C_>dW-\u00198\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~\u0005AA-\u0019;b)f\u0004X-\u0006\u0002\u0002\u0000A!\u00111MAA\u0013\u0011\t\u0019)!\u001a\u0003\u0011\u0011\u000bG/\u0019+za\u0016Dq!a\"\u0001\t\u0003\nI)\u0001\u0005dQ&dGM]3o+\t\tY\tE\u0003\u0002L\u0005mc\u0006C\u0004\u0002\u0010\u0002!\t%!%\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002\u0014B!\u0011QSAO\u001d\u0011\t9*!'\u0011\u0007\u0005=C%C\u0002\u0002\u001c\u0012\na\u0001\u0015:fI\u00164\u0017\u0002BAP\u0003C\u0013aa\u0015;sS:<'bAANI!I\u0011Q\u0015\u0001\u0002\u0002\u0013\u0005\u0011qU\u0001\u0005G>\u0004\u0018\u0010F\u0007O\u0003S\u000bY+!,\u00020\u0006E\u00161\u0017\u0005\tY\u0005\r\u0006\u0013!a\u0001]!AA'a)\u0011\u0002\u0003\u0007a\u0006\u0003\u00059\u0003G\u0003\n\u00111\u0001/\u0011!a\u00141\u0015I\u0001\u0002\u0004q\u0003\u0002\u0003!\u0002$B\u0005\t\u0019\u0001\"\t\u0011!\u000b\u0019\u000b%AA\u0002\tC\u0011\"a.\u0001#\u0003%\t!!/\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0018\u0016\u0004]\u0005u6FAA`!\u0011\t\t-a3\u000e\u0005\u0005\r'\u0002BAc\u0003\u000f\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%G%\u0001\u0006b]:|G/\u0019;j_:LA!!4\u0002D\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005E\u0007!%A\u0005\u0002\u0005e\u0016AD2paf$C-\u001a4bk2$HE\r\u0005\n\u0003+\u0004\u0011\u0013!C\u0001\u0003s\u000babY8qs\u0012\"WMZ1vYR$3\u0007C\u0005\u0002Z\u0002\t\n\u0011\"\u0001\u0002:\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0004\"CAo\u0001E\u0005I\u0011AAp\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"!!9+\u0007\t\u000bi\fC\u0005\u0002f\u0002\t\n\u0011\"\u0001\u0002`\u0006q1m\u001c9zI\u0011,g-Y;mi\u00122\u0004\"CAu\u0001\u0005\u0005I\u0011IAv\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u001e\t\u0005\u0003_\fI0\u0004\u0002\u0002r*!\u00111_A{\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0018\u0001\u00026bm\u0006LA!a(\u0002r\"A\u0011Q \u0001\u0002\u0002\u0013\u0005\u0011)\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010C\u0005\u0003\u0002\u0001\t\t\u0011\"\u0001\u0003\u0004\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0005\u0005\u000bA\u0011Ba\u0002\u0002\u0000\u0006\u0005\t\u0019\u0001\"\u0002\u0007a$\u0013\u0007C\u0005\u0003\f\u0001\t\t\u0011\"\u0011\u0003\u000e\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u0010A1!\u0011\u0003B\f\u0003\u0013i!Aa\u0005\u000b\u0007\tUA%\u0001\u0006d_2dWm\u0019;j_:LAA!\u0007\u0003\u0014\tA\u0011\n^3sCR|'\u000fC\u0005\u0003\u001e\u0001\t\t\u0011\"\u0001\u0003 \u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002t\t\u0005\u0002B\u0003B\u0004\u00057\t\t\u00111\u0001\u0002\n!I!Q\u0005\u0001\u0002\u0002\u0013\u0005#qE\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005M$\u0011\u0006\u0005\u000b\u0005\u000f\u0011\u0019#!AA\u0002\u0005%\u0001f\u0002\u0001\u0003.\tM\"Q\u0007\t\u0004?\t=\u0012b\u0001B\u0019\t\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B\u001c\u0003\tE&\u0002\t\u0011!A}3UKT\"`Q\r|G\u000e\f\u0011faNd\u0003eY8oM&$WM\\2fY\u0001\u001aX-\u001a3*A5\u0002#+\u001a;ve:\u001c\b%\u0019\u0011d_VtG/L7j]\u0002\u001a8.\u001a;dQ\u0002zg\rI1!G>dW/\u001c8!o&$\b\u000e\t;iK\u0002:\u0017N^3oA\u0015\u001c\b\u000f\f\u0006!A\u0001\u0002\u0003\u0005I2p]\u001aLG-\u001a8dK\u0002\ng\u000e\u001a\u0011tK\u0016$g\u0006\t+iK\u0002\u0012Xm];mi\u0002J7\u000fI1oA\u0005\u0014(/Y=!_\u001a\u0004#-\u001f;fg2\u0002s\u000f[5dQ\u0002\u001a\u0017M\u001c\u0011cK\u0002\"Wm]3sS\u0006d\u0017N_3eAQ|\u0007%\u0019\u0006!A\u0001\u0002\u0003\u0005\t1D_VtG/T5o'.,Go\u00195aA\t,gm\u001c:fAU\u001c\u0018mZ3/A\r{WO\u001c;.[&t\u0007e]6fi\u000eD\u0007%[:!C\u0002\u0002(o\u001c2bE&d\u0017n\u001d;jG\u0002\"\u0017\r^1!gR\u0014Xo\u0019;ve\u0016\u0004So]3eA\u0019|'O\u0003\u0011!A\u0001\u0002\u0003eY1sI&t\u0017\r\\5us\u0002*7\u000f^5nCRLwN\u001c\u0011vg&tw\rI:vE6b\u0017N\\3be\u0002\u001a\b/Y2f])\u0001\u0003eB\u0005\u0003<\t\t\t\u0011#\u0001\u0003>\u0005\t2i\\;oi6KgnU6fi\u000eD\u0017iZ4\u0011\u0007M\u0011yD\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001B!'\u0015\u0011yDa\u0011)!-\u0011)Ea\u0013/]9r#I\u0011(\u000e\u0005\t\u001d#b\u0001B%I\u00059!/\u001e8uS6,\u0017\u0002\u0002B'\u0005\u000f\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c87\u0011\u001da%q\bC\u0001\u0005#\"\"A!\u0010\t\u0015\tU#qHA\u0001\n\u000b\u00129&\u0001\u0005u_N#(/\u001b8h)\t\ti\u000f\u0003\u0006\u0003\\\t}\u0012\u0011!CA\u0005;\nQ!\u00199qYf$RB\u0014B0\u0005C\u0012\u0019G!\u001a\u0003h\t%\u0004B\u0002\u0017\u0003Z\u0001\u0007a\u0006\u0003\u00045\u00053\u0002\rA\f\u0005\u0007q\te\u0003\u0019\u0001\u0018\t\rq\u0012I\u00061\u0001/\u0011\u0019\u0001%\u0011\fa\u0001\u0005\"1\u0001J!\u0017A\u0002\tC!B!\u001c\u0003@\u0005\u0005I\u0011\u0011B8\u0003\u001d)h.\u00199qYf$BA!\u001d\u0003~A)1Ea\u001d\u0003x%\u0019!Q\u000f\u0013\u0003\r=\u0003H/[8o!%\u0019#\u0011\u0010\u0018/]9\u0012%)C\u0002\u0003|\u0011\u0012a\u0001V;qY\u00164\u0004\"\u0003B@\u0005W\n\t\u00111\u0001O\u0003\rAH\u0005\r\u0005\u000b\u0005\u0007\u0013y$!A\u0005\n\t\u0015\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\"\u0011\t\u0005=(\u0011R\u0005\u0005\u0005\u0017\u000b\tP\u0001\u0004PE*,7\r\u001e")
public class CountMinSketchAgg
extends TypedImperativeAggregate<CountMinSketch>
implements ExpectsInputTypes,
Serializable {
    private double eps;
    private double confidence;
    private int seed;
    private final Expression child;
    private final Expression epsExpression;
    private final Expression confidenceExpression;
    private final Expression seedExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private volatile byte bitmap$0;

    public static Option<Tuple6<Expression, Expression, Expression, Expression, Object, Object>> unapply(CountMinSketchAgg countMinSketchAgg) {
        return CountMinSketchAgg$.MODULE$.unapply(countMinSketchAgg);
    }

    public static Function1<Tuple6<Expression, Expression, Expression, Expression, Object, Object>, CountMinSketchAgg> tupled() {
        return CountMinSketchAgg$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, CountMinSketchAgg>>>>>> curried() {
        return CountMinSketchAgg$.MODULE$.curried();
    }

    public Expression child() {
        return this.child;
    }

    public Expression epsExpression() {
        return this.epsExpression;
    }

    public Expression confidenceExpression() {
        return this.confidenceExpression;
    }

    public Expression seedExpression() {
        return this.seedExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private double eps$lzycompute() {
        CountMinSketchAgg countMinSketchAgg = this;
        synchronized (countMinSketchAgg) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.eps = BoxesRunTime.unboxToDouble((Object)this.epsExpression().eval(this.epsExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.eps;
    }

    private double eps() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.eps$lzycompute() : this.eps;
    }

    private double confidence$lzycompute() {
        CountMinSketchAgg countMinSketchAgg = this;
        synchronized (countMinSketchAgg) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.confidence = BoxesRunTime.unboxToDouble((Object)this.confidenceExpression().eval(this.confidenceExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.confidence;
    }

    private double confidence() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.confidence$lzycompute() : this.confidence;
    }

    private int seed$lzycompute() {
        CountMinSketchAgg countMinSketchAgg = this;
        synchronized (countMinSketchAgg) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.seed = BoxesRunTime.unboxToInt((Object)this.seedExpression().eval(this.seedExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.seed;
    }

    private int seed() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.seed$lzycompute() : this.seed;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.epsExpression().foldable() || !this.confidenceExpression().foldable() || !this.seedExpression().foldable() ? new TypeCheckResult.TypeCheckFailure("The eps, confidence or seed provided must be a literal or foldable") : (this.epsExpression().eval(this.epsExpression().eval$default$1()) == null || this.confidenceExpression().eval(this.confidenceExpression().eval$default$1()) == null || this.seedExpression().eval(this.seedExpression().eval$default$1()) == null ? new TypeCheckResult.TypeCheckFailure("The eps, confidence or seed provided should not be null") : (this.eps() <= 0.0 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(50).append("Relative error must be positive (current value = ").append(this.eps()).append(")").toString()) : (this.confidence() <= 0.0 || this.confidence() >= 1.0 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(61).append("Confidence must be within range (0.0, 1.0) (current value = ").append(this.confidence()).append(")").toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$))));
    }

    @Override
    public CountMinSketch createAggregationBuffer() {
        return CountMinSketch.create((double)this.eps(), (double)this.confidence(), (int)this.seed());
    }

    @Override
    public CountMinSketch update(CountMinSketch buffer, InternalRow input) {
        block2: {
            Object value = this.child().eval(input);
            if (value == null) break block2;
            DataType dataType = this.child().dataType();
            if (StringType$.MODULE$.equals(dataType)) {
                buffer.addBinary(((UTF8String)value).getBytes());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                buffer.add(value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        return buffer;
    }

    @Override
    public CountMinSketch merge(CountMinSketch buffer, CountMinSketch input) {
        buffer.mergeInPlace(input);
        return buffer;
    }

    @Override
    public Object eval(CountMinSketch buffer) {
        return this.serialize(buffer);
    }

    @Override
    public byte[] serialize(CountMinSketch buffer) {
        return buffer.toByteArray();
    }

    @Override
    public CountMinSketch deserialize(byte[] storageFormat) {
        return CountMinSketch.readFrom((byte[])storageFormat);
    }

    @Override
    public CountMinSketchAgg withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        int x$6 = this.copy$default$6();
        return this.copy(x$2, x$3, x$4, x$5, x$1, x$6);
    }

    @Override
    public CountMinSketchAgg withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$7 = newInputAggBufferOffset;
        Expression x$8 = this.copy$default$1();
        Expression x$9 = this.copy$default$2();
        Expression x$10 = this.copy$default$3();
        Expression x$11 = this.copy$default$4();
        int x$12 = this.copy$default$5();
        return this.copy(x$8, x$9, x$10, x$11, x$12, x$7);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegralType$.MODULE$, StringType$.MODULE$, BinaryType$.MODULE$})), DoubleType$.MODULE$, DoubleType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child(), this.epsExpression(), this.confidenceExpression(), this.seedExpression()}));
    }

    @Override
    public String prettyName() {
        return "count_min_sketch";
    }

    public CountMinSketchAgg copy(Expression child, Expression epsExpression, Expression confidenceExpression, Expression seedExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new CountMinSketchAgg(child, epsExpression, confidenceExpression, seedExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.epsExpression();
    }

    public Expression copy$default$3() {
        return this.confidenceExpression();
    }

    public Expression copy$default$4() {
        return this.seedExpression();
    }

    public int copy$default$5() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$6() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "CountMinSketchAgg";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.epsExpression();
                break;
            }
            case 2: {
                object = this.confidenceExpression();
                break;
            }
            case 3: {
                object = this.seedExpression();
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CountMinSketchAgg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CountMinSketchAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        CountMinSketchAgg countMinSketchAgg = (CountMinSketchAgg)x$1;
        Expression expression = this.child();
        Expression expression2 = countMinSketchAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.epsExpression();
        Expression expression4 = countMinSketchAgg.epsExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.confidenceExpression();
        Expression expression6 = countMinSketchAgg.confidenceExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.seedExpression();
        Expression expression8 = countMinSketchAgg.seedExpression();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (this.mutableAggBufferOffset() != countMinSketchAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != countMinSketchAgg.inputAggBufferOffset()) return false;
        if (!countMinSketchAgg.canEqual(this)) return false;
        return true;
    }

    public CountMinSketchAgg(Expression child, Expression epsExpression, Expression confidenceExpression, Expression seedExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.epsExpression = epsExpression;
        this.confidenceExpression = confidenceExpression;
        this.seedExpression = seedExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
    }

    public CountMinSketchAgg(Expression child, Expression epsExpression, Expression confidenceExpression, Expression seedExpression) {
        this(child, epsExpression, confidenceExpression, seedExpression, 0, 0);
    }
}

