/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n    _FUNC_(col, percentage [, accuracy]) - Returns the approximate percentile value of numeric\n      column `col` at the given percentage. The value of percentage must be between 0.0\n      and 1.0. The `accuracy` parameter (default: 10000) is a positive numeric literal which\n      controls approximation accuracy at the cost of memory. Higher value of `accuracy` yields\n      better accuracy, `1.0/accuracy` is the relative error of the approximation.\n      When `percentage` is an array, each value of the percentage array must be between 0.0 and 1.0.\n      In this case, returns the approximate percentile array of column `col` at the given\n      percentage array.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(10.0, array(0.5, 0.4, 0.1), 100);\n       [10.0,10.0,10.0]\n      > SELECT _FUNC_(10.0, 0.5, 100);\n       10.0\n  ")
@ScalaSignature(bytes="\u0006\u0001\r5b\u0001B\u0001\u0003\u0001F\u0011Q#\u00119qe>D\u0018.\\1uKB+'oY3oi&dWM\u0003\u0002\u0004\t\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003\u000b\u0019\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0001C\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M9\u0001AEAG\u0003'#\u0004cA\n\u0015-5\t!!\u0003\u0002\u0016\u0005\tAB+\u001f9fI&k\u0007/\u001a:bi&4X-Q4he\u0016<\u0017\r^3\u0011\u0005]\u0011eB\u0001\r*\u001d\tI\u0002F\u0004\u0002\u001bO9\u00111D\n\b\u00039\u0015r!!\b\u0013\u000f\u0005y\u0019cBA\u0010#\u001b\u0005\u0001#BA\u0011\u0011\u0003\u0019a$o\\8u}%\tq\"\u0003\u0002\u000e\u001d%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u000f\u0015Q#\u0001#\u0001,\u0003U\t\u0005\u000f\u001d:pq&l\u0017\r^3QKJ\u001cWM\u001c;jY\u0016\u0004\"a\u0005\u0017\u0007\u000b\u0005\u0011\u0001\u0012A\u0017\u0014\u00071rC\u0007\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0004B]f\u0014VM\u001a\t\u0003_UJ!A\u000e\u0019\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000babC\u0011A\u001d\u0002\rqJg.\u001b;?)\u0005Y\u0003bB\u001e-\u0005\u0004%\t\u0001P\u0001\u001c\t\u00163\u0015)\u0016'U?B+%kQ#O)&cUiX!D\u0007V\u0013\u0016iQ-\u0016\u0003u\u0002\"a\f \n\u0005}\u0002$aA%oi\"1\u0011\t\fQ\u0001\nu\nA\u0004R#G\u0003VcEk\u0018)F%\u000e+e\nV%M\u000b~\u000b5iQ+S\u0003\u000eK\u0006E\u0002\u0003DY\u0001!%\u0001\u0005)fe\u000e,g\u000e^5mK\u0012Kw-Z:u'\t\u0011e\u0006\u0003\u0005G\u0005\n\u0005\r\u0011\"\u0003H\u0003%\u0019X/\\7be&,7/F\u0001I!\tIE*D\u0001K\u0015\tYe!\u0001\u0003vi&d\u0017BA'K\u0005E\tV/\u00198uS2,7+^7nCJLWm\u001d\u0005\t\u001f\n\u0013\t\u0019!C\u0005!\u0006i1/^7nCJLWm]0%KF$\"!\u0015+\u0011\u0005=\u0012\u0016BA*1\u0005\u0011)f.\u001b;\t\u000fUs\u0015\u0011!a\u0001\u0011\u0006\u0019\u0001\u0010J\u0019\t\u0011]\u0013%\u0011!Q!\n!\u000b!b];n[\u0006\u0014\u0018.Z:!\u0011\u0015A$\t\"\u0001Z)\tQF\f\u0005\u0002\\\u00056\tA\u0006C\u0003G1\u0002\u0007\u0001\nC\u00039\u0005\u0012\u0005a\f\u0006\u0002[?\")\u0001-\u0018a\u0001C\u0006i!/\u001a7bi&4X-\u0012:s_J\u0004\"a\f2\n\u0005\r\u0004$A\u0002#pk\ndW\r\u0003\u0004f\u0005\u0012\u0005\u0001BZ\u0001\rSN\u001cu.\u001c9sKN\u001cX\rZ\u000b\u0002OB\u0011q\u0006[\u0005\u0003SB\u0012qAQ8pY\u0016\fg\u000eC\u0003l\u0005\u0012\u0005q)A\trk\u0006tG/\u001b7f'VlW.\u0019:jKNDQ!\u001c\"\u0005\u00029\f1!\u00193e)\t\tv\u000eC\u0003qY\u0002\u0007\u0011-A\u0003wC2,X\rC\u0003s\u0005\u0012\u00051/A\u0003nKJ<W\r\u0006\u0002Ri\")Q/\u001da\u00015\u0006)q\u000e\u001e5fe\")qO\u0011C\u0001q\u0006qq-\u001a;QKJ\u001cWM\u001c;jY\u0016\u001cHCA=}!\ry#0Y\u0005\u0003wB\u0012Q!\u0011:sCfDQ! <A\u0002e\f1\u0002]3sG\u0016tG/Y4fg\"1qP\u0011C\u0007\u0003\u0003\t\u0001bY8naJ,7o\u001d\u000b\u0002#\u001a1\u0011Q\u0001\u0017\u0001\u0003\u000f\u0011!\u0004U3sG\u0016tG/\u001b7f\t&<Wm\u001d;TKJL\u0017\r\\5{KJ\u001c2!a\u0001/\u0011\u001dA\u00141\u0001C\u0001\u0003\u0017!\"!!\u0004\u0011\u0007m\u000b\u0019\u0001\u0003\u0005\u0002\u0012\u0005\rAQBA\n\u0003\u0019aWM\\4uQR\u0019Q(!\u0006\t\r\u0019\u000by\u00011\u0001I\u0011!\tI\"a\u0001\u0005\u0006\u0005m\u0011!C:fe&\fG.\u001b>f)\u0011\ti\"!\n\u0011\t=R\u0018q\u0004\t\u0004_\u0005\u0005\u0012bAA\u0012a\t!!)\u001f;f\u0011\u001d\t9#a\u0006A\u0002i\u000b1a\u001c2k\u0011!\tY#a\u0001\u0005\u0006\u00055\u0012a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$2AWA\u0018\u0011!\t\t$!\u000bA\u0002\u0005u\u0011!\u00022zi\u0016\u001c\b\"CA\u001bY\t\u0007I\u0011AA\u001c\u0003)\u0019XM]5bY&TXM]\u000b\u0003\u0003\u001bA\u0001\"a\u000f-A\u0003%\u0011QB\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0005C\u0005\u0002@1\n\t\u0011\"!\u0002B\u0005)\u0011\r\u001d9msRa\u00111IA#\u0003#\n)&!\u0017\u0002^A\u00111\u0003\u0001\u0005\t\u0003\u000f\ni\u00041\u0001\u0002J\u0005)1\r[5mIB!\u00111JA'\u001b\u0005!\u0011bAA(\t\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u0005M\u0013Q\ba\u0001\u0003\u0013\nA\u0003]3sG\u0016tG/Y4f\u000bb\u0004(/Z:tS>t\u0007\u0002CA,\u0003{\u0001\r!!\u0013\u0002%\u0005\u001c7-\u001e:bGf,\u0005\u0010\u001d:fgNLwN\u001c\u0005\b\u00037\ni\u00041\u0001>\u0003YiW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\bbBA0\u0003{\u0001\r!P\u0001\u0015S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\t\u0013\u0005\rD&!A\u0005\u0002\u0006\u0015\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003O\n\u0019\bE\u00030\u0003S\ni'C\u0002\u0002lA\u0012aa\u00149uS>t\u0007cC\u0018\u0002p\u0005%\u0013\u0011JA%{uJ1!!\u001d1\u0005\u0019!V\u000f\u001d7fk!Q\u0011QOA1\u0003\u0003\u0005\r!a\u0011\u0002\u0007a$\u0003\u0007C\u0005\u0002z1\n\t\u0011\"\u0003\u0002|\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\b\u0005\u0003\u0002\u0000\u0005%UBAAA\u0015\u0011\t\u0019)!\"\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000f\u000bAA[1wC&!\u00111RAA\u0005\u0019y%M[3diB!\u00111JAH\u0013\r\t\t\n\u0002\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0019q&!&\n\u0007\u0005]\u0005GA\u0004Qe>$Wo\u0019;\t\u0015\u0005\u001d\u0003A!f\u0001\n\u0003\tY*\u0006\u0002\u0002J!Q\u0011q\u0014\u0001\u0003\u0012\u0003\u0006I!!\u0013\u0002\r\rD\u0017\u000e\u001c3!\u0011)\t\u0019\u0006\u0001BK\u0002\u0013\u0005\u00111\u0014\u0005\u000b\u0003K\u0003!\u0011#Q\u0001\n\u0005%\u0013!\u00069fe\u000e,g\u000e^1hK\u0016C\bO]3tg&|g\u000e\t\u0005\u000b\u0003/\u0002!Q3A\u0005\u0002\u0005m\u0005BCAV\u0001\tE\t\u0015!\u0003\u0002J\u0005\u0019\u0012mY2ve\u0006\u001c\u00170\u0012=qe\u0016\u001c8/[8oA!I\u00111\f\u0001\u0003\u0016\u0004%\t\u0005\u0010\u0005\n\u0003c\u0003!\u0011#Q\u0001\nu\nq#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\t\u0013\u0005}\u0003A!f\u0001\n\u0003b\u0004\"CA\\\u0001\tE\t\u0015!\u0003>\u0003UIg\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0002Ba\u0001\u000f\u0001\u0005\u0002\u0005mF\u0003DA\"\u0003{\u000by,!1\u0002D\u0006\u0015\u0007\u0002CA$\u0003s\u0003\r!!\u0013\t\u0011\u0005M\u0013\u0011\u0018a\u0001\u0003\u0013B\u0001\"a\u0016\u0002:\u0002\u0007\u0011\u0011\n\u0005\b\u00037\nI\f1\u0001>\u0011\u001d\ty&!/A\u0002uBa\u0001\u000f\u0001\u0005\u0002\u0005%G\u0003CA\"\u0003\u0017\fi-a4\t\u0011\u0005\u001d\u0013q\u0019a\u0001\u0003\u0013B\u0001\"a\u0015\u0002H\u0002\u0007\u0011\u0011\n\u0005\t\u0003/\n9\r1\u0001\u0002J!1\u0001\b\u0001C\u0001\u0003'$b!a\u0011\u0002V\u0006]\u0007\u0002CA$\u0003#\u0004\r!!\u0013\t\u0011\u0005M\u0013\u0011\u001ba\u0001\u0003\u0013B\u0011\"a7\u0001\u0011\u000b\u0007I\u0011\u0002\u001f\u0002\u0011\u0005\u001c7-\u001e:bGfDq!a8\u0001\t\u0003\n\t/\u0001\u0006j]B,H\u000fV=qKN,\"!a9\u0011\r\u0005\u0015\u0018q^A{\u001d\u0011\t9/a;\u000f\u0007}\tI/C\u00012\u0013\r\ti\u000fM\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t0a=\u0003\u0007M+\u0017OC\u0002\u0002nB\u0002B!a>\u0002~6\u0011\u0011\u0011 \u0006\u0004\u0003wD\u0011!\u0002;za\u0016\u001c\u0018\u0002BA\u0000\u0003s\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\t\u0017U\u0003\u0001\u0013!EDB\u0013%!1A\u000b\u0003\u0005\u000b\u0001Ra\fB\u0004OfL1A!\u00031\u0005\u0019!V\u000f\u001d7fe!I!Q\u0002\u0001\t\u0006\u0004%IAZ\u0001\u0016e\u0016$XO\u001d8QKJ\u001cWM\u001c;jY\u0016\f%O]1z\u0011%i\b\u0001#b\u0001\n\u0013\u0011\t\"F\u0001z\u0011\u001d\u0011)\u0002\u0001C!\u0005/\t1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\"A!\u0007\u0011\t\tm!\u0011E\u0007\u0003\u0005;Q1Aa\b\u0007\u0003!\tg.\u00197zg&\u001c\u0018\u0002\u0002B\u0012\u0005;\u0011q\u0002V=qK\u000eCWmY6SKN,H\u000e\u001e\u0005\b\u0005O\u0001A\u0011\tB\u0015\u0003]\u0019'/Z1uK\u0006;wM]3hCRLwN\u001c\"vM\u001a,'\u000fF\u0001\u0017\u0011\u001d\u0011i\u0003\u0001C!\u0005_\ta!\u001e9eCR,G#\u0002\f\u00032\tU\u0002b\u0002B\u001a\u0005W\u0001\rAF\u0001\u0007EV4g-\u001a:\t\u0011\t]\"1\u0006a\u0001\u0005s\t\u0001\"\u001b8qkR\u0014vn\u001e\t\u0005\u0005w\u0011i$D\u0001\u0007\u0013\r\u0011yD\u0002\u0002\f\u0013:$XM\u001d8bYJ{w\u000f\u0003\u0004s\u0001\u0011\u0005#1\t\u000b\u0006-\t\u0015#q\t\u0005\b\u0005g\u0011\t\u00051\u0001\u0017\u0011\u0019)(\u0011\ta\u0001-!9!1\n\u0001\u0005B\t5\u0013\u0001B3wC2$BAa\u0014\u0003VA\u0019qF!\u0015\n\u0007\tM\u0003GA\u0002B]fDqAa\r\u0003J\u0001\u0007a\u0003C\u0004\u0003Z\u0001!\tEa\u0017\u0002;]LG\u000f\u001b(fo6+H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$B!a\u0011\u0003^!9!q\fB,\u0001\u0004i\u0014!\u00038fo>3gm]3u\u0011\u001d\u0011\u0019\u0007\u0001C!\u0005K\n1d^5uQ:+w/\u00138qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$H\u0003BA\"\u0005OBqAa\u0018\u0003b\u0001\u0007Q\bC\u0004\u0003l\u0001!\tE!\u001c\u0002\u0011\rD\u0017\u000e\u001c3sK:,\"Aa\u001c\u0011\r\u0005\u0015\u0018q^A%\u0011\u0019\u0011\u0019\b\u0001C!M\u0006Aa.\u001e7mC\ndW\rC\u0004\u0003x\u0001!\tE!\u001f\u0002\u0011\u0011\fG/\u0019+za\u0016,\"Aa\u001f\u0011\t\u0005](QP\u0005\u0005\u0005\u007f\nIP\u0001\u0005ECR\fG+\u001f9f\u0011\u001d\u0011\u0019\t\u0001C!\u0005\u000b\u000b!\u0002\u001d:fiRLh*Y7f+\t\u00119\t\u0005\u0003\u0003\n\nEe\u0002\u0002BF\u0005\u001b\u0003\"a\b\u0019\n\u0007\t=\u0005'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005'\u0013)J\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005\u001f\u0003\u0004bBA\r\u0001\u0011\u0005#\u0011\u0014\u000b\u0005\u0003;\u0011Y\nC\u0004\u0002(\t]\u0005\u0019\u0001\f\t\u000f\u0005-\u0002\u0001\"\u0011\u0003 R\u0019aC!)\t\u0011\u0005E\"Q\u0014a\u0001\u0003;A\u0011B!*\u0001\u0003\u0003%\tAa*\u0002\t\r|\u0007/\u001f\u000b\r\u0003\u0007\u0012IKa+\u0003.\n=&\u0011\u0017\u0005\u000b\u0003\u000f\u0012\u0019\u000b%AA\u0002\u0005%\u0003BCA*\u0005G\u0003\n\u00111\u0001\u0002J!Q\u0011q\u000bBR!\u0003\u0005\r!!\u0013\t\u0013\u0005m#1\u0015I\u0001\u0002\u0004i\u0004\"CA0\u0005G\u0003\n\u00111\u0001>\u0011%\u0011)\fAI\u0001\n\u0003\u00119,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\te&\u0006BA%\u0005w[#A!0\u0011\t\t}&\u0011Z\u0007\u0003\u0005\u0003TAAa1\u0003F\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u000f\u0004\u0014AC1o]>$\u0018\r^5p]&!!1\u001aBa\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005\u001f\u0004\u0011\u0013!C\u0001\u0005o\u000babY8qs\u0012\"WMZ1vYR$#\u0007C\u0005\u0003T\u0002\t\n\u0011\"\u0001\u00038\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0004\"\u0003Bl\u0001E\u0005I\u0011\u0001Bm\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"Aa7+\u0007u\u0012Y\fC\u0005\u0003`\u0002\t\n\u0011\"\u0001\u0003Z\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0004\"\u0003Br\u0001\u0005\u0005I\u0011\tBs\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!q\u001d\t\u0005\u0003\u007f\u0012I/\u0003\u0003\u0003\u0014\u0006\u0005\u0005\u0002\u0003Bw\u0001\u0005\u0005I\u0011\u0001\u001f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0013\tE\b!!A\u0005\u0002\tM\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u001f\u0012)\u0010\u0003\u0005V\u0005_\f\t\u00111\u0001>\u0011%\u0011I\u0010AA\u0001\n\u0003\u0012Y0A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011i\u0010\u0005\u0004\u0003\u0000\u000e\u0015!qJ\u0007\u0003\u0007\u0003Q1aa\u00011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0007\u000f\u0019\tA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\u0019Y\u0001AA\u0001\n\u0003\u0019i!\u0001\u0005dC:,\u0015/^1m)\r97q\u0002\u0005\n+\u000e%\u0011\u0011!a\u0001\u0005\u001fB\u0011ba\u0005\u0001\u0003\u0003%\te!\u0006\u0002\r\u0015\fX/\u00197t)\r97q\u0003\u0005\n+\u000eE\u0011\u0011!a\u0001\u0005\u001fB3\u0002AB\u000e\u0007C\u0019\u0019ca\n\u0004*A!\u00111JB\u000f\u0013\r\u0019y\u0002\u0002\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0019)#AC \u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK2pY2\u0002\u0003/\u001a:dK:$\u0018mZ3!72\u0002\u0013mY2ve\u0006\u001c\u00170X\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!CB\u0004(o\u001c=j[\u0006$X\r\t9fe\u000e,g\u000e^5mK\u00022\u0018\r\\;fA=4\u0007E\\;nKJL7M\u0003\u0011!A\u0001\u0002\u0003eY8mk6t\u0007\u0005Y2pY\u0002\u0004\u0013\r\u001e\u0011uQ\u0016\u0004s-\u001b<f]\u0002\u0002XM]2f]R\fw-\u001a\u0018!)\",\u0007E^1mk\u0016\u0004sN\u001a\u0011qKJ\u001cWM\u001c;bO\u0016\u0004S.^:uA\t,\u0007EY3uo\u0016,g\u000e\t\u0019/a)\u0001\u0003\u0005\t\u0011!A\u0005tG\rI\u0019/a9\u0002C\u000b[3!A\u0006\u001c7-\u001e:bGf\u0004\u0007\u0005]1sC6,G/\u001a:!Q\u0011,g-Y;mij\u0002\u0013\u0007\r\u00191a%\u0002\u0013n\u001d\u0011bAA|7/\u001b;jm\u0016\u0004c.^7fe&\u001c\u0007\u0005\\5uKJ\fG\u000eI<iS\u000eD'\u0002\t\u0011!A\u0001\u00023m\u001c8ue>d7\u000fI1qaJ|\u00070[7bi&|g\u000eI1dGV\u0014\u0018mY=!CR\u0004C\u000f[3!G>\u001cH\u000fI8gA5,Wn\u001c:z]\u0001B\u0015n\u001a5fe\u00022\u0018\r\\;fA=4\u0007\u0005Y1dGV\u0014\u0018mY=aAeLW\r\u001c3t\u0015\u0001\u0002\u0003\u0005\t\u0011!E\u0016$H/\u001a:!C\u000e\u001cWO]1ds2\u0002\u0003-\r\u00181_\u0005\u001c7-\u001e:bGf\u0004\u0007%[:!i\",\u0007E]3mCRLg/\u001a\u0011feJ|'\u000fI8gAQDW\rI1qaJ|\u00070[7bi&|gN\f\u0006!A\u0001\u0002\u0003\u0005I,iK:\u0004\u0003\r]3sG\u0016tG/Y4fA\u0002J7\u000fI1oA\u0005\u0014(/Y=-A\u0015\f7\r\u001b\u0011wC2,X\rI8gAQDW\r\t9fe\u000e,g\u000e^1hK\u0002\n'O]1zA5,8\u000f\u001e\u0011cK\u0002\u0012W\r^<fK:\u0004\u0003G\f\u0019!C:$\u0007%\r\u00181])\u0001\u0003\u0005\t\u0011!A%s\u0007\u0005\u001e5jg\u0002\u001a\u0017m]3-AI,G/\u001e:og\u0002\"\b.\u001a\u0011baB\u0014x\u000e_5nCR,\u0007\u0005]3sG\u0016tG/\u001b7fA\u0005\u0014(/Y=!_\u001a\u00043m\u001c7v[:\u0004\u0003mY8mA\u0002\nG\u000f\t;iK\u0002:\u0017N^3o\u0015\u0001\u0002\u0003\u0005\t\u0011!a\u0016\u00148-\u001a8uC\u001e,\u0007%\u0019:sCft#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#aa\u000b\u0002\u0003SQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\r\u0019/a1\u0002\u0013M\u001d:bs\"\u0002d&\u000e\u0017!a9\"D\u0006\t\u0019/c%b\u0003%\r\u00191SmR\u0001\u0005\t\u0011!A\u0001\u00023,\r\u0019/a1\n\u0004G\f\u0019-cAr\u0003'\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)cAr\u0003\u0007\f\u00111]Ub\u0003%\r\u00191SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013\u0007\r\u00181\u0015\u0001\u0002\u0003")
public class ApproximatePercentile
extends TypedImperativeAggregate<PercentileDigest>
implements ImplicitCastInputTypes,
scala.Serializable {
    private int accuracy;
    private Tuple2<Object, double[]> x$1;
    private boolean returnPercentileArray;
    private double[] percentages;
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression accuracyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private volatile byte bitmap$0;

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(ApproximatePercentile approximatePercentile) {
        return ApproximatePercentile$.MODULE$.unapply(approximatePercentile);
    }

    public static PercentileDigestSerializer serializer() {
        return ApproximatePercentile$.MODULE$.serializer();
    }

    public static int DEFAULT_PERCENTILE_ACCURACY() {
        return ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY();
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    public Expression accuracyExpression() {
        return this.accuracyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private int accuracy$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.accuracy = BoxesRunTime.unboxToInt((Object)this.accuracyExpression().eval(this.accuracyExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.accuracy;
    }

    private int accuracy() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.accuracy$lzycompute() : this.accuracy;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$})), TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, ArrayType$.MODULE$.apply(DoubleType$.MODULE$)})), IntegerType$.MODULE$}));
    }

    private Tuple2<Object, double[]> x$1$lzycompute() {
        block10: {
            ApproximatePercentile approximatePercentile = this;
            synchronized (approximatePercentile) {
                boolean bl;
                double[] percentages;
                block12: {
                    Tuple2 tuple2;
                    block11: {
                        Tuple2 tuple22;
                        if ((byte)(this.bitmap$0 & 2) != 0) break block10;
                        Object object = this.percentageExpression().eval(this.percentageExpression().eval$default$1());
                        if (object instanceof Double) {
                            double d = BoxesRunTime.unboxToDouble((Object)object);
                            tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new double[]{d});
                        } else if (object instanceof ArrayData) {
                            ArrayData arrayData = (ArrayData)object;
                            tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)arrayData.toDoubleArray());
                        } else {
                            throw new MatchError(object);
                        }
                        tuple2 = tuple22;
                        if (tuple2 == null) break block11;
                        boolean returnPercentileArray = tuple2._1$mcZ$sp();
                        percentages = (double[])tuple2._2();
                        bl = returnPercentileArray;
                        if (percentages != null) break block12;
                    }
                    throw new MatchError((Object)tuple2);
                }
                double[] dArray = percentages;
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)bl), (Object)dArray);
                this.x$1 = tuple2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.x$1$lzycompute() : this.x$1;
    }

    private boolean returnPercentileArray$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.returnPercentileArray = this.x$1()._1$mcZ$sp();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.returnPercentileArray;
    }

    private boolean returnPercentileArray() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.returnPercentileArray$lzycompute() : this.returnPercentileArray;
    }

    private double[] percentages$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.percentages = (double[])this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.percentages;
    }

    private double[] percentages() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.percentages$lzycompute() : this.percentages;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.percentageExpression().foldable() || !this.accuracyExpression().foldable() ? new TypeCheckResult.TypeCheckFailure("The accuracy or percentage provided must be a constant literal") : (this.accuracy() <= 0 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(75).append("The accuracy provided must be a positive integer literal (current value = ").append(this.accuracy()).append(")").toString()) : (new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.percentages())).exists((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)percentage -> percentage < 0.0 || percentage > 1.0) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(50).append("All percentage values must be between 0.0 and 1.0 ").append(new StringBuilder(12).append("(current = ").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.percentages())).mkString(", ")).append(")").toString()).toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$)));
    }

    @Override
    public PercentileDigest createAggregationBuffer() {
        double relativeError = 1.0 / (double)this.accuracy();
        return new PercentileDigest(relativeError);
    }

    @Override
    public PercentileDigest update(PercentileDigest buffer, InternalRow inputRow) {
        block7: {
            double d;
            Object value = this.child().eval(inputRow);
            if (value == null) break block7;
            DataType dataType = this.child().dataType();
            if (DateType$.MODULE$.equals(dataType)) {
                d = BoxesRunTime.unboxToInt((Object)value);
            } else if (TimestampType$.MODULE$.equals(dataType)) {
                d = BoxesRunTime.unboxToLong((Object)value);
            } else if (dataType instanceof NumericType) {
                NumericType numericType = (NumericType)dataType;
                d = numericType.numeric().toDouble(value);
            } else {
                if (dataType != null) {
                    DataType dataType2 = dataType;
                    throw new UnsupportedOperationException(new StringBuilder(21).append("Unexpected data type ").append(dataType2.catalogString()).toString());
                }
                throw new MatchError((Object)dataType);
            }
            double doubleValue = d;
            buffer.add(doubleValue);
        }
        return buffer;
    }

    @Override
    public PercentileDigest merge(PercentileDigest buffer, PercentileDigest other) {
        buffer.merge(other);
        return buffer;
    }

    @Override
    public Object eval(PercentileDigest buffer) {
        Object object;
        double[] doubleResult = buffer.getPercentiles(this.percentages());
        DataType dataType = this.child().dataType();
        if (DateType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x$2 -> (int)x$2, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)x$3 -> (long)x$3, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        } else if (ByteType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToByte((byte)ApproximatePercentile.$anonfun$eval$3(BoxesRunTime.unboxToDouble((Object)x$4))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToShort((short)ApproximatePercentile.$anonfun$eval$4(BoxesRunTime.unboxToDouble((Object)x$5))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Short()));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x$6 -> (int)x$6, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        } else if (LongType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)x$7 -> (long)x$7, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$8 -> (float)x$8, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            object = doubleResult;
        } else if (dataType instanceof DecimalType) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1 & Serializable & scala.Serializable)x$9 -> Decimal$.MODULE$.apply(BoxesRunTime.unboxToDouble((Object)x$9)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Decimal.class)));
        } else {
            if (dataType != null) {
                DataType dataType2 = dataType;
                throw new UnsupportedOperationException(new StringBuilder(21).append("Unexpected data type ").append(dataType2.catalogString()).toString());
            }
            throw new MatchError((Object)dataType);
        }
        Object result = object;
        return ScalaRunTime$.MODULE$.array_length(result) == 0 ? null : (this.returnPercentileArray() ? new GenericArrayData(result) : ScalaRunTime$.MODULE$.array_apply(result, 0));
    }

    @Override
    public ApproximatePercentile withNewMutableAggBufferOffset(int newOffset) {
        int x$10 = newOffset;
        Expression x$11 = this.copy$default$1();
        Expression x$12 = this.copy$default$2();
        Expression x$13 = this.copy$default$3();
        int x$14 = this.copy$default$5();
        return this.copy(x$11, x$12, x$13, x$10, x$14);
    }

    @Override
    public ApproximatePercentile withNewInputAggBufferOffset(int newOffset) {
        int x$15 = newOffset;
        Expression x$16 = this.copy$default$1();
        Expression x$17 = this.copy$default$2();
        Expression x$18 = this.copy$default$3();
        int x$19 = this.copy$default$4();
        return this.copy(x$16, x$17, x$18, x$19, x$15);
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child(), this.percentageExpression(), this.accuracyExpression()}));
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.returnPercentileArray() ? new ArrayType(this.child().dataType(), false) : this.child().dataType();
    }

    @Override
    public String prettyName() {
        return "percentile_approx";
    }

    @Override
    public byte[] serialize(PercentileDigest obj) {
        return ApproximatePercentile$.MODULE$.serializer().serialize(obj);
    }

    @Override
    public PercentileDigest deserialize(byte[] bytes) {
        return ApproximatePercentile$.MODULE$.serializer().deserialize(bytes);
    }

    public ApproximatePercentile copy(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproximatePercentile(child, percentageExpression, accuracyExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.accuracyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ApproximatePercentile";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.percentageExpression();
                break;
            }
            case 2: {
                object = this.accuracyExpression();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproximatePercentile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproximatePercentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproximatePercentile approximatePercentile = (ApproximatePercentile)x$1;
        Expression expression = this.child();
        Expression expression2 = approximatePercentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = approximatePercentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.accuracyExpression();
        Expression expression6 = approximatePercentile.accuracyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.mutableAggBufferOffset() != approximatePercentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != approximatePercentile.inputAggBufferOffset()) return false;
        if (!approximatePercentile.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ byte $anonfun$eval$3(double x$4) {
        return (byte)x$4;
    }

    public static final /* synthetic */ short $anonfun$eval$4(double x$5) {
        return (short)x$5;
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.accuracyExpression = accuracyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression) {
        this(child, percentageExpression, accuracyExpression, 0, 0);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY())));
    }

    public static class PercentileDigest {
        private QuantileSummaries summaries;

        private QuantileSummaries summaries() {
            return this.summaries;
        }

        private void summaries_$eq(QuantileSummaries x$1) {
            this.summaries = x$1;
        }

        public boolean isCompressed() {
            return this.summaries().compressed();
        }

        public QuantileSummaries quantileSummaries() {
            block0: {
                if (this.isCompressed()) break block0;
                this.compress();
            }
            return this.summaries();
        }

        public void add(double value) {
            this.summaries_$eq(this.summaries().insert(value));
        }

        public void merge(PercentileDigest other) {
            if (!this.isCompressed()) {
                this.compress();
            }
            this.summaries_$eq(this.summaries().merge(other.quantileSummaries()));
        }

        /*
         * WARNING - void declaration
         */
        public double[] getPercentiles(double[] percentages) {
            double[] dArray;
            if (!this.isCompressed()) {
                this.compress();
            }
            if (this.summaries().count() == 0L || percentages.length == 0) {
                dArray = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
            } else {
                void var2_2;
                double[] result = new double[percentages.length];
                for (int i = 0; i < percentages.length; ++i) {
                    result[i] = BoxesRunTime.unboxToDouble((Object)this.summaries().query(percentages[i]).get());
                }
                dArray = var2_2;
            }
            return dArray;
        }

        private final void compress() {
            this.summaries_$eq(this.summaries().compress());
        }

        public PercentileDigest(QuantileSummaries summaries) {
            this.summaries = summaries;
        }

        public PercentileDigest(double relativeError) {
            int x$20 = QuantileSummaries$.MODULE$.defaultCompressThreshold();
            double x$21 = relativeError;
            boolean x$22 = true;
            QuantileSummaries.Stats[] x$23 = QuantileSummaries$.MODULE$.$lessinit$greater$default$3();
            long x$24 = QuantileSummaries$.MODULE$.$lessinit$greater$default$4();
            this(new QuantileSummaries(x$20, x$21, x$23, x$24, x$22));
        }
    }

    public static class PercentileDigestSerializer {
        private final int length(QuantileSummaries summaries) {
            return 24 + summaries.sampled().length * 24;
        }

        public final byte[] serialize(PercentileDigest obj) {
            QuantileSummaries summary = obj.quantileSummaries();
            ByteBuffer buffer = ByteBuffer.wrap(new byte[this.length(summary)]);
            buffer.putInt(summary.compressThreshold());
            buffer.putDouble(summary.relativeError());
            buffer.putLong(summary.count());
            buffer.putInt(summary.sampled().length);
            for (int i = 0; i < summary.sampled().length; ++i) {
                QuantileSummaries.Stats stat = summary.sampled()[i];
                buffer.putDouble(stat.value());
                buffer.putLong(stat.g());
                buffer.putLong(stat.delta());
            }
            return buffer.array();
        }

        public final PercentileDigest deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            int compressThreshold = buffer.getInt();
            double relativeError = buffer.getDouble();
            long count = buffer.getLong();
            int sampledLength = buffer.getInt();
            QuantileSummaries.Stats[] sampled = new QuantileSummaries.Stats[sampledLength];
            for (int i = 0; i < sampledLength; ++i) {
                double value = buffer.getDouble();
                long g = buffer.getLong();
                long delta = buffer.getLong();
                sampled[i] = new QuantileSummaries.Stats(value, g, delta);
            }
            QuantileSummaries summary = new QuantileSummaries(compressThreshold, relativeError, sampled, count, true);
            return new PercentileDigest(summary);
        }
    }
}

