/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.ZipWith$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(left, right, func) - Merges the two given arrays, element-wise, into a single array using function. If one array is shorter, nulls are appended at the end to match the length of the longer array, before applying function.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array('a', 'b', 'c'), (x, y) -> (y, x));\n       [{\"y\":\"a\",\"x\":1},{\"y\":\"b\",\"x\":2},{\"y\":\"c\",\"x\":3}]\n      > SELECT _FUNC_(array(1, 2), array(3, 4), (x, y) -> x + y);\n       [4,6]\n      > SELECT _FUNC_(array('a', 'b', 'c'), array('d', 'e', 'f'), (x, y) -> concat(x, y));\n       [\"ad\",\"be\",\"cf\"]\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\tma\u0001B\u0001\u0003\u0001>\u0011qAW5q/&$\bN\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0001\u0003F\f\u001eGA\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\t\u0016\u0013\t1\"AA\nIS\u001eDWM](sI\u0016\u0014h)\u001e8di&|g\u000e\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\u0005\u000591m\u001c3fO\u0016t\u0017B\u0001\u000f\u001a\u0005=\u0019u\u000eZ3hK:4\u0015\r\u001c7cC\u000e\\\u0007C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"a\u0002)s_\u0012,8\r\u001e\t\u0003=\u0011J!!J\u0010\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011\u001d\u0002!Q3A\u0005\u0002!\nA\u0001\\3giV\t\u0001\u0003\u0003\u0005+\u0001\tE\t\u0015!\u0003\u0011\u0003\u0015aWM\u001a;!\u0011!a\u0003A!f\u0001\n\u0003A\u0013!\u0002:jO\"$\b\u0002\u0003\u0018\u0001\u0005#\u0005\u000b\u0011\u0002\t\u0002\rILw\r\u001b;!\u0011!\u0001\u0004A!f\u0001\n\u0003A\u0013\u0001\u00034v]\u000e$\u0018n\u001c8\t\u0011I\u0002!\u0011#Q\u0001\nA\t\u0011BZ;oGRLwN\u001c\u0011\t\u000bQ\u0002A\u0011A\u001b\u0002\rqJg.\u001b;?)\u00111t\u0007O\u001d\u0011\u0005E\u0001\u0001\"B\u00144\u0001\u0004\u0001\u0002\"\u0002\u00174\u0001\u0004\u0001\u0002\"\u0002\u00194\u0001\u0004\u0001\u0002\"B\u001e\u0001\t\u0003A\u0013a\u00044v]\u000e$\u0018n\u001c8G_J,e/\u00197\t\u000bu\u0002A\u0011\t \u0002\u0013\u0005\u0014x-^7f]R\u001cX#A \u0011\u0007\u0001C\u0005C\u0004\u0002B\r:\u0011!)R\u0007\u0002\u0007*\u0011AID\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001J!aR\u0010\u0002\u000fA\f7m[1hK&\u0011\u0011J\u0013\u0002\u0004'\u0016\f(BA$ \u0011\u0015a\u0005\u0001\"\u0011N\u00035\t'oZ;nK:$H+\u001f9fgV\ta\nE\u0002A\u0011>\u0003\"\u0001U*\u000e\u0003ES!A\u0015\u0004\u0002\u000bQL\b/Z:\n\u0005Q\u000b&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u00151\u0006\u0001\"\u0011?\u0003%1WO\\2uS>t7\u000fC\u0003Y\u0001\u0011\u0005S*A\u0007gk:\u001cG/[8o)f\u0004Xm\u001d\u0005\u00065\u0002!\teW\u0001\tI\u0006$\u0018\rV=qKV\tA\f\u0005\u0002Q;&\u0011a,\u0015\u0002\n\u0003J\u0014\u0018-\u001f+za\u0016DQ\u0001\u0019\u0001\u0005B\u0005\fAAY5oIR\u0011aG\u0019\u0005\u0006G~\u0003\r\u0001Z\u0001\u0002MB)a$\u001a\thc&\u0011am\b\u0002\n\rVt7\r^5p]J\u00022\u0001\u0011%i!\u0011q\u0012n\u001b8\n\u0005)|\"A\u0002+va2,'\u0007\u0005\u0002QY&\u0011Q.\u0015\u0002\t\t\u0006$\u0018\rV=qKB\u0011ad\\\u0005\u0003a~\u0011qAQ8pY\u0016\fg\u000e\u0005\u0002\u0012e&\u00111O\u0001\u0002\u000f\u0019\u0006l'\rZ1Gk:\u001cG/[8o\u0011))\b\u0001%A\t\b\u0004&IA^\u0001\u0005q\u0012\"\u0004'F\u0001x!\u0011q\u0012\u000e\u001f=\u0011\u0005EI\u0018B\u0001>\u0003\u0005Mq\u0015-\\3e\u0019\u0006l'\rZ1WCJL\u0017M\u00197f\u0011!a\b\u0001#b\u0001\n\u0003i\u0018a\u00037fMR,E.Z7WCJ,\u0012\u0001\u001f\u0015\u0003w~\u00042AHA\u0001\u0013\r\t\u0019a\b\u0002\niJ\fgn]5f]RD\u0011\"a\u0002\u0001\u0011\u000b\u0007I\u0011A?\u0002\u0019ILw\r\u001b;FY\u0016lg+\u0019:)\u0007\u0005\u0015q\u0010C\u0004\u0002\u000e\u0001!\t%a\u0004\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003#\t9\u0002E\u0002\u001f\u0003'I1!!\u0006 \u0005\r\te.\u001f\u0005\u000b\u00033\tY\u0001%AA\u0002\u0005m\u0011!B5oaV$\b\u0003BA\u000f\u0003?i\u0011\u0001B\u0005\u0004\u0003C!!aC%oi\u0016\u0014h.\u00197S_^Dq!!\n\u0001\t\u0003\n9#\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u000b\u0011\t\u0005-\u00121\u0007\b\u0005\u0003[\ty\u0003\u0005\u0002C?%\u0019\u0011\u0011G\u0010\u0002\rA\u0013X\rZ3g\u0013\u0011\t)$a\u000e\u0003\rM#(/\u001b8h\u0015\r\t\td\b\u0005\n\u0003w\u0001\u0011\u0011!C\u0001\u0003{\tAaY8qsR9a'a\u0010\u0002B\u0005\r\u0003\u0002C\u0014\u0002:A\u0005\t\u0019\u0001\t\t\u00111\nI\u0004%AA\u0002AA\u0001\u0002MA\u001d!\u0003\u0005\r\u0001\u0005\u0005\n\u0003\u000f\u0002\u0011\u0013!C\u0001\u0003\u0013\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002L)\u001a\u0001#!\u0014,\u0005\u0005=\u0003\u0003BA)\u00037j!!a\u0015\u000b\t\u0005U\u0013qK\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0017 \u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003;\n\u0019FA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!\u0019\u0001#\u0003%\t!!\u0013\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u0011Q\r\u0001\u0012\u0002\u0013\u0005\u0011\u0011J\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011%\tI\u0007AA\u0001\n\u0003\nY'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003[\u0002B!a\u001c\u0002z5\u0011\u0011\u0011\u000f\u0006\u0005\u0003g\n)(\u0001\u0003mC:<'BAA<\u0003\u0011Q\u0017M^1\n\t\u0005U\u0012\u0011\u000f\u0005\n\u0003{\u0002\u0011\u0011!C\u0001\u0003\u007f\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!!\u0011\u0007y\t\u0019)C\u0002\u0002\u0006~\u00111!\u00138u\u0011%\tI\tAA\u0001\n\u0003\tY)\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005E\u0011Q\u0012\u0005\u000b\u0003\u001f\u000b9)!AA\u0002\u0005\u0005\u0015a\u0001=%c!I\u00111\u0013\u0001\u0002\u0002\u0013\u0005\u0013QS\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0013\t\u0007\u00033\u000by*!\u0005\u000e\u0005\u0005m%bAAO?\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0005\u00161\u0014\u0002\t\u0013R,'/\u0019;pe\"I\u0011Q\u0015\u0001\u0002\u0002\u0013\u0005\u0011qU\u0001\tG\u0006tW)];bYR\u0019a.!+\t\u0015\u0005=\u00151UA\u0001\u0002\u0004\t\t\u0002C\u0005\u0002.\u0002\t\t\u0011\"\u0011\u00020\u00061Q-];bYN$2A\\AY\u0011)\ty)a+\u0002\u0002\u0003\u0007\u0011\u0011\u0003\u0015\u0010\u0001\u0005U\u00161XA_\u0003\u0003\f\u0019-a2\u0002JB\u0019\u0011#a.\n\u0007\u0005e&AA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005}\u0016!!3`\rVs5i\u0018\u0015mK\u001a$H\u0006\t:jO\"$H\u0006\t4v]\u000eL\u0003%\f\u0011NKJ<Wm\u001d\u0011uQ\u0016\u0004Co^8!O&4XM\u001c\u0011beJ\f\u0017p\u001d\u0017!K2,W.\u001a8u[]L7/\u001a\u0017!S:$x\u000eI1!g&tw\r\\3!CJ\u0014\u0018-\u001f\u0011vg&tw\r\t4v]\u000e$\u0018n\u001c8/A%3\u0007e\u001c8fA\u0005\u0014(/Y=!SN\u00043\u000f[8si\u0016\u0014H\u0006\t8vY2\u001c\b%\u0019:fA\u0005\u0004\b/\u001a8eK\u0012\u0004\u0013\r\u001e\u0011uQ\u0016\u0004SM\u001c3!i>\u0004S.\u0019;dQ\u0002\"\b.\u001a\u0011mK:<G\u000f\u001b\u0011pM\u0002\"\b.\u001a\u0011m_:<WM\u001d\u0011beJ\f\u0017\u0010\f\u0011cK\u001a|'/\u001a\u0011baBd\u00170\u001b8hA\u0019,hn\u0019;j_:t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0015\u0017Aa.\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)c1\u0002#\u0007\f\u00114S1\u0002\u0013M\u001d:bs\":\u0013m\n\u0017!O\t<C\u0006I\u0014dO%b\u0003\u0005\u000b=-AeL\u0003%\f !Qed\u0003\u0005_\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z6PI=#u\t\n'\u0005\f\u0012yEi\nT\u0010L>#s\nR$E\u0019\u0012-Ea\u0014#HM?-w\nJ(E\u000f\u0012dE1\u0012\u0003P\t\u001e4{vS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD\u0013\u0007\f\u00113S1\u0002\u0013M\u001d:bs\"\u001aD\u0006\t\u001b*Y\u0001B\u0003\u0010\f\u0011zS\u0001jc\b\t=!W\u0001J\u0018f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\i12TL\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0014bO1\u0002sEY\u0014-A\u001d\u001aw%\u000b\u0017!CJ\u0014\u0018-\u001f\u0015(I\u001eb\u0003eJ3(Y\u0001:cmJ\u0015-A!BH\u0006I=*A5r\u0004eY8oG\u0006$\b\u0006\u001f\u0017!s&J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.#C\u0012\u0014CF\t2fE1\u00123M\u001a\u0012^\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAf\u0003\u0015\u0011d\u0006\u000e\u00181\u000f%\tyMAA\u0001\u0012\u0003\t\t.A\u0004[SB<\u0016\u000e\u001e5\u0011\u0007E\t\u0019N\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAk'\u0015\t\u0019.a6$!!\tI.a8\u0011!A1TBAAn\u0015\r\tinH\u0001\beVtG/[7f\u0013\u0011\t\t/a7\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u00045\u0003'$\t!!:\u0015\u0005\u0005E\u0007BCAu\u0003'\f\t\u0011\"\u0012\u0002l\u0006AAo\\*ue&tw\r\u0006\u0002\u0002n!Q\u0011q^Aj\u0003\u0003%\t)!=\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fY\n\u00190!>\u0002x\"1q%!<A\u0002AAa\u0001LAw\u0001\u0004\u0001\u0002B\u0002\u0019\u0002n\u0002\u0007\u0001\u0003\u0003\u0006\u0002|\u0006M\u0017\u0011!CA\u0003{\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0000\n-\u0001#\u0002\u0010\u0003\u0002\t\u0015\u0011b\u0001B\u0002?\t1q\n\u001d;j_:\u0004bA\bB\u0004!A\u0001\u0012b\u0001B\u0005?\t1A+\u001e9mKNB\u0011B!\u0004\u0002z\u0006\u0005\t\u0019\u0001\u001c\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003\u0012\u0005M\u0017\u0011!C\u0005\u0005'\t1B]3bIJ+7o\u001c7wKR\u0011!Q\u0003\t\u0005\u0003_\u00129\"\u0003\u0003\u0003\u001a\u0005E$AB(cU\u0016\u001cG\u000f")
public class ZipWith
extends Expression
implements HigherOrderFunction,
CodegenFallback,
Serializable {
    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$40;
    private transient NamedLambdaVariable leftElemVar;
    private transient NamedLambdaVariable rightElemVar;
    private final Expression left;
    private final Expression right;
    private final Expression function;
    private boolean argumentsResolved;
    private boolean resolved;
    private transient Seq<Expression> functionsForEval;
    private volatile byte bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(ZipWith zipWith) {
        return ZipWith$.MODULE$.unapply(zipWith);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, ZipWith> tupled() {
        return ZipWith$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, ZipWith>>> curried() {
        return ZipWith$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public boolean nullable() {
        return HigherOrderFunction.nullable$(this);
    }

    @Override
    public Seq<Expression> children() {
        return HigherOrderFunction.children$(this);
    }

    @Override
    public TypeCheckResult checkArgumentDataTypes() {
        return HigherOrderFunction.checkArgumentDataTypes$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return HigherOrderFunction.inputTypes$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean argumentsResolved$lzycompute() {
        ZipWith zipWith = this;
        synchronized (zipWith) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.argumentsResolved = HigherOrderFunction.argumentsResolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.argumentsResolved;
    }

    @Override
    public boolean argumentsResolved() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.argumentsResolved$lzycompute() : this.argumentsResolved;
    }

    private boolean resolved$lzycompute() {
        ZipWith zipWith = this;
        synchronized (zipWith) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.resolved = HigherOrderFunction.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private Seq<Expression> functionsForEval$lzycompute() {
        ZipWith zipWith = this;
        synchronized (zipWith) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.functionsForEval = HigherOrderFunction.functionsForEval$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.functionsForEval;
    }

    @Override
    public Seq<Expression> functionsForEval() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.functionsForEval$lzycompute() : this.functionsForEval;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    public Expression function() {
        return this.function;
    }

    public Expression functionForEval() {
        return (Expression)this.functionsForEval().head();
    }

    @Override
    public Seq<Expression> arguments() {
        Expression expression = this.left();
        Expression expression2 = this.right();
        return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> argumentTypes() {
        ArrayType$ arrayType$ = ArrayType$.MODULE$;
        ArrayType$ arrayType$2 = ArrayType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)arrayType$2).$colon$colon((Object)arrayType$);
    }

    @Override
    public Seq<Expression> functions() {
        return new .colon.colon((Object)this.function(), (List)Nil$.MODULE$);
    }

    @Override
    public Seq<AbstractDataType> functionTypes() {
        AnyDataType$ anyDataType$ = AnyDataType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)anyDataType$);
    }

    @Override
    public ArrayType dataType() {
        return new ArrayType(this.function().dataType(), this.function().nullable());
    }

    @Override
    public ZipWith bind(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        DataType rightElementType;
        DataType leftElementType;
        DataType dataType = this.left().dataType();
        if (!(dataType instanceof ArrayType)) {
            throw new MatchError((Object)dataType);
        }
        ArrayType arrayType = (ArrayType)dataType;
        DataType dataType2 = leftElementType = arrayType.elementType();
        DataType leftElementType2 = dataType2;
        DataType dataType3 = this.right().dataType();
        if (!(dataType3 instanceof ArrayType)) {
            throw new MatchError((Object)dataType3);
        }
        ArrayType arrayType2 = (ArrayType)dataType3;
        DataType dataType4 = rightElementType = arrayType2.elementType();
        DataType rightElementType2 = dataType4;
        Tuple2 tuple2 = new Tuple2((Object)leftElementType2, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        Tuple2 tuple22 = new Tuple2((Object)rightElementType2, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        LambdaFunction x$58 = (LambdaFunction)f.apply((Object)this.function(), (Object)Nil$.MODULE$.$colon$colon((Object)tuple22).$colon$colon((Object)tuple2));
        Expression x$59 = this.copy$default$1();
        Expression x$60 = this.copy$default$2();
        return this.copy(x$59, x$60, x$58);
    }

    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$40$lzycompute() {
        block5: {
            ZipWith zipWith = this;
            synchronized (zipWith) {
                NamedLambdaVariable namedLambdaVariable;
                NamedExpression rightElemVar;
                block7: {
                    Expression expression;
                    block6: {
                        LambdaFunction lambdaFunction;
                        Seq<NamedExpression> seq;
                        Some some;
                        if ((byte)(this.bitmap$0 & 1) != 0) break block5;
                        expression = this.function();
                        if (!(expression instanceof LambdaFunction) || (some = Seq$.MODULE$.unapplySeq(seq = (lambdaFunction = (LambdaFunction)expression).arguments())).isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block6;
                        NamedExpression leftElemVar = (NamedExpression)((SeqLike)some.get()).apply(0);
                        rightElemVar = (NamedExpression)((SeqLike)some.get()).apply(1);
                        if (!(leftElemVar instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable = (NamedLambdaVariable)leftElemVar;
                        if (rightElemVar instanceof NamedLambdaVariable) break block7;
                    }
                    throw new MatchError((Object)expression);
                }
                NamedLambdaVariable namedLambdaVariable2 = (NamedLambdaVariable)rightElemVar;
                Tuple2 tuple2 = new Tuple2((Object)namedLambdaVariable, (Object)namedLambdaVariable2);
                this.x$40 = tuple2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$40;
    }

    private /* synthetic */ Tuple2 x$40() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$40$lzycompute() : this.x$40;
    }

    private NamedLambdaVariable leftElemVar$lzycompute() {
        ZipWith zipWith = this;
        synchronized (zipWith) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.leftElemVar = (NamedLambdaVariable)this.x$40()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.leftElemVar;
    }

    public NamedLambdaVariable leftElemVar() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.leftElemVar$lzycompute() : this.leftElemVar;
    }

    private NamedLambdaVariable rightElemVar$lzycompute() {
        ZipWith zipWith = this;
        synchronized (zipWith) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.rightElemVar = (NamedLambdaVariable)this.x$40()._2();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.rightElemVar;
    }

    public NamedLambdaVariable rightElemVar() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.rightElemVar$lzycompute() : this.rightElemVar;
    }

    @Override
    public Object eval(InternalRow input) {
        GenericArrayData genericArrayData;
        ArrayData leftArr = (ArrayData)this.left().eval(input);
        if (leftArr == null) {
            genericArrayData = null;
        } else {
            ArrayData rightArr = (ArrayData)this.right().eval(input);
            if (rightArr == null) {
                genericArrayData = null;
            } else {
                int resultLength = package$.MODULE$.max(leftArr.numElements(), rightArr.numElements());
                Expression f = this.functionForEval();
                GenericArrayData result = new GenericArrayData(new Object[resultLength]);
                for (int i = 0; i < resultLength; ++i) {
                    if (i < leftArr.numElements()) {
                        this.leftElemVar().value().set(leftArr.get(i, this.leftElemVar().dataType()));
                    } else {
                        this.leftElemVar().value().set(null);
                    }
                    if (i < rightArr.numElements()) {
                        this.rightElemVar().value().set(rightArr.get(i, this.rightElemVar().dataType()));
                    } else {
                        this.rightElemVar().value().set(null);
                    }
                    result.update(i, f.eval(input));
                }
                genericArrayData = result;
            }
        }
        return genericArrayData;
    }

    @Override
    public String prettyName() {
        return "zip_with";
    }

    public ZipWith copy(Expression left, Expression right, Expression function) {
        return new ZipWith(left, right, function);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Expression copy$default$3() {
        return this.function();
    }

    @Override
    public String productPrefix() {
        return "ZipWith";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 2: {
                expression = this.function();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ZipWith;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ZipWith)) return false;
        boolean bl = true;
        if (!bl) return false;
        ZipWith zipWith = (ZipWith)x$1;
        Expression expression = this.left();
        Expression expression2 = zipWith.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = zipWith.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.function();
        Expression expression6 = zipWith.function();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!zipWith.canEqual(this)) return false;
        return true;
    }

    public ZipWith(Expression left, Expression right, Expression function) {
        this.left = left;
        this.right = right;
        this.function = function;
        ExpectsInputTypes.$init$(this);
        HigherOrderFunction.$init$(this);
        CodegenFallback.$init$(this);
    }
}

