/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrimRight$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the trailing space characters from `str`.\n\n    _FUNC_(trimStr, str) - Removes the trailing string which contains the characters from the trim string from the `str`\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_('LQSa', 'SSparkSQLS');\n       SSpark\n  ")
@ScalaSignature(bytes="\u0006\u0001\u00055w!B\u0001\u0003\u0011\u0003y\u0011aD*ue&tw\r\u0016:j[JKw\r\u001b;\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0001\"\u0001E\t\u000e\u0003\t1QA\u0005\u0002\t\u0002M\u0011qb\u0015;sS:<GK]5n%&<\u0007\u000e^\n\u0004#QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u00167%\u0011AD\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006=E!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=AQ!I\t\u0005\u0002\t\nQ!\u00199qYf$RaIAJ\u0003/\u0003\"\u0001\u0005\u0013\u0007\tI\u0011\u0001)J\n\u0006I\u0019JCF\u0007\t\u0003!\u001dJ!\u0001\u000b\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002\u0011U%\u00111F\u0001\u0002\u0016'R\u0014\u0018N\\43)JLW.\u0012=qe\u0016\u001c8/[8o!\t)R&\u0003\u0002/-\t9\u0001K]8ek\u000e$\b\u0002\u0003\u0019%\u0005+\u0007I\u0011A\u0019\u0002\rM\u00148m\u0015;s+\u00051\u0003\u0002C\u001a%\u0005#\u0005\u000b\u0011\u0002\u0014\u0002\u000fM\u00148m\u0015;sA!AQ\u0007\nBK\u0002\u0013\u0005a'A\u0004ue&l7\u000b\u001e:\u0016\u0003]\u00022!\u0006\u001d'\u0013\tIdC\u0001\u0004PaRLwN\u001c\u0005\tw\u0011\u0012\t\u0012)A\u0005o\u0005AAO]5n'R\u0014\b\u0005C\u0003\u001fI\u0011\u0005Q\bF\u0002$}}BQ\u0001\r\u001fA\u0002\u0019Bq!\u000e\u001f\u0011\u0002\u0003\u0007q\u0007C\u0003\u001fI\u0011\u0005\u0011\tF\u0002$\u0005\u000eCQ!\u000e!A\u0002\u0019BQ\u0001\r!A\u0002\u0019BQA\b\u0013\u0005\u0002\u0015#\"a\t$\t\u000bA\"\u0005\u0019\u0001\u0014\t\u000b!#C\u0011I%\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001K!\tY%K\u0004\u0002M!B\u0011QJF\u0007\u0002\u001d*\u0011qJD\u0001\u0007yI|w\u000e\u001e \n\u0005E3\u0012A\u0002)sK\u0012,g-\u0003\u0002T)\n11\u000b\u001e:j]\u001eT!!\u0015\f\t\u000bY#C\u0011I,\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012\u0001\u0017\t\u00043z3cB\u0001.]\u001d\ti5,C\u0001\u0018\u0013\tif#A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0003'aA*fc*\u0011QL\u0006\u0005\u0006E\u0012\"\teY\u0001\u0005KZ\fG\u000e\u0006\u0002eOB\u0011Q#Z\u0005\u0003MZ\u00111!\u00118z\u0011\u001dA\u0017\r%AA\u0002%\fQ!\u001b8qkR\u0004\"A[6\u000e\u0003\u0011I!\u0001\u001c\u0003\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0006]\u0012\"\tf\\\u0001\nI><UM\\\"pI\u0016$2\u0001\u001d<|!\t\tH/D\u0001s\u0015\t\u0019(!A\u0004d_\u0012,w-\u001a8\n\u0005U\u0014(\u0001C#yaJ\u001cu\u000eZ3\t\u000b]l\u0007\u0019\u0001=\u0002\u0007\r$\b\u0010\u0005\u0002rs&\u0011!P\u001d\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015aX\u000e1\u0001q\u0003\t)g\u000fC\u0004\u007fI\u0005\u0005I\u0011A@\u0002\t\r|\u0007/\u001f\u000b\u0006G\u0005\u0005\u00111\u0001\u0005\bau\u0004\n\u00111\u0001'\u0011\u001d)T\u0010%AA\u0002]B\u0011\"a\u0002%#\u0003%\t!!\u0003\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0002\u0016\u0004M\u000551FAA\b!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005ea#\u0001\u0006b]:|G/\u0019;j_:LA!!\b\u0002\u0014\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005\u0005B%%A\u0005\u0002\u0005\r\u0012AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003KQ3aNA\u0007\u0011%\tI\u0003JA\u0001\n\u0003\nY#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003[\u0001B!a\f\u0002:5\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$\u0001\u0003mC:<'BAA\u001c\u0003\u0011Q\u0017M^1\n\u0007M\u000b\t\u0004C\u0005\u0002>\u0011\n\t\u0011\"\u0001\u0002@\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\t\t\u0004+\u0005\r\u0013bAA#-\t\u0019\u0011J\u001c;\t\u0013\u0005%C%!A\u0005\u0002\u0005-\u0013A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004I\u00065\u0003BCA(\u0003\u000f\n\t\u00111\u0001\u0002B\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005MC%!A\u0005B\u0005U\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005]\u0003#BA-\u0003?\"WBAA.\u0015\r\tiFF\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA1\u00037\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003K\"\u0013\u0011!C\u0001\u0003O\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003S\ny\u0007E\u0002\u0016\u0003WJ1!!\u001c\u0017\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u0014\u0002d\u0005\u0005\t\u0019\u00013\t\u0013\u0005MD%!A\u0005B\u0005U\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002j\u0005]\u0004\"CA(\u0003c\n\t\u00111\u0001eQ=!\u00131PAA\u0003\u0007\u000b9)!#\u0002\u000e\u0006=\u0005c\u0001\t\u0002~%\u0019\u0011q\u0010\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QQ\u0001\u0002\u0004*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015tiJL\u0003%\f\u0011SK6|g/Z:!i\",\u0007\u0005\u001e:bS2Lgn\u001a\u0011ta\u0006\u001cW\rI2iCJ\f7\r^3sg\u00022'o\\7!AN$(\u000f\u0019\u0018\u000b\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b;sS6\u001cFO\u001d\u0017!gR\u0014\u0018\u0006I\u0017!%\u0016lwN^3tAQDW\r\t;sC&d\u0017N\\4!gR\u0014\u0018N\\4!o\"L7\r\u001b\u0011d_:$\u0018-\u001b8tAQDW\rI2iCJ\f7\r^3sg\u00022'o\\7!i\",\u0007\u0005\u001e:j[\u0002\u001aHO]5oO\u00022'o\\7!i\",\u0007\u0005Y:ue\u0002T\u0001\u0005I\u0001\nCJ<W/\\3oiN\f#!a#\u0002\u0003;Q\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I:ue\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:T\u0001\u0005\t\u0011!A\u0001R\u0003\u0005\u001e:j[N#(\u000fI\u0017!i\",\u0007\u0005\u001e:j[\u0002\u001aHO]5oO\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011u_\u0002\"(/[7-AQDW\r\t3fM\u0006,H\u000e\u001e\u0011wC2,X\rI5tA\u0005\u00043/\u001b8hY\u0016\u00043\u000f]1dK*\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\t*AA\u0007\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0003\u0005\t\u0011!'B\f'o[*R\u0019\u0002\u0002\u0003eJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\u0003\u0018M]6T#2S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n'R'\u0006<C\u0006I\u0014T'B\f'o[*R\u0019N;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011T'B\f'o\u001b\u0006!A!1\u0011Q\u0013\u0011A\u0002\u0019\n1a\u001d;s\u0011\u0015)\u0004\u00051\u0001'\u0011\u0019\t\u0013\u0003\"\u0001\u0002\u001cR\u00191%!(\t\u000f\u0005U\u0015\u0011\u0014a\u0001M!A\u0011%EA\u0001\n\u0003\u000b\t\u000bF\u0003$\u0003G\u000b)\u000b\u0003\u00041\u0003?\u0003\rA\n\u0005\tk\u0005}\u0005\u0013!a\u0001o!I\u0011\u0011V\t\u0002\u0002\u0013\u0005\u00151V\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti+!.\u0011\tUA\u0014q\u0016\t\u0006+\u0005EfeN\u0005\u0004\u0003g3\"A\u0002+va2,'\u0007C\u0005\u00028\u0006\u001d\u0016\u0011!a\u0001G\u0005\u0019\u0001\u0010\n\u0019\t\u0013\u0005m\u0016#%A\u0005\u0002\u0005\r\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#\u0007C\u0005\u0002@F\t\n\u0011\"\u0001\u0002$\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#\u0007C\u0005\u0002DF\t\t\u0011\"\u0003\u0002F\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t9\r\u0005\u0003\u00020\u0005%\u0017\u0002BAf\u0003c\u0011aa\u00142kK\u000e$\b")
public class StringTrimRight
extends Expression
implements String2TrimExpression,
scala.Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;

    public static Option<Expression> apply$default$2() {
        return StringTrimRight$.MODULE$.apply$default$2();
    }

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrimRight$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrimRight stringTrimRight) {
        return StringTrimRight$.MODULE$.unapply(stringTrimRight);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression srcStr() {
        return this.srcStr;
    }

    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "rtrim";
    }

    @Override
    public Seq<Expression> children() {
        List list;
        if (this.trimStr().isDefined()) {
            Expression expression = this.srcStr();
            Expression expression2 = (Expression)this.trimStr().get();
            list = Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
        } else {
            Expression expression = this.srcStr();
            list = Nil$.MODULE$.$colon$colon((Object)expression);
        }
        return list;
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String srcString = (UTF8String)this.srcStr().eval(input);
        return srcString == null ? null : (this.trimStr().isDefined() ? srcString.trimRight((UTF8String)((Expression)this.trimStr().get()).eval(input)) : srcString.trimRight());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Seq evals = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$44 -> x$44.genCode(ctx), Seq$.MODULE$.canBuildFrom());
        ExprCode srcString = (ExprCode)evals.apply(0);
        if (evals.length() == 1) {
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$45 -> x$45.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trimRight();\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), ev.value(), srcString.value()})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        } else {
            ExprCode trimString = (ExprCode)evals.apply(1);
            String getTrimRightFunction = new StringBuilder(89).append("\n        if (").append(trimString.isNull()).append(") {\n          ").append(ev.isNull()).append(" = true;\n        } else {\n          ").append(ev.value()).append(" = ").append(srcString.value()).append(".trimRight(").append(trimString.value()).append(");\n        }").toString();
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$46 -> x$46.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", "\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), getTrimRightFunction})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        }
        return exprCode;
    }

    public StringTrimRight copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrimRight(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrimRight";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<Expression> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.srcStr();
                break;
            }
            case 1: {
                option = this.trimStr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrimRight;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrimRight)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrimRight stringTrimRight = (StringTrimRight)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrimRight.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrimRight.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrimRight.canEqual(this)) return false;
        return true;
    }

    public StringTrimRight(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
    }

    public StringTrimRight(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrimRight(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

