/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrim$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading and trailing space characters from `str`.\n\n    _FUNC_(BOTH trimStr FROM str) - Remove the leading and trailing `trimStr` characters from `str`\n\n    _FUNC_(LEADING trimStr FROM str) - Remove the leading `trimStr` characters from `str`\n\n    _FUNC_(TRAILING trimStr FROM str) - Remove the trailing `trimStr` characters from `str`\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n      * BOTH, FROM - these are keywords to specify trimming string characters from both ends of\n          the string\n      * LEADING, FROM - these are keywords to specify trimming string characters from the left\n          end of the string\n      * TRAILING, FROM - these are keywords to specify trimming string characters from the right\n          end of the string\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_('SL', 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(BOTH 'SL' FROM 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(LEADING 'SL' FROM 'SSparkSQLS');\n       parkSQLS\n      > SELECT _FUNC_(TRAILING 'SL' FROM 'SSparkSQLS');\n       SSparkSQ\n  ")
@ScalaSignature(bytes="\u0006\u0001\u00055w!B\u0001\u0003\u0011\u0003y\u0011AC*ue&tw\r\u0016:j[*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u0011#5\t!AB\u0003\u0013\u0005!\u00051C\u0001\u0006TiJLgn\u001a+sS6\u001c2!\u0005\u000b\u001b!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fMB\u0011QcG\u0005\u00039Y\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQAH\t\u0005\u0002}\ta\u0001P5oSRtD#A\b\t\u000b\u0005\nB\u0011\u0001\u0012\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b\r\n\u0019*a&\u0011\u0005A!c\u0001\u0002\n\u0003\u0001\u0016\u001aR\u0001\n\u0014*Yi\u0001\"\u0001E\u0014\n\u0005!\u0012!AC#yaJ,7o]5p]B\u0011\u0001CK\u0005\u0003W\t\u0011Qc\u0015;sS:<'\u0007\u0016:j[\u0016C\bO]3tg&|g\u000e\u0005\u0002\u0016[%\u0011aF\u0006\u0002\b!J|G-^2u\u0011!\u0001DE!f\u0001\n\u0003\t\u0014AB:sGN#(/F\u0001'\u0011!\u0019DE!E!\u0002\u00131\u0013aB:sGN#(\u000f\t\u0005\tk\u0011\u0012)\u001a!C\u0001m\u00059AO]5n'R\u0014X#A\u001c\u0011\u0007UAd%\u0003\u0002:-\t1q\n\u001d;j_:D\u0001b\u000f\u0013\u0003\u0012\u0003\u0006IaN\u0001\tiJLWn\u0015;sA!)a\u0004\nC\u0001{Q\u00191EP \t\u000bAb\u0004\u0019\u0001\u0014\t\u000fUb\u0004\u0013!a\u0001o!)a\u0004\nC\u0001\u0003R\u00191EQ\"\t\u000bU\u0002\u0005\u0019\u0001\u0014\t\u000bA\u0002\u0005\u0019\u0001\u0014\t\u000by!C\u0011A#\u0015\u0005\r2\u0005\"\u0002\u0019E\u0001\u00041\u0003\"\u0002%%\t\u0003J\u0015A\u00039sKR$\u0018PT1nKV\t!\n\u0005\u0002L%:\u0011A\n\u0015\t\u0003\u001bZi\u0011A\u0014\u0006\u0003\u001f:\ta\u0001\u0010:p_Rt\u0014BA)\u0017\u0003\u0019\u0001&/\u001a3fM&\u00111\u000b\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005E3\u0002\"\u0002,%\t\u0003:\u0016\u0001C2iS2$'/\u001a8\u0016\u0003a\u00032!\u00170'\u001d\tQFL\u0004\u0002N7&\tq#\u0003\u0002^-\u00059\u0001/Y2lC\u001e,\u0017BA0a\u0005\r\u0019V-\u001d\u0006\u0003;ZAQA\u0019\u0013\u0005B\r\fA!\u001a<bYR\u0011Am\u001a\t\u0003+\u0015L!A\u001a\f\u0003\u0007\u0005s\u0017\u0010C\u0004iCB\u0005\t\u0019A5\u0002\u000b%t\u0007/\u001e;\u0011\u0005)\\W\"\u0001\u0003\n\u00051$!aC%oi\u0016\u0014h.\u00197S_^DQA\u001c\u0013\u0005B=\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u0007A48\u0010\u0005\u0002ri6\t!O\u0003\u0002t\u0005\u000591m\u001c3fO\u0016t\u0017BA;s\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"B<n\u0001\u0004A\u0018aA2uqB\u0011\u0011/_\u0005\u0003uJ\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003}[\u0002\u0007\u0001/\u0001\u0002fm\"9a\u0010JA\u0001\n\u0003y\u0018\u0001B2paf$RaIA\u0001\u0003\u0007Aq\u0001M?\u0011\u0002\u0003\u0007a\u0005C\u00046{B\u0005\t\u0019A\u001c\t\u0013\u0005\u001dA%%A\u0005\u0002\u0005%\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0017Q3AJA\u0007W\t\ty\u0001\u0005\u0003\u0002\u0012\u0005mQBAA\n\u0015\u0011\t)\"a\u0006\u0002\u0013Ut7\r[3dW\u0016$'bAA\r-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00111\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u0011IE\u0005I\u0011AA\u0012\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\n+\u0007]\ni\u0001C\u0005\u0002*\u0011\n\t\u0011\"\u0011\u0002,\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\f\u0011\t\u0005=\u0012\u0011H\u0007\u0003\u0003cQA!a\r\u00026\u0005!A.\u00198h\u0015\t\t9$\u0001\u0003kCZ\f\u0017bA*\u00022!I\u0011Q\b\u0013\u0002\u0002\u0013\u0005\u0011qH\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u0003\u00022!FA\"\u0013\r\t)E\u0006\u0002\u0004\u0013:$\b\"CA%I\u0005\u0005I\u0011AA&\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001ZA'\u0011)\ty%a\u0012\u0002\u0002\u0003\u0007\u0011\u0011I\u0001\u0004q\u0012\n\u0004\"CA*I\u0005\u0005I\u0011IA+\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA,!\u0015\tI&a\u0018e\u001b\t\tYFC\u0002\u0002^Y\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t'a\u0017\u0003\u0011%#XM]1u_JD\u0011\"!\u001a%\u0003\u0003%\t!a\u001a\u0002\u0011\r\fg.R9vC2$B!!\u001b\u0002pA\u0019Q#a\u001b\n\u0007\u00055dCA\u0004C_>dW-\u00198\t\u0013\u0005=\u00131MA\u0001\u0002\u0004!\u0007\"CA:I\u0005\u0005I\u0011IA;\u0003\u0019)\u0017/^1mgR!\u0011\u0011NA<\u0011%\ty%!\u001d\u0002\u0002\u0003\u0007A\rK\b%\u0003w\n\t)a!\u0002\b\u0006%\u0015QRAH!\r\u0001\u0012QP\u0005\u0004\u0003\u007f\u0012!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u000b\u000b!\u0011\u001d\u0006!A\u0001\u0002sLR+O\u0007~C3\u000f\u001e:*A5\u0002#+Z7pm\u0016\u001c\b\u0005\u001e5fA1,\u0017\rZ5oO\u0002\ng\u000e\u001a\u0011ue\u0006LG.\u001b8hAM\u0004\u0018mY3!G\"\f'/Y2uKJ\u001c\bE\u001a:p[\u0002\u00027\u000f\u001e:a])Q\u0001\u0005\t\u0011!?\u001a+fjQ0)\u0005>#\u0006\n\t;sS6\u001cFO\u001d\u0011G%>k\u0005e\u001d;sS\u0001j\u0003EU3n_Z,\u0007\u0005\u001e5fA1,\u0017\rZ5oO\u0002\ng\u000e\u001a\u0011ue\u0006LG.\u001b8hA\u0001$(/[7TiJ\u0004\u0007e\u00195be\u0006\u001cG/\u001a:tA\u0019\u0014x.\u001c\u0011agR\u0014\bM\u0003\u0006!A\u0001\u0002sLR+O\u0007~CC*R!E\u0013:;\u0005\u0005\u001e:j[N#(\u000f\t$S\u001f6\u00033\u000f\u001e:*A5\u0002#+Z7pm\u0016\u0004C\u000f[3!Y\u0016\fG-\u001b8hA\u0001$(/[7TiJ\u0004\u0007e\u00195be\u0006\u001cG/\u001a:tA\u0019\u0014x.\u001c\u0011agR\u0014\bM\u0003\u0006!A\u0001\u0002sLR+O\u0007~CCKU!J\u0019&su\t\t;sS6\u001cFO\u001d\u0011G%>k\u0005e\u001d;sS\u0001j\u0003EU3n_Z,\u0007\u0005\u001e5fAQ\u0014\u0018-\u001b7j]\u001e\u0004\u0003\r\u001e:j[N#(\u000f\u0019\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004cM]8nA\u0001\u001cHO\u001d1\u000bA\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005-\u0015aa>\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001aHO\u001d\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004S\r\u001f9sKN\u001c\u0018n\u001c8\u000bA\u0001\u0002\u0003\u0005\t\u0011+AQ\u0014\u0018.\\*ue\u0002j\u0003\u0005\u001e5fAQ\u0014\u0018.\u001c\u0011tiJLgn\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004Co\u001c\u0011ue&lG\u0006\t;iK\u0002\"WMZ1vYR\u0004c/\u00197vK\u0002J7\u000fI1!g&tw\r\\3!gB\f7-\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0016!\u0005>#\u0006\n\f\u0011G%>k\u0005%\f\u0011uQ\u0016\u001cX\rI1sK\u0002ZW-_<pe\u0012\u001c\b\u0005^8!gB,7-\u001b4zAQ\u0014\u0018.\\7j]\u001e\u00043\u000f\u001e:j]\u001e\u00043\r[1sC\u000e$XM]:!MJ|W\u000e\t2pi\"\u0004SM\u001c3tA=4'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!i\",\u0007e\u001d;sS:<'\u0002\t\u0011!A\u0001\u0002#\u0006\t'F\u0003\u0012Kej\u0012\u0017!\rJ{U\nI\u0017!i\",7/\u001a\u0011be\u0016\u00043.Z=x_J$7\u000f\t;pAM\u0004XmY5gs\u0002\"(/[7nS:<\u0007e\u001d;sS:<\u0007e\u00195be\u0006\u001cG/\u001a:tA\u0019\u0014x.\u001c\u0011uQ\u0016\u0004C.\u001a4u\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u001a8eA=4\u0007\u0005\u001e5fAM$(/\u001b8h\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"&+Q%M\u0013:;E\u0006\t$S\u001f6\u0003S\u0006\t;iKN,\u0007%\u0019:fA-,\u0017p^8sIN\u0004Co\u001c\u0011ta\u0016\u001c\u0017NZ=!iJLW.\\5oO\u0002\u001aHO]5oO\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005\u001e5fAILw\r\u001b;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002SM\u001c3!_\u001a\u0004C\u000f[3!gR\u0014\u0018N\\4\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003#\u000b!1\u0016\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O\u0001\u0002\u0003\u0005I*qCJ\\7+\u0015'!A\u0001:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011Ta\u0006\u00148nU)M\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3\u000bT\u0014-A\u001d\u001a6\u000b]1sWN\u000bFjU\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0018M]6T#*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C#i\u0014+IA\u001d\u001aFj\n\u0011G%>k\u0005eJ*Ta\u0006\u00148nU)M'\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t9be.\u001c\u0016K\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015M\u000b\u0006#\u0015JT$!OMcu\u0005\t$S\u001f6\u0003seU*qCJ\\7+\u0015'TO%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005]1sWN\u000bFj\u0015\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0))J\u000b\u0015\nT%O\u000f\u0002:3\u000bT\u0014!\rJ{U\nI\u0014T'B\f'o[*R\u0019N;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011T'B\f'o[*R\u0015\u0001\u0002\u0003BBAKA\u0001\u0007a%A\u0002tiJDQ!\u000e\u0011A\u0002\u0019Ba!I\t\u0005\u0002\u0005mEcA\u0012\u0002\u001e\"9\u0011QSAM\u0001\u00041\u0003\u0002C\u0011\u0012\u0003\u0003%\t)!)\u0015\u000b\r\n\u0019+!*\t\rA\ny\n1\u0001'\u0011!)\u0014q\u0014I\u0001\u0002\u00049\u0004\"CAU#\u0005\u0005I\u0011QAV\u0003\u001d)h.\u00199qYf$B!!,\u00026B!Q\u0003OAX!\u0015)\u0012\u0011\u0017\u00148\u0013\r\t\u0019L\u0006\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005]\u0016qUA\u0001\u0002\u0004\u0019\u0013a\u0001=%a!I\u00111X\t\u0012\u0002\u0013\u0005\u00111E\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005}\u0016#%A\u0005\u0002\u0005\r\u0012aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005\r\u0017#!A\u0005\n\u0005\u0015\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a2\u0011\t\u0005=\u0012\u0011Z\u0005\u0005\u0003\u0017\f\tD\u0001\u0004PE*,7\r\u001e")
public class StringTrim
extends Expression
implements String2TrimExpression,
scala.Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;

    public static Option<Expression> apply$default$2() {
        return StringTrim$.MODULE$.apply$default$2();
    }

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrim$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrim stringTrim) {
        return StringTrim$.MODULE$.unapply(stringTrim);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression srcStr() {
        return this.srcStr;
    }

    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "trim";
    }

    @Override
    public Seq<Expression> children() {
        List list;
        if (this.trimStr().isDefined()) {
            Expression expression = this.srcStr();
            Expression expression2 = (Expression)this.trimStr().get();
            list = Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
        } else {
            Expression expression = this.srcStr();
            list = Nil$.MODULE$.$colon$colon((Object)expression);
        }
        return list;
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String srcString = (UTF8String)this.srcStr().eval(input);
        return srcString == null ? null : (this.trimStr().isDefined() ? srcString.trim((UTF8String)((Expression)this.trimStr().get()).eval(input)) : srcString.trim());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Seq evals = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$32 -> x$32.genCode(ctx), Seq$.MODULE$.canBuildFrom());
        ExprCode srcString = (ExprCode)evals.apply(0);
        if (evals.length() == 1) {
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$33 -> x$33.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trim();\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), ev.value(), srcString.value()})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        } else {
            ExprCode trimString = (ExprCode)evals.apply(1);
            String getTrimFunction = new StringBuilder(84).append("\n        if (").append(trimString.isNull()).append(") {\n          ").append(ev.isNull()).append(" = true;\n        } else {\n          ").append(ev.value()).append(" = ").append(srcString.value()).append(".trim(").append(trimString.value()).append(");\n        }").toString();
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$34 -> x$34.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", "\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), getTrimFunction})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        }
        return exprCode;
    }

    public StringTrim copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrim(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrim";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<Expression> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.srcStr();
                break;
            }
            case 1: {
                option = this.trimStr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrim;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrim)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrim stringTrim = (StringTrim)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrim.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrim.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrim.canEqual(this)) return false;
        return true;
    }

    public StringTrim(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
    }

    public StringTrim(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrim(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

