/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Shuffle$;
import org.apache.spark.sql.catalyst.expressions.Stateful;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.RandomIndicesGenerator;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(array) - Returns a random permutation of the given array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 20, 3, 5));\n       [3,1,5,20]\n      > SELECT _FUNC_(array(1, 20, null, 3));\n       [20,null,3,1]\n  ", note="The function is non-deterministic.", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t\rc\u0001B\u0001\u0003\u0001>\u0011qa\u00155vM\u001adWM\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u001d\u0001\u0001\u0003F\f\u001b;\r\u0002\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"!E\u000b\n\u0005Y\u0011!!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011\u0011\u0003G\u0005\u00033\t\u0011\u0001b\u0015;bi\u00164W\u000f\u001c\t\u0003#mI!\u0001\b\u0002\u00031\u0015C\bO]3tg&|gnV5uQJ\u000bg\u000eZ8n'\u0016,G\r\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sDA\u0004Qe>$Wo\u0019;\u0011\u0005y!\u0013BA\u0013 \u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!9\u0003A!f\u0001\n\u0003A\u0013!B2iS2$W#A\u0015\u0011\u0005EQ\u0013BA\u0016\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\t[\u0001\u0011\t\u0012)A\u0005S\u000511\r[5mI\u0002B\u0001b\f\u0001\u0003\u0016\u0004%\t\u0001M\u0001\u000be\u0006tGm\\7TK\u0016$W#A\u0019\u0011\u0007y\u0011D'\u0003\u00024?\t1q\n\u001d;j_:\u0004\"AH\u001b\n\u0005Yz\"\u0001\u0002'p]\u001eD\u0001\u0002\u000f\u0001\u0003\u0012\u0003\u0006I!M\u0001\fe\u0006tGm\\7TK\u0016$\u0007\u0005C\u0003;\u0001\u0011\u00051(\u0001\u0004=S:LGO\u0010\u000b\u0004yur\u0004CA\t\u0001\u0011\u00159\u0013\b1\u0001*\u0011\u001dy\u0013\b%AA\u0002EBQA\u000f\u0001\u0005\u0002\u0001#\"\u0001P!\t\u000b\u001dz\u0004\u0019A\u0015\t\u000b\r\u0003A\u0011\t#\u0002\u0017]LG\u000f\u001b(foN+W\r\u001a\u000b\u0003y\u0015CQA\u0012\"A\u0002Q\nAa]3fI\"A\u0001\n\u0001EC\u0002\u0013\u0005\u0013*\u0001\u0005sKN|GN^3e+\u0005Q\u0005C\u0001\u0010L\u0013\tauDA\u0004C_>dW-\u00198\t\u000b9\u0003A\u0011I(\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001Q!\r\t\u0016\f\u0018\b\u0003%^s!a\u0015,\u000e\u0003QS!!\u0016\b\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0013B\u0001- \u0003\u001d\u0001\u0018mY6bO\u0016L!AW.\u0003\u0007M+\u0017O\u0003\u0002Y?A\u0011Q\fY\u0007\u0002=*\u0011qLB\u0001\u0006if\u0004Xm]\u0005\u0003Cz\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\t\u000b\r\u0004A\u0011\t3\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012!\u001a\t\u0003;\u001aL!a\u001a0\u0003\u0011\u0011\u000bG/\u0019+za\u0016D\u0001\"\u001b\u0001\t\u0006\u0004%\t\u0001Z\u0001\fK2,W.\u001a8u)f\u0004X\r\u000b\u0002iWB\u0011a\u0004\\\u0005\u0003[~\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u0013=\u0004\u0001\u0019!A!B\u0013\u0001\u0018A\u0002:b]\u0012|W\u000e\u0005\u0002ri6\t!O\u0003\u0002t\t\u0005!Q\u000f^5m\u0013\t)(O\u0001\fSC:$w.\\%oI&\u001cWm]$f]\u0016\u0014\u0018\r^8sQ\tq7\u000eC\u0003y\u0001\u0011E\u00130\u0001\nj]&$\u0018.\u00197ju\u0016Le\u000e^3s]\u0006dGC\u0001>~!\tq20\u0003\u0002}?\t!QK\\5u\u0011\u0015qx\u000f1\u0001\u0000\u00039\u0001\u0018M\u001d;ji&|g.\u00138eKb\u00042AHA\u0001\u0013\r\t\u0019a\b\u0002\u0004\u0013:$\bbBA\u0004\u0001\u0011E\u0013\u0011B\u0001\rKZ\fG.\u00138uKJt\u0017\r\u001c\u000b\u0005\u0003\u0017\t\t\u0002E\u0002\u001f\u0003\u001bI1!a\u0004 \u0005\r\te.\u001f\u0005\t\u0003'\t)\u00011\u0001\u0002\u0016\u0005)\u0011N\u001c9viB!\u0011qCA\r\u001b\u0005!\u0011bAA\u000e\t\tY\u0011J\u001c;fe:\fGNU8x\u0011\u001d\ty\u0002\u0001C)\u0003C\t\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005\r\u0012qFA\u001d!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"bAA\u0015\u0005\u000591m\u001c3fO\u0016t\u0017\u0002BA\u0017\u0003O\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\t\u0003c\ti\u00021\u0001\u00024\u0005\u00191\r\u001e=\u0011\t\u0005\u0015\u0012QG\u0005\u0005\u0003o\t9C\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u0011\u0005m\u0012Q\u0004a\u0001\u0003G\t!!\u001a<\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B\u0005\u00192\u000f[;gM2,\u0017I\u001d:bs\u000e{G-Z$f]RA\u00111IA*\u0003+\n9\u0006\u0005\u0003\u0002F\u00055c\u0002BA$\u0003\u0013\u0002\"aU\u0010\n\u0007\u0005-s$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\n\tF\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0017z\u0002\u0002CA\u0019\u0003{\u0001\r!a\r\t\u0011\u0005m\u0012Q\ba\u0001\u0003GA\u0001\"!\u0017\u0002>\u0001\u0007\u00111I\u0001\nG\"LG\u000e\u001a(b[\u0016Dq!!\u0018\u0001\t\u0003\ny&A\u0005ge\u0016\u001c\bnQ8qsR\tA\bC\u0005\u0002d\u0001\t\t\u0011\"\u0001\u0002f\u0005!1m\u001c9z)\u0015a\u0014qMA5\u0011!9\u0013\u0011\rI\u0001\u0002\u0004I\u0003\u0002C\u0018\u0002bA\u0005\t\u0019A\u0019\t\u0013\u00055\u0004!%A\u0005\u0002\u0005=\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003cR3!KA:W\t\t)\b\u0005\u0003\u0002x\u0005\u0005UBAA=\u0015\u0011\tY(! \u0002\u0013Ut7\r[3dW\u0016$'bAA@?\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0015\u0011\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CAD\u0001E\u0005I\u0011AAE\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a#+\u0007E\n\u0019\bC\u0005\u0002\u0010\u0002\t\t\u0011\"\u0011\u0002\u0012\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a%\u0011\t\u0005U\u0015qT\u0007\u0003\u0003/SA!!'\u0002\u001c\u0006!A.\u00198h\u0015\t\ti*\u0001\u0003kCZ\f\u0017\u0002BA(\u0003/C\u0011\"a)\u0001\u0003\u0003%\t!!*\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003}D\u0011\"!+\u0001\u0003\u0003%\t!a+\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111BAW\u0011%\ty+a*\u0002\u0002\u0003\u0007q0A\u0002yIEB\u0011\"a-\u0001\u0003\u0003%\t%!.\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a.\u0011\r\u0005e\u0016qXA\u0006\u001b\t\tYLC\u0002\u0002>~\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t-a/\u0003\u0011%#XM]1u_JD\u0011\"!2\u0001\u0003\u0003%\t!a2\u0002\u0011\r\fg.R9vC2$2ASAe\u0011)\ty+a1\u0002\u0002\u0003\u0007\u00111\u0002\u0005\n\u0003\u001b\u0004\u0011\u0011!C!\u0003\u001f\fa!Z9vC2\u001cHc\u0001&\u0002R\"Q\u0011qVAf\u0003\u0003\u0005\r!a\u0003)'\u0001\t).a7\u0002^\u0006\u0005\u00181]At\u0003S\fi/a<\u0011\u0007E\t9.C\u0002\u0002Z\n\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002`\u0006\u0001uLR+O\u0007~C\u0013M\u001d:bs&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011bAI\fg\u000eZ8nAA,'/\\;uCRLwN\u001c\u0011pM\u0002\"\b.\u001a\u0011hSZ,g\u000eI1se\u0006Lh&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t)/AA\u0012\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQEb\u0003E\r\u0019-AMb\u0003%N\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z6\u0007L\u0019-k1\u0012\u0004'\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00152Y\u0001\u0012\u0004\u0007\f\u0011ok2dG\u0006I\u001a*SmR\u0001\u0005\t\u0011!A\u0001\u00023L\r\u0019-]VdG\u000eL\u001a-cuS\u0001\u0005I\u0001\u0005]>$X-\t\u0002\u0002l\u0006\u0011C\u000b[3!MVt7\r^5p]\u0002J7\u000f\t8p]6\"W\r^3s[&t\u0017n\u001d;jG:\nQa]5oG\u0016\f#!!=\u0002\u000bIrCG\f\u0019\b\u0013\u0005U(!!A\t\u0002\u0005]\u0018aB*ik\u001a4G.\u001a\t\u0004#\u0005eh\u0001C\u0001\u0003\u0003\u0003E\t!a?\u0014\u000b\u0005e\u0018Q`\u0012\u0011\u000f\u0005}(QA\u00152y5\u0011!\u0011\u0001\u0006\u0004\u0005\u0007y\u0012a\u0002:v]RLW.Z\u0005\u0005\u0005\u000f\u0011\tAA\tBEN$(/Y2u\rVt7\r^5p]JBqAOA}\t\u0003\u0011Y\u0001\u0006\u0002\u0002x\"Q!qBA}\u0003\u0003%)E!\u0005\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a%\t\u0015\tU\u0011\u0011`A\u0001\n\u0003\u00139\"A\u0003baBd\u0017\u0010F\u0003=\u00053\u0011Y\u0002\u0003\u0004(\u0005'\u0001\r!\u000b\u0005\t_\tM\u0001\u0013!a\u0001c!Q!qDA}\u0003\u0003%\tI!\t\u0002\u000fUt\u0017\r\u001d9msR!!1\u0005B\u0016!\u0011q\"G!\n\u0011\u000by\u00119#K\u0019\n\u0007\t%rD\u0001\u0004UkBdWM\r\u0005\n\u0005[\u0011i\"!AA\u0002q\n1\u0001\u001f\u00131\u0011)\u0011\t$!?\u0012\u0002\u0013\u0005\u0011\u0011R\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\t\u0015\tU\u0012\u0011`I\u0001\n\u0003\tI)A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011)\u0011I$!?\u0002\u0002\u0013%!1H\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003>A!\u0011Q\u0013B \u0013\u0011\u0011\t%a&\u0003\r=\u0013'.Z2u\u0001")
public class Shuffle
extends UnaryExpression
implements ExpectsInputTypes,
Stateful,
ExpressionWithRandomSeed,
scala.Serializable {
    private boolean resolved;
    private transient DataType elementType;
    private final Expression child;
    private final Option<Object> randomSeed;
    private transient RandomIndicesGenerator random;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Object> apply$default$2() {
        return Shuffle$.MODULE$.apply$default$2();
    }

    public static Option<Object> $lessinit$greater$default$2() {
        return Shuffle$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Object>>> unapply(Shuffle shuffle) {
        return Shuffle$.MODULE$.unapply(shuffle);
    }

    public static Function1<Tuple2<Expression, Option<Object>>, Shuffle> tupled() {
        return Shuffle$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Object>, Shuffle>> curried() {
        return Shuffle$.MODULE$.curried();
    }

    @Override
    public boolean fastEquals(TreeNode<?> other) {
        return Stateful.fastEquals$(this, other);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean deterministic$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.deterministic$lzycompute() : this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Option<Object> randomSeed() {
        return this.randomSeed;
    }

    @Override
    public Shuffle withNewSeed(long seed) {
        Some x$82 = new Some((Object)BoxesRunTime.boxToLong((long)seed));
        Expression x$83 = this.copy$default$1();
        return this.copy(x$83, (Option<Object>)x$82);
    }

    private boolean resolved$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = this.childrenResolved() && this.checkInputDataTypes().isSuccess() && this.randomSeed().isDefined();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayType$[]{ArrayType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    private DataType elementType$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if (!this.bitmap$trans$0) {
                this.elementType = ((ArrayType)this.dataType()).elementType();
                this.bitmap$trans$0 = true;
            }
        }
        return this.elementType;
    }

    public DataType elementType() {
        return !this.bitmap$trans$0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.random = new RandomIndicesGenerator(BoxesRunTime.unboxToLong((Object)this.randomSeed().get()) + (long)partitionIndex);
    }

    @Override
    public Object evalInternal(InternalRow input) {
        GenericArrayData genericArrayData;
        Object value = this.child().eval(input);
        if (value == null) {
            genericArrayData = null;
        } else {
            ArrayData source = (ArrayData)value;
            int numElements = source.numElements();
            int[] indices = this.random.getNextIndices(numElements);
            genericArrayData = new GenericArrayData(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).map((Function1 & Serializable & scala.Serializable)x$24 -> source.get(BoxesRunTime.unboxToInt((Object)x$24), this.elementType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Object())));
        }
        return genericArrayData;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> this.shuffleArrayCodeGen(ctx, ev, (String)c));
    }

    private String shuffleArrayCodeGen(CodegenContext ctx, ExprCode ev, String childName) {
        String randomClass;
        String x$84 = randomClass = RandomIndicesGenerator.class.getName();
        String x$85 = "rand";
        boolean x$86 = true;
        Function1<String, String> x$87 = ctx.addMutableState$default$3();
        boolean x$88 = ctx.addMutableState$default$5();
        String rand = ctx.addMutableState(x$84, x$85, x$87, x$86, x$88);
        ctx.addPartitionInitializationStatement(new StringBuilder(28).append(rand).append(" = new ").append(randomClass).append("(").append(this.randomSeed().get()).append("L + partitionIndex);").toString());
        String numElements = ctx.freshName("numElements");
        String arrayData = ctx.freshName("arrayData");
        String indices = ctx.freshName("indices");
        String i = ctx.freshName("i");
        String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, this.elementType(), numElements, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, this.elementType(), childName, i, new StringBuilder(2).append(indices).append("[").append(i).append("]").toString(), ((ArrayType)this.dataType()).containsNull());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(150).append("\n       |int ").append(numElements).append(" = ").append(childName).append(".numElements();\n       |int[] ").append(indices).append(" = ").append(rand).append(".getNextIndices(").append(numElements).append(");\n       |").append(initialization).append("\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(numElements).append("; ").append(i).append("++) {\n       |  ").append(assignment).append("\n       |}\n       |").append(ev.value()).append(" = ").append(arrayData).append(";\n     ").toString())).stripMargin();
    }

    @Override
    public Shuffle freshCopy() {
        return new Shuffle(this.child(), this.randomSeed());
    }

    public Shuffle copy(Expression child, Option<Object> randomSeed) {
        return new Shuffle(child, randomSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<Object> copy$default$2() {
        return this.randomSeed();
    }

    @Override
    public String productPrefix() {
        return "Shuffle";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<Object> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.child();
                break;
            }
            case 1: {
                option = this.randomSeed();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Shuffle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Shuffle)) return false;
        boolean bl = true;
        if (!bl) return false;
        Shuffle shuffle = (Shuffle)x$1;
        Expression expression = this.child();
        Expression expression2 = shuffle.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Object> option = this.randomSeed();
        Option<Object> option2 = shuffle.randomSeed();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!shuffle.canEqual(this)) return false;
        return true;
    }

    public Shuffle(Expression child, Option<Object> randomSeed) {
        this.child = child;
        this.randomSeed = randomSeed;
        ExpectsInputTypes.$init$(this);
        Nondeterministic.$init$(this);
        Stateful.$init$(this);
    }

    public Shuffle(Expression child) {
        this(child, (Option<Object>)None$.MODULE$);
    }
}

