/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Reverse$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(array) - Returns a reversed string or an array with reverse order of elements.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL');\n       LQS krapS\n      > SELECT _FUNC_(array(2, 1, 4, 3));\n       [3,4,1,2]\n  ", since="1.5.0", note="Reverse logic for arrays is available since 2.4.0.")
@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001B\u0001\u0003\u0001>\u0011qAU3wKJ\u001cXM\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0003F\f\u001e!\t\t\"#D\u0001\u0003\u0013\t\u0019\"AA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\tR#\u0003\u0002\u0017\u0005\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012DA\u0004Qe>$Wo\u0019;\u0011\u0005aq\u0012BA\u0010\u001a\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\t\u0003A!f\u0001\n\u0003\u0011\u0013!B2iS2$W#A\u0012\u0011\u0005E!\u0013BA\u0013\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tO\u0001\u0011\t\u0012)A\u0005G\u000511\r[5mI\u0002BQ!\u000b\u0001\u0005\u0002)\na\u0001P5oSRtDCA\u0016-!\t\t\u0002\u0001C\u0003\"Q\u0001\u00071\u0005C\u0003/\u0001\u0011\u0005s&\u0001\u0006j]B,H\u000fV=qKN,\u0012\u0001\r\t\u0004cebdB\u0001\u001a8\u001d\t\u0019d'D\u00015\u0015\t)d\"\u0001\u0004=e>|GOP\u0005\u00025%\u0011\u0001(G\u0001\ba\u0006\u001c7.Y4f\u0013\tQ4HA\u0002TKFT!\u0001O\r\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}2\u0011!\u0002;za\u0016\u001c\u0018BA!?\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X\rC\u0003D\u0001\u0011\u0005C)\u0001\u0005eCR\fG+\u001f9f+\u0005)\u0005CA\u001fG\u0013\t9eH\u0001\u0005ECR\fG+\u001f9f\u0011\u0015I\u0005\u0001\"\u0011K\u00031qW\u000f\u001c7TC\u001a,WI^1m)\tYe\n\u0005\u0002\u0019\u0019&\u0011Q*\u0007\u0002\u0004\u0003:L\b\"B(I\u0001\u0004Y\u0015!B5oaV$\b\u0002C)\u0001\u0011\u000b\u0007I\u0011\u0002*\u0002\u0013\u0011|'+\u001a<feN,W#A*\u0011\ta!6jS\u0005\u0003+f\u0011\u0011BR;oGRLwN\\\u0019)\u0005A;\u0006C\u0001\rY\u0013\tI\u0016DA\u0005ue\u0006t7/[3oi\")1\f\u0001C!9\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0004;\u000eD\u0007C\u00010b\u001b\u0005y&B\u00011\u0003\u0003\u001d\u0019w\u000eZ3hK:L!AY0\u0003\u0011\u0015C\bO]\"pI\u0016DQ\u0001\u001a.A\u0002\u0015\f1a\u0019;y!\tqf-\u0003\u0002h?\nq1i\u001c3fO\u0016t7i\u001c8uKb$\b\"B5[\u0001\u0004i\u0016AA3w\u0011\u0015Y\u0007\u0001\"\u0003m\u00035\u0019HO]5oO\u000e{G-Z$f]R\u0019Q.\u001e<\u0011\u00059\u0014hBA8q!\t\u0019\u0014$\u0003\u0002r3\u00051\u0001K]3eK\u001aL!a\u001d;\u0003\rM#(/\u001b8h\u0015\t\t\u0018\u0004C\u0003jU\u0002\u0007Q\fC\u0003xU\u0002\u0007Q.A\u0005dQ&dGMT1nK\")\u0011\u0010\u0001C\u0005u\u0006a\u0011M\u001d:bs\u000e{G-Z$f]R!Qn\u001f?~\u0011\u0015!\u0007\u00101\u0001f\u0011\u0015I\u0007\u00101\u0001^\u0011\u00159\b\u00101\u0001n\u0011\u0019y\b\u0001\"\u0011\u0002\u0002\u0005Q\u0001O]3uift\u0015-\\3\u0016\u00035D\u0011\"!\u0002\u0001\u0003\u0003%\t!a\u0002\u0002\t\r|\u0007/\u001f\u000b\u0004W\u0005%\u0001\u0002C\u0011\u0002\u0004A\u0005\t\u0019A\u0012\t\u0013\u00055\u0001!%A\u0005\u0002\u0005=\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003#Q3aIA\nW\t\t)\u0002\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\u0013Ut7\r[3dW\u0016$'bAA\u00103\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0012\u0011\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u0014\u0001\u0005\u0005I\u0011IA\u0015\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0006\t\u0005\u0003[\t9$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003\u0011a\u0017M\\4\u000b\u0005\u0005U\u0012\u0001\u00026bm\u0006L1a]A\u0018\u0011%\tY\u0004AA\u0001\n\u0003\ti$\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002@A\u0019\u0001$!\u0011\n\u0007\u0005\r\u0013DA\u0002J]RD\u0011\"a\u0012\u0001\u0003\u0003%\t!!\u0013\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u00191*a\u0013\t\u0015\u00055\u0013QIA\u0001\u0002\u0004\ty$A\u0002yIEB\u0011\"!\u0015\u0001\u0003\u0003%\t%a\u0015\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u0016\u0011\u000b\u0005]\u0013QL&\u000e\u0005\u0005e#bAA.3\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0013\u0011\f\u0002\t\u0013R,'/\u0019;pe\"I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0011QM\u0001\tG\u0006tW)];bYR!\u0011qMA7!\rA\u0012\u0011N\u0005\u0004\u0003WJ\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u001b\n\t'!AA\u0002-C\u0011\"!\u001d\u0001\u0003\u0003%\t%a\u001d\u0002\r\u0015\fX/\u00197t)\u0011\t9'!\u001e\t\u0013\u00055\u0013qNA\u0001\u0002\u0004Y\u0005f\u0005\u0001\u0002z\u0005}\u0014\u0011QAC\u0003\u000f\u000bY)!$\u0002\u0012\u0006M\u0005cA\t\u0002|%\u0019\u0011Q\u0010\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111Q\u0001V?\u001a+fjQ0)CJ\u0014\u0018-_\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\r\t:fm\u0016\u00148/\u001a3!gR\u0014\u0018N\\4!_J\u0004\u0013M\u001c\u0011beJ\f\u0017\u0010I<ji\"\u0004#/\u001a<feN,\u0007e\u001c:eKJ\u0004sN\u001a\u0011fY\u0016lWM\u001c;t]\u0005AQ\r_1na2,7/\t\u0002\u0002\n\u0006\t\u0019A\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015('B\f'o\u001b\u0011T#2;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011M#N\u00033N]1q'*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"\u0012D\u0006I\u0019-AQb\u0003eM\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z6\u0007\f\u001b-c1\u0012TL\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\ty)A\u00032]Ur\u0003'\u0001\u0003o_R,\u0017EAAK\u0003I\u0012VM^3sg\u0016\u0004Cn\\4jG\u00022wN\u001d\u0011beJ\f\u0017p\u001d\u0011jg\u0002\ng/Y5mC\ndW\rI:j]\u000e,\u0007E\r\u00185]Ars!CAM\u0005\u0005\u0005\t\u0012AAN\u0003\u001d\u0011VM^3sg\u0016\u00042!EAO\r!\t!!!A\t\u0002\u0005}5#BAO\u0003Ck\u0002CBAR\u0003S\u001b3&\u0004\u0002\u0002&*\u0019\u0011qU\r\u0002\u000fI,h\u000e^5nK&!\u00111VAS\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u0005\bS\u0005uE\u0011AAX)\t\tY\n\u0003\u0006\u00024\u0006u\u0015\u0011!C#\u0003k\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003WA!\"!/\u0002\u001e\u0006\u0005I\u0011QA^\u0003\u0015\t\u0007\u000f\u001d7z)\rY\u0013Q\u0018\u0005\u0007C\u0005]\u0006\u0019A\u0012\t\u0015\u0005\u0005\u0017QTA\u0001\n\u0003\u000b\u0019-A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u0015\u00171\u001a\t\u00051\u0005\u001d7%C\u0002\u0002Jf\u0011aa\u00149uS>t\u0007\"CAg\u0003\u007f\u000b\t\u00111\u0001,\u0003\rAH\u0005\r\u0005\u000b\u0003#\fi*!A\u0005\n\u0005M\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!6\u0011\t\u00055\u0012q[\u0005\u0005\u00033\fyC\u0001\u0004PE*,7\r\u001e")
public class Reverse
extends UnaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private transient Function1<Object, Object> doReverse;
    private final Expression child;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> unapply(Reverse reverse) {
        return Reverse$.MODULE$.unapply(reverse);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Reverse, A> function1) {
        return Reverse$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Reverse> compose(Function1<A, Expression> function1) {
        return Reverse$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, ArrayType$.MODULE$}))}));
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    @Override
    public Object nullSafeEval(Object input) {
        return this.doReverse().apply(input);
    }

    private Function1<Object, Object> doReverse$lzycompute() {
        Reverse reverse = this;
        synchronized (reverse) {
            if (!this.bitmap$trans$0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.dataType();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType elementType = arrayType.elementType();
                    intersect = (Function1 & Serializable & scala.Serializable)input -> {
                        ArrayData arrayData = (ArrayData)input;
                        return new GenericArrayData(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(arrayData.toObjectArray(elementType))).reverse());
                    };
                } else if (StringType$.MODULE$.equals(dataType)) {
                    intersect = (Function1 & Serializable & scala.Serializable)x$25 -> ((UTF8String)x$25).reverse();
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doReverse = intersect;
                this.bitmap$trans$0 = true;
            }
        }
        return this.doReverse;
    }

    private Function1<Object, Object> doReverse() {
        return !this.bitmap$trans$0 ? this.doReverse$lzycompute() : this.doReverse;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> {
            String string;
            DataType dataType = this.dataType();
            if (dataType instanceof StringType) {
                string = this.stringCodeGen(ev, (String)c);
            } else if (dataType instanceof ArrayType) {
                string = this.arrayCodeGen(ctx, ev, (String)c);
            } else {
                throw new MatchError((Object)dataType);
            }
            return string;
        });
    }

    private String stringCodeGen(ExprCode ev, String childName) {
        return new StringBuilder(16).append(ev.value()).append(" = (").append(childName).append(").reverse();").toString();
    }

    private String arrayCodeGen(CodegenContext ctx, ExprCode ev, String childName) {
        String numElements = ctx.freshName("numElements");
        String arrayData = ctx.freshName("arrayData");
        String i = ctx.freshName("i");
        String j = ctx.freshName("j");
        DataType elementType = ((ArrayType)this.dataType()).elementType();
        String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, elementType, numElements, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, elementType, childName, i, j, ((ArrayType)this.dataType()).containsNull());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(146).append("\n       |final int ").append(numElements).append(" = ").append(childName).append(".numElements();\n       |").append(initialization).append("\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(numElements).append("; ").append(i).append("++) {\n       |  int ").append(j).append(" = ").append(numElements).append(" - ").append(i).append(" - 1;\n       |  ").append(assignment).append("\n       |}\n       |").append(ev.value()).append(" = ").append(arrayData).append(";\n     ").toString())).stripMargin();
    }

    @Override
    public String prettyName() {
        return "reverse";
    }

    public Reverse copy(Expression child) {
        return new Reverse(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Reverse";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Reverse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Reverse)) return false;
        boolean bl = true;
        if (!bl) return false;
        Reverse reverse = (Reverse)x$1;
        Expression expression = this.child();
        Expression expression2 = reverse.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!reverse.canEqual(this)) return false;
        return true;
    }

    public Reverse(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

