/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HashExpression;
import org.apache.spark.sql.catalyst.expressions.Murmur3Hash$;
import org.apache.spark.sql.catalyst.expressions.Murmur3HashFunction$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr1, expr2, ...) - Returns a hash value of the arguments.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', array(123), 2);\n       -1321691492\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0001\u0003\u0001>\u00111\"T;s[V\u00148\u0007S1tQ*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!ii\u0002cA\t\u0013)5\t!!\u0003\u0002\u0014\u0005\tq\u0001*Y:i\u000bb\u0004(/Z:tS>t\u0007CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"aA%oiB\u0011QcG\u0005\u00039Y\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0016=%\u0011qD\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tC\u0001\u0011)\u001a!C\u0001E\u0005A1\r[5mIJ,g.F\u0001$!\r!Cf\f\b\u0003K)r!AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\b\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0012BA\u0016\u0017\u0003\u001d\u0001\u0018mY6bO\u0016L!!\f\u0018\u0003\u0007M+\u0017O\u0003\u0002,-A\u0011\u0011\u0003M\u0005\u0003c\t\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0011!\u0019\u0004A!E!\u0002\u0013\u0019\u0013!C2iS2$'/\u001a8!\u0011!)\u0004A!f\u0001\n\u00031\u0014\u0001B:fK\u0012,\u0012\u0001\u0006\u0005\tq\u0001\u0011\t\u0012)A\u0005)\u0005)1/Z3eA!)!\b\u0001C\u0001w\u00051A(\u001b8jiz\"2\u0001P\u001f?!\t\t\u0002\u0001C\u0003\"s\u0001\u00071\u0005C\u00036s\u0001\u0007A\u0003C\u0003;\u0001\u0011\u0005\u0001\t\u0006\u0002=\u0003\")!i\u0010a\u0001G\u0005I\u0011M]4v[\u0016tGo\u001d\u0005\u0006\t\u0002!\t%R\u0001\tI\u0006$\u0018\rV=qKV\ta\t\u0005\u0002H\u00156\t\u0001J\u0003\u0002J\r\u0005)A/\u001f9fg&\u00111\n\u0013\u0002\t\t\u0006$\u0018\rV=qK\")Q\n\u0001C!\u001d\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003=\u0003\"\u0001\u0015+\u000f\u0005E\u0013\u0006C\u0001\u0014\u0017\u0013\t\u0019f#\u0001\u0004Qe\u0016$WMZ\u0005\u0003+Z\u0013aa\u0015;sS:<'BA*\u0017\u0011\u0015A\u0006\u0001\"\u0015O\u0003=A\u0017m\u001d5fe\u000ec\u0017m]:OC6,\u0007\"\u0002.\u0001\t#Z\u0016aC2p[B,H/\u001a%bg\"$B\u0001\u0006/bE\")Q,\u0017a\u0001=\u0006)a/\u00197vKB\u0011QcX\u0005\u0003AZ\u00111!\u00118z\u0011\u0015!\u0015\f1\u0001G\u0011\u0015)\u0014\f1\u0001\u0015\u0011\u001d!\u0007!!A\u0005\u0002\u0015\fAaY8qsR\u0019AHZ4\t\u000f\u0005\u001a\u0007\u0013!a\u0001G!9Qg\u0019I\u0001\u0002\u0004!\u0002bB5\u0001#\u0003%\tA[\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005Y'FA\u0012mW\u0005i\u0007C\u00018t\u001b\u0005y'B\u00019r\u0003%)hn\u00195fG.,GM\u0003\u0002s-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Q|'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"9a\u000fAI\u0001\n\u00039\u0018AD2paf$C-\u001a4bk2$HEM\u000b\u0002q*\u0012A\u0003\u001c\u0005\bu\u0002\t\t\u0011\"\u0011|\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\tA\u0010E\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011\u0001\u00027b]\u001eT!!a\u0001\u0002\t)\fg/Y\u0005\u0003+zD\u0001\"!\u0003\u0001\u0003\u0003%\tAN\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\n\u0003\u001b\u0001\u0011\u0011!C\u0001\u0003\u001f\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002_\u0003#A\u0011\"a\u0005\u0002\f\u0005\u0005\t\u0019\u0001\u000b\u0002\u0007a$\u0013\u0007C\u0005\u0002\u0018\u0001\t\t\u0011\"\u0011\u0002\u001a\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u001cA)\u0011QDA\u0012=6\u0011\u0011q\u0004\u0006\u0004\u0003C1\u0012AC2pY2,7\r^5p]&!\u0011QEA\u0010\u0005!IE/\u001a:bi>\u0014\b\"CA\u0015\u0001\u0005\u0005I\u0011AA\u0016\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0017\u0003g\u00012!FA\u0018\u0013\r\t\tD\u0006\u0002\b\u0005>|G.Z1o\u0011%\t\u0019\"a\n\u0002\u0002\u0003\u0007a\fC\u0005\u00028\u0001\t\t\u0011\"\u0011\u0002:\u00051Q-];bYN$B!!\f\u0002<!I\u00111CA\u001b\u0003\u0003\u0005\rA\u0018\u0015\f\u0001\u0005}\u0012QIA$\u0003\u0017\ni\u0005E\u0002\u0012\u0003\u0003J1!a\u0011\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u0013\u0002\u0005~3UKT\"`Q\u0015D\bO]\u0019-A\u0015D\bO\u001d\u001a-A9rc&\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007\u0005[1tQ\u00022\u0018\r\\;fA=4\u0007\u0005\u001e5fA\u0005\u0014x-^7f]R\u001ch&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ty%A*\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u001a\u0006/\u0019:lO1\u0002\u0013M\u001d:bs\"\n$gM\u0015-AIJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u00172gI\nd'O\u00195sIR\u0001\u0005I\u0004\n\u0003'\u0012\u0011\u0011!E\u0001\u0003+\n1\"T;s[V\u00148\u0007S1tQB\u0019\u0011#a\u0016\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u00033\u001aR!a\u0016\u0002\\u\u0001r!!\u0018\u0002d\r\"B(\u0004\u0002\u0002`)\u0019\u0011\u0011\r\f\u0002\u000fI,h\u000e^5nK&!\u0011QMA0\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\bu\u0005]C\u0011AA5)\t\t)\u0006\u0003\u0006\u0002n\u0005]\u0013\u0011!C#\u0003_\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002y\"Q\u00111OA,\u0003\u0003%\t)!\u001e\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bq\n9(!\u001f\t\r\u0005\n\t\b1\u0001$\u0011\u0019)\u0014\u0011\u000fa\u0001)!Q\u0011QPA,\u0003\u0003%\t)a \u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011QAG!\u0015)\u00121QAD\u0013\r\t)I\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bU\tIi\t\u000b\n\u0007\u0005-eC\u0001\u0004UkBdWM\r\u0005\n\u0003\u001f\u000bY(!AA\u0002q\n1\u0001\u001f\u00131\u0011)\t\u0019*a\u0016\u0002\u0002\u0013%\u0011QS\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0018B\u0019Q0!'\n\u0007\u0005meP\u0001\u0004PE*,7\r\u001e")
public class Murmur3Hash
extends HashExpression<Object>
implements Serializable {
    private final Seq<Expression> children;
    private final int seed;

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(Murmur3Hash murmur3Hash) {
        return Murmur3Hash$.MODULE$.unapply(murmur3Hash);
    }

    public static Function1<Tuple2<Seq<Expression>, Object>, Murmur3Hash> tupled() {
        return Murmur3Hash$.MODULE$.tupled();
    }

    public static Function1<Seq<Expression>, Function1<Object, Murmur3Hash>> curried() {
        return Murmur3Hash$.MODULE$.curried();
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public int seed() {
        return this.seed;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "hash";
    }

    @Override
    public String hasherClassName() {
        return Murmur3_x86_32.class.getName();
    }

    @Override
    public int computeHash(Object value, DataType dataType, int seed) {
        return (int)Murmur3HashFunction$.MODULE$.hash(value, dataType, seed);
    }

    public Murmur3Hash copy(Seq<Expression> children2, int seed) {
        return new Murmur3Hash(children2, seed);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public int copy$default$2() {
        return this.seed();
    }

    @Override
    public String productPrefix() {
        return "Murmur3Hash";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.seed());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Murmur3Hash;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Murmur3Hash)) return false;
        boolean bl = true;
        if (!bl) return false;
        Murmur3Hash murmur3Hash = (Murmur3Hash)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = murmur3Hash.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.seed() != murmur3Hash.seed()) return false;
        if (!murmur3Hash.canEqual(this)) return false;
        return true;
    }

    public Murmur3Hash(Seq<Expression> children2, int seed) {
        this.children = children2;
        this.seed = seed;
    }

    public Murmur3Hash(Seq<Expression> arguments) {
        this(arguments, 42);
    }
}

