/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.Serializable;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonExprUtils$;
import org.apache.spark.sql.catalyst.expressions.JsonToStructs$;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptions$;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(jsonStr, schema[, options]) - Returns a struct value with the given `jsonStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":1, \"b\":0.8}', 'a INT, b DOUBLE');\n       {\"a\":1, \"b\":0.8}\n      > SELECT _FUNC_('{\"time\":\"26/08/2015\"}', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":\"2015-08-26 00:00:00.0\"}\n  ", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\t]d\u0001B\u0001\u0003\u0001>\u0011QBS:p]R{7\u000b\u001e:vGR\u001c(BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001\u0001BcF\u000f!MA\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005aYR\"A\r\u000b\u0005i\u0011\u0011aB2pI\u0016<WM\\\u0005\u00039e\u0011qbQ8eK\u001e,gNR1mY\n\f7m\u001b\t\u0003#yI!a\b\u0002\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#EA\u0004Qe>$Wo\u0019;\u0011\u0005\u0005:\u0013B\u0001\u0015#\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!Q\u0003A!f\u0001\n\u0003Y\u0013AB:dQ\u0016l\u0017-F\u0001-!\ti\u0003'D\u0001/\u0015\tyc!A\u0003usB,7/\u0003\u00022]\tAA)\u0019;b)f\u0004X\r\u0003\u00054\u0001\tE\t\u0015!\u0003-\u0003\u001d\u00198\r[3nC\u0002B\u0001\"\u000e\u0001\u0003\u0016\u0004%\tAN\u0001\b_B$\u0018n\u001c8t+\u00059\u0004\u0003\u0002\u001d@\u0005\ns!!O\u001f\u0011\u0005i\u0012S\"A\u001e\u000b\u0005qr\u0011A\u0002\u001fs_>$h(\u0003\u0002?E\u00051\u0001K]3eK\u001aL!\u0001Q!\u0003\u00075\u000b\u0007O\u0003\u0002?EA\u0011\u0001hQ\u0005\u0003\t\u0006\u0013aa\u0015;sS:<\u0007\u0002\u0003$\u0001\u0005#\u0005\u000b\u0011B\u001c\u0002\u0011=\u0004H/[8og\u0002B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!S\u0001\u0006G\"LG\u000eZ\u000b\u0002\u0015B\u0011\u0011cS\u0005\u0003\u0019\n\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0011!q\u0005A!E!\u0002\u0013Q\u0015AB2iS2$\u0007\u0005\u0003\u0005Q\u0001\tU\r\u0011\"\u0001R\u0003)!\u0018.\\3[_:,\u0017\nZ\u000b\u0002%B\u0019\u0011e\u0015\"\n\u0005Q\u0013#AB(qi&|g\u000e\u0003\u0005W\u0001\tE\t\u0015!\u0003S\u0003-!\u0018.\\3[_:,\u0017\n\u001a\u0011\t\u000ba\u0003A\u0011A-\u0002\rqJg.\u001b;?)\u0015Q6\fX/_!\t\t\u0002\u0001C\u0003+/\u0002\u0007A\u0006C\u00036/\u0002\u0007q\u0007C\u0003I/\u0002\u0007!\nC\u0004Q/B\u0005\t\u0019\u0001*\t\u000f\u0001\u0004!\u0019!C\u0001C\u0006\u0019bm\u001c:dK:+H\u000e\\1cY\u0016\u001c6\r[3nCV\t!\r\u0005\u0002\"G&\u0011AM\t\u0002\b\u0005>|G.Z1o\u0011\u00191\u0007\u0001)A\u0005E\u0006!bm\u001c:dK:+H\u000e\\1cY\u0016\u001c6\r[3nC\u0002Bq\u0001\u001b\u0001C\u0002\u0013\u00051&\u0001\bok2d\u0017M\u00197f'\u000eDW-\\1\t\r)\u0004\u0001\u0015!\u0003-\u0003=qW\u000f\u001c7bE2,7k\u00195f[\u0006\u0004\u0003\"\u00027\u0001\t\u0003\n\u0017\u0001\u00038vY2\f'\r\\3\t\u000ba\u0003A\u0011\u00018\u0015\ti{\u0007/\u001d\u0005\u0006\u00116\u0004\rA\u0013\u0005\u0006U5\u0004\rA\u0013\u0005\u0006k5\u0004\ra\u000e\u0005\u00061\u0002!\ta\u001d\u000b\u00045R,\b\"\u0002%s\u0001\u0004Q\u0005\"\u0002\u0016s\u0001\u0004Q\u0005\"\u0002-\u0001\t\u00039H\u0003\u0002.ysjDQ\u0001\u0013<A\u0002)CQA\u000b<A\u0002)CQ!\u000e<A\u0002)CQ\u0001 \u0001\u0005Bu\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012A \t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019\u0001B\u0001\tC:\fG._:jg&!\u0011qAA\u0001\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\bBCA\u0006\u0001!\u0015\r\u0011\"\u0001\u0002\u000e\u0005I1m\u001c8wKJ$XM]\u000b\u0003\u0003\u001f\u0001r!IA\t\u0003+\ty#C\u0002\u0002\u0014\t\u0012\u0011BR;oGRLwN\\\u0019\u0011\r\u0005]\u0011\u0011EA\u0014\u001d\u0011\tI\"!\b\u000f\u0007i\nY\"C\u0001$\u0013\r\tyBI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019#!\n\u0003\u0007M+\u0017OC\u0002\u0002 \t\u0002B!!\u000b\u0002,5\tA!C\u0002\u0002.\u0011\u00111\"\u00138uKJt\u0017\r\u001c*poJ)\u0011\u0011\u0007\u0014\u00026\u00191\u00111\u0007\u0001\u0001\u0003_\u0011A\u0002\u0010:fM&tW-\\3oiz\u0002B!a\u000e\u0002B5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$\u0001\u0003mC:<'BAA \u0003\u0011Q\u0017M^1\n\t\u0005\r\u0013\u0011\b\u0002\u0007\u001f\nTWm\u0019;)\t\u0005%\u0011q\t\t\u0004C\u0005%\u0013bAA&E\tIAO]1og&,g\u000e\u001e\u0005\u000b\u0003\u001f\u0002\u0001R1A\u0005\u0002\u0005E\u0013A\u00029beN,'/\u0006\u0002\u0002TA!\u0011QKA.\u001b\t\t9FC\u0002\u0002Z\u0011\tAA[:p]&!\u0011QLA,\u00055Q\u0015mY6t_:\u0004\u0016M]:fe\"\"\u0011QJA$\u0011\u0019\t\u0019\u0007\u0001C!W\u0005AA-\u0019;b)f\u0004X\rC\u0004\u0002h\u0001!\t%!\u001b\u0002\u0019]LG\u000f\u001b+j[\u0016TvN\\3\u0015\u0007Q\tY\u0007\u0003\u0004Q\u0003K\u0002\rA\u0011\u0005\b\u0003_\u0002A\u0011IA9\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0011\t\u0019(!\u001f\u0011\u0007\u0005\n)(C\u0002\u0002x\t\u00121!\u00118z\u0011!\tI&!\u001cA\u0002\u0005M\u0004bBA?\u0001\u0011\u0005\u0013qP\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAAA!\u0019\t9\"!\t\u0002\u0004B\u0019Q&!\"\n\u0007\u0005\u001deF\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\"1q\u0001\u0001C!\u0003\u0017+\u0012A\u0011\u0005\n\u0003\u001f\u0003\u0011\u0011!C\u0001\u0003#\u000bAaY8qsRI!,a%\u0002\u0016\u0006]\u0015\u0011\u0014\u0005\tU\u00055\u0005\u0013!a\u0001Y!AQ'!$\u0011\u0002\u0003\u0007q\u0007\u0003\u0005I\u0003\u001b\u0003\n\u00111\u0001K\u0011!\u0001\u0016Q\u0012I\u0001\u0002\u0004\u0011\u0006\"CAO\u0001E\u0005I\u0011AAP\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!)+\u00071\n\u0019k\u000b\u0002\u0002&B!\u0011qUAY\u001b\t\tIK\u0003\u0003\u0002,\u00065\u0016!C;oG\",7m[3e\u0015\r\tyKI\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAZ\u0003S\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t9\fAI\u0001\n\u0003\tI,\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m&fA\u001c\u0002$\"I\u0011q\u0018\u0001\u0012\u0002\u0013\u0005\u0011\u0011Y\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019MK\u0002K\u0003GC\u0011\"a2\u0001#\u0003%\t!!3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u001a\u0016\u0004%\u0006\r\u0006\"CAh\u0001\u0005\u0005I\u0011IAi\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u001b\t\u0005\u0003o\t).C\u0002E\u0003sA\u0011\"!7\u0001\u0003\u0003%\t!a7\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\u0007cA\u0011\u0002`&\u0019\u0011\u0011\u001d\u0012\u0003\u0007%sG\u000fC\u0005\u0002f\u0002\t\t\u0011\"\u0001\u0002h\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA:\u0003SD!\"a;\u0002d\u0006\u0005\t\u0019AAo\u0003\rAH%\r\u0005\n\u0003_\u0004\u0011\u0011!C!\u0003c\fq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003g\u0004b!!>\u0002|\u0006MTBAA|\u0015\r\tIPI\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u007f\u0003o\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0005\u0003\u0001\u0011\u0011!C\u0001\u0005\u0007\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004E\n\u0015\u0001BCAv\u0003\u007f\f\t\u00111\u0001\u0002t!I!\u0011\u0002\u0001\u0002\u0002\u0013\u0005#1B\u0001\u0007KF,\u0018\r\\:\u0015\u0007\t\u0014i\u0001\u0003\u0006\u0002l\n\u001d\u0011\u0011!a\u0001\u0003gBs\u0002\u0001B\t\u0005/\u0011IB!\b\u0003 \t\r\"Q\u0005\t\u0004#\tM\u0011b\u0001B\u000b\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B\u000e\u0003\t|f)\u0016(D?\"R7o\u001c8TiJd\u0003e]2iK6\f7\f\f\u0011paRLwN\\:^S\u0001j\u0003EU3ukJt7\u000fI1!gR\u0014Xo\u0019;!m\u0006dW/\u001a\u0011xSRD\u0007\u0005\u001e5fA\u001dLg/\u001a8!A*\u001cxN\\*ue\u0002\u0004\u0013M\u001c3!AN\u001c\u0007.Z7bA:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005C\t\u0011q\u001e\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Om\u0014\u0013M\t\u001e2Y\u0001\u0012#M\t\u001e1]ajx\u0005\f\u0011(C\u0002Je\n\u0016\u0017!E\u0002\"u*\u0016\"M\u000b\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I>#C\nR\u0014\u0007\f\u0011#E\nR\u0004G\f\u001d~\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3P\t;j[\u0016\u0014#H\t\u001a7_ABtF\r\u00192k\tjx\u0005\f\u0011(i&lW\r\t+j[\u0016\u001cH/Y7qO1\u0002S.\u00199)OQLW.Z:uC6\u0004hi\u001c:nCR<C\u0006I\u0014eI>jUjL=zsf<\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!w\n\"\u0018.\\3#u\t\u0012\u0004'M\u001b.aaj#G\u000e\u00111ai\u0002\u0004G\u000f\u00191]A\u0012SP\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\u00119#A\u00033]Ir\u0003gB\u0005\u0003,\t\t\t\u0011#\u0001\u0003.\u0005i!j]8o)>\u001cFO];diN\u00042!\u0005B\u0018\r!\t!!!A\t\u0002\tE2#\u0002B\u0018\u0005g1\u0003#\u0003B\u001b\u0005wasG\u0013*[\u001b\t\u00119DC\u0002\u0003:\t\nqA];oi&lW-\u0003\u0003\u0003>\t]\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oi!9\u0001La\f\u0005\u0002\t\u0005CC\u0001B\u0017\u0011)\u0011)Ea\f\u0002\u0002\u0013\u0015#qI\u0001\ti>\u001cFO]5oOR\u0011\u00111\u001b\u0005\u000b\u0005\u0017\u0012y#!A\u0005\u0002\n5\u0013!B1qa2LH#\u0003.\u0003P\tE#1\u000bB+\u0011\u0019Q#\u0011\na\u0001Y!1QG!\u0013A\u0002]Ba\u0001\u0013B%\u0001\u0004Q\u0005\u0002\u0003)\u0003JA\u0005\t\u0019\u0001*\t\u0015\te#qFA\u0001\n\u0003\u0013Y&A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tu#Q\r\t\u0005CM\u0013y\u0006E\u0004\"\u0005CbsG\u0013*\n\u0007\t\r$E\u0001\u0004UkBdW\r\u000e\u0005\n\u0005O\u00129&!AA\u0002i\u000b1\u0001\u001f\u00131\u0011)\u0011YGa\f\u0012\u0002\u0013\u0005\u0011\u0011Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\t\u0015\t=$qFI\u0001\n\u0003\tI-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0011)\u0011\u0019Ha\f\u0002\u0002\u0013%!QO\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u00026\u0001")
public class JsonToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
scala.Serializable {
    private transient Function1<Seq<InternalRow>, Object> converter;
    private transient JacksonParser parser;
    private final DataType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final boolean forceNullableSchema;
    private final DataType nullableSchema;
    private boolean resolved;
    private transient TimeZone timeZone;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<String> apply$default$4() {
        return JsonToStructs$.MODULE$.apply$default$4();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return JsonToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<DataType, Map<String, String>, Expression, Option<String>>> unapply(JsonToStructs jsonToStructs) {
        return JsonToStructs$.MODULE$.unapply(jsonToStructs);
    }

    public static Function1<Tuple4<DataType, Map<String, String>, Expression, Option<String>>, JsonToStructs> tupled() {
        return JsonToStructs$.MODULE$.tupled();
    }

    public static Function1<DataType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, JsonToStructs>>>> curried() {
        return JsonToStructs$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.timeZone = TimeZoneAwareExpression.timeZone$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.timeZone;
    }

    @Override
    public TimeZone timeZone() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    public DataType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public boolean forceNullableSchema() {
        return this.forceNullableSchema;
    }

    public DataType nullableSchema() {
        return this.nullableSchema;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType = this.nullableSchema();
        boolean bl = dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType);
        TypeCheckResult typeCheckResult = bl ? ExpectsInputTypes.checkInputDataTypes$(this) : new TypeCheckResult.TypeCheckFailure(new StringBuilder(50).append("Input schema ").append(this.nullableSchema().catalogString()).append(" must be a struct, an array or a map.").toString());
        return typeCheckResult;
    }

    private Function1<Seq<InternalRow>, Object> converter$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.nullableSchema();
                if (dataType instanceof StructType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> rows.length() == 1 ? (InternalRow)rows.head() : null;
                } else if (dataType instanceof ArrayType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> ((SpecializedGetters)rows.head()).getArray(0);
                } else if (dataType instanceof MapType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> ((SpecializedGetters)rows.head()).getMap(0);
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.converter = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.converter;
    }

    public Function1<Seq<InternalRow>, Object> converter() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.converter$lzycompute() : this.converter;
    }

    private JacksonParser parser$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.parser = new JacksonParser(this.nullableSchema(), new JSONOptions((Map<String, String>)this.options().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)FailFastMode$.MODULE$.name())), (String)this.timeZoneId().get(), JSONOptions$.MODULE$.$lessinit$greater$default$3()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.parser;
    }

    public JacksonParser parser() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.parser$lzycompute() : this.parser;
    }

    @Override
    public DataType dataType() {
        return this.nullableSchema();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$14 = Option$.MODULE$.apply((Object)timeZoneId);
        DataType x$15 = this.copy$default$1();
        Map<String, String> x$16 = this.copy$default$2();
        Expression x$17 = this.copy$default$3();
        return this.copy(x$15, x$16, x$17, (Option<String>)x$14);
    }

    @Override
    public Object nullSafeEval(Object json) {
        Object object;
        if (json.toString().trim().isEmpty()) {
            return null;
        }
        try {
            object = this.converter().apply(this.parser().parse((UTF8String)json, (Function2 & Serializable & scala.Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.utf8String((JsonFactory)jsonFactory, (UTF8String)record), (Function1 & Serializable & scala.Serializable)x -> (UTF8String)Predef$.MODULE$.identity(x)));
        }
        catch (BadRecordException badRecordException) {
            object = null;
        }
        return object;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringType$ stringType$ = StringType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)stringType$);
    }

    @Override
    public String sql() {
        DataType dataType = this.schema();
        String string = dataType instanceof MapType ? "entries" : super.sql();
        return string;
    }

    public JsonToStructs copy(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new JsonToStructs(schema, options, child, timeZoneId);
    }

    public DataType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "JsonToStructs";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.schema();
                break;
            }
            case 1: {
                object = this.options();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonToStructs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonToStructs jsonToStructs = (JsonToStructs)x$1;
        DataType dataType = this.schema();
        DataType dataType2 = jsonToStructs.schema();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = jsonToStructs.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = jsonToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = jsonToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!jsonToStructs.canEqual(this)) return false;
        return true;
    }

    public JsonToStructs(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.forceNullableSchema = BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.FROM_JSON_FORCE_NULLABLE_SCHEMA()));
        this.nullableSchema = this.forceNullableSchema() ? schema.asNullable() : schema;
    }

    public JsonToStructs(Expression child, Expression schema, Map<String, String> options) {
        this(JsonExprUtils$.MODULE$.evalSchemaExpr(schema), options, child, (Option<String>)None$.MODULE$);
    }

    public JsonToStructs(Expression child, Expression schema) {
        this(child, schema, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public JsonToStructs(Expression child, Expression schema, Expression options) {
        this(JsonExprUtils$.MODULE$.evalSchemaExpr(schema), JsonExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

