/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualTo$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` equals `expr2`, or false otherwise.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be used in equality comparison. Map type is not supported.\n          For complex types such array/struct, the data types of fields must be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1 _FUNC_ '1';\n       true\n      > SELECT true _FUNC_ NULL;\n       NULL\n      > SELECT NULL _FUNC_ NULL;\n       NULL\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\u0001\u0003\u0001>\u0011q!R9vC2$vN\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0003F\u000e\"!\t\t\"#D\u0001\u0003\u0013\t\u0019\"A\u0001\tCS:\f'/_\"p[B\f'/[:p]B\u0011Q\u0003\u0007\b\u0003#YI!a\u0006\u0002\u0002\u000fA\f7m[1hK&\u0011\u0011D\u0007\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\t9\"\u0001\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SDA\u0004Qe>$Wo\u0019;\u0011\u0005q\u0011\u0013BA\u0012\u001e\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!)\u0003A!f\u0001\n\u00031\u0013\u0001\u00027fMR,\u0012a\n\t\u0003#!J!!\u000b\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005,\u0001\tE\t\u0015!\u0003(\u0003\u0015aWM\u001a;!\u0011!i\u0003A!f\u0001\n\u00031\u0013!\u0002:jO\"$\b\u0002C\u0018\u0001\u0005#\u0005\u000b\u0011B\u0014\u0002\rILw\r\u001b;!\u0011\u0015\t\u0004\u0001\"\u00013\u0003\u0019a\u0014N\\5u}Q\u00191\u0007N\u001b\u0011\u0005E\u0001\u0001\"B\u00131\u0001\u00049\u0003\"B\u00171\u0001\u00049\u0003\"B\u001c\u0001\t\u0003B\u0014AB:z[\n|G.F\u0001:!\tQ\u0014I\u0004\u0002<\u007fA\u0011A(H\u0007\u0002{)\u0011aHD\u0001\u0007yI|w\u000e\u001e \n\u0005\u0001k\u0012A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n11\u000b\u001e:j]\u001eT!\u0001Q\u000f\t\u000b\u0015\u0003A\u0011\u000b$\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0007\u001dS5\n\u0005\u0002\u001d\u0011&\u0011\u0011*\b\u0002\u0004\u0003:L\b\"B\u0013E\u0001\u00049\u0005\"B\u0017E\u0001\u00049\u0005\"B'\u0001\t\u0003r\u0015!\u00033p\u000f\u0016t7i\u001c3f)\ryUK\u0017\t\u0003!Nk\u0011!\u0015\u0006\u0003%\n\tqaY8eK\u001e,g.\u0003\u0002U#\nAQ\t\u001f9s\u0007>$W\rC\u0003W\u0019\u0002\u0007q+A\u0002dib\u0004\"\u0001\u0015-\n\u0005e\u000b&AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u000672\u0003\raT\u0001\u0003KZDq!\u0018\u0001\u0002\u0002\u0013\u0005a,\u0001\u0003d_BLHcA\u001a`A\"9Q\u0005\u0018I\u0001\u0002\u00049\u0003bB\u0017]!\u0003\u0005\ra\n\u0005\bE\u0002\t\n\u0011\"\u0001d\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012\u0001\u001a\u0016\u0003O\u0015\\\u0013A\u001a\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005-l\u0012AC1o]>$\u0018\r^5p]&\u0011Q\u000e\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007bB8\u0001#\u0003%\taY\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011\u001d\t\b!!A\u0005BI\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#A:\u0011\u0005QLX\"A;\u000b\u0005Y<\u0018\u0001\u00027b]\u001eT\u0011\u0001_\u0001\u0005U\u00064\u0018-\u0003\u0002Ck\"91\u0010AA\u0001\n\u0003a\u0018\u0001\u00049s_\u0012,8\r^!sSRLX#A?\u0011\u0005qq\u0018BA@\u001e\u0005\rIe\u000e\u001e\u0005\n\u0003\u0007\u0001\u0011\u0011!C\u0001\u0003\u000b\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002H\u0003\u000fA\u0011\"!\u0003\u0002\u0002\u0005\u0005\t\u0019A?\u0002\u0007a$\u0013\u0007C\u0005\u0002\u000e\u0001\t\t\u0011\"\u0011\u0002\u0010\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0012A)\u00111CA\r\u000f6\u0011\u0011Q\u0003\u0006\u0004\u0003/i\u0012AC2pY2,7\r^5p]&!\u00111DA\u000b\u0005!IE/\u001a:bi>\u0014\b\"CA\u0010\u0001\u0005\u0005I\u0011AA\u0011\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0012\u0003S\u00012\u0001HA\u0013\u0013\r\t9#\b\u0002\b\u0005>|G.Z1o\u0011%\tI!!\b\u0002\u0002\u0003\u0007q\tC\u0005\u0002.\u0001\t\t\u0011\"\u0011\u00020\u00051Q-];bYN$B!a\t\u00022!I\u0011\u0011BA\u0016\u0003\u0003\u0005\ra\u0012\u0015\u0010\u0001\u0005U\u00121HA\u001f\u0003\u0003\n\u0019%a\u0012\u0002JA\u0019\u0011#a\u000e\n\u0007\u0005e\"AA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005}\u0012\u0001U3yaJ\f\u0004e\u0018$V\u001d\u000e{\u0006%\u001a=qeJ\u0002S\u0006\t*fiV\u0014hn\u001d\u0011ueV,\u0007%\u001b4!A\u0016D\bO]\u0019aA\u0015\fX/\u00197tA\u0001,\u0007\u0010\u001d:3A2\u0002sN\u001d\u0011gC2\u001cX\rI8uQ\u0016\u0014x/[:f]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003\u000b\n!Q\f\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0015D\bO]\u0019-A\u0015D\bO\u001d\u001a![\u0001\"\b.\u001a\u0011uo>\u0004S\r\u001f9sKN\u001c\u0018n\u001c8tA5,8\u000f\u001e\u0011cK\u0002\u001a\u0018-\\3!if\u0004X\rI8sA\r\fg\u000e\t2fA\r\f7\u000f^3eAQ|\u0007%\u0019\u0011d_6lwN\u001c\u0011usB,GF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0005tG\rI7vgR\u0004#-\u001a\u0011bAQL\b/\u001a\u0011uQ\u0006$\beY1oA\t,\u0007%^:fI\u0002Jg\u000eI3rk\u0006d\u0017\u000e^=!G>l\u0007/\u0019:jg>tg\u0006I'ba\u0002\"\u0018\u0010]3!SN\u0004cn\u001c;!gV\u0004\bo\u001c:uK\u0012t#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\r>\u0014\beY8na2,\u0007\u0010\t;za\u0016\u001c\be];dQ\u0002\n'O]1z_M$(/^2uY\u0001\"\b.\u001a\u0011eCR\f\u0007\u0005^=qKN\u0004sN\u001a\u0011gS\u0016dGm\u001d\u0011nkN$\bEY3!_J$WM]1cY\u0016t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\u0013\u0002\u0003oR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006E\r\u0011`\rVs5i\u0018\u00113w)\u0001\u0003\u0005\t\u0011!A\u0001\"(/^3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAE\u0002sLR+O\u0007~\u0003s%M\u0014<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!iJ,X\rI0G+:\u001bu\f\t(V\u00192[$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003c*\u0016'MA}3UKT\"`A9+F\nT\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u001dVcEJ\u0003\u0011!\u000f%\tyEAA\u0001\u0012\u0003\t\t&A\u0004FcV\fG\u000eV8\u0011\u0007E\t\u0019F\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AA+'\u0015\t\u0019&a\u0016\"!\u001d\tI&a\u0018(OMj!!a\u0017\u000b\u0007\u0005uS$A\u0004sk:$\u0018.\\3\n\t\u0005\u0005\u00141\f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004bB\u0019\u0002T\u0011\u0005\u0011Q\r\u000b\u0003\u0003#B!\"!\u001b\u0002T\u0005\u0005IQIA6\u0003!!xn\u0015;sS:<G#A:\t\u0015\u0005=\u00141KA\u0001\n\u0003\u000b\t(A\u0003baBd\u0017\u0010F\u00034\u0003g\n)\b\u0003\u0004&\u0003[\u0002\ra\n\u0005\u0007[\u00055\u0004\u0019A\u0014\t\u0015\u0005e\u00141KA\u0001\n\u0003\u000bY(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005u\u0014\u0011\u0012\t\u00069\u0005}\u00141Q\u0005\u0004\u0003\u0003k\"AB(qi&|g\u000eE\u0003\u001d\u0003\u000b;s%C\u0002\u0002\bv\u0011a\u0001V;qY\u0016\u0014\u0004\"CAF\u0003o\n\t\u00111\u00014\u0003\rAH\u0005\r\u0005\u000b\u0003\u001f\u000b\u0019&!A\u0005\n\u0005E\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a%\u0011\u0007Q\f)*C\u0002\u0002\u0018V\u0014aa\u00142kK\u000e$\b")
public class EqualTo
extends BinaryComparison
implements package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(EqualTo equalTo) {
        return EqualTo$.MODULE$.unapply(equalTo);
    }

    public static Function1<Tuple2<Expression, Expression>, EqualTo> tupled() {
        return EqualTo$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, EqualTo>> curried() {
        return EqualTo$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "=";
    }

    @Override
    public Object nullSafeEval(Object left, Object right) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().equiv(left, right));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & java.io.Serializable & Serializable)(c1, c2) -> ctx.genEqual(this.left().dataType(), (String)c1, (String)c2));
    }

    public EqualTo copy(Expression left, Expression right) {
        return new EqualTo(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "EqualTo";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EqualTo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EqualTo)) return false;
        boolean bl = true;
        if (!bl) return false;
        EqualTo equalTo = (EqualTo)x$1;
        Expression expression = this.left();
        Expression expression2 = equalTo.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = equalTo.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!equalTo.canEqual(this)) return false;
        return true;
    }

    public EqualTo(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

