/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.AssertTrue$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.expressions.codegen.TrueLiteral$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Throws an exception if `expr` is not true.", examples="\n    Examples:\n      > SELECT _FUNC_(0 < 1);\n       NULL\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u0001\u0003\u0001>\u0011!\"Q:tKJ$HK];f\u0015\t\u0019A!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\u0007\u0003!\u0019\u0017\r^1msN$(BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011#\u0002\u0001\u0011)]i\u0002CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\t\u0016\u0013\t1\"A\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0007\u0010\n\u0005}I\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\u0011\u0001\u0005+\u0007I\u0011\u0001\u0012\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003\r\u0002\"!\u0005\u0013\n\u0005\u0015\u0012!AC#yaJ,7o]5p]\"Aq\u0005\u0001B\tB\u0003%1%\u0001\u0004dQ&dG\r\t\u0005\u0006S\u0001!\tAK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005-b\u0003CA\t\u0001\u0011\u0015\t\u0003\u00061\u0001$\u0011\u0015q\u0003\u0001\"\u00110\u0003!qW\u000f\u001c7bE2,W#\u0001\u0019\u0011\u0005a\t\u0014B\u0001\u001a\u001a\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u000e\u0001\u0005BU\n!\"\u001b8qkR$\u0016\u0010]3t+\u00051\u0004cA\u001c@\u0005:\u0011\u0001(\u0010\b\u0003sqj\u0011A\u000f\u0006\u0003w9\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u0005yJ\u0012a\u00029bG.\fw-Z\u0005\u0003\u0001\u0006\u00131aU3r\u0015\tq\u0014\u0004\u0005\u0002D\r6\tAI\u0003\u0002F\r\u0005)A/\u001f9fg&\u0011q\t\u0012\u0002\t\t\u0006$\u0018\rV=qK\")\u0011\n\u0001C!\u0015\u0006AA-\u0019;b)f\u0004X-F\u0001C\u0011\u0015a\u0005\u0001\"\u0011N\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002\u001dB\u0011qj\u0015\b\u0003!F\u0003\"!O\r\n\u0005IK\u0012A\u0002)sK\u0012,g-\u0003\u0002U+\n11\u000b\u001e:j]\u001eT!AU\r\t\u000f]\u0003!\u0019!C\u0005\u001b\u00061QM\u001d:Ng\u001eDa!\u0017\u0001!\u0002\u0013q\u0015aB3se6\u001bx\r\t\u0005\u00067\u0002!\t\u0005X\u0001\u0005KZ\fG\u000e\u0006\u0002^AB\u0011\u0001DX\u0005\u0003?f\u00111!\u00118z\u0011\u001d\t'\f%AA\u0002\t\fQ!\u001b8qkR\u0004\"a\u00193\u000e\u0003\u0011I!!\u001a\u0003\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0006O\u0002!\t\u0005[\u0001\nI><UM\\\"pI\u0016$2![8u!\tQW.D\u0001l\u0015\ta'!A\u0004d_\u0012,w-\u001a8\n\u00059\\'\u0001C#yaJ\u001cu\u000eZ3\t\u000bA4\u0007\u0019A9\u0002\u0007\r$\b\u0010\u0005\u0002ke&\u00111o\u001b\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015)h\r1\u0001j\u0003\t)g\u000fC\u0003\b\u0001\u0011\u0005S\nC\u0004y\u0001\u0005\u0005I\u0011A=\u0002\t\r|\u0007/\u001f\u000b\u0003WiDq!I<\u0011\u0002\u0003\u00071\u0005C\u0004}\u0001E\u0005I\u0011A?\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\taP\u000b\u0002$\u007f.\u0012\u0011\u0011\u0001\t\u0005\u0003\u0007\ti!\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003%)hn\u00195fG.,GMC\u0002\u0002\fe\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty!!\u0002\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002\u0014\u0001\t\t\u0011\"\u0011\u0002\u0016\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0006\u0011\t\u0005e\u00111E\u0007\u0003\u00037QA!!\b\u0002 \u0005!A.\u00198h\u0015\t\t\t#\u0001\u0003kCZ\f\u0017b\u0001+\u0002\u001c!I\u0011q\u0005\u0001\u0002\u0002\u0013\u0005\u0011\u0011F\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003W\u00012\u0001GA\u0017\u0013\r\ty#\u0007\u0002\u0004\u0013:$\b\"CA\u001a\u0001\u0005\u0005I\u0011AA\u001b\u00039\u0001(o\u001c3vGR,E.Z7f]R$2!XA\u001c\u0011)\tI$!\r\u0002\u0002\u0003\u0007\u00111F\u0001\u0004q\u0012\n\u0004\"CA\u001f\u0001\u0005\u0005I\u0011IA \u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA!!\u0015\t\u0019%!\u0013^\u001b\t\t)EC\u0002\u0002He\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY%!\u0012\u0003\u0011%#XM]1u_JD\u0011\"a\u0014\u0001\u0003\u0003%\t!!\u0015\u0002\u0011\r\fg.R9vC2$2\u0001MA*\u0011%\tI$!\u0014\u0002\u0002\u0003\u0007Q\fC\u0005\u0002X\u0001\t\t\u0011\"\u0011\u0002Z\u00051Q-];bYN$2\u0001MA.\u0011%\tI$!\u0016\u0002\u0002\u0003\u0007Q\fK\u0006\u0001\u0003?\n)'a\u001a\u0002l\u00055\u0004cA\t\u0002b%\u0019\u00111\r\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011N\u0001:?\u001a+fjQ0)Kb\u0004(/\u000b\u0011.AQC'o\\<tA\u0005t\u0007%\u001a=dKB$\u0018n\u001c8!S\u001a\u0004\u0003-\u001a=qe\u0002\u0004\u0013n\u001d\u0011o_R\u0004CO];f]\u0005AQ\r_1na2,7/\t\u0002\u0002p\u0005Y$\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b\u0019!y\u0001\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011\b\u0013\u0005M$!!A\t\u0002\u0005U\u0014AC!tg\u0016\u0014H\u000f\u0016:vKB\u0019\u0011#a\u001e\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003s\u001aR!a\u001e\u0002|u\u0001b!! \u0002\u0004\u000eZSBAA@\u0015\r\t\t)G\u0001\beVtG/[7f\u0013\u0011\t))a \u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007C\u0004*\u0003o\"\t!!#\u0015\u0005\u0005U\u0004BCAG\u0003o\n\t\u0011\"\u0012\u0002\u0010\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0018!Q\u00111SA<\u0003\u0003%\t)!&\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007-\n9\n\u0003\u0004\"\u0003#\u0003\ra\t\u0005\u000b\u00037\u000b9(!A\u0005\u0002\u0006u\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003?\u000b)\u000b\u0005\u0003\u0019\u0003C\u001b\u0013bAAR3\t1q\n\u001d;j_:D\u0011\"a*\u0002\u001a\u0006\u0005\t\u0019A\u0016\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002,\u0006]\u0014\u0011!C\u0005\u0003[\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0016\t\u0005\u00033\t\t,\u0003\u0003\u00024\u0006m!AB(cU\u0016\u001cG\u000f")
public class AssertTrue
extends UnaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression child;
    private final String errMsg;

    public static Option<Expression> unapply(AssertTrue assertTrue) {
        return AssertTrue$.MODULE$.unapply(assertTrue);
    }

    public static <A> Function1<Expression, A> andThen(Function1<AssertTrue, A> function1) {
        return AssertTrue$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, AssertTrue> compose(Function1<A, Expression> function1) {
        return AssertTrue$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BooleanType$[]{BooleanType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return NullType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "assert_true";
    }

    private String errMsg() {
        return this.errMsg;
    }

    @Override
    public Object eval(InternalRow input) {
        Object v = this.child().eval(input);
        if (v == null || Boolean.FALSE.equals(v)) {
            throw new RuntimeException(this.errMsg());
        }
        return null;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode eval = this.child().genCode(ctx);
        String errMsgField = ctx.addReferenceObj("errMsg", this.errMsg(), ctx.addReferenceObj$default$3());
        return new ExprCode(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\n       |if (", " || !", ") {\n       |  throw new RuntimeException(", ");\n       |}"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), eval.isNull(), eval.value(), errMsgField})).stripMargin(), TrueLiteral$.MODULE$, JavaCode$.MODULE$.defaultLiteral(this.dataType()));
    }

    @Override
    public String sql() {
        return new StringBuilder(13).append("assert_true(").append(this.child().sql()).append(")").toString();
    }

    public AssertTrue copy(Expression child) {
        return new AssertTrue(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "AssertTrue";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AssertTrue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AssertTrue)) return false;
        boolean bl = true;
        if (!bl) return false;
        AssertTrue assertTrue = (AssertTrue)x$1;
        Expression expression = this.child();
        Expression expression2 = assertTrue.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!assertTrue.canEqual(this)) return false;
        return true;
    }

    public AssertTrue(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
        this.errMsg = new StringBuilder(15).append("'").append(child.simpleString()).append("' is not true!").toString();
    }
}

