/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArraysOverlap$;
import org.apache.spark.sql.catalyst.expressions.BinaryArrayExpressionWithImplicitCast;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(a1, a2) - Returns true if a1 contains at least a non-null element present also in a2. If the arrays have no common element and they are both non-empty and either of them contains a null element null is returned, false otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array(3, 4, 5));\n       true\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t\u001dc\u0001B\u0001\u0003\u0001>\u0011Q\"\u0011:sCf\u001cxJ^3sY\u0006\u0004(BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001BcF\u000f\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\tR#\u0003\u0002\u0017\u0005\t)#)\u001b8bef\f%O]1z\u000bb\u0004(/Z:tS>tw+\u001b;i\u00136\u0004H.[2ji\u000e\u000b7\u000f\u001e\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\b!J|G-^2u!\tAb$\u0003\u0002 3\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0005\u0001BK\u0002\u0013\u0005!%\u0001\u0003mK\u001a$X#A\u0012\u0011\u0005E!\u0013BA\u0013\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tO\u0001\u0011\t\u0012)A\u0005G\u0005)A.\u001a4uA!A\u0011\u0006\u0001BK\u0002\u0013\u0005!%A\u0003sS\u001eDG\u000f\u0003\u0005,\u0001\tE\t\u0015!\u0003$\u0003\u0019\u0011\u0018n\u001a5uA!)Q\u0006\u0001C\u0001]\u00051A(\u001b8jiz\"2a\f\u00192!\t\t\u0002\u0001C\u0003\"Y\u0001\u00071\u0005C\u0003*Y\u0001\u00071\u0005C\u00034\u0001\u0011\u0005C'A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u00016!\t1\u0014(D\u00018\u0015\tAD!\u0001\u0005b]\u0006d\u0017p]5t\u0013\tQtGA\bUsB,7\t[3dWJ+7/\u001e7u\u0011!a\u0004\u0001#b\u0001\n\u0013i\u0014\u0001C8sI\u0016\u0014\u0018N\\4\u0016\u0003y\u00022aP$K\u001d\t\u0001UI\u0004\u0002B\t6\t!I\u0003\u0002D\u001d\u00051AH]8pizJ\u0011AG\u0005\u0003\rf\tq\u0001]1dW\u0006<W-\u0003\u0002I\u0013\nAqJ\u001d3fe&twM\u0003\u0002G3A\u0011\u0001dS\u0005\u0003\u0019f\u00111!\u00118zQ\tYd\n\u0005\u0002\u0019\u001f&\u0011\u0001+\u0007\u0002\niJ\fgn]5f]RD\u0001B\u0015\u0001\t\u0006\u0004%IaU\u0001\rI>,e/\u00197vCRLwN\\\u000b\u0002)B)\u0001$V,X\u0015&\u0011a+\u0007\u0002\n\rVt7\r^5p]J\u0002\"\u0001W.\u000e\u0003eS!A\u0017\u0003\u0002\tU$\u0018\u000e\\\u0005\u00039f\u0013\u0011\"\u0011:sCf$\u0015\r^1)\u0005Es\u0005\"B0\u0001\t\u0003\u0002\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\u0005\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u0004\u0002\u000bQL\b/Z:\n\u0005\u0019\u001c'\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000b!\u0004A\u0011I5\u0002\u00119,H\u000e\\1cY\u0016,\u0012A\u001b\t\u00031-L!\u0001\\\r\u0003\u000f\t{w\u000e\\3b]\")a\u000e\u0001C!_\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0019!\n\u001d:\t\u000bEl\u0007\u0019\u0001&\u0002\u0005\u0005\f\u0004\"B:n\u0001\u0004Q\u0015AA13\u0011\u0015)\b\u0001\"\u0003w\u0003!1\u0017m\u001d;Fm\u0006dGc\u0001&xs\")\u0001\u0010\u001ea\u0001/\u0006!\u0011M\u001d:2\u0011\u0015QH\u000f1\u0001X\u0003\u0011\t'O\u001d\u001a\t\u000bq\u0004A\u0011B?\u0002\u001d\t\u0014X\u000f^3G_J\u001cW-\u0012<bYR\u0019!J`@\t\u000ba\\\b\u0019A,\t\u000bi\\\b\u0019A,\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003\u000f\t\u0019\"!\b\u0011\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u0004\u0003\u0003\u001d\u0019w\u000eZ3hK:LA!!\u0005\u0002\f\tAQ\t\u001f9s\u0007>$W\r\u0003\u0005\u0002\u0016\u0005\u0005\u0001\u0019AA\f\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u0013\tI\"\u0003\u0003\u0002\u001c\u0005-!AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\t\u0003?\t\t\u00011\u0001\u0002\b\u0005\u0011QM\u001e\u0005\b\u0003G\u0001A\u0011BA\u0013\u0003-1\u0017m\u001d;D_\u0012,w-\u001a8\u0015\u0015\u0005\u001d\u0012qGA\u001d\u0003w\ty\u0004\u0005\u0003\u0002*\u0005Eb\u0002BA\u0016\u0003[\u0001\"!Q\r\n\u0007\u0005=\u0012$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003g\t)D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003_I\u0002\u0002CA\u000b\u0003C\u0001\r!a\u0006\t\u0011\u0005}\u0011\u0011\u0005a\u0001\u0003\u000fA\u0001\"!\u0010\u0002\"\u0001\u0007\u0011qE\u0001\bg6\fG\u000e\\3s\u0011!\t\t%!\tA\u0002\u0005\u001d\u0012A\u00022jO\u001e,'\u000fC\u0004\u0002F\u0001!I!a\u0012\u0002#\t\u0014X\u000f^3G_J\u001cWmQ8eK\u001e,g\u000e\u0006\u0006\u0002(\u0005%\u00131JA'\u0003\u001fB\u0001\"!\u0006\u0002D\u0001\u0007\u0011q\u0003\u0005\t\u0003?\t\u0019\u00051\u0001\u0002\b!A\u0011QHA\"\u0001\u0004\t9\u0003\u0003\u0005\u0002B\u0005\r\u0003\u0019AA\u0014\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+\naC\\;mYN\u000bg-Z#mK6,g\u000e^\"pI\u0016<WM\u001c\u000b\u000b\u0003O\t9&a\u0017\u0002`\u0005\r\u0004\u0002CA-\u0003#\u0002\r!a\n\u0002\u0011\u0005\u0014(/Y=WCJD\u0001\"!\u0018\u0002R\u0001\u0007\u0011qE\u0001\u0006S:$W\r\u001f\u0005\t\u0003C\n\t\u00061\u0001\u0002(\u0005!1m\u001c3f\u0011!\t)'!\u0015A\u0002\u0005\u001d\u0012AC5t\u001dVdGnQ8eK\"9\u0011\u0011\u000e\u0001\u0005B\u0005-\u0014A\u00039sKR$\u0018PT1nKV\u0011\u0011q\u0005\u0005\n\u0003_\u0002\u0011\u0011!C\u0001\u0003c\nAaY8qsR)q&a\u001d\u0002v!A\u0011%!\u001c\u0011\u0002\u0003\u00071\u0005\u0003\u0005*\u0003[\u0002\n\u00111\u0001$\u0011%\tI\bAI\u0001\n\u0003\tY(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005u$fA\u0012\u0002\u0000-\u0012\u0011\u0011\u0011\t\u0005\u0003\u0007\u000bi)\u0004\u0002\u0002\u0006*!\u0011qQAE\u0003%)hn\u00195fG.,GMC\u0002\u0002\ff\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty)!\"\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002\u0014\u0002\t\n\u0011\"\u0001\u0002|\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004\"CAL\u0001\u0005\u0005I\u0011IAM\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0014\t\u0005\u0003;\u000b9+\u0004\u0002\u0002 *!\u0011\u0011UAR\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0016\u0001\u00026bm\u0006LA!a\r\u0002 \"I\u00111\u0016\u0001\u0002\u0002\u0013\u0005\u0011QV\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003_\u00032\u0001GAY\u0013\r\t\u0019,\u0007\u0002\u0004\u0013:$\b\"CA\\\u0001\u0005\u0005I\u0011AA]\u00039\u0001(o\u001c3vGR,E.Z7f]R$2ASA^\u0011)\ti,!.\u0002\u0002\u0003\u0007\u0011qV\u0001\u0004q\u0012\n\u0004\"CAa\u0001\u0005\u0005I\u0011IAb\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAc!\u0015\t9-!4K\u001b\t\tIMC\u0002\u0002Lf\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty-!3\u0003\u0011%#XM]1u_JD\u0011\"a5\u0001\u0003\u0003%\t!!6\u0002\u0011\r\fg.R9vC2$2A[Al\u0011%\ti,!5\u0002\u0002\u0003\u0007!\nC\u0005\u0002\\\u0002\t\t\u0011\"\u0011\u0002^\u00061Q-];bYN$2A[Ap\u0011%\ti,!7\u0002\u0002\u0003\u0007!\nK\b\u0001\u0003G\fI/a;\u0002p\u0006E\u0018Q_A|!\r\t\u0012Q]\u0005\u0004\u0003O\u0014!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003[\f\u0011q[0G+:\u001bu\fK12Y\u0001\n''\u000b\u0011.AI+G/\u001e:og\u0002\"(/^3!S\u001a\u0004\u0013-\r\u0011d_:$\u0018-\u001b8tA\u0005$\b\u0005\\3bgR\u0004\u0013\r\t8p]6rW\u000f\u001c7!K2,W.\u001a8uAA\u0014Xm]3oi\u0002\nGn]8!S:\u0004\u0013M\r\u0018!\u0013\u001a\u0004C\u000f[3!CJ\u0014\u0018-_:!Q\u00064X\r\t8pA\r|W.\\8oA\u0015dW-\\3oi\u0002\ng\u000e\u001a\u0011uQ\u0016L\b%\u0019:fA\t|G\u000f\u001b\u0011o_:lS-\u001c9us\u0002\ng\u000e\u001a\u0011fSRDWM\u001d\u0011pM\u0002\"\b.Z7!G>tG/Y5og\u0002\n\u0007E\\;mY\u0002*G.Z7f]R\u0004c.\u001e7mA%\u001c\bE]3ukJtW\r\u001a\u0017!M\u0006d7/\u001a\u0011pi\",'o^5tK:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003g\fAK\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0019-AIb\u0003eM\u0015-A\u0005\u0014(/Y=)g1\u0002C\u0007\f\u00116S%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002z\u0006)!G\f\u001b/a\u001dI\u0011Q \u0002\u0002\u0002#\u0005\u0011q`\u0001\u000e\u0003J\u0014\u0018-_:Pm\u0016\u0014H.\u00199\u0011\u0007E\u0011\tA\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001B\u0002'\u0015\u0011\tA!\u0002\u001e!\u001d\u00119A!\u0004$G=j!A!\u0003\u000b\u0007\t-\u0011$A\u0004sk:$\u0018.\\3\n\t\t=!\u0011\u0002\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004bB\u0017\u0003\u0002\u0011\u0005!1\u0003\u000b\u0003\u0003\u007fD!Ba\u0006\u0003\u0002\u0005\u0005IQ\tB\r\u0003!!xn\u0015;sS:<GCAAN\u0011)\u0011iB!\u0001\u0002\u0002\u0013\u0005%qD\u0001\u0006CB\u0004H.\u001f\u000b\u0006_\t\u0005\"1\u0005\u0005\u0007C\tm\u0001\u0019A\u0012\t\r%\u0012Y\u00021\u0001$\u0011)\u00119C!\u0001\u0002\u0002\u0013\u0005%\u0011F\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011YCa\u000e\u0011\u000ba\u0011iC!\r\n\u0007\t=\u0012D\u0001\u0004PaRLwN\u001c\t\u00061\tM2eI\u0005\u0004\u0005kI\"A\u0002+va2,'\u0007C\u0005\u0003:\t\u0015\u0012\u0011!a\u0001_\u0005\u0019\u0001\u0010\n\u0019\t\u0015\tu\"\u0011AA\u0001\n\u0013\u0011y$A\u0006sK\u0006$'+Z:pYZ,GC\u0001B!!\u0011\tiJa\u0011\n\t\t\u0015\u0013q\u0014\u0002\u0007\u001f\nTWm\u0019;")
public class ArraysOverlap
extends BinaryExpression
implements BinaryArrayExpressionWithImplicitCast,
scala.Serializable {
    private transient Ordering<Object> ordering;
    private transient Function2<ArrayData, ArrayData, Object> doEvaluation;
    private final Expression left;
    private final Expression right;
    private transient DataType elementType;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArraysOverlap arraysOverlap) {
        return ArraysOverlap$.MODULE$.unapply(arraysOverlap);
    }

    public static Function1<Tuple2<Expression, Expression>, ArraysOverlap> tupled() {
        return ArraysOverlap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArraysOverlap>> curried() {
        return ArraysOverlap$.MODULE$.curried();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return BinaryArrayExpressionWithImplicitCast.inputTypes$(this);
    }

    private DataType elementType$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.elementType = BinaryArrayExpressionWithImplicitCast.elementType$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.elementType;
    }

    @Override
    public DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult = BinaryArrayExpressionWithImplicitCast.checkInputDataTypes$(this);
        TypeCheckResult typeCheckResult2 = TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult) ? TypeUtils$.MODULE$.checkForOrderingExpr(this.elementType(), new StringBuilder(9).append("function ").append(this.prettyName()).toString()) : typeCheckResult;
        return typeCheckResult2;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.elementType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private Function2<ArrayData, ArrayData, Object> doEvaluation$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.doEvaluation = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? (Function2 & Serializable & scala.Serializable)(arr1, arr2) -> this.fastEval((ArrayData)arr1, (ArrayData)arr2) : (Function2 & Serializable & scala.Serializable)(arr1, arr2) -> this.bruteForceEval((ArrayData)arr1, (ArrayData)arr2);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.doEvaluation;
    }

    private Function2<ArrayData, ArrayData, Object> doEvaluation() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.doEvaluation$lzycompute() : this.doEvaluation;
    }

    @Override
    public DataType dataType() {
        return BooleanType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return this.left().nullable() || this.right().nullable() || ((ArrayType)this.left().dataType()).containsNull() || ((ArrayType)this.right().dataType()).containsNull();
    }

    @Override
    public Object nullSafeEval(Object a1, Object a2) {
        return this.doEvaluation().apply((Object)((ArrayData)a1), (Object)((ArrayData)a2));
    }

    private Object fastEval(ArrayData arr1, ArrayData arr2) {
        Object object;
        Object object2 = new Object();
        try {
            Tuple2 tuple2;
            BooleanRef hasNull = BooleanRef.create((boolean)false);
            Tuple2 tuple22 = tuple2 = arr1.numElements() > arr2.numElements() ? new Tuple2((Object)arr1, (Object)arr2) : new Tuple2((Object)arr2, (Object)arr1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ArrayData bigger = (ArrayData)tuple2._1();
            ArrayData smaller = (ArrayData)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)bigger, (Object)smaller);
            Tuple2 tuple24 = tuple23;
            ArrayData bigger2 = (ArrayData)tuple24._1();
            ArrayData smaller2 = (ArrayData)tuple24._2();
            if (smaller2.numElements() > 0) {
                HashSet smallestSet = new HashSet();
                smaller2.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$27, v) -> {
                    ArraysOverlap.$anonfun$fastEval$1(hasNull, smallestSet, BoxesRunTime.unboxToInt((Object)x$27), v);
                    return BoxedUnit.UNIT;
                });
                bigger2.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$28, v1) -> {
                    ArraysOverlap.$anonfun$fastEval$2(hasNull, smallestSet, object2, BoxesRunTime.unboxToInt((Object)x$28), v1);
                    return BoxedUnit.UNIT;
                });
            }
            object = hasNull.elem ? null : BoxesRunTime.boxToBoolean((boolean)false);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    private Object bruteForceEval(ArrayData arr1, ArrayData arr2) {
        Object object;
        Object object2 = new Object();
        try {
            BooleanRef hasNull = BooleanRef.create((boolean)false);
            if (arr1.numElements() > 0 && arr2.numElements() > 0) {
                arr1.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$29, v1) -> {
                    ArraysOverlap.$anonfun$bruteForceEval$1(this, arr2, hasNull, object2, BoxesRunTime.unboxToInt((Object)x$29), v1);
                    return BoxedUnit.UNIT;
                });
            }
            object = hasNull.elem ? null : BoxesRunTime.boxToBoolean((boolean)false);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(a1, a2) -> {
            String smaller = ctx.freshName("smallerArray");
            String bigger = ctx.freshName("biggerArray");
            String comparisonCode = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? this.fastCodegen(ctx, ev, smaller, bigger) : this.bruteForceCodegen(ctx, ev, smaller, bigger);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(261).append("\n         |ArrayData ").append(smaller).append(";\n         |ArrayData ").append(bigger).append(";\n         |if (").append((String)a1).append(".numElements() > ").append((String)a2).append(".numElements()) {\n         |  ").append(bigger).append(" = ").append((String)a1).append(";\n         |  ").append(smaller).append(" = ").append((String)a2).append(";\n         |} else {\n         |  ").append(smaller).append(" = ").append((String)a1).append(";\n         |  ").append(bigger).append(" = ").append((String)a2).append(";\n         |}\n         |if (").append(smaller).append(".numElements() > 0) {\n         |  ").append(comparisonCode).append("\n         |}\n       ").toString())).stripMargin();
        });
    }

    private String fastCodegen(CodegenContext ctx, ExprCode ev, String smaller, String bigger) {
        String i = ctx.freshName("i");
        String getFromSmaller = CodeGenerator$.MODULE$.getValue(smaller, this.elementType(), i);
        String getFromBigger = CodeGenerator$.MODULE$.getValue(bigger, this.elementType(), i);
        String javaElementClass = CodeGenerator$.MODULE$.boxedType(this.elementType());
        String javaSet = java.util.HashSet.class.getName();
        String set = ctx.freshName("set");
        String addToSetFromSmallerCode = this.nullSafeElementCodegen(smaller, i, new StringBuilder(7).append(set).append(".add(").append(getFromSmaller).append(");").toString(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        String setIsNullCode = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        String elementIsInSetCode = this.nullSafeElementCodegen(bigger, i, new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("\n         |if (").append(set).append(".contains(").append(getFromBigger).append(")) {\n         |  ").append(setIsNullCode).append("\n         |  ").append(ev.value()).append(" = true;\n         |  break;\n         |}\n       ").toString())).stripMargin(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(170).append("\n       |").append(javaSet).append("<").append(javaElementClass).append("> ").append(set).append(" = new ").append(javaSet).append("<").append(javaElementClass).append(">();\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(smaller).append(".numElements(); ").append(i).append(" ++) {\n       |  ").append(addToSetFromSmallerCode).append("\n       |}\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(bigger).append(".numElements(); ").append(i).append(" ++) {\n       |  ").append(elementIsInSetCode).append("\n       |}\n     ").toString())).stripMargin();
    }

    private String bruteForceCodegen(CodegenContext ctx, ExprCode ev, String smaller, String bigger) {
        String i = ctx.freshName("i");
        String j = ctx.freshName("j");
        String getFromSmaller = CodeGenerator$.MODULE$.getValue(smaller, this.elementType(), j);
        String getFromBigger = CodeGenerator$.MODULE$.getValue(bigger, this.elementType(), i);
        String setIsNullCode = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        String compareValues = this.nullSafeElementCodegen(smaller, j, new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(72).append("\n         |if (").append(ctx.genEqual(this.elementType(), getFromSmaller, getFromBigger)).append(") {\n         |  ").append(setIsNullCode).append("\n         |  ").append(ev.value()).append(" = true;\n         |}\n       ").toString())).stripMargin(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        String isInSmaller = this.nullSafeElementCodegen(bigger, i, new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(89).append("\n         |for (int ").append(j).append(" = 0; ").append(j).append(" < ").append(smaller).append(".numElements() && !").append(ev.value()).append("; ").append(j).append(" ++) {\n         |  ").append(compareValues).append("\n         |}\n       ").toString())).stripMargin(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(81).append("\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(bigger).append(".numElements() && !").append(ev.value()).append("; ").append(i).append(" ++) {\n       |  ").append(isInSmaller).append("\n       |}\n     ").toString())).stripMargin();
    }

    public String nullSafeElementCodegen(String arrayVar, String index, String code, String isNullCode) {
        return this.inputTypes().exists((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)ArraysOverlap.$anonfun$nullSafeElementCodegen$1(x$31))) ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(94).append("\n         |if (").append(arrayVar).append(".isNullAt(").append(index).append(")) {\n         |  ").append(isNullCode).append("\n         |} else {\n         |  ").append(code).append("\n         |}\n       ").toString())).stripMargin() : code;
    }

    @Override
    public String prettyName() {
        return "arrays_overlap";
    }

    public ArraysOverlap copy(Expression left, Expression right) {
        return new ArraysOverlap(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArraysOverlap";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArraysOverlap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArraysOverlap)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArraysOverlap arraysOverlap = (ArraysOverlap)x$1;
        Expression expression = this.left();
        Expression expression2 = arraysOverlap.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arraysOverlap.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arraysOverlap.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$fastEval$1(BooleanRef hasNull$2, HashSet smallestSet$1, int x$27, Object v) {
        if (v == null) {
            hasNull$2.elem = true;
        } else {
            smallestSet$1.$plus$eq(v);
        }
    }

    public static final /* synthetic */ void $anonfun$fastEval$2(BooleanRef hasNull$2, HashSet smallestSet$1, Object nonLocalReturnKey2$1, int x$28, Object v1) {
        if (v1 == null) {
            hasNull$2.elem = true;
        } else if (smallestSet$1.contains(v1)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey2$1, true);
        }
    }

    public static final /* synthetic */ void $anonfun$bruteForceEval$2(ArraysOverlap $this, BooleanRef hasNull$3, Object v1$1, Object nonLocalReturnKey3$1, int x$30, Object v2) {
        if (v2 == null) {
            hasNull$3.elem = true;
        } else if ($this.ordering().equiv(v1$1, v2)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey3$1, true);
        }
    }

    public static final /* synthetic */ void $anonfun$bruteForceEval$1(ArraysOverlap $this, ArrayData arr2$1, BooleanRef hasNull$3, Object nonLocalReturnKey3$1, int x$29, Object v1) {
        if (v1 == null) {
            hasNull$3.elem = true;
        } else {
            arr2$1.foreach($this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$30, v2) -> {
                ArraysOverlap.$anonfun$bruteForceEval$2($this, hasNull$3, v1, nonLocalReturnKey3$1, BoxesRunTime.unboxToInt((Object)x$30), v2);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$nullSafeElementCodegen$1(AbstractDataType x$31) {
        return ((ArrayType)x$31).containsNull();
    }

    public ArraysOverlap(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        BinaryArrayExpressionWithImplicitCast.$init$(this);
    }
}

