/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayJoin$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.expressions.codegen.UTF8StringBuilder;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array, delimiter[, nullReplacement]) - Concatenates the elements of the given array\n      using the delimiter and an optional string to replace nulls. If no value is set for\n      nullReplacement, any null value is filtered.", examples="\n    Examples:\n      > SELECT _FUNC_(array('hello', 'world'), ' ');\n       hello world\n      > SELECT _FUNC_(array('hello', null ,'world'), ' ');\n       hello world\n      > SELECT _FUNC_(array('hello', null ,'world'), ' ', ',');\n       hello , world\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\tUa\u0001B\u0001\u0003\u0001>\u0011\u0011\"\u0011:sCfTu.\u001b8\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\t\u0015/u\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002\u0012+%\u0011aC\u0001\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"a\u0002)s_\u0012,8\r\u001e\t\u00031yI!aH\r\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011\u0005\u0002!Q3A\u0005\u0002\t\nQ!\u0019:sCf,\u0012\u0001\u0005\u0005\tI\u0001\u0011\t\u0012)A\u0005!\u00051\u0011M\u001d:bs\u0002B\u0001B\n\u0001\u0003\u0016\u0004%\tAI\u0001\nI\u0016d\u0017.\\5uKJD\u0001\u0002\u000b\u0001\u0003\u0012\u0003\u0006I\u0001E\u0001\u000bI\u0016d\u0017.\\5uKJ\u0004\u0003\u0002\u0003\u0016\u0001\u0005+\u0007I\u0011A\u0016\u0002\u001f9,H\u000e\u001c*fa2\f7-Z7f]R,\u0012\u0001\f\t\u000415\u0002\u0012B\u0001\u0018\u001a\u0005\u0019y\u0005\u000f^5p]\"A\u0001\u0007\u0001B\tB\u0003%A&\u0001\tok2d'+\u001a9mC\u000e,W.\u001a8uA!)!\u0007\u0001C\u0001g\u00051A(\u001b8jiz\"B\u0001N\u001b7oA\u0011\u0011\u0003\u0001\u0005\u0006CE\u0002\r\u0001\u0005\u0005\u0006ME\u0002\r\u0001\u0005\u0005\u0006UE\u0002\r\u0001\f\u0005\u0006e\u0001!\t!\u000f\u000b\u0004iiZ\u0004\"B\u00119\u0001\u0004\u0001\u0002\"\u0002\u00149\u0001\u0004\u0001\u0002\"\u0002\u001a\u0001\t\u0003iD\u0003\u0002\u001b?\u007f\u0001CQ!\t\u001fA\u0002AAQA\n\u001fA\u0002AAQA\u000b\u001fA\u0002AAQA\u0011\u0001\u0005B\r\u000b!\"\u001b8qkR$\u0016\u0010]3t+\u0005!\u0005cA#N!:\u0011ai\u0013\b\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013:\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u00051K\u0012a\u00029bG.\fw-Z\u0005\u0003\u001d>\u00131aU3r\u0015\ta\u0015\u0004\u0005\u0002R)6\t!K\u0003\u0002T\r\u0005)A/\u001f9fg&\u0011QK\u0015\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016DQa\u0016\u0001\u0005Ba\u000b\u0001b\u00195jY\u0012\u0014XM\\\u000b\u00023B\u0019Q)\u0014\t\t\u000bm\u0003A\u0011\t/\u0002\u00119,H\u000e\\1cY\u0016,\u0012!\u0018\t\u00031yK!aX\r\u0003\u000f\t{w\u000e\\3b]\")\u0011\r\u0001C!9\u0006Aam\u001c7eC\ndW\rC\u0003d\u0001\u0011\u0005C-\u0001\u0003fm\u0006dGCA3i!\tAb-\u0003\u0002h3\t\u0019\u0011I\\=\t\u000f%\u0014\u0007\u0013!a\u0001U\u0006)\u0011N\u001c9viB\u00111\u000e\\\u0007\u0002\t%\u0011Q\u000e\u0002\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0003p\u0001\u0011E\u0003/A\u0005e_\u001e+gnQ8eKR\u0019\u0011o\u001e?\u0011\u0005I,X\"A:\u000b\u0005Q\u0014\u0011aB2pI\u0016<WM\\\u0005\u0003mN\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006q:\u0004\r!_\u0001\u0004GRD\bC\u0001:{\u0013\tY8O\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000but\u0007\u0019A9\u0002\u0005\u00154\bBB@\u0001\t\u0013\t\t!A\u000ehK:\u001cu\u000eZ3G_J\f%O]1z\u0003:$G)\u001a7j[&$XM\u001d\u000b\t\u0003\u0007\t\u0019\"!\u0006\u0002\u0018A!\u0011QAA\u0007\u001d\u0011\t9!!\u0003\u0011\u0005\u001dK\u0012bAA\u00063\u00051\u0001K]3eK\u001aLA!a\u0004\u0002\u0012\t11\u000b\u001e:j]\u001eT1!a\u0003\u001a\u0011\u0015Ah\u00101\u0001z\u0011\u0015ih\u00101\u0001r\u0011\u001d\tIB a\u0001\u00037\t\u0001B\\;mY\u00163\u0018\r\u001c\t\f1\u0005u\u00111AA\u0002\u0003\u0007\t\u0019!C\u0002\u0002 e\u0011\u0011BR;oGRLwN\\\u001a\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002&\u0005AA-\u0019;b)f\u0004X-\u0006\u0002\u0002(A\u0019\u0011+!\u000b\n\u0007\u0005-\"K\u0001\u0005ECR\fG+\u001f9f\u0011\u001d\ty\u0003\u0001C!\u0003c\t!\u0002\u001d:fiRLh*Y7f+\t\t\u0019\u0001C\u0005\u00026\u0001\t\t\u0011\"\u0001\u00028\u0005!1m\u001c9z)\u001d!\u0014\u0011HA\u001e\u0003{A\u0001\"IA\u001a!\u0003\u0005\r\u0001\u0005\u0005\tM\u0005M\u0002\u0013!a\u0001!!A!&a\r\u0011\u0002\u0003\u0007A\u0006C\u0005\u0002B\u0001\t\n\u0011\"\u0001\u0002D\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA#U\r\u0001\u0012qI\u0016\u0003\u0003\u0013\u0002B!a\u0013\u0002V5\u0011\u0011Q\n\u0006\u0005\u0003\u001f\n\t&A\u0005v]\u000eDWmY6fI*\u0019\u00111K\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002X\u00055#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u00111\f\u0001\u0012\u0002\u0013\u0005\u00111I\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011%\ty\u0006AI\u0001\n\u0003\t\t'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\r$f\u0001\u0017\u0002H!I\u0011q\r\u0001\u0002\u0002\u0013\u0005\u0013\u0011N\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005-\u0004\u0003BA7\u0003oj!!a\u001c\u000b\t\u0005E\u00141O\u0001\u0005Y\u0006twM\u0003\u0002\u0002v\u0005!!.\u0019<b\u0013\u0011\ty!a\u001c\t\u0013\u0005m\u0004!!A\u0005\u0002\u0005u\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAA@!\rA\u0012\u0011Q\u0005\u0004\u0003\u0007K\"aA%oi\"I\u0011q\u0011\u0001\u0002\u0002\u0013\u0005\u0011\u0011R\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r)\u00171\u0012\u0005\u000b\u0003\u001b\u000b))!AA\u0002\u0005}\u0014a\u0001=%c!I\u0011\u0011\u0013\u0001\u0002\u0002\u0013\u0005\u00131S\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0013\t\u0006\u0003/\u000bi*Z\u0007\u0003\u00033S1!a'\u001a\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003?\u000bIJ\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t\u0019\u000bAA\u0001\n\u0003\t)+\u0001\u0005dC:,\u0015/^1m)\ri\u0016q\u0015\u0005\n\u0003\u001b\u000b\t+!AA\u0002\u0015D\u0011\"a+\u0001\u0003\u0003%\t%!,\u0002\r\u0015\fX/\u00197t)\ri\u0016q\u0016\u0005\n\u0003\u001b\u000bI+!AA\u0002\u0015Ds\u0002AAZ\u0003s\u000bY,a0\u0002B\u0006\u0015\u0017q\u0019\t\u0004#\u0005U\u0016bAA\\\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA_\u0003\u0005e'\u0002\t\u0011!A}3UKT\"`Q\u0005\u0014(/Y=-A\u0011,G.[7ji\u0016\u00148\f\f\u0011ok2d'+\u001a9mC\u000e,W.\u001a8u;&\u0002S\u0006I\"p]\u000e\fG/\u001a8bi\u0016\u001c\b\u0005\u001e5fA\u0015dW-\\3oiN\u0004sN\u001a\u0011uQ\u0016\u0004s-\u001b<f]\u0002\n'O]1z\u0015\u0001\u0002\u0003\u0005\t\u0011!kNLgn\u001a\u0011uQ\u0016\u0004C-\u001a7j[&$XM\u001d\u0011b]\u0012\u0004\u0013M\u001c\u0011paRLwN\\1mAM$(/\u001b8hAQ|\u0007E]3qY\u0006\u001cW\r\t8vY2\u001ch\u0006I%gA9|\u0007E^1mk\u0016\u0004\u0013n\u001d\u0011tKR\u0004cm\u001c:\u000bA\u0001\u0002\u0003\u0005\t\u0011ok2d'+\u001a9mC\u000e,W.\u001a8uY\u0001\ng.\u001f\u0011ok2d\u0007E^1mk\u0016\u0004\u0013n\u001d\u0011gS2$XM]3e]\u0005AQ\r_1na2,7/\t\u0002\u0002D\u0006\tIP\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0014iK2dwn\n\u0017!O]|'\u000f\u001c3(S1\u0002s\u0005I\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001BW\r\u001c7pA]|'\u000f\u001c3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)O!,G\u000e\\8(Y\u0001rW\u000f\u001c7!Y\u001d:xN\u001d7eO%b\u0003e\n\u0011(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003.\u001a7m_\u0002:xN\u001d7e\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQ\u001dBW\r\u001c7pO1\u0002c.\u001e7mA1:so\u001c:mI\u001eJC\u0006I\u0014!O1\u0002s\u0005L\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001BW\r\u001c7pA1\u0002so\u001c:mI*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002J\u0006)!G\f\u001b/a\u001dI\u0011Q\u001a\u0002\u0002\u0002#\u0005\u0011qZ\u0001\n\u0003J\u0014\u0018-\u001f&pS:\u00042!EAi\r!\t!!!A\t\u0002\u0005M7#BAi\u0003+l\u0002\u0003CAl\u0003;\u0004\u0002\u0003\f\u001b\u000e\u0005\u0005e'bAAn3\u00059!/\u001e8uS6,\u0017\u0002BAp\u00033\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84\u0011\u001d\u0011\u0014\u0011\u001bC\u0001\u0003G$\"!a4\t\u0015\u0005\u001d\u0018\u0011[A\u0001\n\u000b\nI/\u0001\u0005u_N#(/\u001b8h)\t\tY\u0007\u0003\u0006\u0002n\u0006E\u0017\u0011!CA\u0003_\fQ!\u00199qYf$r\u0001NAy\u0003g\f)\u0010\u0003\u0004\"\u0003W\u0004\r\u0001\u0005\u0005\u0007M\u0005-\b\u0019\u0001\t\t\r)\nY\u000f1\u0001-\u0011)\tI0!5\u0002\u0002\u0013\u0005\u00151`\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tiP!\u0002\u0011\tai\u0013q \t\u00071\t\u0005\u0001\u0003\u0005\u0017\n\u0007\t\r\u0011D\u0001\u0004UkBdWm\r\u0005\n\u0005\u000f\t90!AA\u0002Q\n1\u0001\u001f\u00131\u0011)\u0011Y!!5\u0002\u0002\u0013%!QB\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u0010A!\u0011Q\u000eB\t\u0013\u0011\u0011\u0019\"a\u001c\u0003\r=\u0013'.Z2u\u0001")
public class ArrayJoin
extends Expression
implements ExpectsInputTypes,
scala.Serializable {
    private final Expression array;
    private final Expression delimiter;
    private final Option<Expression> nullReplacement;

    public static Option<Tuple3<Expression, Expression, Option<Expression>>> unapply(ArrayJoin arrayJoin) {
        return ArrayJoin$.MODULE$.unapply(arrayJoin);
    }

    public static Function1<Tuple3<Expression, Expression, Option<Expression>>, ArrayJoin> tupled() {
        return ArrayJoin$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<Expression>, ArrayJoin>>> curried() {
        return ArrayJoin$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression array() {
        return this.array;
    }

    public Expression delimiter() {
        return this.delimiter;
    }

    public Option<Expression> nullReplacement() {
        return this.nullReplacement;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return this.nullReplacement().isDefined() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{ArrayType$.MODULE$.apply(StringType$.MODULE$), StringType$.MODULE$, StringType$.MODULE$})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{ArrayType$.MODULE$.apply(StringType$.MODULE$), StringType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        return this.nullReplacement().isDefined() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.array(), this.delimiter(), (Expression)this.nullReplacement().get()})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.array(), this.delimiter()}));
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)x$32.nullable()));
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)x$33.foldable()));
    }

    @Override
    public Object eval(InternalRow input) {
        Function1 & Serializable & scala.Serializable intersect;
        Object arrayEval = this.array().eval(input);
        if (arrayEval == null) {
            return null;
        }
        Object delimiterEval = this.delimiter().eval(input);
        if (delimiterEval == null) {
            return null;
        }
        Option nullReplacementEval = this.nullReplacement().map((Function1 & Serializable & scala.Serializable)x$34 -> x$34.eval(input));
        if (nullReplacementEval.contains(null)) {
            return null;
        }
        UTF8StringBuilder buffer = new UTF8StringBuilder();
        BooleanRef firstItem = BooleanRef.create((boolean)true);
        Option option = nullReplacementEval;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object rep = some.value();
            intersect = (Function1 & Serializable & scala.Serializable)prependDelimiter -> BoxesRunTime.boxToBoolean((boolean)ArrayJoin.$anonfun$eval$11(delimiterEval, buffer, rep, BoxesRunTime.unboxToBoolean((Object)prependDelimiter)));
        } else if (None$.MODULE$.equals(option)) {
            intersect = (Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToBoolean((boolean)ArrayJoin.$anonfun$eval$12(BoxesRunTime.unboxToBoolean((Object)x$35)));
        } else {
            throw new MatchError((Object)option);
        }
        Function1 & Serializable & scala.Serializable nullHandling = intersect;
        ((ArrayData)arrayEval).foreach(StringType$.MODULE$, (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$36, item) -> {
            ArrayJoin.$anonfun$eval$13(delimiterEval, buffer, firstItem, nullHandling, BoxesRunTime.unboxToInt((Object)x$36), item);
            return BoxedUnit.UNIT;
        });
        return buffer.build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String string;
        Option<Expression> option = this.nullReplacement();
        if (option instanceof Some) {
            Some some = (Some)option;
            Expression replacement = (Expression)some.value();
            ExprCode replacementGen = replacement.genCode(ctx);
            Function3 & Serializable & scala.Serializable nullHandling = (Function3 & Serializable & scala.Serializable)(buffer, delimiter, firstItem) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(127).append("\n             |if (!").append((String)firstItem).append(") {\n             |  ").append((String)buffer).append(".append(").append((String)delimiter).append(");\n             |}\n             |").append((String)buffer).append(".append(").append(replacementGen.value()).append(");\n             |").append((String)firstItem).append(" = false;\n           ").toString())).stripMargin();
            String execCode = replacement.nullable() ? ctx.nullSafeExec(replacement.nullable(), ExprValue$.MODULE$.exprValueToString(replacementGen.isNull()), this.genCodeForArrayAndDelimiter(ctx, ev, (Function3<String, String, String, String>)nullHandling)) : this.genCodeForArrayAndDelimiter(ctx, ev, (Function3<String, String, String, String>)nullHandling);
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(36).append("\n           |").append(replacementGen.code()).append("\n           |").append(execCode).append("\n         ").toString())).stripMargin();
        } else if (None$.MODULE$.equals(option)) {
            string = this.genCodeForArrayAndDelimiter(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(x$37, x$38, x$39) -> "// nulls are ignored");
        } else {
            throw new MatchError(option);
        }
        String code = string;
        return this.nullable() ? ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |boolean ", " = true;\n           |UTF8String ", " = null;\n           |", "\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), code})).stripMargin(), ev.copy$default$2(), ev.copy$default$3()) : ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |UTF8String ", " = null;\n           |", "\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), code})).stripMargin(), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    private String genCodeForArrayAndDelimiter(CodegenContext ctx, ExprCode ev, Function3<String, String, String, String> nullEval) {
        ExprCode arrayGen = this.array().genCode(ctx);
        ExprCode delimiterGen = this.delimiter().genCode(ctx);
        String buffer = ctx.freshName("buffer");
        String bufferClass = UTF8StringBuilder.class.getName();
        String i = ctx.freshName("i");
        String firstItem = ctx.freshName("firstItem");
        String resultCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(331).append("\n         |").append(bufferClass).append(" ").append(buffer).append(" = new ").append(bufferClass).append("();\n         |boolean ").append(firstItem).append(" = true;\n         |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(arrayGen.value()).append(".numElements(); ").append(i).append(" ++) {\n         |  if (").append(arrayGen.value()).append(".isNullAt(").append(i).append(")) {\n         |    ").append(nullEval.apply((Object)buffer, (Object)ExprValue$.MODULE$.exprValueToString(delimiterGen.value()), (Object)firstItem)).append("\n         |  } else {\n         |    if (!").append(firstItem).append(") {\n         |      ").append(buffer).append(".append(").append(delimiterGen.value()).append(");\n         |    }\n         |    ").append(buffer).append(".append(").append(CodeGenerator$.MODULE$.getValue(ExprValue$.MODULE$.exprValueToString(arrayGen.value()), StringType$.MODULE$, i)).append(");\n         |    ").append(firstItem).append(" = false;\n         |  }\n         |}\n         |").append(ev.value()).append(" = ").append(buffer).append(".build();").toString())).stripMargin();
        return this.array().nullable() || this.delimiter().nullable() ? Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)arrayGen.code()), ctx.nullSafeExec(this.array().nullable(), ExprValue$.MODULE$.exprValueToString(arrayGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)delimiterGen.code()), ctx.nullSafeExec(this.delimiter().nullable(), ExprValue$.MODULE$.exprValueToString(delimiterGen.isNull()), new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(39).append("\n             |").append(ev.isNull()).append(" = false;\n             |").append(resultCode).toString())).stripMargin())))) : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(33).append("\n         |").append(arrayGen.code()).append("\n         |").append(delimiterGen.code()).append("\n         |").append(resultCode).toString())).stripMargin();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "array_join";
    }

    public ArrayJoin copy(Expression array, Expression delimiter, Option<Expression> nullReplacement) {
        return new ArrayJoin(array, delimiter, nullReplacement);
    }

    public Expression copy$default$1() {
        return this.array();
    }

    public Expression copy$default$2() {
        return this.delimiter();
    }

    public Option<Expression> copy$default$3() {
        return this.nullReplacement();
    }

    @Override
    public String productPrefix() {
        return "ArrayJoin";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<Expression> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.array();
                break;
            }
            case 1: {
                option = this.delimiter();
                break;
            }
            case 2: {
                option = this.nullReplacement();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayJoin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayJoin)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayJoin arrayJoin = (ArrayJoin)x$1;
        Expression expression = this.array();
        Expression expression2 = arrayJoin.array();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.delimiter();
        Expression expression4 = arrayJoin.delimiter();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Expression> option = this.nullReplacement();
        Option<Expression> option2 = arrayJoin.nullReplacement();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!arrayJoin.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$eval$11(Object delimiterEval$1, UTF8StringBuilder buffer$1, Object rep$1, boolean prependDelimiter) {
        if (!prependDelimiter) {
            buffer$1.append((UTF8String)delimiterEval$1);
        }
        buffer$1.append((UTF8String)rep$1);
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$eval$12(boolean x$35) {
        return false;
    }

    public static final /* synthetic */ void $anonfun$eval$13(Object delimiterEval$1, UTF8StringBuilder buffer$1, BooleanRef firstItem$1, Function1 nullHandling$1, int x$36, Object item) {
        if (item == null) {
            if (BoxesRunTime.unboxToBoolean((Object)nullHandling$1.apply((Object)BoxesRunTime.boxToBoolean((boolean)firstItem$1.elem)))) {
                firstItem$1.elem = false;
            }
        } else {
            if (!firstItem$1.elem) {
                buffer$1.append((UTF8String)delimiterEval$1);
            }
            buffer$1.append((UTF8String)item);
            firstItem$1.elem = false;
        }
    }

    public ArrayJoin(Expression array, Expression delimiter, Option<Expression> nullReplacement) {
        this.array = array;
        this.delimiter = delimiter;
        this.nullReplacement = nullReplacement;
        ExpectsInputTypes.$init$(this);
    }

    public ArrayJoin(Expression array, Expression delimiter) {
        this(array, delimiter, (Option<Expression>)None$.MODULE$);
    }

    public ArrayJoin(Expression array, Expression delimiter, Expression nullReplacement) {
        this(array, delimiter, (Option<Expression>)new Some((Object)nullReplacement));
    }
}

