/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.AddMonths$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(start_date, num_months) - Returns the date that is `num_months` after `start_date`.", examples="\n    Examples:\n      > SELECT _FUNC_('2016-08-31', 1);\n       2016-09-30\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u0001\u0003\u0001>\u0011\u0011\"\u00113e\u001b>tG\u000f[:\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\t\u0015/u\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\t\u0016\u0013\t1\"A\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0007\u0010\n\u0005}I\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\u0011\u0001\u0005+\u0007I\u0011\u0001\u0012\u0002\u0013M$\u0018M\u001d;ECR,W#A\u0012\u0011\u0005E!\u0013BA\u0013\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tO\u0001\u0011\t\u0012)A\u0005G\u0005Q1\u000f^1si\u0012\u000bG/\u001a\u0011\t\u0011%\u0002!Q3A\u0005\u0002\t\n\u0011B\\;n\u001b>tG\u000f[:\t\u0011-\u0002!\u0011#Q\u0001\n\r\n!B\\;n\u001b>tG\u000f[:!\u0011\u0015i\u0003\u0001\"\u0001/\u0003\u0019a\u0014N\\5u}Q\u0019q\u0006M\u0019\u0011\u0005E\u0001\u0001\"B\u0011-\u0001\u0004\u0019\u0003\"B\u0015-\u0001\u0004\u0019\u0003\"B\u001a\u0001\t\u0003\u0012\u0013\u0001\u00027fMRDQ!\u000e\u0001\u0005B\t\nQA]5hQRDQa\u000e\u0001\u0005Ba\n!\"\u001b8qkR$\u0016\u0010]3t+\u0005I\u0004c\u0001\u001eC\u000b:\u00111\b\u0011\b\u0003y}j\u0011!\u0010\u0006\u0003}9\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u0005\u0005K\u0012a\u00029bG.\fw-Z\u0005\u0003\u0007\u0012\u00131aU3r\u0015\t\t\u0015\u0004\u0005\u0002G\u00136\tqI\u0003\u0002I\r\u0005)A/\u001f9fg&\u0011!j\u0012\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016DQ\u0001\u0014\u0001\u0005B5\u000b\u0001\u0002Z1uCRK\b/Z\u000b\u0002\u001dB\u0011aiT\u0005\u0003!\u001e\u0013\u0001\u0002R1uCRK\b/\u001a\u0005\u0006%\u0002!\teU\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004)^K\u0006C\u0001\rV\u0013\t1\u0016DA\u0002B]fDQ\u0001W)A\u0002Q\u000bQa\u001d;beRDQAW)A\u0002Q\u000ba!\\8oi\"\u001c\b\"\u0002/\u0001\t\u0003j\u0016!\u00033p\u000f\u0016t7i\u001c3f)\rqF-\u001b\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C\n\tqaY8eK\u001e,g.\u0003\u0002dA\nAQ\t\u001f9s\u0007>$W\rC\u0003f7\u0002\u0007a-A\u0002dib\u0004\"aX4\n\u0005!\u0004'AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006Un\u0003\rAX\u0001\u0003KZDQ\u0001\u001c\u0001\u0005B5\f!\u0002\u001d:fiRLh*Y7f+\u0005q\u0007CA8t\u001d\t\u0001\u0018\u000f\u0005\u0002=3%\u0011!/G\u0001\u0007!J,G-\u001a4\n\u0005Q,(AB*ue&twM\u0003\u0002s3!9q\u000fAA\u0001\n\u0003A\u0018\u0001B2paf$2aL={\u0011\u001d\tc\u000f%AA\u0002\rBq!\u000b<\u0011\u0002\u0003\u00071\u0005C\u0004}\u0001E\u0005I\u0011A?\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\taP\u000b\u0002$\u007f.\u0012\u0011\u0011\u0001\t\u0005\u0003\u0007\ti!\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003%)hn\u00195fG.,GMC\u0002\u0002\fe\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty!!\u0002\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0005\u0002\u0014\u0001\t\n\u0011\"\u0001~\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB\u0011\"a\u0006\u0001\u0003\u0003%\t%!\u0007\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u0002\u0005\u0003\u0002\u001e\u0005\u001dRBAA\u0010\u0015\u0011\t\t#a\t\u0002\t1\fgn\u001a\u0006\u0003\u0003K\tAA[1wC&\u0019A/a\b\t\u0013\u0005-\u0002!!A\u0005\u0002\u00055\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0018!\rA\u0012\u0011G\u0005\u0004\u0003gI\"aA%oi\"I\u0011q\u0007\u0001\u0002\u0002\u0013\u0005\u0011\u0011H\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r!\u00161\b\u0005\u000b\u0003{\t)$!AA\u0002\u0005=\u0012a\u0001=%c!I\u0011\u0011\t\u0001\u0002\u0002\u0013\u0005\u00131I\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\t\t\u0006\u0003\u000f\ni\u0005V\u0007\u0003\u0003\u0013R1!a\u0013\u001a\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001f\nIE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t\u0019\u0006AA\u0001\n\u0003\t)&\u0001\u0005dC:,\u0015/^1m)\u0011\t9&!\u0018\u0011\u0007a\tI&C\u0002\u0002\\e\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002>\u0005E\u0013\u0011!a\u0001)\"I\u0011\u0011\r\u0001\u0002\u0002\u0013\u0005\u00131M\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005]\u0013Q\r\u0005\n\u0003{\ty&!AA\u0002QCs\u0002AA5\u0003_\n\t(!\u001e\u0002x\u0005m\u0014Q\u0010\t\u0004#\u0005-\u0014bAA7\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA:\u0003i{f)\u0016(D?\"\u001aH/\u0019:u?\u0012\fG/\u001a\u0017!]Vlw,\\8oi\"\u001c\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t3bi\u0016\u0004C\u000f[1uA%\u001c\b\u0005\u00198v[~kwN\u001c;ig\u0002\u0004\u0013M\u001a;fe\u0002\u00027\u000f^1si~#\u0017\r^3a]\u0005AQ\r_1na2,7/\t\u0002\u0002z\u0005Y%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00143aE2T\u0006\r\u001d.gE:C\u0006I\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'\r\u001c.aej3\u0007\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qP\u0001\u0006c9*d\u0006M\u0004\n\u0003\u0007\u0013\u0011\u0011!E\u0001\u0003\u000b\u000b\u0011\"\u00113e\u001b>tG\u000f[:\u0011\u0007E\t9I\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAE'\u0015\t9)a#\u001e!\u001d\ti)a%$G=j!!a$\u000b\u0007\u0005E\u0015$A\u0004sk:$\u0018.\\3\n\t\u0005U\u0015q\u0012\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004bB\u0017\u0002\b\u0012\u0005\u0011\u0011\u0014\u000b\u0003\u0003\u000bC!\"!(\u0002\b\u0006\u0005IQIAP\u0003!!xn\u0015;sS:<GCAA\u000e\u0011)\t\u0019+a\"\u0002\u0002\u0013\u0005\u0015QU\u0001\u0006CB\u0004H.\u001f\u000b\u0006_\u0005\u001d\u0016\u0011\u0016\u0005\u0007C\u0005\u0005\u0006\u0019A\u0012\t\r%\n\t\u000b1\u0001$\u0011)\ti+a\"\u0002\u0002\u0013\u0005\u0015qV\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\t,!0\u0011\u000ba\t\u0019,a.\n\u0007\u0005U\u0016D\u0001\u0004PaRLwN\u001c\t\u00061\u0005e6eI\u0005\u0004\u0003wK\"A\u0002+va2,'\u0007C\u0005\u0002@\u0006-\u0016\u0011!a\u0001_\u0005\u0019\u0001\u0010\n\u0019\t\u0015\u0005\r\u0017qQA\u0001\n\u0013\t)-A\u0006sK\u0006$'+Z:pYZ,GCAAd!\u0011\ti\"!3\n\t\u0005-\u0017q\u0004\u0002\u0007\u001f\nTWm\u0019;")
public class AddMonths
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression startDate;
    private final Expression numMonths;

    public static Option<Tuple2<Expression, Expression>> unapply(AddMonths addMonths) {
        return AddMonths$.MODULE$.unapply(addMonths);
    }

    public static Function1<Tuple2<Expression, Expression>, AddMonths> tupled() {
        return AddMonths$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, AddMonths>> curried() {
        return AddMonths$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression startDate() {
        return this.startDate;
    }

    public Expression numMonths() {
        return this.numMonths;
    }

    @Override
    public Expression left() {
        return this.startDate();
    }

    @Override
    public Expression right() {
        return this.numMonths();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{DateType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object start, Object months) {
        return BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.dateAddMonths(BoxesRunTime.unboxToInt((Object)start), BoxesRunTime.unboxToInt((Object)months)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(sd, m) -> new StringBuilder(18).append(dtu).append(".dateAddMonths(").append((String)sd).append(", ").append((String)m).append(")").toString());
    }

    @Override
    public String prettyName() {
        return "add_months";
    }

    public AddMonths copy(Expression startDate, Expression numMonths) {
        return new AddMonths(startDate, numMonths);
    }

    public Expression copy$default$1() {
        return this.startDate();
    }

    public Expression copy$default$2() {
        return this.numMonths();
    }

    @Override
    public String productPrefix() {
        return "AddMonths";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.startDate();
                break;
            }
            case 1: {
                expression = this.numMonths();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AddMonths;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AddMonths)) return false;
        boolean bl = true;
        if (!bl) return false;
        AddMonths addMonths = (AddMonths)x$1;
        Expression expression = this.startDate();
        Expression expression2 = addMonths.startDate();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.numMonths();
        Expression expression4 = addMonths.numMonths();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!addMonths.canEqual(this)) return false;
        return true;
    }

    public AddMonths(Expression startDate, Expression numMonths) {
        this.startDate = startDate;
        this.numMonths = numMonths;
        ExpectsInputTypes.$init$(this);
    }
}

