/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.encoders;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.SparkException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.analysis.GetColumnByOrdinal;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.GetStructField$;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.objects.AssertNotNull;
import org.apache.spark.sql.catalyst.expressions.objects.CreateExternalRow;
import org.apache.spark.sql.catalyst.expressions.objects.GetExternalRowField;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke$;
import org.apache.spark.sql.catalyst.expressions.objects.MapObjects;
import org.apache.spark.sql.catalyst.expressions.objects.MapObjects$;
import org.apache.spark.sql.catalyst.expressions.objects.NewInstance;
import org.apache.spark.sql.catalyst.expressions.objects.NewInstance$;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.catalyst.expressions.objects.ValidateExternalType;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.PythonUserDefinedType;
import org.apache.spark.sql.types.SQLUserDefinedType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UDTRegistration$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class RowEncoder$ {
    public static RowEncoder$ MODULE$;

    static {
        new RowEncoder$();
    }

    public ExpressionEncoder<Row> apply(StructType schema) {
        Class<Row> cls = Row.class;
        BoundReference inputObject = new BoundReference(0, new ObjectType(cls), true);
        Expression serializer = this.serializerFor(new AssertNotNull(inputObject, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"top level row object"})))), schema);
        Expression deserializer = this.deserializerFor(schema);
        return new ExpressionEncoder<Row>(schema, false, ((CreateNamedStruct)serializer).flatten(), deserializer, ClassTag$.MODULE$.apply(cls));
    }

    private Expression serializerFor(Expression inputObject, DataType inputType) {
        Expression expression;
        block20: {
            DataType dataType;
            while (true) {
                if (ScalaReflection$.MODULE$.isNativeType(dataType = inputType)) {
                    expression = inputObject;
                    break block20;
                }
                if (!(dataType instanceof PythonUserDefinedType)) break;
                PythonUserDefinedType pythonUserDefinedType = (PythonUserDefinedType)dataType;
                inputType = pythonUserDefinedType.sqlType();
            }
            if (dataType instanceof UserDefinedType) {
                NewInstance obj;
                UserDefinedType userDefinedType = (UserDefinedType)dataType;
                SQLUserDefinedType annotation = userDefinedType.userClass().getAnnotation(SQLUserDefinedType.class);
                Class udtClass = annotation != null ? annotation.udt() : (Class)UDTRegistration$.MODULE$.getUDTFor(userDefinedType.userClass().getName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new SparkException(new StringBuilder(79).append(userDefinedType.userClass().getName()).append(" is not annotated with ").append("SQLUserDefinedType nor registered with UDTRegistration.}").toString());
                });
                NewInstance x$20 = obj = NewInstance$.MODULE$.apply(udtClass, (Seq<Expression>)Nil$.MODULE$, new ObjectType(udtClass), false);
                String x$21 = "serialize";
                UserDefinedType x$22 = userDefinedType;
                Expression expression2 = inputObject;
                List x$23 = Nil$.MODULE$.$colon$colon((Object)expression2);
                boolean x$24 = false;
                boolean x$25 = Invoke$.MODULE$.apply$default$5();
                expression = new Invoke(x$20, x$21, x$22, (Seq<Expression>)x$23, x$25, x$24);
            } else if (TimestampType$.MODULE$.equals(dataType)) {
                Class<?> x$26 = DateTimeUtils$.MODULE$.getClass();
                TimestampType$ x$27 = TimestampType$.MODULE$;
                String x$28 = "fromJavaTimestamp";
                Expression expression3 = inputObject;
                List x$29 = Nil$.MODULE$.$colon$colon((Object)expression3);
                boolean x$30 = false;
                boolean x$31 = StaticInvoke$.MODULE$.apply$default$5();
                expression = new StaticInvoke(x$26, x$27, x$28, (Seq<Expression>)x$29, x$31, x$30);
            } else if (DateType$.MODULE$.equals(dataType)) {
                Class<?> x$32 = DateTimeUtils$.MODULE$.getClass();
                DateType$ x$33 = DateType$.MODULE$;
                String x$34 = "fromJavaDate";
                Expression expression4 = inputObject;
                List x$35 = Nil$.MODULE$.$colon$colon((Object)expression4);
                boolean x$36 = false;
                boolean x$37 = StaticInvoke$.MODULE$.apply$default$5();
                expression = new StaticInvoke(x$32, x$33, x$34, (Seq<Expression>)x$35, x$37, x$36);
            } else if (dataType instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)dataType;
                Class<?> x$38 = Decimal$.MODULE$.getClass();
                DecimalType x$39 = decimalType;
                String x$40 = "fromDecimal";
                Expression expression5 = inputObject;
                List x$41 = Nil$.MODULE$.$colon$colon((Object)expression5);
                boolean x$42 = false;
                boolean x$43 = StaticInvoke$.MODULE$.apply$default$5();
                expression = new StaticInvoke(x$38, x$39, x$40, (Seq<Expression>)x$41, x$43, x$42);
            } else if (StringType$.MODULE$.equals(dataType)) {
                Class<UTF8String> x$44 = UTF8String.class;
                StringType$ x$45 = StringType$.MODULE$;
                String x$46 = "fromString";
                Expression expression6 = inputObject;
                List x$47 = Nil$.MODULE$.$colon$colon((Object)expression6);
                boolean x$48 = false;
                boolean x$49 = StaticInvoke$.MODULE$.apply$default$5();
                expression = new StaticInvoke(x$44, x$45, x$46, (Seq<Expression>)x$47, x$49, x$48);
            } else if (dataType instanceof ArrayType) {
                Expression expression7;
                ArrayType arrayType = (ArrayType)dataType;
                DataType et = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                DataType dataType2 = et;
                boolean bl = BooleanType$.MODULE$.equals(dataType2) ? true : (ByteType$.MODULE$.equals(dataType2) ? true : (ShortType$.MODULE$.equals(dataType2) ? true : (IntegerType$.MODULE$.equals(dataType2) ? true : (LongType$.MODULE$.equals(dataType2) ? true : (FloatType$.MODULE$.equals(dataType2) ? true : DoubleType$.MODULE$.equals(dataType2))))));
                if (bl) {
                    Class<ArrayData> x$50 = ArrayData.class;
                    ArrayType x$51 = arrayType;
                    String x$52 = "toArrayData";
                    Expression expression8 = inputObject;
                    List x$53 = Nil$.MODULE$.$colon$colon((Object)expression8);
                    boolean x$54 = false;
                    boolean x$55 = StaticInvoke$.MODULE$.apply$default$5();
                    expression7 = new StaticInvoke(x$50, x$51, x$52, (Seq<Expression>)x$53, x$55, x$54);
                } else {
                    expression7 = MapObjects$.MODULE$.apply((Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)element -> {
                        void var3_3;
                        Expression value = MODULE$.serializerFor(new ValidateExternalType((Expression)element, et), et);
                        return !containsNull ? new AssertNotNull(value, (Seq<String>)((Seq)Seq$.MODULE$.empty())) : var3_3;
                    }, inputObject, new ObjectType(Object.class), MapObjects$.MODULE$.apply$default$4(), MapObjects$.MODULE$.apply$default$5());
                }
                expression = expression7;
            } else if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType kt = mapType.keyType();
                DataType vt = mapType.valueType();
                boolean valueNullable = mapType.valueContainsNull();
                Expression x$56 = inputObject;
                String x$57 = "keysIterator";
                ObjectType x$58 = new ObjectType(Iterator.class);
                boolean x$59 = false;
                Seq<Expression> x$60 = Invoke$.MODULE$.apply$default$4();
                boolean x$61 = Invoke$.MODULE$.apply$default$5();
                Invoke x$62 = new Invoke(x$56, x$57, x$58, x$60, x$61, x$59);
                String x$63 = "toSeq";
                ObjectType x$64 = new ObjectType(Seq.class);
                boolean x$65 = false;
                Seq<Expression> x$66 = Invoke$.MODULE$.apply$default$4();
                boolean x$67 = Invoke$.MODULE$.apply$default$5();
                Invoke keys = new Invoke(x$62, x$63, x$64, x$66, x$67, x$65);
                Expression convertedKeys = this.serializerFor(keys, new ArrayType(kt, false));
                Expression x$68 = inputObject;
                String x$69 = "valuesIterator";
                ObjectType x$70 = new ObjectType(Iterator.class);
                boolean x$71 = false;
                Seq<Expression> x$72 = Invoke$.MODULE$.apply$default$4();
                boolean x$73 = Invoke$.MODULE$.apply$default$5();
                Invoke x$74 = new Invoke(x$68, x$69, x$70, x$72, x$73, x$71);
                String x$75 = "toSeq";
                ObjectType x$76 = new ObjectType(Seq.class);
                boolean x$77 = false;
                Seq<Expression> x$78 = Invoke$.MODULE$.apply$default$4();
                boolean x$79 = Invoke$.MODULE$.apply$default$5();
                Invoke values = new Invoke(x$74, x$75, x$76, x$78, x$79, x$77);
                Expression convertedValues = this.serializerFor(values, new ArrayType(vt, valueNullable));
                Expression expression9 = convertedKeys;
                Expression expression10 = convertedValues;
                NewInstance nonNullOutput = NewInstance$.MODULE$.apply(ArrayBasedMapData.class, (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)expression10).$colon$colon((Object)expression9), mapType, false);
                expression = inputObject.nullable() ? new If(new IsNull(inputObject), Literal$.MODULE$.create(null, inputType), nonNullOutput) : nonNullOutput;
            } else if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fields = structType.fields();
                CreateNamedStruct nonNullOutput = new CreateNamedStruct((Seq<Expression>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Expression expression;
                    StructField field;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        field = (StructField)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        Expression fieldValue = MODULE$.serializerFor(new ValidateExternalType(new GetExternalRowField(inputObject, index, field.name()), field.dataType()), field.dataType());
                        if (field.nullable()) {
                            Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)index));
                            If if_ = new If(new Invoke(inputObject, "isNullAt", BooleanType$.MODULE$, (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)literal), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6()), Literal$.MODULE$.create(null, field.dataType()), fieldValue);
                            expression = if_;
                        } else {
                            expression = fieldValue;
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Expression convertedField = expression;
                    Literal literal = Literal$.MODULE$.apply(field.name());
                    Expression expression2 = convertedField;
                    List list = Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)literal);
                    return list;
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
                expression = inputObject.nullable() ? new If(new IsNull(inputObject), Literal$.MODULE$.create(null, inputType), nonNullOutput) : nonNullOutput;
            } else {
                throw new MatchError((Object)dataType);
            }
        }
        return expression;
    }

    public DataType externalDataTypeForInput(DataType dt) {
        DataType dataType = dt;
        DataType dataType2 = dataType instanceof DecimalType ? new ObjectType(Object.class) : (dataType instanceof ArrayType ? new ObjectType(Object.class) : this.externalDataTypeFor(dt));
        return dataType2;
    }

    public DataType externalDataTypeFor(DataType dt) {
        DataType dataType;
        block11: {
            DataType dataType2;
            while (true) {
                dataType2 = dt;
                if (ScalaReflection$.MODULE$.isNativeType(dt)) {
                    dataType = dt;
                    break block11;
                }
                if (TimestampType$.MODULE$.equals(dataType2)) {
                    dataType = new ObjectType(Timestamp.class);
                    break block11;
                }
                if (DateType$.MODULE$.equals(dataType2)) {
                    dataType = new ObjectType(Date.class);
                    break block11;
                }
                if (dataType2 instanceof DecimalType) {
                    dataType = new ObjectType(BigDecimal.class);
                    break block11;
                }
                if (StringType$.MODULE$.equals(dataType2)) {
                    dataType = new ObjectType(String.class);
                    break block11;
                }
                if (dataType2 instanceof ArrayType) {
                    dataType = new ObjectType(Seq.class);
                    break block11;
                }
                if (dataType2 instanceof MapType) {
                    dataType = new ObjectType(Map.class);
                    break block11;
                }
                if (dataType2 instanceof StructType) {
                    dataType = new ObjectType(Row.class);
                    break block11;
                }
                if (!(dataType2 instanceof PythonUserDefinedType)) break;
                PythonUserDefinedType pythonUserDefinedType = (PythonUserDefinedType)dataType2;
                dt = pythonUserDefinedType.sqlType();
            }
            if (dataType2 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                dataType = new ObjectType(userDefinedType.userClass());
            } else {
                throw new MatchError((Object)dataType2);
            }
        }
        return dataType;
    }

    private Expression deserializerFor(StructType schema) {
        Seq fields = (Seq)((TraversableLike)schema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            DataType dataType;
            int i;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                StructField f = (StructField)tuple2._1();
                i = tuple2._2$mcI$sp();
                DataType dataType2 = f.dataType();
                if (dataType2 instanceof PythonUserDefinedType) {
                    PythonUserDefinedType pythonUserDefinedType = (PythonUserDefinedType)dataType2;
                    dataType = pythonUserDefinedType.sqlType();
                } else {
                    dataType = dataType2;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            DataType dt = dataType;
            Expression expression = MODULE$.deserializerFor(new GetColumnByOrdinal(i, dt));
            return expression;
        }, Seq$.MODULE$.canBuildFrom());
        return new CreateExternalRow((Seq<Expression>)fields, schema);
    }

    private Expression deserializerFor(Expression input) {
        return this.deserializerFor(input, input.dataType());
    }

    private Expression deserializerFor(Expression input, DataType dataType) {
        Expression expression;
        block18: {
            DataType dataType2;
            while (true) {
                if (ScalaReflection$.MODULE$.isNativeType(dataType2 = dataType)) {
                    expression = input;
                    break block18;
                }
                if (!(dataType2 instanceof PythonUserDefinedType)) break;
                PythonUserDefinedType pythonUserDefinedType = (PythonUserDefinedType)dataType2;
                dataType = pythonUserDefinedType.sqlType();
            }
            if (dataType2 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                SQLUserDefinedType annotation = userDefinedType.userClass().getAnnotation(SQLUserDefinedType.class);
                Class udtClass = annotation != null ? annotation.udt() : (Class)UDTRegistration$.MODULE$.getUDTFor(userDefinedType.userClass().getName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new SparkException(new StringBuilder(79).append(userDefinedType.userClass().getName()).append(" is not annotated with ").append("SQLUserDefinedType nor registered with UDTRegistration.}").toString());
                });
                NewInstance obj = NewInstance$.MODULE$.apply(udtClass, (Seq<Expression>)Nil$.MODULE$, new ObjectType(udtClass), NewInstance$.MODULE$.apply$default$4());
                Expression expression2 = input;
                expression = new Invoke(obj, "deserialize", new ObjectType(userDefinedType.userClass()), (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)expression2), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6());
            } else if (TimestampType$.MODULE$.equals(dataType2)) {
                Class<?> x$80 = DateTimeUtils$.MODULE$.getClass();
                ObjectType x$81 = new ObjectType(Timestamp.class);
                String x$82 = "toJavaTimestamp";
                Expression expression3 = input;
                List x$83 = Nil$.MODULE$.$colon$colon((Object)expression3);
                boolean x$84 = false;
                boolean x$85 = StaticInvoke$.MODULE$.apply$default$5();
                expression = new StaticInvoke(x$80, x$81, x$82, (Seq<Expression>)x$83, x$85, x$84);
            } else if (DateType$.MODULE$.equals(dataType2)) {
                Class<?> x$86 = DateTimeUtils$.MODULE$.getClass();
                ObjectType x$87 = new ObjectType(Date.class);
                String x$88 = "toJavaDate";
                Expression expression4 = input;
                List x$89 = Nil$.MODULE$.$colon$colon((Object)expression4);
                boolean x$90 = false;
                boolean x$91 = StaticInvoke$.MODULE$.apply$default$5();
                expression = new StaticInvoke(x$86, x$87, x$88, (Seq<Expression>)x$89, x$91, x$90);
            } else if (dataType2 instanceof DecimalType) {
                Expression x$92 = input;
                String x$93 = "toJavaBigDecimal";
                ObjectType x$94 = new ObjectType(BigDecimal.class);
                boolean x$95 = false;
                Seq<Expression> x$96 = Invoke$.MODULE$.apply$default$4();
                boolean x$97 = Invoke$.MODULE$.apply$default$5();
                expression = new Invoke(x$92, x$93, x$94, x$96, x$97, x$95);
            } else if (StringType$.MODULE$.equals(dataType2)) {
                Expression x$98 = input;
                String x$99 = "toString";
                ObjectType x$100 = new ObjectType(String.class);
                boolean x$101 = false;
                Seq<Expression> x$102 = Invoke$.MODULE$.apply$default$4();
                boolean x$103 = Invoke$.MODULE$.apply$default$5();
                expression = new Invoke(x$98, x$99, x$100, x$102, x$103, x$101);
            } else if (dataType2 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType2;
                DataType et = arrayType.elementType();
                MapObjects x$104 = MapObjects$.MODULE$.apply((Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x$15 -> MODULE$.deserializerFor((Expression)x$15), input, et, MapObjects$.MODULE$.apply$default$4(), MapObjects$.MODULE$.apply$default$5());
                String x$105 = "array";
                ObjectType x$106 = new ObjectType(Object.class);
                boolean x$107 = false;
                Seq<Expression> x$108 = Invoke$.MODULE$.apply$default$4();
                boolean x$109 = Invoke$.MODULE$.apply$default$5();
                Invoke arrayData = new Invoke(x$104, x$105, x$106, x$108, x$109, x$107);
                Class x$110 = WrappedArray$.MODULE$.getClass();
                ObjectType x$111 = new ObjectType(Seq.class);
                String x$112 = "make";
                Invoke invoke = arrayData;
                List x$113 = Nil$.MODULE$.$colon$colon((Object)invoke);
                boolean x$114 = false;
                boolean x$115 = StaticInvoke$.MODULE$.apply$default$5();
                expression = new StaticInvoke(x$110, x$111, x$112, (Seq<Expression>)x$113, x$115, x$114);
            } else if (dataType2 instanceof MapType) {
                MapType mapType = (MapType)dataType2;
                DataType kt = mapType.keyType();
                DataType vt = mapType.valueType();
                boolean valueNullable = mapType.valueContainsNull();
                ArrayType keyArrayType = new ArrayType(kt, false);
                Expression keyData = this.deserializerFor(new Invoke(input, "keyArray", keyArrayType, Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6()));
                ArrayType valueArrayType = new ArrayType(vt, valueNullable);
                Expression valueData = this.deserializerFor(new Invoke(input, "valueArray", valueArrayType, Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6()));
                Class<?> x$116 = ArrayBasedMapData$.MODULE$.getClass();
                ObjectType x$117 = new ObjectType(Map.class);
                String x$118 = "toScalaMap";
                Expression expression5 = keyData;
                Expression expression6 = valueData;
                List x$119 = Nil$.MODULE$.$colon$colon((Object)expression6).$colon$colon((Object)expression5);
                boolean x$120 = false;
                boolean x$121 = StaticInvoke$.MODULE$.apply$default$5();
                expression = new StaticInvoke(x$116, x$117, x$118, (Seq<Expression>)x$119, x$121, x$120);
            } else if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                StructField[] fields = structType.fields();
                If[] convertedFields = (If[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    StructField f = (StructField)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)i));
                    If if_ = new If(new Invoke(input, "isNullAt", BooleanType$.MODULE$, (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)literal), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6()), Literal$.MODULE$.create(null, MODULE$.externalDataTypeFor(f.dataType())), MODULE$.deserializerFor(new GetStructField(input, i, GetStructField$.MODULE$.apply$default$3())));
                    return if_;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(If.class)));
                expression = new If(new IsNull(input), Literal$.MODULE$.create(null, this.externalDataTypeFor(input.dataType())), new CreateExternalRow((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])convertedFields), structType));
            } else {
                throw new MatchError((Object)dataType2);
            }
        }
        return expression;
    }

    private RowEncoder$() {
        MODULE$ = this;
    }
}

