/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.HigherOrderFunction$class;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.ZipWith$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback$class;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(left, right, func) - Merges the two given arrays, element-wise, into a single array using function. If one array is shorter, nulls are appended at the end to match the length of the longer array, before applying function.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array('a', 'b', 'c'), (x, y) -> (y, x));\n       [{\"y\":\"a\",\"x\":1},{\"y\":\"b\",\"x\":2},{\"y\":\"c\",\"x\":3}]\n      > SELECT _FUNC_(array(1, 2), array(3, 4), (x, y) -> x + y);\n       [4,6]\n      > SELECT _FUNC_(array('a', 'b', 'c'), array('d', 'e', 'f'), (x, y) -> concat(x, y));\n       [\"ad\",\"be\",\"cf\"]\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0015b\u0001B\u0001\u0003\u0001>\u0011qAW5q/&$\bN\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0001\u0003F\f\u001eGA\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\t\u0016\u0013\t1\"AA\nIS\u001eDWM](sI\u0016\u0014h)\u001e8di&|g\u000e\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\u0005\u000591m\u001c3fO\u0016t\u0017B\u0001\u000f\u001a\u0005=\u0019u\u000eZ3hK:4\u0015\r\u001c7cC\u000e\\\u0007C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"a\u0002)s_\u0012,8\r\u001e\t\u0003=\u0011J!!J\u0010\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011\u001d\u0002!Q3A\u0005\u0002!\nA\u0001\\3giV\t\u0001\u0003\u0003\u0005+\u0001\tE\t\u0015!\u0003\u0011\u0003\u0015aWM\u001a;!\u0011!a\u0003A!f\u0001\n\u0003A\u0013!\u0002:jO\"$\b\u0002\u0003\u0018\u0001\u0005#\u0005\u000b\u0011\u0002\t\u0002\rILw\r\u001b;!\u0011!\u0001\u0004A!f\u0001\n\u0003A\u0013\u0001\u00034v]\u000e$\u0018n\u001c8\t\u0011I\u0002!\u0011#Q\u0001\nA\t\u0011BZ;oGRLwN\u001c\u0011\t\u000bQ\u0002A\u0011A\u001b\u0002\rqJg.\u001b;?)\u00111t\u0007O\u001d\u0011\u0005E\u0001\u0001\"B\u00144\u0001\u0004\u0001\u0002\"\u0002\u00174\u0001\u0004\u0001\u0002\"\u0002\u00194\u0001\u0004\u0001\u0002\"B\u001e\u0001\t\u0003A\u0013a\u00044v]\u000e$\u0018n\u001c8G_J,e/\u00197\t\u000bu\u0002A\u0011\t \u0002\u0013\u0005\u0014x-^7f]R\u001cX#A \u0011\u0007\u0001C\u0005C\u0004\u0002B\r:\u0011!)R\u0007\u0002\u0007*\u0011AID\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001J!aR\u0010\u0002\u000fA\f7m[1hK&\u0011\u0011J\u0013\u0002\u0004'\u0016\f(BA$ \u0011\u0015a\u0005\u0001\"\u0011N\u00035\t'oZ;nK:$H+\u001f9fgV\ta\nE\u0002A\u0011>\u0003\"\u0001U*\u000e\u0003ES!A\u0015\u0004\u0002\u000bQL\b/Z:\n\u0005Q\u000b&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u00151\u0006\u0001\"\u0011?\u0003%1WO\\2uS>t7\u000fC\u0003Y\u0001\u0011\u0005S*A\u0007gk:\u001cG/[8o)f\u0004Xm\u001d\u0005\u00065\u0002!\teW\u0001\tI\u0006$\u0018\rV=qKV\tA\f\u0005\u0002Q;&\u0011a,\u0015\u0002\n\u0003J\u0014\u0018-\u001f+za\u0016DQ\u0001\u0019\u0001\u0005B\u0005\fAAY5oIR\u0011aG\u0019\u0005\u0006G~\u0003\r\u0001Z\u0001\u0002MB)a$\u001a\thc&\u0011am\b\u0002\n\rVt7\r^5p]J\u00022\u0001\u0011%i!\u0011q\u0012n\u001b8\n\u0005)|\"A\u0002+va2,'\u0007\u0005\u0002QY&\u0011Q.\u0015\u0002\t\t\u0006$\u0018\rV=qKB\u0011ad\\\u0005\u0003a~\u0011qAQ8pY\u0016\fg\u000e\u0005\u0002\u0012e&\u00111O\u0001\u0002\u000f\u0019\u0006l'\rZ1Gk:\u001cG/[8o\u0011))\b\u0001%A\t\b\u0004&IA^\u0001\u0005q\u0012\"\u0004'F\u0001x!\u0011q\u0012\u000e\u001f=\u0011\u0005EI\u0018B\u0001>\u0003\u0005Mq\u0015-\\3e\u0019\u0006l'\rZ1WCJL\u0017M\u00197f\u0011!a\b\u0001#A!B\u00139\u0018!\u0002=%iA\u0002\u0003\u0002\u0003@\u0001\u0011\u000b\u0007I\u0011A@\u0002\u00171,g\r^#mK64\u0016M]\u000b\u0002q\"I\u00111\u0001\u0001\t\u0002\u0003\u0006K\u0001_\u0001\rY\u00164G/\u00127f[Z\u000b'\u000f\t\u0015\u0005\u0003\u0003\t9\u0001E\u0002\u001f\u0003\u0013I1!a\u0003 \u0005%!(/\u00198tS\u0016tG\u000fC\u0005\u0002\u0010\u0001A)\u0019!C\u0001\u007f\u0006a!/[4ii\u0016cW-\u001c,be\"I\u00111\u0003\u0001\t\u0002\u0003\u0006K\u0001_\u0001\u000ee&<\u0007\u000e^#mK64\u0016M\u001d\u0011)\t\u0005E\u0011q\u0001\u0005\b\u00033\u0001A\u0011IA\u000e\u0003\u0011)g/\u00197\u0015\t\u0005u\u00111\u0005\t\u0004=\u0005}\u0011bAA\u0011?\t\u0019\u0011I\\=\t\u0015\u0005\u0015\u0012q\u0003I\u0001\u0002\u0004\t9#A\u0003j]B,H\u000f\u0005\u0003\u0002*\u0005-R\"\u0001\u0003\n\u0007\u00055BAA\u0006J]R,'O\\1m%><\bbBA\u0019\u0001\u0011\u0005\u00131G\u0001\u000baJ,G\u000f^=OC6,WCAA\u001b!\u0011\t9$!\u0010\u000f\u0007y\tI$C\u0002\u0002<}\ta\u0001\u0015:fI\u00164\u0017\u0002BA \u0003\u0003\u0012aa\u0015;sS:<'bAA\u001e?!I\u0011Q\t\u0001\u0002\u0002\u0013\u0005\u0011qI\u0001\u0005G>\u0004\u0018\u0010F\u00047\u0003\u0013\nY%!\u0014\t\u0011\u001d\n\u0019\u0005%AA\u0002AA\u0001\u0002LA\"!\u0003\u0005\r\u0001\u0005\u0005\ta\u0005\r\u0003\u0013!a\u0001!!I\u0011\u0011\u000b\u0001\u0012\u0002\u0013\u0005\u00111K\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)FK\u0002\u0011\u0003/Z#!!\u0017\u0011\t\u0005m\u0013QM\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Gz\u0012AC1o]>$\u0018\r^5p]&!\u0011qMA/\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003W\u0002\u0011\u0013!C\u0001\u0003'\nabY8qs\u0012\"WMZ1vYR$#\u0007C\u0005\u0002p\u0001\t\n\u0011\"\u0001\u0002T\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0004\"CA:\u0001\u0005\u0005I\u0011IA;\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u000f\t\u0005\u0003s\n\u0019)\u0004\u0002\u0002|)!\u0011QPA@\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0015\u0001\u00026bm\u0006LA!a\u0010\u0002|!I\u0011q\u0011\u0001\u0002\u0002\u0013\u0005\u0011\u0011R\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u0017\u00032AHAG\u0013\r\tyi\b\u0002\u0004\u0013:$\b\"CAJ\u0001\u0005\u0005I\u0011AAK\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\b\u0002\u0018\"Q\u0011\u0011TAI\u0003\u0003\u0005\r!a#\u0002\u0007a$\u0013\u0007C\u0005\u0002\u001e\u0002\t\t\u0011\"\u0011\u0002 \u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\"B1\u00111UAU\u0003;i!!!*\u000b\u0007\u0005\u001dv$\u0001\u0006d_2dWm\u0019;j_:LA!a+\u0002&\nA\u0011\n^3sCR|'\u000fC\u0005\u00020\u0002\t\t\u0011\"\u0001\u00022\u0006A1-\u00198FcV\fG\u000eF\u0002o\u0003gC!\"!'\u0002.\u0006\u0005\t\u0019AA\u000f\u0011%\t9\fAA\u0001\n\u0003\nI,\u0001\u0004fcV\fGn\u001d\u000b\u0004]\u0006m\u0006BCAM\u0003k\u000b\t\u00111\u0001\u0002\u001e!z\u0001!a0\u0002F\u0006\u001d\u00171ZAg\u0003#\f\u0019\u000eE\u0002\u0012\u0003\u0003L1!a1\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!3\u0002\u0003\u0013|f)\u0016(D?\"bWM\u001a;-AILw\r\u001b;-A\u0019,hnY\u0015![\u0001jUM]4fg\u0002\"\b.\u001a\u0011uo>\u0004s-\u001b<f]\u0002\n'O]1zg2\u0002S\r\\3nK:$Xf^5tK2\u0002\u0013N\u001c;pA\u0005\u00043/\u001b8hY\u0016\u0004\u0013M\u001d:bs\u0002*8/\u001b8hA\u0019,hn\u0019;j_:t\u0003%\u00134!_:,\u0007%\u0019:sCf\u0004\u0013n\u001d\u0011tQ>\u0014H/\u001a:-A9,H\u000e\\:!CJ,\u0007%\u00199qK:$W\r\u001a\u0011bi\u0002\"\b.\u001a\u0011f]\u0012\u0004Co\u001c\u0011nCR\u001c\u0007\u000e\t;iK\u0002bWM\\4uQ\u0002zg\r\t;iK\u0002bwN\\4fe\u0002\n'O]1zY\u0001\u0012WMZ8sK\u0002\n\u0007\u000f\u001d7zS:<\u0007EZ;oGRLwN\u001c\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a4\u0002\u0005oS\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD\u0013\u0007\f\u00113Y\u0001\u001a\u0014\u0006\f\u0011beJ\f\u0017\u0010K\u0014bO1\u0002sEY\u0014-A\u001d\u001aw%\u000b\u0017!Qad\u0003%_\u0015![y\u0002\u0003&\u001f\u0017!q&J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.|Ee\u0014#HI1#Y\tB(EO\u0019~Ym\u0014\u0013P\t\u001e#E\nb#\u0005\u001f\u0012;eud3PI=#u\t\u001a'\u0005\f\u0012yEi\u001aT0\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00152Y\u0001\u0012\u0014\u0006\f\u0011beJ\f\u0017\u0010K\u001a-AQJC\u0006\t\u0015yY\u0001J\u0018\u0006I\u0017?Aa\u00043\u0006I=*w)\u0001\u0003\u0005\t\u0011!A\u0001ZF\u0007\f\u001c^\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQ\u001d\nw\u0005\f\u0011(E\u001eb\u0003eJ2(S1\u0002\u0013M\u001d:bs\":Cm\n\u0017!O\u0015<C\u0006I\u0014gO%b\u0003\u0005\u000b=-AeL\u0003%\f !G>t7-\u0019;)q2\u0002\u00130K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0013\u0013\r\u001a\u0012-E\t,'\u0005\f\u0012dM\nj&\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005U\u0017!\u0002\u001a/i9\u0002t!CAm\u0005\u0005\u0005\t\u0012AAn\u0003\u001dQ\u0016\u000e],ji\"\u00042!EAo\r!\t!!!A\t\u0002\u0005}7#BAo\u0003C\u001c\u0003\u0003CAr\u0003S\u0004\u0002\u0003\u0005\u001c\u000e\u0005\u0005\u0015(bAAt?\u00059!/\u001e8uS6,\u0017\u0002BAv\u0003K\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84\u0011\u001d!\u0014Q\u001cC\u0001\u0003_$\"!a7\t\u0015\u0005M\u0018Q\\A\u0001\n\u000b\n)0\u0001\u0005u_N#(/\u001b8h)\t\t9\b\u0003\u0006\u0002z\u0006u\u0017\u0011!CA\u0003w\fQ!\u00199qYf$rANA\u007f\u0003\u007f\u0014\t\u0001\u0003\u0004(\u0003o\u0004\r\u0001\u0005\u0005\u0007Y\u0005]\b\u0019\u0001\t\t\rA\n9\u00101\u0001\u0011\u0011)\u0011)!!8\u0002\u0002\u0013\u0005%qA\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011IA!\u0006\u0011\u000by\u0011YAa\u0004\n\u0007\t5qD\u0001\u0004PaRLwN\u001c\t\u0007=\tE\u0001\u0003\u0005\t\n\u0007\tMqD\u0001\u0004UkBdWm\r\u0005\n\u0005/\u0011\u0019!!AA\u0002Y\n1\u0001\u001f\u00131\u0011)\u0011Y\"!8\u0002\u0002\u0013%!QD\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003 A!\u0011\u0011\u0010B\u0011\u0013\u0011\u0011\u0019#a\u001f\u0003\r=\u0013'.Z2u\u0001")
public class ZipWith
extends Expression
implements HigherOrderFunction,
CodegenFallback,
Serializable {
    private final Expression left;
    private final Expression right;
    private final Expression function;
    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$40;
    private transient NamedLambdaVariable leftElemVar;
    private transient NamedLambdaVariable rightElemVar;
    private final boolean argumentsResolved;
    private final boolean resolved;
    private final transient Seq<Expression> functionsForEval;
    private volatile byte bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(ZipWith zipWith) {
        return ZipWith$.MODULE$.unapply(zipWith);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, ZipWith> tupled() {
        return ZipWith$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, ZipWith>>> curried() {
        return ZipWith$.MODULE$.curried();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2 x$40$lzycompute() {
        ZipWith zipWith = this;
        synchronized (zipWith) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Tuple2 tuple2;
                LambdaFunction lambdaFunction;
                Seq<NamedExpression> seq;
                Some some;
                Expression expression = this.function();
                if (!(expression instanceof LambdaFunction) || (some = Seq$.MODULE$.unapplySeq(seq = (lambdaFunction = (LambdaFunction)expression).arguments())).isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) throw new MatchError((Object)expression);
                NamedExpression leftElemVar = (NamedExpression)((SeqLike)some.get()).apply(0);
                NamedExpression rightElemVar = (NamedExpression)((SeqLike)some.get()).apply(1);
                if (!(leftElemVar instanceof NamedLambdaVariable)) throw new MatchError((Object)expression);
                NamedLambdaVariable namedLambdaVariable = (NamedLambdaVariable)leftElemVar;
                if (!(rightElemVar instanceof NamedLambdaVariable)) throw new MatchError((Object)expression);
                NamedLambdaVariable namedLambdaVariable2 = (NamedLambdaVariable)rightElemVar;
                this.x$40 = tuple2 = new Tuple2((Object)namedLambdaVariable, (Object)namedLambdaVariable2);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.x$40;
        }
    }

    private NamedLambdaVariable leftElemVar$lzycompute() {
        ZipWith zipWith = this;
        synchronized (zipWith) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.leftElemVar = (NamedLambdaVariable)this.x$40()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.leftElemVar;
        }
    }

    private NamedLambdaVariable rightElemVar$lzycompute() {
        ZipWith zipWith = this;
        synchronized (zipWith) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.rightElemVar = (NamedLambdaVariable)this.x$40()._2();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.rightElemVar;
        }
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback$class.doGenCode(this, ctx, ev);
    }

    private boolean argumentsResolved$lzycompute() {
        ZipWith zipWith = this;
        synchronized (zipWith) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.argumentsResolved = HigherOrderFunction$class.argumentsResolved(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.argumentsResolved;
        }
    }

    @Override
    public boolean argumentsResolved() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.argumentsResolved$lzycompute() : this.argumentsResolved;
    }

    private boolean resolved$lzycompute() {
        ZipWith zipWith = this;
        synchronized (zipWith) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.resolved = HigherOrderFunction$class.resolved(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.resolved;
        }
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private Seq functionsForEval$lzycompute() {
        ZipWith zipWith = this;
        synchronized (zipWith) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.functionsForEval = HigherOrderFunction$class.functionsForEval(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.functionsForEval;
        }
    }

    @Override
    public Seq<Expression> functionsForEval() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.functionsForEval$lzycompute() : this.functionsForEval;
    }

    @Override
    public boolean nullable() {
        return HigherOrderFunction$class.nullable(this);
    }

    @Override
    public Seq<Expression> children() {
        return HigherOrderFunction$class.children(this);
    }

    @Override
    public TypeCheckResult checkArgumentDataTypes() {
        return HigherOrderFunction$class.checkArgumentDataTypes(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return HigherOrderFunction$class.inputTypes(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    public Expression function() {
        return this.function;
    }

    public Expression functionForEval() {
        return (Expression)this.functionsForEval().head();
    }

    @Override
    public Seq<Expression> arguments() {
        Expression expression = this.left();
        Expression expression2 = this.right();
        return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> argumentTypes() {
        ArrayType$ arrayType$ = ArrayType$.MODULE$;
        ArrayType$ arrayType$2 = ArrayType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)arrayType$2).$colon$colon((Object)arrayType$);
    }

    @Override
    public Seq<Expression> functions() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.function()}));
    }

    @Override
    public Seq<AbstractDataType> functionTypes() {
        AnyDataType$ anyDataType$ = AnyDataType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)anyDataType$);
    }

    @Override
    public ArrayType dataType() {
        return new ArrayType(this.function().dataType(), this.function().nullable());
    }

    @Override
    public ZipWith bind(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        DataType dataType2 = this.left().dataType();
        if (dataType2 instanceof ArrayType) {
            DataType leftElementType;
            DataType dataType3;
            ArrayType arrayType2 = (ArrayType)dataType2;
            DataType leftElementType2 = dataType3 = (leftElementType = arrayType2.elementType());
            DataType dataType4 = this.right().dataType();
            if (dataType4 instanceof ArrayType) {
                DataType rightElementType;
                DataType dataType5;
                ArrayType arrayType3 = (ArrayType)dataType4;
                DataType rightElementType2 = dataType5 = (rightElementType = arrayType3.elementType());
                Tuple2 tuple2 = new Tuple2((Object)leftElementType2, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                Tuple2 tuple22 = new Tuple2((Object)rightElementType2, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                LambdaFunction x$58 = (LambdaFunction)f.apply((Object)this.function(), (Object)Nil$.MODULE$.$colon$colon((Object)tuple22).$colon$colon((Object)tuple2));
                Expression x$59 = this.copy$default$1();
                Expression x$60 = this.copy$default$2();
                return this.copy(x$59, x$60, x$58);
            }
            throw new MatchError((Object)dataType4);
        }
        throw new MatchError((Object)dataType2);
    }

    private /* synthetic */ Tuple2 x$40() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$40$lzycompute() : this.x$40;
    }

    public NamedLambdaVariable leftElemVar() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.leftElemVar$lzycompute() : this.leftElemVar;
    }

    public NamedLambdaVariable rightElemVar() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.rightElemVar$lzycompute() : this.rightElemVar;
    }

    @Override
    public Object eval(InternalRow input) {
        GenericArrayData genericArrayData;
        ArrayData leftArr = (ArrayData)this.left().eval(input);
        if (leftArr == null) {
            genericArrayData = null;
        } else {
            ArrayData rightArr = (ArrayData)this.right().eval(input);
            if (rightArr == null) {
                genericArrayData = null;
            } else {
                int resultLength = package$.MODULE$.max(leftArr.numElements(), rightArr.numElements());
                Expression f = this.functionForEval();
                GenericArrayData result = new GenericArrayData(new Object[resultLength]);
                for (int i = 0; i < resultLength; ++i) {
                    if (i < leftArr.numElements()) {
                        this.leftElemVar().value().set(leftArr.get(i, this.leftElemVar().dataType()));
                    } else {
                        this.leftElemVar().value().set(null);
                    }
                    if (i < rightArr.numElements()) {
                        this.rightElemVar().value().set(rightArr.get(i, this.rightElemVar().dataType()));
                    } else {
                        this.rightElemVar().value().set(null);
                    }
                    result.update(i, f.eval(input));
                }
                genericArrayData = result;
            }
        }
        return genericArrayData;
    }

    @Override
    public String prettyName() {
        return "zip_with";
    }

    public ZipWith copy(Expression left, Expression right, Expression function) {
        return new ZipWith(left, right, function);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Expression copy$default$3() {
        return this.function();
    }

    @Override
    public String productPrefix() {
        return "ZipWith";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                expression = this.function();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ZipWith;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ZipWith)) return false;
        boolean bl = true;
        if (!bl) return false;
        ZipWith zipWith = (ZipWith)x$1;
        Expression expression = this.left();
        Expression expression2 = zipWith.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = zipWith.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.function();
        Expression expression6 = zipWith.function();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!zipWith.canEqual(this)) return false;
        return true;
    }

    public ZipWith(Expression left, Expression right, Expression function) {
        this.left = left;
        this.right = right;
        this.function = function;
        ExpectsInputTypes$class.$init$(this);
        HigherOrderFunction$class.$init$(this);
        CodegenFallback$class.$init$(this);
    }
}

