/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayRemove$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(array, element) - Remove all elements that equal to element from array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, null, 3), 3);\n       [1,2,null]\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0001\u0003\u0001>\u00111\"\u0011:sCf\u0014V-\\8wK*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!Q9R\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#UI!A\u0006\u0002\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0019=%\u0011q$\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tC\u0001\u0011)\u001a!C\u0001E\u0005!A.\u001a4u+\u0005\u0019\u0003CA\t%\u0013\t)#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001b\n\u0001\u0003\u0012\u0003\u0006IaI\u0001\u0006Y\u00164G\u000f\t\u0005\tS\u0001\u0011)\u001a!C\u0001E\u0005)!/[4ii\"A1\u0006\u0001B\tB\u0003%1%\u0001\u0004sS\u001eDG\u000f\t\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007=\u0002\u0014\u0007\u0005\u0002\u0012\u0001!)\u0011\u0005\fa\u0001G!)\u0011\u0006\fa\u0001G!)1\u0007\u0001C!i\u0005AA-\u0019;b)f\u0004X-F\u00016!\t1\u0014(D\u00018\u0015\tAd!A\u0003usB,7/\u0003\u0002;o\tAA)\u0019;b)f\u0004X\rC\u0003=\u0001\u0011\u0005S(\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u0010\t\u0004\u007f\u001dSeB\u0001!F\u001d\t\tE)D\u0001C\u0015\t\u0019e\"\u0001\u0004=e>|GOP\u0005\u00025%\u0011a)G\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0015JA\u0002TKFT!AR\r\u0011\u0005YZ\u0015B\u0001'8\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X\rC\u0003O\u0001\u0011\u0005s*A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u0001Q!\t\tF+D\u0001S\u0015\t\u0019F!\u0001\u0005b]\u0006d\u0017p]5t\u0013\t)&KA\bUsB,7\t[3dWJ+7/\u001e7u\u0011\u00159\u0006\u0001\"\u00035\u0003-)G.Z7f]R$\u0016\u0010]3\t\u0011e\u0003\u0001R1A\u0005\ni\u000b\u0001b\u001c:eKJLgnZ\u000b\u00027B\u0019q\b\u00180\n\u0005uK%\u0001C(sI\u0016\u0014\u0018N\\4\u0011\u0005ay\u0016B\u00011\u001a\u0005\r\te.\u001f\u0005\tE\u0002A\t\u0011)Q\u00057\u0006IqN\u001d3fe&tw\r\t\u0015\u0003C\u0012\u0004\"\u0001G3\n\u0005\u0019L\"!\u0003;sC:\u001c\u0018.\u001a8u\u0011\u0015A\u0007\u0001\"\u0011j\u00031qW\u000f\u001c7TC\u001a,WI^1m)\rq&\u000e\u001c\u0005\u0006W\u001e\u0004\rAX\u0001\u0004CJ\u0014\b\"B7h\u0001\u0004q\u0016!\u0002<bYV,\u0007\"B8\u0001\t\u0003\u0002\u0018!\u00033p\u000f\u0016t7i\u001c3f)\r\tx\u000f \t\u0003eVl\u0011a\u001d\u0006\u0003i\n\tqaY8eK\u001e,g.\u0003\u0002wg\nAQ\t\u001f9s\u0007>$W\rC\u0003y]\u0002\u0007\u00110A\u0002dib\u0004\"A\u001d>\n\u0005m\u001c(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006{:\u0004\r!]\u0001\u0003KZDaa \u0001\u0005\u0002\u0005\u0005\u0011\u0001E4f]\u000e{G-\u001a$peJ+7/\u001e7u)1\t\u0019!!\u0005\u0002\u0014\u0005U\u0011\u0011DA\u000e!\u0011\t)!a\u0003\u000f\u0007a\t9!C\u0002\u0002\ne\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0007\u0003\u001f\u0011aa\u0015;sS:<'bAA\u00053!)\u0001P a\u0001s\")QP a\u0001c\"9\u0011q\u0003@A\u0002\u0005\r\u0011AC5oaV$\u0018I\u001d:bs\"1QN a\u0001\u0003\u0007Aq!!\b\u007f\u0001\u0004\t\u0019!\u0001\u0007oK^\f%O]1z'&TX\rC\u0004\u0002\"\u0001!\t%a\t\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002\u0004!I\u0011q\u0005\u0001\u0002\u0002\u0013\u0005\u0011\u0011F\u0001\u0005G>\u0004\u0018\u0010F\u00030\u0003W\ti\u0003\u0003\u0005\"\u0003K\u0001\n\u00111\u0001$\u0011!I\u0013Q\u0005I\u0001\u0002\u0004\u0019\u0003\"CA\u0019\u0001E\u0005I\u0011AA\u001a\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u000e+\u0007\r\n9d\u000b\u0002\u0002:A!\u00111HA#\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013!C;oG\",7m[3e\u0015\r\t\u0019%G\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA$\u0003{\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\tY\u0005AI\u0001\n\u0003\t\u0019$\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005=\u0003!!A\u0005B\u0005E\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002TA!\u0011QKA0\u001b\t\t9F\u0003\u0003\u0002Z\u0005m\u0013\u0001\u00027b]\u001eT!!!\u0018\u0002\t)\fg/Y\u0005\u0005\u0003\u001b\t9\u0006C\u0005\u0002d\u0001\t\t\u0011\"\u0001\u0002f\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\r\t\u00041\u0005%\u0014bAA63\t\u0019\u0011J\u001c;\t\u0013\u0005=\u0004!!A\u0005\u0002\u0005E\u0014A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004=\u0006M\u0004BCA;\u0003[\n\t\u00111\u0001\u0002h\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005e\u0004!!A\u0005B\u0005m\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005u\u0004#BA@\u0003\u000bsVBAAA\u0015\r\t\u0019)G\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAD\u0003\u0003\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003\u0017\u0003\u0011\u0011!C\u0001\u0003\u001b\u000b\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u001f\u000b)\nE\u0002\u0019\u0003#K1!a%\u001a\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u001e\u0002\n\u0006\u0005\t\u0019\u00010\t\u0013\u0005e\u0005!!A\u0005B\u0005m\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0010\u0006u\u0005\"CA;\u0003/\u000b\t\u00111\u0001_Q=\u0001\u0011\u0011UAT\u0003S\u000bi+a,\u00024\u0006U\u0006cA\t\u0002$&\u0019\u0011Q\u0015\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111V\u0001O?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u0017!K2,W.\u001a8uS\u0001j\u0003EU3n_Z,\u0007%\u00197mA\u0015dW-\\3oiN\u0004C\u000f[1uA\u0015\fX/\u00197!i>\u0004S\r\\3nK:$\bE\u001a:p[\u0002\n'O]1z]\u0005AQ\r_1na2,7/\t\u0002\u00022\u00061&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\b&\r\u0017!e1\u00023\u0007\f\u0011ok2dG\u0006I\u001a*Y\u0001\u001a\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\c1\u0012DF\\;mYvS\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003o\u000bQA\r\u00185]A:\u0011\"a/\u0003\u0003\u0003E\t!!0\u0002\u0017\u0005\u0013(/Y=SK6|g/\u001a\t\u0004#\u0005}f\u0001C\u0001\u0003\u0003\u0003E\t!!1\u0014\u000b\u0005}\u00161Y\u000f\u0011\u000f\u0005\u0015\u00171Z\u0012$_5\u0011\u0011q\u0019\u0006\u0004\u0003\u0013L\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003\u001b\f9MA\tBEN$(/Y2u\rVt7\r^5p]JBq!LA`\t\u0003\t\t\u000e\u0006\u0002\u0002>\"Q\u0011Q[A`\u0003\u0003%)%a6\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0015\t\u0015\u0005m\u0017qXA\u0001\n\u0003\u000bi.A\u0003baBd\u0017\u0010F\u00030\u0003?\f\t\u000f\u0003\u0004\"\u00033\u0004\ra\t\u0005\u0007S\u0005e\u0007\u0019A\u0012\t\u0015\u0005\u0015\u0018qXA\u0001\n\u0003\u000b9/A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005%\u0018Q\u001f\t\u00061\u0005-\u0018q^\u0005\u0004\u0003[L\"AB(qi&|g\u000eE\u0003\u0019\u0003c\u001c3%C\u0002\u0002tf\u0011a\u0001V;qY\u0016\u0014\u0004\"CA|\u0003G\f\t\u00111\u00010\u0003\rAH\u0005\r\u0005\u000b\u0003w\fy,!A\u0005\n\u0005u\u0018a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a@\u0011\t\u0005U#\u0011A\u0005\u0005\u0005\u0007\t9F\u0001\u0004PE*,7\r\u001e")
public class ArrayRemove
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression left;
    private final Expression right;
    private transient Ordering<Object> org$apache$spark$sql$catalyst$expressions$ArrayRemove$$ordering;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayRemove arrayRemove) {
        return ArrayRemove$.MODULE$.unapply(arrayRemove);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayRemove> tupled() {
        return ArrayRemove$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayRemove>> curried() {
        return ArrayRemove$.MODULE$.curried();
    }

    private Ordering org$apache$spark$sql$catalyst$expressions$ArrayRemove$$ordering$lzycompute() {
        ArrayRemove arrayRemove = this;
        synchronized (arrayRemove) {
            if (!this.bitmap$trans$0) {
                this.org$apache$spark$sql$catalyst$expressions$ArrayRemove$$ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.right().dataType());
                this.bitmap$trans$0 = true;
            }
            return this.org$apache$spark$sql$catalyst$expressions$ArrayRemove$$ordering;
        }
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return this.left().dataType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Seq seq;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 == null) return (Seq)Seq$.MODULE$.empty();
        DataType dataType2 = (DataType)tuple2._1();
        DataType e2 = (DataType)tuple2._2();
        if (!(dataType2 instanceof ArrayType)) return (Seq)Seq$.MODULE$.empty();
        ArrayType arrayType2 = (ArrayType)dataType2;
        DataType e1 = arrayType2.elementType();
        boolean hasNull = arrayType2.containsNull();
        Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e2);
        if (option instanceof Some) {
            Some some = (Some)option;
            DataType dt = (DataType)some.x();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{new ArrayType(dt, hasNull), dt}));
            return seq;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        ArrayType arrayType2;
        DataType e1;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 == null) return new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input to function ", " should have "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"been ", " followed by a value with same element type, but it's "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ArrayType$.MODULE$.simpleString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", ", ", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.left().dataType().catalogString(), this.right().dataType().catalogString()}))).toString());
        DataType dataType2 = (DataType)tuple2._1();
        DataType e2 = (DataType)tuple2._2();
        if (!(dataType2 instanceof ArrayType) || !(e1 = (arrayType2 = (ArrayType)dataType2).elementType()).sameType(e2)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input to function ", " should have "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"been ", " followed by a value with same element type, but it's "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ArrayType$.MODULE$.simpleString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", ", ", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.left().dataType().catalogString(), this.right().dataType().catalogString()}))).toString());
        return TypeUtils$.MODULE$.checkForOrderingExpr(e2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"function ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()})));
    }

    public DataType org$apache$spark$sql$catalyst$expressions$ArrayRemove$$elementType() {
        return ((ArrayType)this.left().dataType()).elementType();
    }

    public Ordering<Object> org$apache$spark$sql$catalyst$expressions$ArrayRemove$$ordering() {
        return this.bitmap$trans$0 ? this.org$apache$spark$sql$catalyst$expressions$ArrayRemove$$ordering : this.org$apache$spark$sql$catalyst$expressions$ArrayRemove$$ordering$lzycompute();
    }

    @Override
    public Object nullSafeEval(Object arr, Object value2) {
        Object[] newArray = new Object[((ArrayData)arr).numElements()];
        IntRef pos = IntRef.create((int)0);
        ((ArrayData)arr).foreach(this.right().dataType(), (Function2<Object, Object, BoxedUnit>)new Serializable(this, value2, newArray, pos){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayRemove $outer;
            private final Object value$3;
            private final Object[] newArray$1;
            private final IntRef pos$1;

            public final void apply(int i, Object v) {
                if (v == null || !this.$outer.org$apache$spark$sql$catalyst$expressions$ArrayRemove$$ordering().equiv(v, this.value$3)) {
                    this.newArray$1[this.pos$1.elem] = v;
                    ++this.pos$1.elem;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.value$3 = value$3;
                this.newArray$1 = newArray$1;
                this.pos$1 = pos$1;
            }
        });
        return new GenericArrayData((Object[])Predef$.MODULE$.genericArrayOps((Object)newArray).slice(0, pos.elem));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ctx, ev){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayRemove $outer;
            private final CodegenContext ctx$17;
            private final ExprCode ev$14;

            public final String apply(String arr, String value2) {
                String numsToRemove = this.ctx$17.freshName("numsToRemove");
                String newArraySize = this.ctx$17.freshName("newArraySize");
                String i = this.ctx$17.freshName("i");
                String getValue = CodeGenerator$.MODULE$.getValue(arr, this.$outer.org$apache$spark$sql$catalyst$expressions$ArrayRemove$$elementType(), i);
                String isEqual = this.ctx$17.genEqual(this.$outer.org$apache$spark$sql$catalyst$expressions$ArrayRemove$$elementType(), value2, getValue);
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |int ", " = 0;\n         |for (int ", " = 0; ", " < ", ".numElements(); ", " ++) {\n         |  if (!", ".isNullAt(", ") && ", ") {\n         |    ", " = ", " + 1;\n         |  }\n         |}\n         |int ", " = ", ".numElements() - ", ";\n         |", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{numsToRemove, i, i, arr, i, arr, i, isEqual, numsToRemove, numsToRemove, newArraySize, arr, numsToRemove, this.$outer.genCodeForResult(this.ctx$17, this.ev$14, arr, value2, newArraySize)})))).stripMargin();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ctx$17 = ctx$17;
                this.ev$14 = ev$14;
            }
        });
    }

    public String genCodeForResult(CodegenContext ctx, ExprCode ev, String inputArray, String value2, String newArraySize) {
        String values2 = ctx.freshName("values");
        String i = ctx.freshName("i");
        String pos = ctx.freshName("pos");
        String getValue = CodeGenerator$.MODULE$.getValue(inputArray, this.org$apache$spark$sql$catalyst$expressions$ArrayRemove$$elementType(), i);
        String isEqual = ctx.genEqual(this.org$apache$spark$sql$catalyst$expressions$ArrayRemove$$elementType(), value2, getValue);
        String allocation = CodeGenerator$.MODULE$.createArrayData(values2, this.org$apache$spark$sql$catalyst$expressions$ArrayRemove$$elementType(), newArraySize, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()})));
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(values2, this.org$apache$spark$sql$catalyst$expressions$ArrayRemove$$elementType(), inputArray, pos, i, false);
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |", "\n       |int ", " = 0;\n       |for (int ", " = 0; ", " < ", ".numElements(); ", " ++) {\n       |  if (", ".isNullAt(", ")) {\n       |    ", ".setNullAt(", ");\n       |    ", " = ", " + 1;\n       |  }\n       |  else {\n       |    if (!(", ")) {\n       |      ", "\n       |      ", " = ", " + 1;\n       |    }\n       |  }\n       |}\n       |", " = ", ";\n     "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{allocation, pos, i, i, inputArray, i, inputArray, i, values2, pos, pos, pos, isEqual, assignment, pos, pos, ev.value(), values2})))).stripMargin();
    }

    @Override
    public String prettyName() {
        return "array_remove";
    }

    public ArrayRemove copy(Expression left, Expression right) {
        return new ArrayRemove(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayRemove";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayRemove;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayRemove)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayRemove arrayRemove = (ArrayRemove)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayRemove.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayRemove.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayRemove.canEqual(this)) return false;
        return true;
    }

    public ArrayRemove(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes$class.$init$(this);
    }
}

