/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.DiscreteSampling;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.ucar.FeaturesWrapper;
import org.apache.sis.internal.netcdf.ucar.GridGeometryWrapper;
import org.apache.sis.internal.netcdf.ucar.LogAdapter;
import org.apache.sis.internal.netcdf.ucar.VariableWrapper;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.logging.WarningListeners;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.VariableIF;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;

public final class DecoderWrapper
extends Decoder
implements CancelTask {
    private final NetcdfFile file;
    private Group[] groups;
    private transient Variable[] variables;
    private transient FeatureDataset features;
    private transient GridGeometry[] geometries;

    public DecoderWrapper(NetcdfFile netcdfFile, GeometryLibrary geometryLibrary, WarningListeners<DataStore> warningListeners) {
        super(geometryLibrary, warningListeners);
        this.file = netcdfFile;
    }

    public DecoderWrapper(String string, GeometryLibrary geometryLibrary, WarningListeners<DataStore> warningListeners) throws IOException {
        super(geometryLibrary, warningListeners);
        this.file = NetcdfDataset.openDataset((String)string, (boolean)false, (CancelTask)this);
    }

    @Override
    public String getFilename() {
        String string = this.file.getLocation();
        if (string != null) {
            int n = string.lastIndexOf(File.separatorChar);
            if (n < 0 && File.separatorChar != '/') {
                n = string.lastIndexOf(47);
            }
            if (n >= 0) {
                string = string.substring(n + 1);
            }
        }
        return string;
    }

    @Override
    public void setSearchPath(String ... stringArray) {
        Object[] objectArray = new Group[stringArray.length];
        int n = 0;
        for (String string : stringArray) {
            if (string != null) {
                Group group = this.file.findGroup(string);
                if (group == null) continue;
                objectArray[n] = group;
            }
            ++n;
        }
        this.groups = (Group[])ArraysExt.resize((Object[])objectArray, (int)n);
    }

    @Override
    public String[] getSearchPath() {
        String[] stringArray = new String[this.groups.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Group group = this.groups[i];
            if (group == null) continue;
            stringArray[i] = group.getShortName();
        }
        return stringArray;
    }

    @Override
    public Collection<String> getAttributeNames() {
        return VariableWrapper.toNames(this.file.getGlobalAttributes());
    }

    private Attribute findAttribute(Group group, String string) {
        return group != null ? group.findAttributeIgnoreCase(string) : this.file.findGlobalAttributeIgnoreCase(string);
    }

    @Override
    public String stringValue(String string) {
        if (string != null) {
            for (Group group : this.groups) {
                String string2;
                Attribute attribute = this.findAttribute(group, string);
                if (attribute == null || !attribute.isString() || (string2 = attribute.getStringValue()) == null || (string2 = string2.trim()).isEmpty()) continue;
                return string2;
            }
        }
        return null;
    }

    @Override
    public Number numericValue(String string) {
        if (string != null) {
            for (Group group : this.groups) {
                Attribute attribute = this.findAttribute(group, string);
                if (attribute == null) continue;
                Number number = attribute.getNumericValue();
                if (number != null) {
                    return number;
                }
                String string2 = attribute.getStringValue();
                if (string2 == null || (string2 = string2.trim()).isEmpty()) continue;
                return this.parseNumber(string2);
            }
        }
        return null;
    }

    @Override
    public Date dateValue(String string) {
        if (string != null) {
            for (Group group : this.groups) {
                CalendarDate calendarDate;
                String string2;
                Attribute attribute = this.findAttribute(group, string);
                if (attribute == null || !attribute.isString() || (string2 = attribute.getStringValue()) == null || (string2 = string2.trim()).isEmpty()) continue;
                try {
                    calendarDate = CalendarDateFormatter.isoStringToCalendarDate((Calendar)Calendar.proleptic_gregorian, (String)string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.listeners.warning(null, (Exception)illegalArgumentException);
                    continue;
                }
                return new Date(calendarDate.getMillis());
            }
        }
        return null;
    }

    @Override
    public Date[] numberToDate(String string, Number ... numberArray) {
        DateUnit dateUnit;
        Date[] dateArray = new Date[numberArray.length];
        try {
            dateUnit = new DateUnit(string);
        }
        catch (Exception exception) {
            this.listeners.warning(null, exception);
            return dateArray;
        }
        for (int i = 0; i < numberArray.length; ++i) {
            Number number = numberArray[i];
            if (number == null) continue;
            dateArray[i] = dateUnit.makeDate(number.doubleValue());
        }
        return dateArray;
    }

    @Override
    public String getId() {
        return this.file.getId();
    }

    @Override
    public String getTitle() {
        return this.file.getTitle();
    }

    @Override
    public Variable[] getVariables() {
        if (this.variables == null) {
            List list = this.file.getVariables();
            this.variables = new Variable[list != null ? list.size() : 0];
            for (int i = 0; i < this.variables.length; ++i) {
                this.variables[i] = new VariableWrapper((VariableIF)list.get(i));
            }
        }
        return this.variables;
    }

    @Override
    public DiscreteSampling[] getDiscreteSampling() throws IOException, DataStoreException {
        if (this.features == null && this.file instanceof NetcdfDataset) {
            this.features = FeatureDatasetFactoryManager.wrap(null, (NetcdfDataset)((NetcdfDataset)this.file), (CancelTask)this, (Formatter)new Formatter(new LogAdapter((WarningListeners<DataStore>)this.listeners), this.listeners.getLocale()));
        }
        List list = null;
        if (this.features instanceof FeatureDatasetPoint) {
            list = ((FeatureDatasetPoint)this.features).getPointFeatureCollectionList();
        }
        DiscreteSampling[] discreteSamplingArray = new FeaturesWrapper[list != null ? list.size() : 0];
        try {
            for (int i = 0; i < discreteSamplingArray.length; ++i) {
                discreteSamplingArray[i] = new FeaturesWrapper((FeatureCollection)list.get(i), this.geomlib, (WarningListeners<DataStore>)this.listeners);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DataStoreException(illegalArgumentException.getLocalizedMessage(), (Throwable)illegalArgumentException);
        }
        return discreteSamplingArray;
    }

    @Override
    public GridGeometry[] getGridGeometries() throws IOException {
        if (this.geometries == null) {
            List list = null;
            if (this.file instanceof NetcdfDataset) {
                NetcdfDataset netcdfDataset = (NetcdfDataset)this.file;
                EnumSet<NetcdfDataset.Enhance> enumSet = EnumSet.copyOf(netcdfDataset.getEnhanceMode());
                if (enumSet.add(NetcdfDataset.Enhance.CoordSystems)) {
                    netcdfDataset.enhance(enumSet);
                }
                list = netcdfDataset.getCoordinateSystems();
            }
            this.geometries = new GridGeometry[list != null ? list.size() : 0];
            for (int i = 0; i < this.geometries.length; ++i) {
                this.geometries[i] = new GridGeometryWrapper((CoordinateSystem)list.get(i));
            }
        }
        return this.geometries;
    }

    public boolean isCancel() {
        return this.canceled;
    }

    public void setProgress(String string, int n) {
    }

    public void setError(String string) {
        this.listeners.warning(string, null);
    }

    @Override
    public void close() throws IOException {
        if (this.features != null) {
            this.features.close();
            this.features = null;
        }
        this.file.close();
    }

    public String toString() {
        return "UCAR driver: \u201c" + this.getFilename() + '\u201d';
    }
}

