/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.config;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.shiro.config.Ini;
import org.apache.shiro.config.ogdl.ReflectionBuilder;
import org.apache.shiro.ini.IniFactorySupport;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.web.filter.mgt.DefaultFilter;
import org.apache.shiro.web.filter.mgt.FilterChainManager;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.filter.mgt.PathMatchingFilterChainResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IniFilterChainResolverFactory
extends IniFactorySupport<FilterChainResolver> {
    public static final String FILTERS = "filters";
    public static final String URLS = "urls";
    private static final Logger LOGGER = LoggerFactory.getLogger(IniFilterChainResolverFactory.class);
    private FilterConfig filterConfig;
    private List<String> globalFilters = Collections.singletonList(DefaultFilter.invalidRequest.name());

    public IniFilterChainResolverFactory() {
    }

    public IniFilterChainResolverFactory(Ini ini) {
        super(ini);
    }

    public IniFilterChainResolverFactory(Ini ini, Map<String, ?> defaultBeans) {
        this(ini);
        this.setDefaults(defaultBeans);
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public List<String> getGlobalFilters() {
        return this.globalFilters;
    }

    public void setGlobalFilters(List<String> globalFilters) {
        this.globalFilters = globalFilters;
    }

    protected FilterChainResolver createInstance(Ini ini) {
        FilterChainResolver filterChainResolver = this.createDefaultInstance();
        if (filterChainResolver instanceof PathMatchingFilterChainResolver) {
            PathMatchingFilterChainResolver resolver = (PathMatchingFilterChainResolver)filterChainResolver;
            FilterChainManager manager = resolver.getFilterChainManager();
            this.buildChains(manager, ini);
        }
        return filterChainResolver;
    }

    protected FilterChainResolver createDefaultInstance() {
        FilterConfig filterConfig = this.getFilterConfig();
        if (filterConfig != null) {
            return new PathMatchingFilterChainResolver(filterConfig);
        }
        return new PathMatchingFilterChainResolver();
    }

    protected void buildChains(FilterChainManager manager, Ini ini) {
        Map defaultBeans;
        Ini.Section section = ini.getSection(FILTERS);
        if (!CollectionUtils.isEmpty((Map)section)) {
            String msg = "The [{}] section has been deprecated and will be removed in a future release!  Please move all object configuration (filters and all other objects) to the [{}] section.";
            LOGGER.warn(msg, (Object)FILTERS, (Object)"main");
        }
        LinkedHashMap<String, Filter> defaults = new LinkedHashMap<String, Filter>();
        Map<String, Filter> defaultFilters = manager.getFilters();
        if (!CollectionUtils.isEmpty(defaultFilters)) {
            defaults.putAll(defaultFilters);
        }
        if (!CollectionUtils.isEmpty((Map)(defaultBeans = this.getDefaults()))) {
            defaults.putAll(defaultBeans);
        }
        Map<String, Filter> filters = this.getFilters((Map<String, String>)section, defaults);
        this.registerFilters(filters, manager);
        manager.setGlobalFilters(this.getGlobalFilters());
        section = ini.getSection(URLS);
        this.createChains((Map<String, String>)section, manager);
        manager.createDefaultChain("/**");
    }

    protected void registerFilters(Map<String, Filter> filters, FilterChainManager manager) {
        if (!CollectionUtils.isEmpty(filters)) {
            boolean init = this.getFilterConfig() != null;
            for (Map.Entry<String, Filter> entry : filters.entrySet()) {
                String name = entry.getKey();
                Filter filter = entry.getValue();
                manager.addFilter(name, filter, init);
            }
        }
    }

    protected Map<String, Filter> getFilters(Map<String, String> section, Map<String, ?> defaults) {
        Map<String, Filter> filters = this.extractFilters(defaults);
        if (!CollectionUtils.isEmpty(section)) {
            ReflectionBuilder builder = new ReflectionBuilder(defaults);
            Map built = builder.buildObjects(section);
            Map<String, Filter> sectionFilters = this.extractFilters(built);
            if (CollectionUtils.isEmpty(filters)) {
                filters = sectionFilters;
            } else if (!CollectionUtils.isEmpty(sectionFilters)) {
                filters.putAll(sectionFilters);
            }
        }
        return filters;
    }

    private Map<String, Filter> extractFilters(Map<String, ?> objects) {
        if (CollectionUtils.isEmpty(objects)) {
            return null;
        }
        LinkedHashMap<String, Filter> filterMap = new LinkedHashMap<String, Filter>();
        for (Map.Entry<String, ?> entry : objects.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof Filter)) continue;
            filterMap.put(key, (Filter)value);
        }
        return filterMap;
    }

    protected void createChains(Map<String, String> urls, FilterChainManager manager) {
        if (CollectionUtils.isEmpty(urls)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No urls to process.");
            }
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Before url processing.");
        }
        for (Map.Entry<String, String> entry : urls.entrySet()) {
            String path = entry.getKey();
            String value = entry.getValue();
            manager.createChain(path, value);
        }
    }
}

