/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.servlet;

import java.io.IOException;
import java.util.concurrent.Callable;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.ExecutionException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.config.ShiroFilterConfiguration;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.servlet.OncePerRequestFilter;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.servlet.ShiroHttpServletResponse;
import org.apache.shiro.web.subject.WebSubject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractShiroFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractShiroFilter.class);
    private static final String STATIC_INIT_PARAM_NAME = "staticSecurityManagerEnabled";
    private WebSecurityManager securityManager;
    private FilterChainResolver filterChainResolver;
    private boolean staticSecurityManagerEnabled = false;

    protected AbstractShiroFilter() {
    }

    public WebSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(WebSecurityManager sm) {
        this.securityManager = sm;
    }

    public FilterChainResolver getFilterChainResolver() {
        return this.filterChainResolver;
    }

    public void setFilterChainResolver(FilterChainResolver filterChainResolver) {
        this.filterChainResolver = filterChainResolver;
    }

    public void setShiroFilterConfiguration(ShiroFilterConfiguration config) {
        this.setFilterOncePerRequest(config.isFilterOncePerRequest());
        this.setStaticSecurityManagerEnabled(config.isStaticSecurityManagerEnabled() || this.isStaticSecurityManagerEnabled());
    }

    public boolean isStaticSecurityManagerEnabled() {
        return this.staticSecurityManagerEnabled;
    }

    public void setStaticSecurityManagerEnabled(boolean staticSecurityManagerEnabled) {
        this.staticSecurityManagerEnabled = staticSecurityManagerEnabled;
    }

    @Override
    protected final void onFilterConfigSet() throws Exception {
        this.applyStaticSecurityManagerEnabledConfig();
        this.init();
        this.ensureSecurityManager();
        if (this.isStaticSecurityManagerEnabled()) {
            SecurityUtils.setSecurityManager((SecurityManager)this.getSecurityManager());
        }
    }

    private void applyStaticSecurityManagerEnabledConfig() {
        boolean b;
        String value = this.getInitParam(STATIC_INIT_PARAM_NAME);
        if (value != null && (b = Boolean.parseBoolean(value))) {
            this.setStaticSecurityManagerEnabled(b);
        }
    }

    public void init() throws Exception {
    }

    private void ensureSecurityManager() {
        WebSecurityManager securityManager = this.getSecurityManager();
        if (securityManager == null) {
            LOGGER.info("No SecurityManager configured.  Creating default.");
            securityManager = this.createDefaultSecurityManager();
            this.setSecurityManager(securityManager);
        }
    }

    protected WebSecurityManager createDefaultSecurityManager() {
        return new DefaultWebSecurityManager();
    }

    protected boolean isHttpSessions() {
        return this.getSecurityManager().isHttpSessionMode();
    }

    protected ServletRequest wrapServletRequest(HttpServletRequest orig) {
        return new ShiroHttpServletRequest(orig, this.getServletContext(), this.isHttpSessions());
    }

    protected ServletRequest prepareServletRequest(ServletRequest request, ServletResponse response, FilterChain chain) {
        ServletRequest toUse = request;
        if (request instanceof HttpServletRequest) {
            HttpServletRequest http = (HttpServletRequest)request;
            toUse = this.wrapServletRequest(http);
        }
        return toUse;
    }

    protected ServletResponse wrapServletResponse(HttpServletResponse orig, ShiroHttpServletRequest request) {
        return new ShiroHttpServletResponse(orig, this.getServletContext(), request);
    }

    protected ServletResponse prepareServletResponse(ServletRequest request, ServletResponse response, FilterChain chain) {
        ServletResponse toUse = response;
        if (!this.isHttpSessions() && request instanceof ShiroHttpServletRequest && response instanceof HttpServletResponse) {
            toUse = this.wrapServletResponse((HttpServletResponse)response, (ShiroHttpServletRequest)request);
        }
        return toUse;
    }

    protected WebSubject createSubject(ServletRequest request, ServletResponse response) {
        return new WebSubject.Builder(this.getSecurityManager(), request, response).buildWebSubject();
    }

    protected void updateSessionLastAccessTime(ServletRequest request, ServletResponse response) {
        Session session;
        Subject subject;
        if (!this.isHttpSessions() && (subject = SecurityUtils.getSubject()) != null && (session = subject.getSession(false)) != null) {
            try {
                session.touch();
            }
            catch (Throwable t) {
                LOGGER.error("session.touch() method invocation has failed.  Unable to update the corresponding session's last access time based on the incoming request.", t);
            }
        }
    }

    @Override
    protected void doFilterInternal(ServletRequest servletRequest, ServletResponse servletResponse, final FilterChain chain) throws ServletException, IOException {
        Throwable t = null;
        try {
            final ServletRequest request = this.prepareServletRequest(servletRequest, servletResponse, chain);
            final ServletResponse response = this.prepareServletResponse(request, servletResponse, chain);
            WebSubject subject = this.createSubject(request, response);
            subject.execute(new Callable(){

                public Object call() throws Exception {
                    AbstractShiroFilter.this.updateSessionLastAccessTime(request, response);
                    AbstractShiroFilter.this.executeChain(request, response, chain);
                    return null;
                }
            });
        }
        catch (ExecutionException ex) {
            t = ex.getCause();
        }
        catch (Throwable throwable) {
            t = throwable;
        }
        if (t != null) {
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            String msg = "Filtered request failed.";
            throw new ServletException(msg, t);
        }
    }

    protected FilterChain getExecutionChain(ServletRequest request, ServletResponse response, FilterChain origChain) {
        FilterChain chain = origChain;
        FilterChainResolver resolver = this.getFilterChainResolver();
        if (resolver == null) {
            LOGGER.debug("No FilterChainResolver configured.  Returning original FilterChain.");
            return origChain;
        }
        FilterChain resolved = resolver.getChain(request, response, origChain);
        if (resolved != null) {
            LOGGER.trace("Resolved a configured FilterChain for the current request.");
            chain = resolved;
        } else {
            LOGGER.trace("No FilterChain configured for the current request.  Using the default.");
        }
        return chain;
    }

    protected void executeChain(ServletRequest request, ServletResponse response, FilterChain origChain) throws IOException, ServletException {
        FilterChain chain = this.getExecutionChain(request, response, origChain);
        chain.doFilter(request, response);
    }
}

