/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.web.servlet.HttpSessionContext;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.session.HttpServletSession;

public class ShiroHttpSession
implements HttpSession {
    public static final String DEFAULT_SESSION_ID_NAME = "JSESSIONID";
    private static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    };
    private static final HttpSessionContext HTTP_SESSION_CONTEXT = new HttpSessionContext(){

        public HttpSession getSession(String s) {
            return null;
        }

        public Enumeration getIds() {
            return EMPTY_ENUMERATION;
        }
    };
    protected ServletContext servletContext;
    protected HttpServletRequest currentRequest;
    protected Session session;

    public ShiroHttpSession(Session session, HttpServletRequest currentRequest, ServletContext servletContext) {
        if (session instanceof HttpServletSession) {
            String msg = "Session constructor argument cannot be an instance of HttpServletSession.  This is enforced to prevent circular dependencies and infinite loops.";
            throw new IllegalArgumentException(msg);
        }
        this.session = session;
        this.currentRequest = currentRequest;
        this.servletContext = servletContext;
    }

    public Session getSession() {
        return this.session;
    }

    public long getCreationTime() {
        try {
            return this.getSession().getStartTimestamp().getTime();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public String getId() {
        return this.getSession().getId().toString();
    }

    public long getLastAccessedTime() {
        return this.getSession().getLastAccessTime().getTime();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int i) {
        try {
            this.getSession().setTimeout((long)i * 1000L);
        }
        catch (InvalidSessionException e) {
            throw new IllegalStateException(e);
        }
    }

    public int getMaxInactiveInterval() {
        try {
            return Long.valueOf(this.getSession().getTimeout() / 1000L).intValue();
        }
        catch (InvalidSessionException e) {
            throw new IllegalStateException(e);
        }
    }

    public HttpSessionContext getSessionContext() {
        return HTTP_SESSION_CONTEXT;
    }

    public Object getAttribute(String s) {
        try {
            return this.getSession().getAttribute((Object)s);
        }
        catch (InvalidSessionException e) {
            throw new IllegalStateException(e);
        }
    }

    public Object getValue(String s) {
        return this.getAttribute(s);
    }

    protected Set<String> getKeyNames() {
        HashSet<String> keyNames;
        Collection keySet;
        try {
            keySet = this.getSession().getAttributeKeys();
        }
        catch (InvalidSessionException e) {
            throw new IllegalStateException(e);
        }
        if (keySet != null && !keySet.isEmpty()) {
            keyNames = new HashSet<String>(keySet.size());
            for (Object o : keySet) {
                keyNames.add(o.toString());
            }
        } else {
            keyNames = Collections.EMPTY_SET;
        }
        return keyNames;
    }

    public Enumeration getAttributeNames() {
        Set<String> keyNames = this.getKeyNames();
        final Iterator<String> iterator = keyNames.iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                return iterator.next();
            }
        };
    }

    public String[] getValueNames() {
        Set<String> keyNames = this.getKeyNames();
        String[] array = new String[keyNames.size()];
        if (keyNames.size() > 0) {
            array = keyNames.toArray(array);
        }
        return array;
    }

    protected void afterBound(String s, Object o) {
        if (o instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)o;
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, s, o);
            listener.valueBound(event);
        }
    }

    protected void afterUnbound(String s, Object o) {
        if (o instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)o;
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, s, o);
            listener.valueUnbound(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String s, Object o) {
        try {
            this.getSession().setAttribute((Object)s, o);
            this.afterBound(s, o);
        }
        catch (InvalidSessionException e) {
            try {
                this.afterUnbound(s, o);
            }
            finally {
                throw new IllegalStateException(e);
            }
        }
    }

    public void putValue(String s, Object o) {
        this.setAttribute(s, o);
    }

    public void removeAttribute(String s) {
        try {
            Object attribute = this.getSession().removeAttribute((Object)s);
            this.afterUnbound(s, attribute);
        }
        catch (InvalidSessionException e) {
            throw new IllegalStateException(e);
        }
    }

    public void removeValue(String s) {
        this.removeAttribute(s);
    }

    public void invalidate() {
        try {
            this.getSession().stop();
        }
        catch (InvalidSessionException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isNew() {
        Boolean value = (Boolean)this.currentRequest.getAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_IS_NEW);
        return value != null && value.equals(Boolean.TRUE);
    }
}

