/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.jaxrs;

import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.apache.shiro.web.jaxrs.AnnotationAuthorizationFilter;

public class ShiroAnnotationFilterFeature
implements DynamicFeature {
    private static final List<Class<? extends Annotation>> SHIRO_ANNOTATIONS = List.of(RequiresPermissions.class, RequiresRoles.class, RequiresAuthentication.class, RequiresUser.class, RequiresGuest.class);
    private static final List<Class<? extends Annotation>> JSR_250_ANNOTATIONS = List.of(RolesAllowed.class, PermitAll.class, DenyAll.class);

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        ArrayList<Annotation> authzSpecs = new ArrayList<Annotation>();
        List<Class<Annotation>> annotations = SHIRO_ANNOTATIONS;
        if (Boolean.TRUE.equals(context.getConfiguration().getProperty("org.apache.shiro.web.jaxrs.disable-principal"))) {
            annotations = Stream.concat(SHIRO_ANNOTATIONS.stream(), JSR_250_ANNOTATIONS.stream()).collect(Collectors.toList());
        }
        for (Class<? extends Annotation> annotationClass : annotations) {
            Annotation classAuthzSpec = resourceInfo.getResourceClass().getAnnotation(annotationClass);
            Annotation methodAuthzSpec = resourceInfo.getResourceMethod().getAnnotation(annotationClass);
            if (classAuthzSpec != null) {
                authzSpecs.add(classAuthzSpec);
            }
            if (methodAuthzSpec == null) continue;
            authzSpecs.add(methodAuthzSpec);
        }
        if (!authzSpecs.isEmpty()) {
            context.register((Object)new AnnotationAuthorizationFilter(authzSpecs), 2000);
        }
    }
}

